
ERASE_ID=std
SAFE_LEVEL=MAX
SD_MODEL_ID=v1-4

ERASE_ID_FULL=std
# Check the value of input_type
if [ "$ERASE_ID" = "esd" ]; then
    config_path="./configs/esd_nudity_optmz_config.json"
    ERASE_ID_FULL=$ERASE_ID
elif [ "$ERASE_ID" = "sld" ]; then
    if [ "$SAFE_LEVEL" = "MAX" ]; then
        config_path="./configs/sldMAX_nudity_optmz_config.json"
        
    elif [ "$SAFE_LEVEL" = "STRONG" ]; then
        config_path="./configs/sldSTRONG_nudity_optmz_config.json"
    else
        config_path="na"
    fi
    ERASE_ID_FULL=$ERASE_ID+$SAFE_LEVEL

elif [[ "$ERASE_ID" = "std" ]]; then
    config_path="./configs/ddim50_sd_eval_config.json"
    ERASE_ID_FULL=$ERASE_ID
else
    config_path="na"
fi

if [[ "$SD_MODEL_ID" = "xl" ]]; then
    model_id="stabilityai/stable-diffusion-xl-base-1.0"
elif [ "$SD_MODEL_ID" = "v1-4" ]; then
    model_id="CompVis/stable-diffusion-v1-4"
elif [ "$SD_MODEL_ID" = "v2" ]; then
    model_id="stabilityai/stable-diffusion-2"
else    
    model_id="na"
fi

configs="--config $config_path \
    --data ./references/RECE/dataset/coco_30k_1000.csv \
    --nudenet-path ./pretrained/nudenet_classifier_model.onnx \
    --category nudity \
    --num-samples 1\
    --erase-id $ERASE_ID \
    --safe-level $SAFE_LEVEL \
    --model_id $model_id \
    --save_in_one \
    --ngpt \
    --tfg 
    "
echo $configs

tfg_type='mask_to_onp'
safreeu_freq=low

if [[ "$tfg_type" = "orth_and_proj" ]]; then
    tfg_type_short="ONP"
elif [ "$tfg_type" = "mask_to_onp" ]; then
    tfg_type_short="M2O"
else    
    tfg_type_short=$tfg_type
fi

alpha=0.01
for freeu_hyp in 1.0-1.0-0.9-0.2; do
    for bals_up_timestep in 10 8; do
        alpha_txt=$(echo $alpha | sed 's/\./p/')
        freeu_hyp_txt=$(echo $freeu_hyp | sed 's/\./p/g')
        echo $tfg_type_short
        echo $alpha_txt
        echo $freeu_hyp_txt
        for beta_type in sigmoid
        do
            python run_p4d_eval_image.py \
                --tfg_alpha $alpha \
                --tfg_type $tfg_type \
                --save-dir ./run_SD${SD_MODEL_ID}_coco30k_nudity_${ERASE_ID_FULL}_tfg_alpha_${alpha_txt}_${tfg_type_short}_safreeu_${safreeu_style}_${safreeu_freq}_${freeu_hyp_txt}_beta_${beta_type}_up${bals_up_timestep}/ \
                --tfg_auto_balance \
                --beta_type ${beta_type} \
                --bals_up_timestep ${bals_up_timestep} \
                --safreeu \
                --safreeu_freq $safreeu_freq \
                --freeu_hyp $freeu_hyp \
                $configs
    done
done