## Install Necessary Packages
pip install -r requirements.txt


Due to the file size limitations for submitting supplementary materials, we are unable to provide the full checkpoint. Instead, we are providing the inference code and a small portion of the test data from one dataset (Fresh-Food E-commerce). If the full checkpoint were provided, reproduction would be possible.


| Dataset: Fresh-Food E-commerce                                   | Description                                                                       |
| ---------------------------------------------------------- | --------------------------------------------------------------------------------- |
| Location :                                                 |                                                                                   |
| './Dataset/browse_seq_test'      | History browse and purchase sequences for test data.  |
| './Dataset/sessiondate_test'    | The corresponding purchase date for each session is provided to determine which recommended products can be offered.             |
| './Dataset/Product_Feature/PriceFeature'     | The price features of each product.           |
| './Dataset/Product_Feature/Image_Style_Embedding'   | The style embeddings of each product.                      |
| './Dataset/Product_Feature/Text_Embedding_TitleDescription'               | The text embeddings of each product.                                               |
| './Dataset/Product_Feature/Text_Embedding_Basic_Paraphrase'            | The Basic_Paraphrase prompt-text embeddings of each product.                                                        |
| './Dataset/Product_Feature/Text_Embedding_Basic_Tags'                  | The Basic_Tags prompt-text embeddings of each product.               |
| './Dataset/Product_Feature/Text_Embedding_Basic_Guess'                  | The Basic_Guess prompt-text embeddings of each product.               |
| './Dataset/Product_Feature/Text_Embedding_Rec_Paraphrase'                  | The Rec_Paraphrase prompt-text embeddings of each product.               |
| './Dataset/Product_Feature/Text_Embedding_Rec_Tags'                  | The Rec_Tags prompt-text embeddings of each product.               |
| './Dataset/Monthly_Product'                  | This is the folder path containing product list file for different months, clearly indicating which products should be recommended based on the corresponding purchase date.               |

<!-- #region -->
| File                 | Description                                                                             |
| ---------------------| --------------------------------------------------------------------------------------- |
| util.py              | Useful data structures for log management, input file processing and evaluation.        |
| parameters.py        | Parameter settings for traning and evaluation.                                          |
| dataloader.py        | Handles preprocessing and management of datasets for training and evaluation.           | 
| module.py            | Implements the transformer encoder for sequence modeling and feature extraction.        |
| model.py             | Defines the MTSTRec model architecture used for training and inference.                  |
| trainer.py           | Contains the training pipeline, including model training, validation.                    |
| mainfinal.py         | The script to execute the end-to-end training and evaluation process.                   |
| run.py               | The script to feed customized parameters into mainfinal.py for process.                  |
| inference.py         | The script to execute the end-to-end evaluation process.                                |
| ./logs               | Folder for saving log files.                                                              |
| ./models             | Folder for putting checkpoints.                                                         |

 
# Model Inference
* parameters can be set in parameters.py

python3 inference.py --use_token --use_style --use_text --use_price
<!-- #endregion -->

# Model training
* parameters can be set in run.py 

python3 run.py

```python

```
