import hydra
import joblib
import logging
import numpy as np
import os

os.environ["WANDB_MODE"] = "disabled"

@hydra.main(version_base="1.2", config_path="configs", config_name="env_config")
def main(cfg):
    workspace = hydra.utils.instantiate(cfg.env.workspace, cfg=cfg, _recursive_=False)
    rewards, results = workspace.run()
    logging.info("==== Summary ====")
    logging.info(rewards)
    logging.info(results)
    logging.info(f"Average reward: {np.mean(rewards)}")
    logging.info(f"Std: {np.std(rewards)}")
    logging.info(f"Average result: {np.mean(results)}")
    logging.info(f"Std: {np.std(results)}")


if __name__ == "__main__":
    main()
