import pickle


import openai
import base64
import requests
import time
import re
import sys
import random 

import os

openai.api_key = os.environ.get("OPENAI_API_KEY") 


scene_template = """You are the runtime monitor for a vision-based autonomous vertical takeoff and landing (VTOL) 
drone operating as an urban air taxi.
 
Your job is to analyze the observations of the VTOL and identify whether certain points along the VTOL's trajectory 
are prone to failure rendering the VTOL unable to handle them as part of its nominal operations. The VTOL's observations 
take the form of object detections generated by an onboard perception pipeline.
"""

def query_reasoner(text_prompt):


    try:
       

        headers = {
            "Content-Type": "application/json",
            "Authorization": f"Bearer {openai.api_key}"
        }

        payload = {
            "model": "o4-mini", 
            "messages": [
                {
                    "role": "system", 
                    "content": scene_template
                },  # Optional system message
                {
                    "role": "user",
                    "content": [
                        {"type": "text", "text": text_prompt},
                        
                    ]
                }
            ],
            "max_tokens": 500  # Adjust as needed
        }

        response = requests.post("https://api.openai.com/v1/chat/completions", headers=headers, json=payload)

        response.raise_for_status() # Raise an exception for bad status codes (4xx or 5xx)
        return response.json()

    except FileNotFoundError:
        print(f"Error: Image file not found at {image_path}")
        return None
    except requests.exceptions.RequestException as e:
        print(f"Error communicating with OpenAI API: {e}")
        if response.status_code != 200:
            try:
                error_message = response.json()
                print(f"OpenAI API Error details: {error_message}")
            except:
                print(f"OpenAI API Error details: {response.text}")
        return None
    except Exception as e:
        print(f"An unexpected error occurred: {e}")
        return None



# Example usage:

NUMBER = 50
text_prompt = f"""Given an urban view from a drone agent, provide concise descriptions no more than four words of at least 50 general potential external failures that the drone may encounter in this environment. Avoid internal problems/failures of the drone or its equipment. Examples include Low Visibility, Near Human, Near Vehicle in motion, High Temperature, Unauthorized Access.
Provide in the format:
n. failure
"""



beg=time.time()
response = query_reasoner(text_prompt)
end=time.time()

print(end-beg)


print(response["choices"][0]["message"]["content"])
lines = response["choices"][0]["message"]["content"].splitlines()

context_failures = []
for line in lines:
    line = line.strip()  # Remove leading/trailing whitespace
    match = re.match(r"^\d+\.\s*", line) # Match the first number, dot, and space
    if match:
        line = line[match.end():] # Remove the matched part
    if line:  # Check if the line is not empty after cleaning
        context_failures.append(line)

print(context_failures)




scene_description = [
"""I am the runtime monitor for a vision-based autonomous vertical takeoff and landing (VTOL) 
drone operating as an urban air taxi.
 
My job is to analyze the observations of the VTOL and identify whether certain points along the VTOL's trajectory 
are prone to failure rendering the VTOL unable to handle them as part of its nominal operations. The VTOL's observations 
take the form of object detections generated by an onboard perception pipeline.

Scene Description: The surroundings of the VTOL include: 
${CONCEPTS}
"""
]

with open('scene_description.pkl', 'wb') as f:
    pickle.dump(scene_description[0], f)

failures = []


for cf in context_failures:
    failures.append({'label' : cf})


print(failures)
failures_file = 'failures'+sys.argv[1]+'.pkl'
with open(failures_file, 'wb') as f:
    pickle.dump(failures, f)


safe_train_concepts = [
"a cardboard box",
"a hay bale",
"an empty park",
"a bridge",
"a tree",
"a hill",
"a barn",
"a dumpster",
"a reservoir",
"a traffic cone",
]


safe_new_test_concepts = [
"a statue",
"a farm",
"a secluded beach",
"a fence",
"a cactus",
"a fern",
"a golf course"
]

danger_new_test_concepts = [
    "a pedestrian",
    "a skydiver",
    "a toddler",
    "restricted entry federal land",
    "private property",
    "a tree on fire",
    "an unstable nuclear reactor",
    "a moving truck",
    "a bird",
    "a heat radiator",
    "a swimming pool with children",
    "a tornado",
    "a windy alley",
    "fog",
    "a storm",
    "power lines",
    "cattle",
    "a weather balloon"
]

# train set
train_data = []
for i in range(len(safe_train_concepts)):
    for j in range(len(safe_train_concepts)):
        if i==j:
            continue
        train_data.append([safe_train_concepts[i], safe_train_concepts[j]])
        print(train_data[-1])

print('\n\n\n\n\n')

# test set
safe_test_data = []
for c1 in safe_train_concepts:
    for c2 in safe_new_test_concepts:
        safe_test_data.append([c1, c2])
        print(safe_test_data[-1])


print('\n\n\n\n\n')
unsafe_test_data = []
for c1 in safe_train_concepts:
    for c2 in danger_new_test_concepts:
        unsafe_test_data.append([c1, c2])
        print(unsafe_test_data[-1])

for c1 in safe_new_test_concepts:
    for c2 in danger_new_test_concepts:
        unsafe_test_data.append([c1, c2])
        print(unsafe_test_data[-1])


all_data = {'train_data': train_data, 'safe_test_data': safe_test_data, 'unsafe_test_data': unsafe_test_data}

with open('train_test_data.pkl', 'wb') as f:
    pickle.dump(all_data, f)


