# QuantV2X: A Fully Quantized Multi-Agent System for Cooperative Perception

**Anonymous Submission for ICLR 2026**

![teaser](assets/quantv2x_teaser.png)

This is the implementation of "QuantV2X: A Fully Quantized Multi-Agent System for Cooperative Perception". In this work, we address the problems of inefficiency and performance degradation for cooperative perception in real-world resource-constrained scenarios. We illustrate the system-level latency bottleneck in full-precision systems and introduce QuantV2X, a fully quantized multi-agent system for cooperative perception that enables efficient model inference and multi-agent communication with maximum perception performance preservation while meeting the requirements of real-world deployment. To the best of our knowledge, this is the first work to demonstrate the viability and practicality of a fully quantized intermediate fusion system for future real-world deployment.

## ✅ Currently Supported Features
- [√] Full-Precision Baseline Training and Inference on V2X-Real Dataset, covering the original functionality of V2X-Real codebase.
- [√] Codebook Learning Training and Inference Pipeline.
- [√] Post-Training Quantization (PTQ) Pipeline.
- [√] Support on OPV2V(-H) and DAIR-V2X datasets.
- [√] TensorRT Deployment Pipeline.

## V2X-Real Data Download

For V2X-Real dataset, please check the original V2X-Real publication to download the data. The data is in OPV2V format.

After downloading the data, please put the data in the following structure:
```shell
├── v2xreal
│   ├── train
|      |── 2023-03-17-15-53-02_1_0
│   ├── validate
│   ├── test
```

## Other Data Preparation
- OPV2V: Please refer to [this repo](https://github.com/DerrickXuNu/OpenCOOD). You also need to download `additional-001.zip` which stores data for camera modality.
- OPV2V-H: Please refer to [Huggingface Hub](https://huggingface.co/datasets/yifanlu/OPV2V-H) and refer to [Downloading datasets](https://huggingface.co/docs/hub/datasets-downloading) tutorial for the usage.
- DAIR-V2X-C: Download the data from [this page](https://thudair.baai.ac.cn/index). We use complemented annotation, so please also follow the instruction of [this page](https://siheng-chen.github.io/dataset/dair-v2x-c-complemented/).


## Installation

### Step 1: Basic Installation

```bash
conda create -n quantv2x python=3.8 pytorch==1.12.0 torchvision==0.13.0 torchaudio==0.12.0 cudatoolkit=11.6 -c pytorch -c conda-forge
conda activate quantv2x
# install dependency
pip install -r requirements.txt
# install this project. It's OK if EasyInstallDeprecationWarning shows up.
python setup.py develop
```

### Step 2: Install Spconv 2.x

To install **spconv 2.x**, check the [table](https://github.com/traveller59/spconv#spconv-spatially-sparse-convolution-library) to run the installation command. For example we have cudatoolkit 11.6, then we should run

```bash
pip install spconv-cu116 # match your cudatoolkit version
```

### Step 3: Bbx IoU cuda version compile

Install bbx nms calculation cuda version

```bash
python opencood/utils/setup.py build_ext --inplace
```

## Tutorials
- [Tutorial of Baseline Training and Inference on V2X-Real dataset](docs/Tutorial_V2X-Real_Baseline.md)
- [Tutorial of Codebook Learning on V2X-Real dataset](docs/Tutorial_V2X-Real_Codebook.md)
- [Tutorial of PTQ on V2X-Real dataset](docs/Tutorial_V2X-Real_PTQ.md)
- [Tutorial of Training and Inference on other datasets](docs/Tutorial_Other_Datasets.md)
- [Tutorial on Exporting PyTorch Model to TensorRT](docs/Tutorial_Tensorrt_Export.md)
