# DBSCAN Runtime Experiments (Supplementary Material for ICLR 2026 Submission)

To run our experiments, first install the necessary dependencies.

```bash
pip install -r requirements.txt
```

To execute our runtime experiments, run the command 

```bash
python experiments/{dataset}_runtime.py
```

where `dataset` $\in$ \{`mnist, fashion_mnist, aloi, glove`\}.

For our visualizations on the ALOI dataset, run

```bash
python experiments/aloi_visualizations.py
```

For our demonstration of the failure of PCA for DBSCAN, run

```bash
python experiments/pca_failure.py
```

Note that in order to run any of the ALOI tests, you will need to download the [ALOI Dataset (Quarter Resolution, direction)](http://aloi.science.uva.nl/tars/aloi_grey_red4_ill.tar). The default path for this data is `data/grey4`.