#!/usr/bin/env python3
import os
import sys

# Add the parent directory to the experiments directory to Python path
experiments_dir = os.path.dirname(os.path.dirname(os.path.abspath(__file__)))
sys.path.insert(0, experiments_dir)

from dbscan_experiment import DBSCANExperiment


def main():
    # Configuration for basic experiment
    config = {
        'dataset_name': 'ALOI',
        'n': 1000, # 1000 folders, 24000 images
        'eps': 7500,
        'min_pts': 3,
        'c_values': [2, 3, 4, 5, 6, 7, 8, 9, 10],
        'center_ratio': (0.8, 0.4),
        'ratio_offsets_cpi': [0],
        'ratio_offsets_cf': [0],
        'pickling': False,
        'pca_output': 'all',
        'verbose': False
    }

    experiment = DBSCANExperiment(config)
    results = experiment.run_experiment()
    
    return results


if __name__ == "__main__":
    main()
