import os
import sys
import numpy as np
import pickle

# Add the parent directory to the experiments directory to Python path
experiments_dir = os.path.dirname(os.path.dirname(os.path.abspath(__file__)))
sys.path.insert(0, experiments_dir)

from dbscan_experiment import DBSCANExperiment


def main():
    folders = ['103', '410', '487', '749', '31', '9']
    config = {
        'dataset_name': 'ALOI',
        'aloi_specific_folders': folders,
        'eps': 7500,
        'min_pts': 3,
        'c_values': [2,3,4,5],
        'center_ratio': (1, 1),
        'delta': 0.001,
        'pickling': False,
        'pca_output': 'all',
        'verbose': False,
        'plot_config': {
            'separate_plots': True,
            'show_subplot_titles': False
        }
    }

    experiment = DBSCANExperiment(config)
    results = experiment.run_experiment()
    
    return results


if __name__ == "__main__":
    main()