#!/usr/bin/env python3
import os
import sys

# Add the parent directory to the experiments directory to Python path
experiments_dir = os.path.dirname(os.path.dirname(os.path.abspath(__file__)))
sys.path.insert(0, experiments_dir)

from dbscan_experiment import DBSCANExperiment


def main():
    # Configuration for basic experiment
    config = {
        'dataset_name': 'FashionMNIST',
        'n': 600,
        'eps': 800,
        'min_pts': 10,
        'c_values': [2,3,4,5,6,7,8,9,10],
        'center_ratio': (0.8, 0.4),
        'ratio_offsets_cpi': [0],
        'ratio_offsets_cf': [0],
        'pickling': False,
        'pca_output': 'first_lsh',
        'verbose': False
    }

    experiment = DBSCANExperiment(config)
    results = experiment.run_experiment()
    
    return results


if __name__ == "__main__":
    main()
