import logging
import os


def setup_logger(model_name: str, dataset_name: str, log_directory: str) -> logging.Logger:
    log_filename = f"{model_name}_{dataset_name}.log"
    log_path = os.path.join(log_directory, log_filename)
    logger = logging.getLogger(f"{model_name}_{dataset_name}")
    logger.setLevel(logging.INFO)
    logger.propagate = False
    
    file_handler = logging.FileHandler(log_path)
    file_formatter = logging.Formatter("[%(asctime)s] [%(levelname)s] %(message)s", datefmt="%Y-%m-%d %H:%M:%S")
    file_handler.setFormatter(file_formatter)

    console_handler = logging.StreamHandler()
    console_formatter = logging.Formatter("[%(levelname)s] %(message)s")
    console_handler.setFormatter(console_formatter)

    if not logger.handlers:
        logger.addHandler(file_handler)
        logger.addHandler(console_handler)

    logger.info(f"Logging to file: {log_path}")
    
    return logger
