import pathlib
import os

# Root folder where your data lives
root_dir = pathlib.Path("original_vs_disctraction_rollouts")

# Find all mp4 files recursively in bridge/ and fractal/
mp4_files = list(root_dir.rglob("*.mp4"))

print(f"Found {len(mp4_files)} mp4 files to convert...")

for mp4_path in mp4_files:
    gif_path = mp4_path.with_suffix(".gif")
    # Build ffmpeg command (optimize fps + scale)
    cmd = f'ffmpeg -y -i "{mp4_path}" -vf "fps=10,scale=320:-1:flags=lanczos" "{gif_path}"'
    print(f"Converting: {mp4_path} -> {gif_path}")
    os.system(cmd)
