import os
from dotenv import load_dotenv

# Load environment variables from .env
load_dotenv()

# API Key
GOOGLE_GEMINI_API_KEY = os.getenv("GOOGLE_GEMINI_API_KEY")

# Models
LLM_MODEL_NAME = "gemini-2.5-pro"
EMBEDDING_MODEL_NAME = "gemini-embedding-001"

# RAG / cache thresholds
TOP_K_RAG2 = 5            # number of top documents to fetch from RAG2
THRESHOLD_RAG1 = 0.2      # 20% threshold for RAG1 scoring
THRESHOLD_RAG2 = 0.3      # 30% threshold for fallback RAG2
CACHE_HOT_PROMOTE = 4     # number of occurrences to promote to hot cache

# Data paths
DATA_DIR = "data"
TEXTBOOK_PDF = f"{DATA_DIR}/history_book.pdf"
QUESTIONS_EXCEL = f"{DATA_DIR}/questions.xlsx"
ANSWER_KEY_EXCEL = f"{DATA_DIR}/faculty_answers.xlsx"
STUDENT_ANSWERS_EXCEL = f"{DATA_DIR}/Student_Answers_Real.xlsx"
FAISS_INDEX_PATH = "faiss_index"
COLD_CACHE_JSON = f"{DATA_DIR}/final_cold_cache.json"
HOT_CACHE_JSON = f"{DATA_DIR}/final_hot_cache.json"
CACHE_PICKLE = f"{DATA_DIR}/final_cache.pkl"
