import { NextResponse } from "next/server"
import { getKeys, setKeys, hasKeys } from "@/lib/keys"

export const runtime = "nodejs"

export async function GET() {
  const present = hasKeys()
  return NextResponse.json({ present })
}

export async function POST(req: Request) {
  try {
    const { llm, trocr } = await req.json()
    if (llm && typeof llm !== "string") return NextResponse.json({ error: "invalid llm" }, { status: 400 })
    if (trocr && typeof trocr !== "string") return NextResponse.json({ error: "invalid trocr" }, { status: 400 })
    setKeys({ llm, trocr })
    const present = hasKeys()
    return NextResponse.json({ ok: true, present })
  } catch {
    return NextResponse.json({ error: "bad payload" }, { status: 400 })
  }
}
