import { NextResponse } from "next/server"

export async function POST(request: Request) {
  try {
    const body = await request.json()
    const { studentId, text, analysis, emailAddress } = body

    if (!emailAddress) {
      return NextResponse.json({ success: false, error: "emailAddress required" }, { status: 400 })
    }

    await new Promise((r) => setTimeout(r, 300))

    return NextResponse.json({ success: true, deliveredTo: emailAddress, studentId, receivedAt: new Date().toISOString() })
  } catch (e) {
    return NextResponse.json({ success: false, error: "Failed to process email delivery" }, { status: 500 })
  }
}
