import { NextResponse } from "next/server"

export async function POST(request: Request) {
  try {
    const body = await request.json()
    const { studentId, text, analysis, webhookUrl } = body

    if (!webhookUrl) {
      return NextResponse.json({ success: false, error: "webhookUrl required" }, { status: 400 })
    }

    await new Promise((r) => setTimeout(r, 300))

    // In real implementation, forward to webhookUrl
    return NextResponse.json({ success: true, forwardedTo: webhookUrl, studentId, receivedAt: new Date().toISOString() })
  } catch (e) {
    return NextResponse.json({ success: false, error: "Failed to process webhook delivery" }, { status: 500 })
  }
}
