import { NextResponse } from "next/server"
import { getRandomQuestions } from "@/lib/class12-questions"

export async function GET() {
  const historyQuestions = getRandomQuestions("History", 2)
  const geographyQuestions = getRandomQuestions("Geography", 2)
  const politicalScienceQuestions = getRandomQuestions("Political Science", 2)

  const allQuestions = [...historyQuestions, ...geographyQuestions, ...politicalScienceQuestions]

  const examData = {
    subject: "Class 12 - History, Geography & Political Science",
    duration: 180,
    totalMarks: allQuestions.reduce((sum, q) => sum + q.marks, 0),
    questions: allQuestions.map((q, index) => ({
      id: index + 1,
      text: q.question,
      marks: q.marks,
      subject: q.subject,
      type: q.type,
    })),
  }

  return NextResponse.json(examData)
}
