import { NextResponse } from "next/server"
import { publish } from "@/lib/realtime"

export const runtime = "nodejs"

export async function POST(req: Request) {
  try {
    const body = await req.json()
    const { studentId = "default", payload } = body

    if (!studentId || typeof studentId !== "string") {
      return NextResponse.json({ success: false, error: "studentId required" }, { status: 400 })
    }

    // sanitize payload to prevent throwing during stringify
    let safePayload: any = null
    try {
      safePayload = typeof payload === "string" || typeof payload === "number" || typeof payload === "boolean" ? payload : JSON.parse(JSON.stringify(payload))
    } catch (e) {
      safePayload = { error: "unserializable payload" }
    }

    publish(`student:${studentId}`, safePayload)
    return NextResponse.json({ success: true })
  } catch (e) {
    console.error("Publish SSE error:", e)
    return NextResponse.json({ success: false, error: "invalid payload" }, { status: 400 })
  }
}
