import Link from "next/link"
import { Button } from "@/components/ui/button"
import { Card, CardContent, CardDescription, CardHeader, CardTitle } from "@/components/ui/card"
import { Badge } from "@/components/ui/badge"
import { GraduationCap, Users, BarChart3, Settings, Shield, Zap, CheckCircle, ArrowRight } from "lucide-react"

export default function Home() {
  return (
    <main className="min-h-screen bg-background">
      <section className="section-padding border-b border-border/50">
        <div className="container-wide">
          <div className="text-center space-y-6 max-w-4xl mx-auto">
            <Badge variant="secondary" className="mb-4">
              AI-Powered Education Technology
            </Badge>
            <h1 className="text-5xl lg:text-6xl font-bold bg-gradient-to-r from-foreground to-muted-foreground bg-clip-text text-transparent">
              TrueGradeAI
            </h1>
            <p className="text-xl text-muted-foreground max-w-2xl mx-auto">
              Revolutionary examination platform combining handwriting recognition, AI-powered grading, and
              comprehensive analytics for modern education.
            </p>
            <div className="flex flex-col sm:flex-row gap-4 justify-center pt-4">
              <Button size="lg" className="text-lg px-8" asChild>
                <Link href="/student">
                  Get Started <ArrowRight className="ml-2 h-5 w-5" />
                </Link>
              </Button>
              <Button size="lg" variant="outline" className="text-lg px-8 bg-transparent" asChild>
                <Link href="/teacher">View Demo</Link>
              </Button>
            </div>
          </div>
        </div>
      </section>

      <section className="section-padding">
        <div className="container-wide">
          <div className="text-center mb-16">
            <h2 className="text-3xl font-bold mb-4">Platform Features</h2>
            <p className="text-muted-foreground text-lg max-w-2xl mx-auto">
              Comprehensive tools for students, educators, and administrators
            </p>
          </div>

          <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
            <Card className="glass-effect hover:shadow-lg transition-all duration-300 group">
              <CardHeader className="pb-4">
                <div className="w-12 h-12 rounded-lg bg-primary/10 flex items-center justify-center mb-4 group-hover:bg-primary/20 transition-colors">
                  <GraduationCap className="h-6 w-6 text-primary" />
                </div>
                <CardTitle className="text-xl">Student Interface</CardTitle>
                <CardDescription>
                  Secure digital exam experience with handwriting recognition and real-time authentication
                </CardDescription>
              </CardHeader>
              <CardContent className="pt-0">
                <ul className="space-y-2 text-sm text-muted-foreground mb-6">
                  <li className="flex items-center gap-2">
                    <CheckCircle className="h-4 w-4 text-primary" />
                    Multi-factor authentication
                  </li>
                  <li className="flex items-center gap-2">
                    <CheckCircle className="h-4 w-4 text-primary" />
                    Handwriting canvas
                  </li>
                  <li className="flex items-center gap-2">
                    <CheckCircle className="h-4 w-4 text-primary" />
                    Real-time progress tracking
                  </li>
                </ul>
                <Button asChild className="w-full">
                  <Link href="/student">Access Portal</Link>
                </Button>
              </CardContent>
            </Card>

            <Card className="glass-effect hover:shadow-lg transition-all duration-300 group">
              <CardHeader className="pb-4">
                <div className="w-12 h-12 rounded-lg bg-accent/10 flex items-center justify-center mb-4 group-hover:bg-accent/20 transition-colors">
                  <Users className="h-6 w-6 text-accent" />
                </div>
                <CardTitle className="text-xl">Teacher Dashboard</CardTitle>
                <CardDescription>Comprehensive monitoring and management tools for educators</CardDescription>
              </CardHeader>
              <CardContent className="pt-0">
                <ul className="space-y-2 text-sm text-muted-foreground mb-6">
                  <li className="flex items-center gap-2">
                    <CheckCircle className="h-4 w-4 text-accent" />
                    Live exam monitoring
                  </li>
                  <li className="flex items-center gap-2">
                    <CheckCircle className="h-4 w-4 text-accent" />
                    Result management
                  </li>
                  <li className="flex items-center gap-2">
                    <CheckCircle className="h-4 w-4 text-accent" />
                    Student analytics
                  </li>
                </ul>
                <Button asChild className="w-full" variant="secondary">
                  <Link href="/teacher">View Dashboard</Link>
                </Button>
              </CardContent>
            </Card>

            <Card className="glass-effect hover:shadow-lg transition-all duration-300 group">
              <CardHeader className="pb-4">
                <div className="w-12 h-12 rounded-lg bg-chart-3/10 flex items-center justify-center mb-4 group-hover:bg-chart-3/20 transition-colors">
                  <Zap className="h-6 w-6 text-chart-3" />
                </div>
                <CardTitle className="text-xl">AI Grading Pipeline</CardTitle>
                <CardDescription>Advanced AI-powered grading with TrOCR and Gemini 2.5 Pro</CardDescription>
              </CardHeader>
              <CardContent className="pt-0">
                <ul className="space-y-2 text-sm text-muted-foreground mb-6">
                  <li className="flex items-center gap-2">
                    <CheckCircle className="h-4 w-4 text-chart-3" />
                    Real-time processing
                  </li>
                  <li className="flex items-center gap-2">
                    <CheckCircle className="h-4 w-4 text-chart-3" />
                    Vector similarity search
                  </li>
                  <li className="flex items-center gap-2">
                    <CheckCircle className="h-4 w-4 text-chart-3" />
                    Explainable scoring
                  </li>
                </ul>
                <Button asChild className="w-full bg-transparent" variant="outline">
                  <Link href="/grading">Monitor Pipeline</Link>
                </Button>
              </CardContent>
            </Card>

            <Card className="glass-effect hover:shadow-lg transition-all duration-300 group">
              <CardHeader className="pb-4">
                <div className="w-12 h-12 rounded-lg bg-chart-2/10 flex items-center justify-center mb-4 group-hover:bg-chart-2/20 transition-colors">
                  <BarChart3 className="h-6 w-6 text-chart-2" />
                </div>
                <CardTitle className="text-xl">Analytics Dashboard</CardTitle>
                <CardDescription>
                  Comprehensive insights and performance analytics with AI recommendations
                </CardDescription>
              </CardHeader>
              <CardContent className="pt-0">
                <ul className="space-y-2 text-sm text-muted-foreground mb-6">
                  <li className="flex items-center gap-2">
                    <CheckCircle className="h-4 w-4 text-chart-2" />
                    Performance trends
                  </li>
                  <li className="flex items-center gap-2">
                    <CheckCircle className="h-4 w-4 text-chart-2" />
                    Interactive visualizations
                  </li>
                  <li className="flex items-center gap-2">
                    <CheckCircle className="h-4 w-4 text-chart-2" />
                    AI-generated insights
                  </li>
                </ul>
                <Button asChild className="w-full bg-transparent" variant="outline">
                  <Link href="/analytics">View Analytics</Link>
                </Button>
              </CardContent>
            </Card>

            <Card className="glass-effect hover:shadow-lg transition-all duration-300 group">
              <CardHeader className="pb-4">
                <div className="w-12 h-12 rounded-lg bg-chart-4/10 flex items-center justify-center mb-4 group-hover:bg-chart-4/20 transition-colors">
                  <Shield className="h-6 w-6 text-chart-4" />
                </div>
                <CardTitle className="text-xl">Appeals Management</CardTitle>
                <CardDescription>Transparent review process with detailed evidence analysis</CardDescription>
              </CardHeader>
              <CardContent className="pt-0">
                <ul className="space-y-2 text-sm text-muted-foreground mb-6">
                  <li className="flex items-center gap-2">
                    <CheckCircle className="h-4 w-4 text-chart-4" />
                    Evidence review
                  </li>
                  <li className="flex items-center gap-2">
                    <CheckCircle className="h-4 w-4 text-chart-4" />
                    Human oversight
                  </li>
                  <li className="flex items-center gap-2">
                    <CheckCircle className="h-4 w-4 text-chart-4" />
                    Audit trails
                  </li>
                </ul>
                <Button asChild className="w-full bg-transparent" variant="outline">
                  <Link href="/appeals">Manage Appeals</Link>
                </Button>
              </CardContent>
            </Card>

            <Card className="glass-effect hover:shadow-lg transition-all duration-300 group">
              <CardHeader className="pb-4">
                <div className="w-12 h-12 rounded-lg bg-chart-5/10 flex items-center justify-center mb-4 group-hover:bg-chart-5/20 transition-colors">
                  <Settings className="h-6 w-6 text-chart-5" />
                </div>
                <CardTitle className="text-xl">System Administration</CardTitle>
                <CardDescription>Complete platform management and configuration tools</CardDescription>
              </CardHeader>
              <CardContent className="pt-0">
                <ul className="space-y-2 text-sm text-muted-foreground mb-6">
                  <li className="flex items-center gap-2">
                    <CheckCircle className="h-4 w-4 text-chart-5" />
                    User management
                  </li>
                  <li className="flex items-center gap-2">
                    <CheckCircle className="h-4 w-4 text-chart-5" />
                    System monitoring
                  </li>
                  <li className="flex items-center gap-2">
                    <CheckCircle className="h-4 w-4 text-chart-5" />
                    Security controls
                  </li>
                </ul>
                <Button asChild className="w-full bg-transparent" variant="outline">
                  <Link href="/admin">Admin Panel</Link>
                </Button>
              </CardContent>
            </Card>
          </div>
        </div>
      </section>

      <footer className="border-t border-border/50 section-padding bg-muted/20">
        <div className="container-wide">
          <div className="text-center space-y-4">
            <h3 className="text-lg font-semibold">TrueGradeAI</h3>
            <p className="text-muted-foreground">Transforming education through AI-powered assessment technology</p>
            <div className="flex justify-center gap-4 text-sm text-muted-foreground">
              <span>© 2025 TrueGradeAI</span>
              <span>•</span>
              <span>Privacy Policy</span>
              <span>•</span>
              <span>Terms of Service</span>
            </div>
          </div>
        </div>
      </footer>
    </main>
  )
}
