"use client"

import { useState } from "react"
import { NavigationHeader } from "@/components/navigation-header"
import { GradeComparisonView } from "@/components/grade-comparison-view"
import { BatchGradingInterface } from "@/components/batch-grading-interface"
import { GradingRubricDisplay } from "@/components/grading-rubric-display"
import { Tabs, TabsContent, TabsList, TabsTrigger } from "@/components/ui/tabs"

// Mock data for demonstration
const mockGradeComparison = {
  studentName: "Alice Johnson",
  question:
    "Analyze the causes and consequences of the Revolt of 1857. How did it impact British colonial policy in India?",
  subject: "History" as const,
  humanGrade: {
    marks: 8,
    totalMarks: 10,
    feedback: "Good understanding of causes and consequences. Could include more specific examples of policy changes.",
    gradedBy: "Dr. Sarah Wilson",
  },
  aiGrade: {
    marks: 7,
    totalMarks: 10,
    feedback:
      "Demonstrates solid understanding of the revolt's causes including economic and military factors. Analysis of consequences is adequate but could be more detailed regarding specific policy changes like the Government of India Act.",
    confidence: 85,
  },
  finalGrade: {
    marks: 8,
    totalMarks: 10,
    method: "human" as const,
  },
}

const mockBatchItems = [
  {
    id: "1",
    studentName: "Alice Johnson",
    question: "Analyze the causes of the Revolt of 1857",
    subject: "History" as const,
    status: "completed" as const,
    estimatedTime: 45,
    actualTime: 42,
    marks: 8,
    totalMarks: 10,
  },
  {
    id: "2",
    studentName: "Bob Smith",
    question: "Explain sustainable development concepts",
    subject: "Geography" as const,
    status: "processing" as const,
    estimatedTime: 38,
    totalMarks: 8,
  },
  {
    id: "3",
    studentName: "Carol Davis",
    question: "Evaluate role of regional parties",
    subject: "Political Science" as const,
    status: "pending" as const,
    estimatedTime: 52,
    totalMarks: 12,
  },
]

const mockRubricCriteria = [
  {
    name: "Historical Knowledge",
    description: "Demonstrates accurate knowledge of historical facts and events",
    maxPoints: 25,
    earnedPoints: 20,
    feedback: "Good factual knowledge with minor gaps",
    status: "good" as const,
  },
  {
    name: "Analysis & Interpretation",
    description: "Shows critical thinking and analytical skills",
    maxPoints: 25,
    earnedPoints: 18,
    feedback: "Adequate analysis but could be more critical",
    status: "satisfactory" as const,
  },
]

export default function GradingPage() {
  const [isProcessing, setIsProcessing] = useState(false)

  const handleStartBatch = (selectedIds: string[]) => {
    setIsProcessing(true)
    // Simulate batch processing
    setTimeout(() => setIsProcessing(false), 5000)
  }

  const handlePauseBatch = () => {
    setIsProcessing(false)
  }

  return (
    <main className="min-h-screen bg-background">
      <NavigationHeader title="Advanced Grading Tools" badge="AI-Powered" />

      <div className="container mx-auto px-6 py-6">
        <Tabs defaultValue="batch" className="space-y-6">
          <TabsList className="grid w-full grid-cols-3">
            <TabsTrigger value="batch">Batch Grading</TabsTrigger>
            <TabsTrigger value="comparison">Grade Comparison</TabsTrigger>
            <TabsTrigger value="rubric">Detailed Rubric</TabsTrigger>
          </TabsList>

          <TabsContent value="batch">
            <BatchGradingInterface
              items={mockBatchItems}
              onStartBatch={handleStartBatch}
              onPauseBatch={handlePauseBatch}
              isProcessing={isProcessing}
            />
          </TabsContent>

          <TabsContent value="comparison">
            <GradeComparisonView comparison={mockGradeComparison} />
          </TabsContent>

          <TabsContent value="rubric">
            <GradingRubricDisplay criteria={mockRubricCriteria} totalPoints={50} earnedPoints={38} subject="History" />
          </TabsContent>
        </Tabs>
      </div>
    </main>
  )
}
