"use client"

import { useState } from "react"
import Link from "next/link"
import { Button } from "@/components/ui/button"
import { Card, CardContent, CardDescription, CardHeader, CardTitle } from "@/components/ui/card"
import { Badge } from "@/components/ui/badge"
import { Tabs, TabsContent, TabsList, TabsTrigger } from "@/components/ui/tabs"
import {
  Users,
  Settings,
  Shield,
  Database,
  Activity,
  AlertTriangle,
  CheckCircle,
  Clock,
  ArrowLeft,
  Server,
  Key,
  UserCheck,
  FileText,
} from "lucide-react"

export function AdminDashboard() {
  const [activeTab, setActiveTab] = useState("overview")

  return (
    <div className="min-h-screen bg-background">
      <header className="border-b border-border/50 bg-card/50 backdrop-blur-sm sticky top-0 z-50">
        <div className="container-wide py-4">
          <div className="flex items-center justify-between">
            <div className="flex items-center gap-4">
              <Button variant="ghost" size="sm" asChild>
                <Link href="/" className="flex items-center gap-2">
                  <ArrowLeft className="h-4 w-4" />
                  Back to Home
                </Link>
              </Button>
              <div className="h-6 w-px bg-border" />
              <h1 className="text-2xl font-bold">System Administration</h1>
            </div>
            <Badge variant="secondary">Admin Panel</Badge>
          </div>
        </div>
      </header>

      <div className="container-wide py-8">
        <Tabs value={activeTab} onValueChange={setActiveTab} className="space-y-6">
          <TabsList className="grid w-full grid-cols-5">
            <TabsTrigger value="overview">Overview</TabsTrigger>
            <TabsTrigger value="users">Users</TabsTrigger>
            <TabsTrigger value="system">System</TabsTrigger>
            <TabsTrigger value="security">Security</TabsTrigger>
            <TabsTrigger value="settings">Settings</TabsTrigger>
          </TabsList>

          <TabsContent value="overview" className="space-y-6">
            <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
              <Card>
                <CardHeader className="pb-2">
                  <CardTitle className="text-sm font-medium text-muted-foreground">Total Users</CardTitle>
                </CardHeader>
                <CardContent>
                  <div className="text-2xl font-bold">2,847</div>
                  <p className="text-xs text-muted-foreground">+12% from last month</p>
                </CardContent>
              </Card>

              <Card>
                <CardHeader className="pb-2">
                  <CardTitle className="text-sm font-medium text-muted-foreground">Active Exams</CardTitle>
                </CardHeader>
                <CardContent>
                  <div className="text-2xl font-bold">23</div>
                  <p className="text-xs text-muted-foreground">Currently running</p>
                </CardContent>
              </Card>

              <Card>
                <CardHeader className="pb-2">
                  <CardTitle className="text-sm font-medium text-muted-foreground">System Health</CardTitle>
                </CardHeader>
                <CardContent>
                  <div className="flex items-center gap-2">
                    <CheckCircle className="h-5 w-5 text-green-500" />
                    <span className="text-sm font-medium">Operational</span>
                  </div>
                  <p className="text-xs text-muted-foreground">All systems running</p>
                </CardContent>
              </Card>

              <Card>
                <CardHeader className="pb-2">
                  <CardTitle className="text-sm font-medium text-muted-foreground">Storage Used</CardTitle>
                </CardHeader>
                <CardContent>
                  <div className="text-2xl font-bold">67%</div>
                  <p className="text-xs text-muted-foreground">2.1TB of 3.2TB</p>
                </CardContent>
              </Card>
            </div>

            <div className="grid grid-cols-1 lg:grid-cols-2 gap-6">
              <Card>
                <CardHeader>
                  <CardTitle className="flex items-center gap-2">
                    <Activity className="h-5 w-5" />
                    System Status
                  </CardTitle>
                </CardHeader>
                <CardContent className="space-y-4">
                  <div className="flex items-center justify-between">
                    <span className="text-sm">AI Grading Pipeline</span>
                    <Badge variant="secondary" className="bg-green-500/10 text-green-500">
                      <CheckCircle className="h-3 w-3 mr-1" />
                      Online
                    </Badge>
                  </div>
                  <div className="flex items-center justify-between">
                    <span className="text-sm">Database Cluster</span>
                    <Badge variant="secondary" className="bg-green-500/10 text-green-500">
                      <CheckCircle className="h-3 w-3 mr-1" />
                      Online
                    </Badge>
                  </div>
                  <div className="flex items-center justify-between">
                    <span className="text-sm">Vector Search</span>
                    <Badge variant="secondary" className="bg-green-500/10 text-green-500">
                      <CheckCircle className="h-3 w-3 mr-1" />
                      Online
                    </Badge>
                  </div>
                  <div className="flex items-center justify-between">
                    <span className="text-sm">Authentication Service</span>
                    <Badge variant="secondary" className="bg-yellow-500/10 text-yellow-500">
                      <Clock className="h-3 w-3 mr-1" />
                      Maintenance
                    </Badge>
                  </div>
                </CardContent>
              </Card>

              <Card>
                <CardHeader>
                  <CardTitle className="flex items-center gap-2">
                    <AlertTriangle className="h-5 w-5" />
                    Recent Alerts
                  </CardTitle>
                </CardHeader>
                <CardContent className="space-y-4">
                  <div className="space-y-2">
                    <div className="text-sm font-medium">High CPU usage detected</div>
                    <div className="text-xs text-muted-foreground">Grading server #3 - 2 minutes ago</div>
                  </div>
                  <div className="space-y-2">
                    <div className="text-sm font-medium">Storage threshold reached</div>
                    <div className="text-xs text-muted-foreground">Database cluster - 15 minutes ago</div>
                  </div>
                  <div className="space-y-2">
                    <div className="text-sm font-medium">Failed login attempts</div>
                    <div className="text-xs text-muted-foreground">Security system - 1 hour ago</div>
                  </div>
                </CardContent>
              </Card>
            </div>
          </TabsContent>

          <TabsContent value="users" className="space-y-6">
            <Card>
              <CardHeader>
                <CardTitle className="flex items-center gap-2">
                  <Users className="h-5 w-5" />
                  User Management
                </CardTitle>
                <CardDescription>Manage student, teacher, and administrator accounts</CardDescription>
              </CardHeader>
              <CardContent>
                <div className="grid grid-cols-1 md:grid-cols-3 gap-4">
                  <Card>
                    <CardHeader className="pb-2">
                      <CardTitle className="text-sm">Students</CardTitle>
                    </CardHeader>
                    <CardContent>
                      <div className="text-2xl font-bold">2,456</div>
                      <Button size="sm" className="mt-2 w-full">
                        Manage Students
                      </Button>
                    </CardContent>
                  </Card>
                  <Card>
                    <CardHeader className="pb-2">
                      <CardTitle className="text-sm">Teachers</CardTitle>
                    </CardHeader>
                    <CardContent>
                      <div className="text-2xl font-bold">342</div>
                      <Button size="sm" className="mt-2 w-full">
                        Manage Teachers
                      </Button>
                    </CardContent>
                  </Card>
                  <Card>
                    <CardHeader className="pb-2">
                      <CardTitle className="text-sm">Administrators</CardTitle>
                    </CardHeader>
                    <CardContent>
                      <div className="text-2xl font-bold">49</div>
                      <Button size="sm" className="mt-2 w-full">
                        Manage Admins
                      </Button>
                    </CardContent>
                  </Card>
                </div>
              </CardContent>
            </Card>
          </TabsContent>

          <TabsContent value="system" className="space-y-6">
            <div className="grid grid-cols-1 lg:grid-cols-2 gap-6">
              <Card>
                <CardHeader>
                  <CardTitle className="flex items-center gap-2">
                    <Server className="h-5 w-5" />
                    Infrastructure
                  </CardTitle>
                </CardHeader>
                <CardContent className="space-y-4">
                  <Button className="w-full justify-start">
                    <Database className="h-4 w-4 mr-2" />
                    Database Management
                  </Button>
                  <Button className="w-full justify-start bg-transparent" variant="outline">
                    <Activity className="h-4 w-4 mr-2" />
                    Performance Monitoring
                  </Button>
                  <Button className="w-full justify-start bg-transparent" variant="outline">
                    <FileText className="h-4 w-4 mr-2" />
                    System Logs
                  </Button>
                </CardContent>
              </Card>

              <Card>
                <CardHeader>
                  <CardTitle className="flex items-center gap-2">
                    <Settings className="h-5 w-5" />
                    Configuration
                  </CardTitle>
                </CardHeader>
                <CardContent className="space-y-4">
                  <Button className="w-full justify-start">
                    <Key className="h-4 w-4 mr-2" />
                    API Keys & Integrations
                  </Button>
                  <Button className="w-full justify-start bg-transparent" variant="outline">
                    <Shield className="h-4 w-4 mr-2" />
                    Security Policies
                  </Button>
                  <Button className="w-full justify-start bg-transparent" variant="outline">
                    <UserCheck className="h-4 w-4 mr-2" />
                    Access Controls
                  </Button>
                </CardContent>
              </Card>
            </div>
          </TabsContent>

          <TabsContent value="security" className="space-y-6">
            <Card>
              <CardHeader>
                <CardTitle className="flex items-center gap-2">
                  <Shield className="h-5 w-5" />
                  Security Overview
                </CardTitle>
                <CardDescription>Monitor and manage system security</CardDescription>
              </CardHeader>
              <CardContent>
                <div className="grid grid-cols-1 md:grid-cols-2 gap-6">
                  <div className="space-y-4">
                    <h4 className="font-medium">Authentication</h4>
                    <div className="space-y-2 text-sm">
                      <div className="flex justify-between">
                        <span>Multi-factor Authentication</span>
                        <Badge variant="secondary" className="bg-green-500/10 text-green-500">
                          Enabled
                        </Badge>
                      </div>
                      <div className="flex justify-between">
                        <span>Biometric Verification</span>
                        <Badge variant="secondary" className="bg-green-500/10 text-green-500">
                          Active
                        </Badge>
                      </div>
                      <div className="flex justify-between">
                        <span>Session Management</span>
                        <Badge variant="secondary" className="bg-green-500/10 text-green-500">
                          Secure
                        </Badge>
                      </div>
                    </div>
                  </div>
                  <div className="space-y-4">
                    <h4 className="font-medium">Data Protection</h4>
                    <div className="space-y-2 text-sm">
                      <div className="flex justify-between">
                        <span>Encryption at Rest</span>
                        <Badge variant="secondary" className="bg-green-500/10 text-green-500">
                          AES-256
                        </Badge>
                      </div>
                      <div className="flex justify-between">
                        <span>Encryption in Transit</span>
                        <Badge variant="secondary" className="bg-green-500/10 text-green-500">
                          TLS 1.3
                        </Badge>
                      </div>
                      <div className="flex justify-between">
                        <span>Key Management</span>
                        <Badge variant="secondary" className="bg-green-500/10 text-green-500">
                          HSM
                        </Badge>
                      </div>
                    </div>
                  </div>
                </div>
              </CardContent>
            </Card>
          </TabsContent>

          <TabsContent value="settings" className="space-y-6">
            <Card>
              <CardHeader>
                <CardTitle className="flex items-center gap-2">
                  <Settings className="h-5 w-5" />
                  System Settings
                </CardTitle>
                <CardDescription>Configure global system parameters</CardDescription>
              </CardHeader>
              <CardContent className="space-y-6">
                <div className="grid grid-cols-1 md:grid-cols-2 gap-6">
                  <div className="space-y-4">
                    <h4 className="font-medium">Exam Configuration</h4>
                    <div className="space-y-2">
                      <Button variant="outline" className="w-full justify-start bg-transparent">
                        Default Exam Duration
                      </Button>
                      <Button variant="outline" className="w-full justify-start bg-transparent">
                        Grading Thresholds
                      </Button>
                      <Button variant="outline" className="w-full justify-start bg-transparent">
                        Appeal Timeframes
                      </Button>
                    </div>
                  </div>
                  <div className="space-y-4">
                    <h4 className="font-medium">AI Configuration</h4>
                    <div className="space-y-2">
                      <form
                        className="space-y-3"
                        onSubmit={async (e) => {
                          e.preventDefault()
                          const form = e.currentTarget as HTMLFormElement
                          const formData = new FormData(form)
                          const llm = String(formData.get("llm") || "")
                          const trocr = String(formData.get("trocr") || "")
                          await fetch("/api/admin/keys", {
                            method: "POST",
                            headers: { "Content-Type": "application/json" },
                            body: JSON.stringify({ llm, trocr }),
                          })
                          form.reset()
                          alert("Keys saved in memory for this session. For persistence, set env vars.")
                        }}
                      >
                        <label className="text-sm font-medium">LLM API Key</label>
                        <input name="llm" type="password" className="w-full px-3 py-2 border rounded-md" placeholder="sk-..." />
                        <label className="text-sm font-medium">TrOCR API Key</label>
                        <input name="trocr" type="password" className="w-full px-3 py-2 border rounded-md" placeholder="trocr-..." />
                        <Button type="submit" className="w-full mt-2">Save Keys (temporary)</Button>
                      </form>
                      <div className="text-xs text-muted-foreground">
                        For secure, persistent storage, set environment variables via project settings. Names:
                        <code className="ml-1">LLM_API_KEY</code> and <code>TROCR_API_KEY</code>.
                      </div>
                    </div>
                  </div>
                </div>
              </CardContent>
            </Card>
          </TabsContent>
        </Tabs>
      </div>
    </div>
  )
}
