import Link from "next/link"
import { Button } from "@/components/ui/button"
import { Badge } from "@/components/ui/badge"
import { ArrowLeft } from "lucide-react"

interface NavigationHeaderProps {
  title: string
  badge?: string
  backHref?: string
  backText?: string
}

export function NavigationHeader({ title, badge, backHref = "/", backText = "Back to Home" }: NavigationHeaderProps) {
  return (
    <header className="border-b border-border/50 bg-card/50 backdrop-blur-sm sticky top-0 z-50">
      <div className="container-wide py-4">
        <div className="flex items-center justify-between">
          <div className="flex items-center gap-4">
            <Button variant="ghost" size="sm" asChild>
              <Link href={backHref} className="flex items-center gap-2">
                <ArrowLeft className="h-4 w-4" />
                {backText}
              </Link>
            </Button>
            <div className="h-6 w-px bg-border" />
            <h1 className="text-2xl font-bold">{title}</h1>
          </div>
          {badge && <Badge variant="secondary">{badge}</Badge>}
        </div>
      </div>
    </header>
  )
}
