interface GradingRequest {
  question: string
  studentAnswer: string
  correctAnswer: string
  subject: "History" | "Geography" | "Political Science"
  totalMarks: number
}

interface GradingResponse {
  totalMarks: number
  awardedMarks: number
  pointBreakdown: {
    point: string
    awarded: boolean
    reason: string
  }[]
  overallFeedback: string
  suggestions: string[]
  similarityScore: number
}

export async function gradeAnswerWithAI(request: GradingRequest): Promise<GradingResponse> {
  try {
    const response = await fetch("/api/ai-grading", {
      method: "POST",
      headers: {
        "Content-Type": "application/json",
      },
      body: JSON.stringify(request),
    })

    if (!response.ok) {
      throw new Error("Failed to grade answer")
    }

    return await response.json()
  } catch (error) {
    console.error("Error grading answer:", error)
    throw error
  }
}

export function calculateGradeFromMarks(marks: number, totalMarks: number): string {
  const percentage = (marks / totalMarks) * 100

  if (percentage >= 90) return "A+"
  if (percentage >= 80) return "A"
  if (percentage >= 70) return "B+"
  if (percentage >= 60) return "B"
  if (percentage >= 50) return "C+"
  if (percentage >= 40) return "C"
  if (percentage >= 33) return "D"
  return "F"
}

export function getGradeColor(grade: string): string {
  switch (grade) {
    case "A+":
    case "A":
      return "text-green-600"
    case "B+":
    case "B":
      return "text-blue-600"
    case "C+":
    case "C":
      return "text-yellow-600"
    case "D":
      return "text-orange-600"
    case "F":
      return "text-red-600"
    default:
      return "text-gray-600"
  }
}

export function getSubjectSpecificCriteria(subject: "History" | "Geography" | "Political Science"): string[] {
  switch (subject) {
    case "History":
      return [
        "Historical accuracy and factual knowledge",
        "Understanding of chronology and causation",
        "Analysis of historical significance",
        "Use of historical evidence",
        "Critical evaluation of sources",
      ]
    case "Geography":
      return [
        "Understanding of geographical concepts",
        "Knowledge of spatial patterns",
        "Environmental awareness",
        "Use of case studies and examples",
        "Application of geographical skills",
      ]
    case "Political Science":
      return [
        "Understanding of political concepts",
        "Knowledge of Indian political system",
        "Analysis of democratic processes",
        "Critical evaluation of issues",
        "Use of political terminology",
      ]
    default:
      return []
  }
}
