export interface Class12Question {
  id: string
  subject: "History" | "Geography" | "Political Science"
  question: string
  marks: number
  timeLimit?: number
  type: "analytical" | "descriptive" | "case-study" | "comparative"
  keyPoints: string[]
  sampleAnswer: string
}

export const class12Questions: Class12Question[] = [
  // History Questions
  {
    id: "hist_1",
    subject: "History",
    question:
      "Analyze the causes and consequences of the Revolt of 1857. How did it impact British colonial policy in India?",
    marks: 12,
    type: "analytical",
    keyPoints: [
      "Multiple causes - economic, social, religious, military",
      "Economic exploitation and land revenue policies",
      "Social and religious reforms causing unrest",
      "Military grievances - cartridge issue, discrimination",
      "Consequences - end of East India Company rule",
      "Introduction of Crown rule and policy changes",
      "Impact on future freedom struggle",
    ],
    sampleAnswer:
      "The Revolt of 1857 was caused by multiple factors including economic exploitation through land revenue policies, social unrest due to British reforms, religious concerns over cartridge grease, and military discrimination. The consequences included the end of East India Company rule, introduction of Crown rule, and significant policy changes in British colonial administration.",
  },
  {
    id: "hist_2",
    subject: "History",
    question:
      "Evaluate the role of Mahatma Gandhi in the Indian freedom struggle. Discuss his methods and their effectiveness.",
    marks: 15,
    type: "analytical",
    keyPoints: [
      "Non-violent resistance (Satyagraha)",
      "Mass movements - Non-cooperation, Civil Disobedience",
      "Salt March and its significance",
      "Quit India Movement",
      "Impact on masses and international opinion",
      "Effectiveness in achieving independence",
    ],
    sampleAnswer:
      "Gandhi's role was pivotal through his philosophy of non-violent resistance. His methods included mass movements like Non-cooperation and Civil Disobedience, with the Salt March being particularly effective in mobilizing masses and gaining international attention. The Quit India Movement demonstrated the depth of anti-British sentiment.",
  },

  // Geography Questions
  {
    id: "geo_1",
    subject: "Geography",
    question:
      "Explain the concept of sustainable development with reference to India's environmental challenges. Suggest measures for achieving sustainability.",
    marks: 10,
    type: "descriptive",
    keyPoints: [
      "Definition of sustainable development",
      "Environmental challenges in India",
      "Air pollution in major cities",
      "Water scarcity and pollution",
      "Deforestation and biodiversity loss",
      "Climate change impacts",
      "Sustainable solutions and policies",
    ],
    sampleAnswer:
      "Sustainable development meets present needs without compromising future generations. India faces challenges like air pollution in Delhi-NCR, water scarcity in western regions, deforestation in Northeast, and climate change impacts. Solutions include renewable energy adoption, water conservation, afforestation, and sustainable urban planning.",
  },
  {
    id: "geo_2",
    subject: "Geography",
    question:
      "Analyze the distribution pattern of iron ore in India and its impact on the steel industry. Discuss the challenges faced by the industry.",
    marks: 12,
    type: "analytical",
    keyPoints: [
      "Major iron ore producing states",
      "Jharkhand, Odisha, Chhattisgarh deposits",
      "Quality and reserves",
      "Location of steel plants",
      "Transportation challenges",
      "Environmental concerns",
      "Competition and market issues",
    ],
    sampleAnswer:
      "Iron ore is concentrated in Jharkhand, Odisha, and Chhattisgarh forming the mineral belt. This has led to steel plants being located in these regions like Jamshedpur, Rourkela, and Bhilai. Challenges include transportation costs, environmental degradation, and competition from imports affecting the industry's growth.",
  },

  // Political Science Questions
  {
    id: "pol_1",
    subject: "Political Science",
    question:
      "Evaluate the role of regional parties in Indian democracy and coalition politics. How have they influenced national politics?",
    marks: 12,
    type: "analytical",
    keyPoints: [
      "Rise of regional parties post-1990s",
      "Representation of regional interests",
      "Coalition politics at national level",
      "Influence on policy making",
      "Federal balance and decentralization",
      "Challenges to national integration",
      "Examples of successful regional parties",
    ],
    sampleAnswer:
      "Regional parties have played a crucial role in Indian democracy by representing local interests and ensuring federal balance. They have been key players in coalition governments, influencing national policies on agriculture, language, and regional development. Parties like DMK, AIADMK, and JD(U) have significantly shaped national politics.",
  },
  {
    id: "pol_2",
    subject: "Political Science",
    question:
      "Discuss the challenges to democracy in contemporary India. Suggest measures to strengthen democratic institutions.",
    marks: 15,
    type: "analytical",
    keyPoints: [
      "Corruption in political system",
      "Criminalization of politics",
      "Money power in elections",
      "Communalism and identity politics",
      "Media manipulation",
      "Weakening of institutions",
      "Electoral reforms needed",
      "Strengthening measures",
    ],
    sampleAnswer:
      "Contemporary challenges include corruption, criminalization of politics, excessive money power in elections, and communal polarization. Media manipulation and weakening institutions pose additional threats. Measures include electoral reforms, transparency in funding, strengthening anti-corruption mechanisms, and promoting civic education to strengthen democracy.",
  },
]

export const getQuestionsBySubject = (subject: "History" | "Geography" | "Political Science") => {
  return class12Questions.filter((q) => q.subject === subject)
}

export const getAllSubjects = () => {
  return ["History", "Geography", "Political Science"] as const
}

export const getRandomQuestions = (subject: "History" | "Geography" | "Political Science", count = 2) => {
  const subjectQuestions = getQuestionsBySubject(subject)
  const shuffled = [...subjectQuestions].sort(() => 0.5 - Math.random())
  return shuffled.slice(0, count)
}
