let LLM_API_KEY: string | null = null
let TROCR_API_KEY: string | null = null

export function setKeys({ llm, trocr }: { llm?: string; trocr?: string }) {
  if (typeof llm === "string" && llm.trim()) LLM_API_KEY = llm.trim()
  if (typeof trocr === "string" && trocr.trim()) TROCR_API_KEY = trocr.trim()
}

export function getKeys() {
  return {
    llm: LLM_API_KEY,
    trocr: TROCR_API_KEY,
  }
}

export function hasKeys() {
  return {
    llm: !!LLM_API_KEY,
    trocr: !!TROCR_API_KEY,
  }
}
