type Subscriber = (event: string) => void

const channels: Map<string, Set<Subscriber>> = new Map()

export function subscribe(channel: string, listener: Subscriber) {
  if (!channels.has(channel)) channels.set(channel, new Set())
  channels.get(channel)!.add(listener)
  return () => {
    channels.get(channel)?.delete(listener)
    if (channels.get(channel)?.size === 0) channels.delete(channel)
  }
}

export function publish(channel: string, data: any) {
  const payload = JSON.stringify({ data, timestamp: new Date().toISOString() })
  channels.get(channel)?.forEach((fn) => fn(payload))
}
