# 本地部署 Qwen2.5-14B-Instruct 并通过 OpenAI API 协议调用

本指南介绍如何使用 FastChat 框架，将本地 Qwen2.5-14B-Instruct 大模型部署为兼容 OpenAI API 的服务，实现与 OpenAI 官方 API 一致的调用方式。

## 步骤说明

### 1. 启动 FastChat 控制器

```bash
python3 -m fastchat.serve.controller &
```
**作用**：
- 启动 FastChat 的任务调度控制器，负责管理后端模型 worker。

### 2. 启动模型 Worker

```bash
python3 -m fastchat.serve.model_worker --model-path /data/Qwen2.5-14B-Instruct --model-names qwen2.5-14b-instruct &
```
**作用**：
- 启动一个模型推理进程，加载本地 Qwen2.5-14B-Instruct 权重。
- `--model-path` 指定模型权重目录。
- `--model-names` 指定该 worker 的模型名称（后续 API 调用时需一致）。

### 3. 启动 OpenAI API 兼容服务

```bash
python3 -m fastchat.serve.openai_api_server --host 0.0.0.0 --port 8000
```
**作用**：
- 启动一个兼容 OpenAI API 协议的 HTTP 服务。
- 监听 8000 端口，允许本地/局域网通过 OpenAI API 协议访问本地大模型。

## 调用示例（Python）

```python
import openai
openai.api_key = "EMPTY"  # FastChat 不校验 key
openai.base_url = "http://localhost:8000/v1"

response = openai.ChatCompletion.create(
    model="qwen2.5-14b-instruct",
    messages=[
        {"role": "system", "content": "你是一个有用的助手。"},
        {"role": "user", "content": "请简要介绍一下图像质量评价的常用指标。"}
    ]
)
print(response['choices'][0]['message']['content'])
```

## 注意事项
- 需提前安装 fastchat 及其依赖。
- `--model-path` 路径需替换为你本地实际模型目录。
- 启动顺序建议：controller → model_worker → openai_api_server。
- 端口和 host 可根据实际需求调整。
- 只需将 openai-python 的 `base_url` 指向本地服务即可无缝切换。
