
#include <torch/extension.h>

torch::Tensor ts_spmm_fp32(torch::Tensor rowptr, torch::Tensor col,
                        torch::Tensor value, torch::Tensor mat);

torch::Tensor ts_fuse_fp32(torch::Tensor rowptr, torch::Tensor col,
                        torch::Tensor value, torch::Tensor mat, torch::Tensor w,
                        bool materialize);

PYBIND11_MODULE(TORCH_EXTENSION_NAME, m) {
    m.def("ts_spmm_fp32", &ts_spmm_fp32, "ts spmm");
    m.def("ts_fuse_fp32", &ts_fuse_fp32, "ts fuse");
}