#!/bin/bash
METRICS="achieved_occupancy,flop_sp_efficiency,global_hit_rate,local_hit_rate,tex_cache_hit_rate,stall_memory_dependency"
ITERS=10
N=256

nvprof --metrics "${METRICS}" -- python prof.py /app/datasets/ dense ${N} --iters ${ITERS} --dataset arxiv
nvprof --metrics "${METRICS}" -- python prof.py /app/datasets/ dense ${N} --iters ${ITERS} --dataset reddit

nvprof --metrics "${METRICS}" -- python prof.py /app/datasets/ sparse ${N} --iters ${ITERS} --dataset arxiv
nvprof --metrics "${METRICS}" -- python prof.py /app/datasets/ sparse ${N} --iters ${ITERS} --dataset reddit

nvprof --metrics "${METRICS}" -- python prof.py /app/datasets/ sparse ${N} --iters ${ITERS} --dataset arxiv --fuse
nvprof --metrics "${METRICS}" -- python prof.py /app/datasets/ sparse ${N} --iters ${ITERS} --dataset reddit --fuse
