# Memory Efficient GNNs

## Overview

This repo provides the implementation of the Efficient Graph Convolution (EGC) layer using PyTorch Geometric.
We include experiments from the paper which we ran, and pretrained models (even for baselines which we trained).

- `hyperparameters.md` contains Hyperparameters and experiment details.
- `experiments/layers.py` contains the layer definitions for EGC, and is likely what you are most interested in.
- The `experiments` directory contains subdirectories for each experiment dataset.
- The `kernels` folder includes code to evaluate the CPU/GPU implementations of aggregator fusion. More information is provided in a README there.
- The code is structured using an experiment tuning library ([exptune](https://github.com/shyam196/exptune)).

## Getting Started
To set the dataset location, use the `DATASET_LOC` environment variable; the default will be `~/datasets`.

Alternatively, you can use conda.
In a new conda env, you can run:

```bash
# installing pytorch:
conda install pytorch=1.7.1 torchvision torchaudio cudatoolkit=10.1 -c pytorch

# PyG requires scipy but doesn't seem to install it itself.
pip install scipy

# Torch geometric stuff:
pip install --no-index torch-scatter -f https://pytorch-geometric.com/whl/torch-1.7.0+cu101.html
pip install --no-index torch-sparse -f https://pytorch-geometric.com/whl/torch-1.7.0+cu101.html
pip install --no-index torch-cluster -f https://pytorch-geometric.com/whl/torch-1.7.0+cu101.html
pip install --no-index torch-spline-conv -f https://pytorch-geometric.com/whl/torch-1.7.0+cu101.html
pip install torch-geometric

# Finally, install this repo's requirements from the requirements.txt
pip install -r requirements.txt
```

### Using Pre-Trained Models

The script `run_pretrained.sh` provides all the commands you need to download the models and perform a run over the test set.

### Re-Generating Experiment Results

We provide two scripts to generate the results for the main table, and for ablation studies
This is discussed in more depth in `hyperparameters.md`.

