BeginPackage["PEP`"]

CvxConstraint::usage = "CvxConstraint[xi, xj, fi, fj, gi, gj, l, m] returns the strong convexity, Lipschitz continuity constraint for the given variables.";
Lagrangian::usage = "Lagrangian[objective, constraints, variables] returns the Lagrangian for the given objective and constraints.";
CompressConstraint::usage = "CompressConstraint[o, c, e] returns the compressibility constraint for the given variables.";

Begin["`Private`"]

CvxConstraint[xi_, xj_, fi_, fj_, gi_, gj_, l_, m_] := fj - fi + gj*(xi - xj) + 1 / (2*l)*(gi - gj)^2 + m / (2*(1 - m / l)) * (xi - xj - 1/l * (gi - gj))^2;
Lagrangian[objective_, constraints_, variables_] := objective - Sum[variables[[i]] * constraints[[i]], {i, 1, Length[constraints]}];
CompressConstraint[o_, c_, e_] := (o - c)^2 - e*o^2;

End[]
EndPackage[]