# Reviewer Instructions for NeurIPS 2025

NOTE: for any of this to work you need to have MOSEK with a valid license.

This repository contains the code to reproduce all figures and tables from our paper. To facilitate reproducibility, we have implemented:

- A command-line interface for generating individual figures/tables or all results at once
- Automatic data caching to avoid recomputing results unnecessarily

## Setup

To get started, we recommend creating a new virtual environment:

```bash
python -m venv venv
source venv/bin/activate  # On Unix/macOS
# or
.\venv\Scripts\activate  # On Windows
pip install -r requirements.txt
```

## Running Experiments

The experiments can be run in two ways:

1. Generate all figures and tables at once:
```bash
python neurips.py all
```

2. Generate individual figures or tables:
```bash
# Generate Figure 1 (performance comparison)
python neurips.py "Figure 1"

# Generate Table 1 (EF vs EF21 comparison)
python neurips.py "Table 1"
```

Note: 
- Running all experiments from scratch takes approximately 30 minutes on a modern machine (tested on a MacBook Pro with M4 Max). Subsequent runs are pretty much immediate because of the saved data. 
- You should delete the data folder if you make any changes to the code.
