# Reliability-Adjusted Prioritized Experience Replay (ReaPER)

**ReaPER** is a novel reinforcement learning technique that builds upon Prioritized Experience Replay (PER) by incorporating a reliability-adjusted temporal-difference error (TDE), which prioritizes experiences not just by surprise, but also by trustworthiness, enhancing learning efficiency.

This project extends the [Stable Baselines3](https://github.com/DLR-RM/stable-baselines3) framework and includes an implementation of ReaPER integrated with a Double Deep Q-Network (DDQN) agent. It supports customizable environments and flexible training configurations.

---

## Project Structure

```
.
├── run.py                              # Main script to launch training
├── requirements.txt                    # Required Python packages
├── README.md                           # Project overview and setup guide
├── custom_buffers/                    
│   └── reaper.py                       # ReaPER buffer implementation
├── custom_policies/
│   └── custom_ddqn.py                  # DDQN agent modified for ReaPER
├── utils/   
│   ├── storage.py                      # Utility: result storage path handling
│   └── environment.py                  # Utility: environment config & hyperparameters
└── results/                            # Output directory for logs and models (created at runtime)
```

---

## Installation

To set up the environment:

```bash
python -m venv venv
source venv/bin/activate       # On Windows: venv\Scripts\activate
pip install -r requirements.txt
```

---

## Usage

To start training an agent, run:

```bash
python run.py
```

You can modify the training environment name directly in `run.py`.

---

## Logging & Evaluation

Training metrics are logged in TensorBoard format and saved under the `results/` directory. You can visualize them using:

```bash
tensorboard --logdir results/
```

---

## License

This project is licensed under the **Creative Commons Attribution 4.0 International License (CC BY 4.0)**.  
See the [LICENSE](https://creativecommons.org/licenses/by/4.0/) for details.