import os

import pandas as pd

from kal.active_strategies import STRATEGIES, NAME_MAPPINGS

datasets = [
    "xor",
    "iris",
    "animals",
    "cub200",
]
dataset_mappings = {
    "xor": "XOR",
    "iris": "Iris",
    "animals": "Animals",
    "cub200": "CUB200",
}

# dfs = {
#     "Method": [],
#     "XOR": [],
#     "Iris": [],
#     "Animals": [],
#     "CUB200": []
# }
dfs = []
for dataset in datasets:
    result_df = pd.read_pickle(os.path.join(dataset, "results.pkl"))

    df_mean = result_df.groupby(["Strategy"]).mean()['Time']
    baseline = df_mean['Random']
    df_mean_percentage = (df_mean / baseline - 1) * 100

    # df_mean_over_seeds = result_df.groupby(["Strategy", "Seed", "Iteration"]).mean()
    result_df['Time Percentage'] = (result_df['Time'] / baseline - 1) * 100
    df_std = result_df.groupby('Strategy').std()

    strategies = []
    times = []
    for i, (mean, std) in enumerate(zip(df_mean_percentage, df_std)):
        strategy = df_mean.index[i]
        if strategy not in STRATEGIES:
            continue
        strategies.append(strategy)
        times.append(f"$+{mean:.2f}$ {{\\tiny $\\pm {std:.2f}$ }}")

    df_dataset = pd.DataFrame({
        "Strategy": strategies,
        f"{dataset_mappings[dataset]} Time": times
    })
    dfs.append(df_dataset)

dfs = pd.concat(dfs, axis=1, join="outer")

print(dfs.to_latex(float_format="%.2f", escape=False))
with open(f"time_table.txt", "w") as f:
    f.write(dfs.to_latex(float_format="%.2f", escape=False))
