import os

import pandas as pd

strategies = [
    CAL := "constrained",
    SUPERVISED := "supervised",
    RANDOM := "random"
]

strategies_mappings = {
    CAL: "KAL",
    SUPERVISED: "SupLoss",
    RANDOM: "Random",
}

result_folder = "dogvsperson"
dataset = "Dog vs Person"
points = [1000, 1500, 2000, 2500, 3000]
seeds = range(3)

dfs = {
    "Dataset": [],
    "Seed": [],
    "Iter": [],
    "Points": [],
    "KAL": [],
    "SupLoss": [],
    "Random": [],
}

for seed in seeds:
    for i, used_points in enumerate(points):
        dfs["Dataset"].append(dataset)
        dfs["Seed"].append(seed)
        dfs["Iter"].append(i)
        dfs["Points"].append(used_points)
        for strategy in strategies:
            df_file = os.path.join(result_folder, f"metrics_{strategy}_strategy_{seed}_seed_"
                                                  f"{used_points}_points.pkl")
            if i == 0:
                df_file = os.path.join(result_folder, f"metrics_{CAL}_strategy_{seed}_seed_"
                                                      f"{used_points}_points.pkl")
            df = pd.read_pickle(df_file)
            test_map = df['test accuracy'].item() * 100
            dfs[strategies_mappings[strategy]].append(test_map)

dfs = pd.DataFrame(dfs)
df_mean = dfs.groupby("Dataset").mean()
df_std = dfs.groupby(["Dataset", "Seed"]).mean().groupby("Dataset").std()

df_final = pd.DataFrame({
    "Dataset": [dataset],
    "SupLoss": [f"${df_mean['SupLoss'].item():.2f}$ {{\\tiny $\\pm {df_std['SupLoss'].item():.2f}$ }}"],
    "Random": [f"${df_mean['Random'].item():.2f}$ {{\\tiny $\\pm {df_std['Random'].item():.2f}$ }}"],
    "KAL": [f"${df_mean['KAL'].item():.2f}$ {{\\tiny $\\pm {df_std['KAL'].item():.2f}$ }}"]
})

print(df_final.to_latex(float_format="%.2f", escape=False))
with open(f"obj_rec_table.txt", "w") as f:
    f.write(df_final.to_latex(float_format="%.2f", escape=False))
