def construct_prompt_text2action(entry):
    prompt = f'''You are a real-world agent, and you will plan action-object sequences for the real-world tasks. You will be provided with 'Task Description', 'Allowed Actions', 'Visible Objects', and 'Already Executed Action-Object Sequences'. The 'Task Description' is a user instruction that instructs you to complete the task. The 'Allowed Actions' is a list of actions that are allowed to be used by you to complete the task. The 'visible objects' is a list of objects that are assumed to be visible to you when you are completing the task. The 'Already Executed Action-Object Sequences' is a list of action-object sequences that are assumed to have been completed by you at the moment. You need to plan the remaining action-object sequences to complete the task.

Below is a simplified example:

**Start of Example**
Task Description: Put a heated egg in the sink.
Allowed Actions: [OpenObject], [CloseObject], [PickupObject], [PutObject], [ToggleObjectOn], [ToggleObjectOff], [SliceObject], [Navigation]
Visible Objects: <microwave>, <sink>, <toaster>, <coffee maker>, <fridge>, <blender>, <potato>, <bows>, <egg>, <garbagecan>
Already Executed Action-Object Sequences: [Navigation] <fridge>, [OpenObject] <fridge>, [PickupObject] <egg>, [CloseObject] <fridge>, [Navigation] <microwave>, [PutObject] <egg> <microwave>
Your Planning: [ToggleObjectOn] <microwave>, [ToggleObjectOff] <microwave>, [PickupObject] <egg>, [Navigation] <sink>, [PutObject] <egg> <sink>
**End of Example**

With the above description and example, plan the remaining action-object sequences for the below task:

Task Description: {entry["task description"]}
Allowed Actions: {entry["allowed actions"]}
Visible Objects: {entry["visible objects"]}
Already Executed Action-Object Sequences: {entry["already executed steps"]}
Your Planning: 
'''
    
    return prompt


def read_image(image_path):
    # write the image processing according to the model
    
    return processed_image

def construct_prompt_image2action(entry, example_image_path):
    prompt = f'''You are a real-world agent, and you will plan action-object sequences for the real-world tasks. You will be provided with 'Task Description', 'Allowed Actions', 'Visible Objects', and 'Already Executed Action-Object Sequences'. The 'Task Description' is a user instruction that instructs you to complete the task. The 'Allowed Actions' is a list of actions that are allowed to be used by you to complete the task. The 'visible objects' is an image indicating the objects visible to you when you are completing the task. The 'Already Executed Action-Object Sequences' is a list of action-object sequences that are assumed to have been completed by you at the moment. You need to plan the remaining action-object sequences to complete the task.

Below is a simplified example:

**Start of Example**
Task Description: Get the egg from the fridge, and put the heated egg in the sink.
Allowed Actions: [OpenObject], [CloseObject], [PickupObject], [PutObject], [ToggleObjectOn], [ToggleObjectOff], [SliceObject], [Navigation]
Visible Objects: {read_image(example_image_path)}
Already Executed Action-Object Sequences: [Navigation] <fridge>, [OpenObject] <fridge>, [PickupObject] <egg>, [CloseObject] <fridge>, [Navigation] <microwave>, [PutObject] <egg> <microwave>
Your Planning: [ToggleObjectOn] <microwave>, [ToggleObjectOff] <microwave>, [PickupObject] <egg>, [Navigation] <sink>, [PutObject] <egg> <sink>
**End of Example**

With the above description and example, plan the remaining action-object sequences for the below task:

Task Description: {entry["task description"]}
Allowed Actions: {entry["allowed actions"]}
Visible Objects: {read_image(root_dir + entry["image_id"])}
Already Executed Action-Object Sequences: {entry["already executed steps"]}
Your Planning: 
'''
    
    return prompt