_base_ = './base_config.py'

# model settings
model = dict(
    name_path='./configs/cls_potsdam.txt',
    prob_thd=0.1,
    bg_idx=5,
    ignore_residual=True,
    logits_lambda=0.1,
    visual_query_lambda=0.3,
    cluster_num=3
)

# dataset settings
dataset_type = 'PotsdamDataset'
data_root = 'datasets/potsdam'

test_pipeline = [
    dict(type='LoadImageFromFile'),
    dict(type='Resize', scale=(448, 448), keep_ratio=True),
    # add loading annotation after ``Resize`` because ground truth
    # does not need to do resize data transform
    dict(type='LoadAnnotations'),
    dict(type='PackSegInputs')
]

test_dataloader = dict(
    batch_size=1,
    num_workers=4,
    persistent_workers=True,
    sampler=dict(type='DefaultSampler', shuffle=False),
    dataset=dict(
        type=dataset_type,
        data_root=data_root,
        data_prefix=dict(
            img_path='img_dir/val',
            seg_map_path='ann_dir/val'),
        pipeline=test_pipeline))