BENCHMARK=${BENCHMARK:-""}
CONFIG=./configs/cfg_${BENCHMARK}.py

WORK_DIR=${WORK_DIR:-"./temp"}
GPUS=${GPUS:-8}
VISIBLE_GPUS=${VISIBLE_GPUS:-"0,1,2,3,4,5,6,7"}
NNODES=${NNODES:-1}
NODE_RANK=${NODE_RANK:-0}
PORT=${PORT:-29500}
MASTER_ADDR=${MASTER_ADDR:-"127.0.0.1"}

export CUDA_VISIBLE_DEVICES=$VISIBLE_GPUS

PYTHONPATH="$(dirname $0)/..":$PYTHONPATH \
python -m torch.distributed.launch \
    --nnodes=$NNODES \
    --node_rank=$NODE_RANK \
    --master_addr=$MASTER_ADDR \
    --nproc_per_node=$GPUS \
    --master_port=$PORT \
    $(dirname "$0")/eval.py \
    --config $CONFIG \
    --work-dir $WORK_DIR/${BENCHMARK} \
    --launcher pytorch \
    ${@:4}