# PAVI examples

## Directory organization
* scripts in this directory are related to various experiments performed in our submitted paper
* subdirectory `generative_hbms` contains tensorflow-probability distributions used as input for our architecture.

## Experiments

All scripts naming follow the same pattern:
* the HBM is indicated at first:
    * `GRE_*` refers to the model from **sec 4.1, 4.2, 4.3, B.2**
    * `HCPL_*` refers to the model from **sec 4.4, B.3.3**
    * `GM_*` refers to the model from **sec B.3.1**
    * `HV_*` refers to the model from **sec B.3.2**
* then the method is indicated

As an exmaple, `GRE_PAVI-F.py` refers to the application of our method PAVI-F to the Gaussian random effects example.

All scripts fit the given method on the given HBM's data, then produce a loss, some samples, and store away results in `../data/`. In addition, scripts display the inference results on a few data points.

Scripts can be ran in interactive mode (as they are `# %%`-decorated), or as `python` scripts **FROM THIS DIRECTORY** (not to break relative paths), in which case:
* for *non-sample-amortized* methods the data index of the point the method is fit upon can be fed using the `--na-val-idx` command line argument
* for the `GRE_*` scripts, the number of groups $G$ can be fed using the `--G` command line argument. Baware that $G=200$ results in significant ressource usage

For instance:
```bash
python GRE_CF.py --G 20 --na-val-idx 4
```
launches a non-sample-amortized Cascading Flows on the $4^{th}$ Gaussian random effects' data point with $G=20$ groups.

## Note on HCP data usage
We cannot freely distribute data from the [Human Connectome Project](https://www.humanconnectome.org/). To run our HCPL model at scale, and to visualize our results, one would typically need to have access to the HCP dataset, which in our understanding goes beyond the scope of this review process.

As a consequence, experiments related to the application of our architecture to HCP data are not presented here. Nonetheless, the script `HCPL_PAVI-F.py` constitutes a good proxy for it.