from typing import List


def get_stops(
    full_size: int,
    batch_size: int
) -> List[int]:
    return (
        [
            s
            for s in range(
                batch_size,
                full_size,
                batch_size
            )
        ]
        + [full_size]
    )


def get_ranges(
    full_size: int,
    batch_size: int
) -> List[List[int]]:
    stops = get_stops(full_size, batch_size)
    ranges = [
        [
            v
            for v in range(
                stop - batch_size,
                stop
            )
        ]
        for stop in stops
    ]

    return ranges
