import tensorflow as tf


def tril_eye(
    num_rows,
    num_columns=None,
    batch_shape=None,
    dtype=tf.dtypes.float32
) -> tf.Tensor:

    eye = tf.eye(
        num_rows,
        num_columns,
        batch_shape,
        dtype
    )

    return tf.concat(
        [
            eye[..., i:, i:]
            for i in range(num_rows)
        ],
        axis=-1
    )
