function main(num_edges, sd, num_iter)
    rng("shuffle")
    pitprops = readtable("pitprops.csv");
    true_M = table2array(pitprops(:,2:end));
    d = length(true_M);

    true_support = [1,2,7,8,9,10];
    true_idx = zeros(d,1);
    true_idx(true_support) = 1;
    s = length(true_support);

    rho_list = 0.025:0.025:1;
    mu_list = 0.1:0.1:2;
    alpha_list = 0:0.5:7;
    gamma_list = 0:0.5:7;
    delta_list = 0.2:0.2:2;

    threshold = 1e-4;

    gp_list = 0:0.2:2;
    for gp = gp_list
        iter = 0;
        while iter < num_iter
            sdp_res = zeros(size(rho_list));
            sdp_complete_res = zeros(size(rho_list));
            dt_res = [];
            it_res = [];
            dt_complete_res = [];
            it_complete_res = [];
            amanpg_res = [];
            amanpg_complete_res = [];
            gpm_res = [];
            gpm_complete_res = [];

            %% Create Adjacency Matrix
            p = num_edges/(d^2);
            while 1
                A = triu(rand(d,d)<=p);
                A = triu(A,1) + A';
                if (sum(sum(A)) ~= num_edges)
                    continue
                end
                A1 = A(true_support,true_support);
                L = diag(sum(A1))-A1;
                eL = eig(L);
                L_eig_2 = eL(2);
                if L_eig_2 < 0 
                    L_eig_2 = 0;
                end
                A1_tilde = ones(s) - eye(s) - A1;
                L_tilde = diag(sum(A1_tilde)) - A1_tilde;
                eL_tilde = eig(L_tilde);
                L_eig_2_tilde = eL_tilde(2);
                if L_eig_2_tilde < 0 
                    L_eig_2_tilde = 0;
                end
                delta_min = min(sum(A1));
                delta_max = max(sum(A1));
                temp_gp = max([delta_max-L_eig_2, s-delta_min-L_eig_2_tilde])/L_eig_2;
                if (temp_gp > gp) && (temp_gp <= gp+0.2)
                    break
                end
            end

            graph_properties = [temp_gp, delta_min, delta_max, gp, L_eig_2, L_eig_2_tilde];

            %% Add Noise
            N = sd*triu(randn(d));
            N = triu(N,1) + N';

            M = (true_M + N).*A;

            
            %% Matrix Completion
            M_complete = matrix_completion(M, A, d);
            relative_error = norm(M_complete - true_M, "fro")/norm(true_M, "fro");      
            
            %% SDP
            M_hat = sdp_optim(M, 0, d);
            var0 = trace(M*M_hat);

            res = [];
            for i = 1:length(rho_list)
                rho = rho_list(i);
                M_hat = sdp_optim(M, rho, d);
                if abs(sum(diag(M_hat))-1) > 1e-7
                    break
                end
                var1 = trace(M*M_hat);
                num_select = sum((diag(M_hat) > threshold));
                cp = 0.6*var1/var0 + 0.4*(d-num_select)/d;
                exact_recovery = double(sum((diag(M_hat)>threshold)==true_idx)==d);
                res = [res; [cp, exact_recovery]];
                sdp_res(i) = exact_recovery;
            end
            [~,max_idx] = max(res(:,1));
            selected_sdp_res = res(max_idx,2);


            %% SDP with Completion
            M_hat = sdp_optim(M_complete, 0, d);
            var0 = trace(M_complete*M_hat);

            res = [];
            for i = 1:length(rho_list)
                rho = rho_list(i);
                M_hat = sdp_optim(M_complete, rho, d);
                if abs(sum(diag(M_hat))-1) > 1e-7
                    break
                end
                var1 = trace(M_complete*M_hat);
                num_select = sum((diag(M_hat) > threshold));
                cp = 0.6*var1/var0 + 0.4*(d-num_select)/d;
                exact_recovery = double(sum((diag(M_hat)>threshold)==true_idx)==d);
                res = [res; [cp, exact_recovery]];
                sdp_complete_res(i) = exact_recovery;
            end
            [~,max_idx] = max(res(:,1));
            selected_sdp_complete_res = res(max_idx,2);

            %% Thresholding
            for alpha = alpha_list
                for gamma = gamma_list
                    [u, v] = TSPCA(M, d, alpha, gamma);
                    exact_recovery = double(sum((abs(v)>sqrt(threshold))==true_idx)==d);
                    it_res = [it_res, exact_recovery];
                end
                exact_recovery = double(sum((abs(u)>sqrt(threshold))==true_idx)==d);
                dt_res = [dt_res, exact_recovery];
            end
            
            %% Thresholding with Completion
            for alpha = alpha_list
                for gamma = gamma_list
                    [u, v] = TSPCA(M_complete, d, alpha, gamma);
                    exact_recovery = double(sum((v>sqrt(threshold))==true_idx)==d);
                    it_complete_res = [it_complete_res, exact_recovery];
                end
                exact_recovery = double(sum((u>sqrt(threshold))==true_idx)==d);
                dt_complete_res = [dt_complete_res, exact_recovery];
            end
            
            %% A-ManPG
            [~,~,Vu] = svds(M,1);  
            phi_init = Vu;
            for mu = mu_list
                option_manpg_alt.X0 = phi_init;
                option_manpg_alt.Y0 = phi_init;
                option_manpg_alt.maxiter =1e4; 
                option_manpg_alt.tol =1e-10;
                option_manpg_alt.n = 1;  
                option_manpg_alt.d = d;  
                option_manpg_alt.mu = mu;  
                option_manpg_alt.type = 1;
                option_manpg_alt.lambda = 1;

                try
                    [~, ~ , ~, ~, ~, Y_alt]= spca_amanpg(M,option_manpg_alt);
                catch
                    amanpg_res = [amanpg_res, 0];
                    continue
                end
                
                exact_recovery = double(sum((abs(Y_alt)>sqrt(threshold))==true_idx)==d);
                amanpg_res = [amanpg_res, exact_recovery];
            end
                   
            %% A-ManPG with Completion
            [~,~,Vu] = svds(M_complete,1);  
            phi_init = Vu;
            for mu = mu_list
                option_manpg_alt.X0 = phi_init;
                option_manpg_alt.Y0 = phi_init;
                option_manpg_alt.maxiter =1e4; 
                option_manpg_alt.tol =1e-10;
                option_manpg_alt.n = 1;  
                option_manpg_alt.d = d;  
                option_manpg_alt.mu = mu;  
                option_manpg_alt.type = 1;
                option_manpg_alt.lambda = 1;

                try
                    [~, ~ , ~, ~, ~, Y_alt]= spca_amanpg(M_complete,option_manpg_alt);
                catch
                    amanpg_complete_res = [amanpg_complete_res, 0];
                    continue
                end
                
                exact_recovery = double(sum((abs(Y_alt)>sqrt(threshold))==true_idx)==d);
                amanpg_complete_res = [amanpg_complete_res, exact_recovery];
            end

            
            %% Generalized Power Method
            delta_bound = max(sqrt(sum(M.^2)));
            for delta = sort([delta_list, delta_bound])
                [~, supp_est] = GPM(M, delta);
                exact_recovery = double(sum(supp_est==true_idx)==d);
                gpm_res = [gpm_res, exact_recovery];
                if delta == delta_bound
                    selected_gpm_res = exact_recovery;
                end
            end
            
            %% Generalized Power Method with Completion
            delta_bound = max(sqrt(sum(M_complete.^2)));
            for delta = sort([delta_list, delta_bound])
                [~, supp_est] = GPM(M_complete, delta);
                exact_recovery= double(sum(supp_est==true_idx)==d);
                gpm_complete_res = [gpm_complete_res, exact_recovery];
                if delta == delta_bound
                    selected_gpm_complete_res = exact_recovery;
                end
            end
            
            %% Save Results            
            results = [graph_properties, relative_error, selected_sdp_res, selected_sdp_complete_res, sdp_res, ...
                sdp_complete_res, amanpg_res, amanpg_complete_res, dt_res, dt_complete_res, it_res, it_complete_res, ...
                gpm_res, gpm_complete_res, selected_gpm_res, selected_gpm_complete_res];
            formatSpec = '%.4f, %d, %d, %.4f, %.4f, %.4f, %.4f, '+join(repelem("%d,",length(results)-8))+' %d\n';

            fileID = fopen('compare_algorithms_result.csv', 'a+'); 
            fprintf(fileID, formatSpec, results);
            fclose(fileID);

            iter = iter + 1;
            fprintf('.')
        end
    end
end