# Evaluation Script

In our benchmark paper, we introduce five simulation indicators as follows:
* Radial distribution function (RDF)
* Angular distribution function (ADF)
* Bulk modulus (B<sub>0</sub>)
* Equilibrium volume (V<sub>0</sub>)
* Potential energy curves (PECs)


## Command (`--mode evaluate`) and Script

### 1. RDF and ADF

*script* : `run_evaluate_dfs_*.sh`

There is [a template file](../../configs/evaluate/distribution_funcs.yml).  
A structure and its data in the template are replaced by information listed in this script.

Before running the script, user should run the MD simulation (please see [this](../simulate/)).  
This script aims to calculate RDF and ADF from the generated trajectories, and thus it does not need GPUs and checkpoints.

*Note* : For now, the paths including trajectories generated by MLFF models are manually specified in [the template](../../configs/evaluate/distribution_funcs.yml).  
Because we want to provide a plot that includes RDF or ADF of all of the given trajectories.  
The trajectories with super-cells should be also specificed.  

■ **Command** (example: triclinic_1200K of SiN)
```
CONFIG='configs/evaluate/distribution_funcs.yml'
CONFIG_TEMP='configs/evaluate/dfs_temp.yml'

sed "s@{STRUCTURE}@triclinic_1200K@g" ${CONFIG} > ${CONFIG_TEMP}
sed -i "s/{DATA}/SiN/g" ${CONFIG_TEMP}

python main.py --mode evaluate --evaluation-config-yml ${CONFIG_TEMP}

rm ${CONFIG_TEMP}
```
When executing this command at the home directory of this framework (../../), users just specify a structure and its data: triclinic_1200K and SiN in this example.


■ **Script** (used for all the structures)
```
./run_evaluate_dfs_SiN.sh
./run_evaluate_dfs_HfO.sh
```


### 2. B<sub>0</sub> and V<sub>0</sub>

*script* : `run_evaluate_eos_*.sh`

There is [a template file](../../configs/evaluate/eos.yml).  
Variables in the template (structure, data, model name) are replaced by information listed in this script.

■ **Command** (example: P31c_28atoms of SiN, GemNet-dT)
```
CONFIG='configs/evaluate/eos.yml'
CONFIG_TEMP='configs/evaluate/eos_temp.yml'

sed "s@{STRUCTURE}@P31c_28atoms@g" ${CONFIG} > ${CONFIG_TEMP}
sed -i "s@{MODEL_NAME}@GemNet-dT@g" ${CONFIG_TEMP}
sed -i "s/{DATA}/SiN/g" ${CONFIG_TEMP}

CUDA_VISIBLE_DEVICES=0 python main.py \
--mode evaluate \
--evaluation-config-yml ${CONFIG_TEMP} \
--checkpoint ${CKPT_PATH}  \

rm ${CONFIG_TEMP}
```


■ **Script** (for all the structures)
```
./run_evaluate_eos_SiN.sh 0 GemNet-dT ../../train_results/SiN/GemNet-dT/checkpoints/train-20230101_010000
./run_evaluate_eos_HfO.sh 0 GemNet-dT ../../train_results/HfO/GemNet-dT/checkpoints/train-20230101_010000
```


### 3. PECs

*script* : `run_evaluate_pec_*.sh`

There is [a template file](../../configs/evaluate/pec.yml).  
Variables in the template (structure, data, model name) are replaced by information listed in this script.


■ **Command** (example: SiSi of SiN, GemNet-dT)
```
CONFIG='configs/evaluate/pec.yml'
CONFIG_TEMP='configs/evaluate/pec_temp.yml'

sed "s@{STRUCTURE}@SiSi@g" ${CONFIG} > ${CONFIG_TEMP}
sed -i "s@{MODEL}@GemNet-dT@g" ${CONFIG_TEMP}
sed -i "s/{DATA}/SiN/g" ${CONFIG_TEMP}
sed -i "s@{PEC_PARAM}@interatomic_distance@g" ${CONFIG_TEMP}
sed -i "s@{START}@1.0@g" ${CONFIG_TEMP}
sed -i "s@{END}@8.0@g" ${CONFIG_TEMP}
sed -i "s@{INTERVAL}@0.1@g" ${CONFIG_TEMP}
sed -i "s@{ENERGY_RELATION}@energy_distance.dat@g" ${CONFIG_TEMP}

CUDA_VISIBLE_DEVICES=$GPU python main.py \
--mode evaluate \
--evaluation-config-yml ${CONFIG_TEMP} \
--checkpoint ${CKPT_PATH} \

rm ${CONFIG_TEMP}
```


■ **Script** (for all the structures considering two-body or many-body interactions)
```
./run_evaluate_pec_SiN.sh 0 GemNet-dT ../../train_results/SiN/GemNet-dT/checkpoints/train-20230101_010000
./run_evaluate_pec_HfO.sh 0 GemNet-dT ../../train_results/HfO/GemNet-dT/checkpoints/train-20230101_010000
```


## [Evaluate Errors of Energy and Forces](#evaluate-errors-of-energy-and-forceslink_energy_force_error)

Even though errors of energy and forces are not categorized as simulation indicators, we offer this functional to predict energy and forces given an atomic data file with `.xyz` and calculate the errors in term of MAE and RMSE.

The command is as follow:
```
CUDA_VISIBLE_DEVICES=$GPU python main.py \
    --mode evaluate \
    --evaluation-metric ef \
    --checkpoint ${CKPT} \
    --reference-trajectory $DATA \
    --measure-time \
    --save-ef \
```
Users should specify `CKPT` and `DATA`.  
For now, `DATA` should have the `.xyz` file format.

The arguments mean as follows:
* `--evaluation-metric ef` : This functional does not need a configuration file, and thus users should specifiy `ef` as evalution-metric
* `--checkpoint` : a checkpoint of an MLFF model
* `--reference-trajectory` : an atomic data file with `.xyz` that can be accessed by ASE library
* `--measure-time` : perform the timing profile and print the profile results. To diable the profile, exclude it from the command.
* `--save-ef` : save the predicted energy and forces as a file with `.xyz`. To disable the save fucntional, exclude it from the command.


The convenient script is as follow:
```
./run_evaluate_ef.sh $GPU $CKPT $DATA

# example:
# ./run_evaluate_ef.sh 0 ../../train_results/HfO/GemNet-dT/checkpoints/train-20230101_010000/ckpt_ep200.pt ../../datasets/SiN/OOD.xyz
```