import numpy as np
from sklearn.datasets import load_svmlight_file
from scipy.special import expit


def generate_synthetic_data(num_agents, means, cov, label_noise, num_samples_local, num_samples_test):

    # labeling function
    def labeling_function(Xi):
        b0 = 0.0
        b1 = [1.0, 1.0]
        temp = b0 + np.dot(b1, Xi)
        return expit(temp)

    np.random.seed(0)

    # training data
    training_data = []

    for k in range(num_agents):

        X_samples = np.random.multivariate_normal(
            means[k], cov, num_samples_local)
        Y_samples = np.zeros(X_samples.shape[0])

        for idx, Xi in enumerate(X_samples):
            Y_samples[idx] = labeling_function(
                Xi) + np.random.normal(0, label_noise)

        training_data.append([X_samples, Y_samples])

    # test data
    num_samples_per_mixture = int(num_samples_test/num_agents)
    X_samples_test = np.zeros([num_samples_test, 2])

    for k in range(num_agents):
        test_data_k = np.random.multivariate_normal(
            means[k], cov, num_samples_per_mixture)
        X_samples_test[k*num_samples_per_mixture:(k+1)
                       * num_samples_per_mixture, :] = test_data_k

    Y_samples_test = np.zeros(X_samples_test.shape[0])

    for idx, Xi in enumerate(X_samples_test):
        Y_samples_test[idx] = labeling_function(Xi)

    return training_data, [X_samples_test, Y_samples_test]
