import numpy as np


def compute_mse(array_1, array_2):
    """
    Calculated mean squared error given two arrays
    """
    array_1 = np.array(array_1)
    array_2 = np.array(array_2)
    return ((array_1 - array_2)**2).mean(axis=None)

# evaluate local accuracy


def find_nearest_neighbors(test_point, train_set, k=10, sparse=False):
    """
    return a list of k nearest neighbors of a test point using Euclidean distance from a train set
    """
    #num_train_points = len(train_set[0])
    num_train_points = train_set[0].shape[0]
    distance = np.zeros(num_train_points)

    if k > num_train_points:
        return [i for i in range(num_train_points)]

    for i, point in enumerate(train_set[0]):

        delta = point - test_point
        temp = np.dot(delta, delta.T)

        if sparse:
            temp = temp[0, 0]

        distance[i] = temp

    return np.argpartition((-1)*distance, -k)[-k:]


def distance_from_datapoints(test_point, train_set, sparse=False):
    """
    return a list of k nearest neighbors of a test point using Euclidean distance from a train set
    """
    #num_train_points = len(train_set[0])
    num_train_points = train_set[0].shape[0]
    distance = np.zeros(num_train_points)

    for i, point in enumerate(train_set[0]):
        temp = np.dot(point, test_point.T)
        if sparse:
            temp = temp[0, 0]

        distance[i] = temp

    return distance
