import torch
from torch import nn
from src import utils
from src.laplace1 import utils as laplace_utils


class Net(nn.Module):
    def __init__(self):
        super().__init__()
        self.fc1 = nn.Linear(2, 64)
        self.fc2 = nn.Linear(64, 64)
        self.fc3 = nn.Linear(64, 64)
        self.fc4 = nn.Linear(64, 1)

    def forward(self, x):
        out = self.fc1(x)
        out = torch.tanh(out)
        out = self.fc2(out)
        out = torch.tanh(out)
        out = self.fc3(out)
        out = torch.tanh(out)
        out = self.fc4(out)
        return out


def get_loss_function_and_network():
    collocation_points = laplace_utils.CollocationPoints()
    net = Net()

    def loss(net):
        collocation_points.increment_adaptive_points(net)
        x, target = collocation_points.dirichlet_boundary
        preds = net(x)
        boundary_loss = (preds - target).pow(2).mean()
        x, y = collocation_points.adaptive_interior
        pde_loss = laplace_utils.pde_loss(net, x, y)
        return boundary_loss + pde_loss
    return loss, net
