import Mathlib
import Aesop
set_option pp.numericTypes true
set_option pp.funBinderTypes true
set_option maxHeartbeats 0
set_option maxRecDepth 1000
set_option tactic.hygienic false
open BigOperators Real Nat Topology Rat Classical Polynomial


theorem k_le_3_for_n_le_4_round1_main (n k : ℕ) (verts : Finset ℝ) (lines : Finset (ℝ × ℝ)) (points : Finset (ℕ × ℕ)) (hn : 3 ≤ n) (hcard : lines.card + verts.card = n) (hallpoints : ∀ p, p ∈ points ↔ p.1 ≥ 1 ∧ p.2 ≥ 1 ∧ p.1 + p.2 ≤ n + 1) (hmain : ∀ p ∈ points, (∃ l ∈ lines, l.1 * p.1 + l.2 = p.2) ∨ (∃ x ∈ verts, p.1 = x)) (hk : (lines.filter (fun l ↦ l.1 ≠ 0 ∧ l.1 ≠ -1)).card = k) (hn2 : n = 4):
  k ≤ 3 := by
  by_contra h16
  have h161 : k ≥ 4 := by linarith
  have h162 : (lines.filter (fun l ↦ l.1 ≠ 0 ∧ l.1 ≠ -1)).card ≥ 4 := by linarith
  have h163 : (lines.filter (fun l ↦ l.1 ≠ 0 ∧ l.1 ≠ -1)).card ≤ lines.card := by apply Finset.card_filter_le
  have h164 : lines.card + verts.card = 4 := by linarith
  have h165 : lines.card ≥ 4 := by omega
  have h166 : lines.card = 4 := by omega
  have h167 : verts.card = 0 := by omega
  have h168 : verts = ∅ := by
    exact Finset.card_eq_zero.mp h167
  have h170 : ∀ (p : ℕ × ℕ), p ∈ points → ∃ l ∈ lines, l.1 * p.1 + l.2 = p.2 := by
    intro p hp
    have h1701 := hmain p hp
    rcases h1701 with (h1701 | h1702)
    · exact h1701
    · rcases h1702 with ⟨x, hx, _⟩
      have h1703 : x ∈ verts := hx
      rw [h168] at h1703
      contradiction
  have h177 : ∀ l ∈ lines, l.1 ≠ 0 ∧ l.1 ≠ -1 := by
    intro l hl
    by_contra h1771
    have h1772 : ¬(l.1 ≠ 0 ∧ l.1 ≠ -1) := by tauto
    have h1773 : l ∉ (lines.filter (fun l ↦ l.1 ≠ 0 ∧ l.1 ≠ -1)) := by
      simp [Finset.mem_filter]
      <;> tauto
    have h1774 : (lines.filter (fun l ↦ l.1 ≠ 0 ∧ l.1 ≠ -1)).card < lines.card := by
      apply Finset.card_lt_card
      exact Finset.ssubset_iff_subset_ne.mpr ⟨Finset.filter_subset _ _, fun h ↦ by simp_all⟩
    linarith
  have h171 : (1, 1) ∈ points := by
    rw [hallpoints]
    norm_num [hn2]
  obtain ⟨l1, hl1_in_lines, h11_eq⟩ := h170 (1, 1) h171
  obtain ⟨l2, hl2_in_lines, h12_eq⟩ := h170 (1, 2) (by
    rw [hallpoints]
    norm_num [hn2])
  obtain ⟨l3, hl3_in_lines, h13_eq⟩ := h170 (1, 3) (by
    rw [hallpoints]
    norm_num [hn2])
  obtain ⟨l4, hl4_in_lines, h14_eq⟩ := h170 (1, 4) (by
    rw [hallpoints]
    norm_num [hn2])
  have h111 : l1.1 + l1.2 = 1 := by
    norm_num at h11_eq
    <;> linarith
  have h122 : l2.1 + l2.2 = 2 := by
    norm_num at h12_eq
    <;> linarith
  have h133 : l3.1 + l3.2 = 3 := by
    norm_num at h13_eq
    <;> linarith
  have h144 : l4.1 + l4.2 = 4 := by
    norm_num at h14_eq
    <;> linarith
  have h11_ne_12 : l1 ≠ l2 := by
    intro h
    have h1 : l1.1 + l1.2 = 2 := by
      have h11 : l1 = l2 := h
      have h1221 : l2.1 + l2.2 = 2 := h122
      simp [h11] at *
      <;> linarith
    linarith
  have h11_ne_13 : l1 ≠ l3 := by
    intro h
    have h1 : l1.1 + l1.2 = 3 := by
      have h11 : l1 = l3 := h
      have h1331 : l3.1 + l3.2 = 3 := h133
      simp [h11] at *
      <;> linarith
    linarith
  have h11_ne_14 : l1 ≠ l4 := by
    intro h
    have h1 : l1.1 + l1.2 = 4 := by
      have h11 : l1 = l4 := h
      have h1441 : l4.1 + l4.2 = 4 := h144
      simp [h11] at *
      <;> linarith
    linarith
  have h12_ne_13 : l2 ≠ l3 := by
    intro h
    have h1 : l2.1 + l2.2 = 3 := by
      have h11 : l2 = l3 := h
      have h1331 : l3.1 + l3.2 = 3 := h133
      simp [h11] at *
      <;> linarith
    linarith
  have h12_ne_14 : l2 ≠ l4 := by
    intro h
    have h1 : l2.1 + l2.2 = 4 := by
      have h11 : l2 = l4 := h
      have h1441 : l4.1 + l4.2 = 4 := h144
      simp [h11] at *
      <;> linarith
    linarith
  have h13_ne_14 : l3 ≠ l4 := by
    intro h
    have h1 : l3.1 + l3.2 = 4 := by
      have h11 : l3 = l4 := h
      have h1441 : l4.1 + l4.2 = 4 := h144
      simp [h11] at *
      <;> linarith
    linarith
  have h178 : ({l1, l2, l3, l4} : Finset (ℝ × ℝ)) ⊆ lines := by
    intro x hx
    simp only [Finset.mem_insert, Finset.mem_singleton] at hx
    rcases hx with (rfl | rfl | rfl | rfl)
    · exact hl1_in_lines
    · exact hl2_in_lines
    · exact hl3_in_lines
    · exact hl4_in_lines
  have h179 : ({l1, l2, l3, l4} : Finset (ℝ × ℝ)).card = 4 := by
    simp [h11_ne_12, h11_ne_13, h11_ne_14, h12_ne_13, h12_ne_14, h13_ne_14]
  have h180 : ({l1, l2, l3, l4} : Finset (ℝ × ℝ)) = lines := by
    apply Finset.eq_of_subset_of_card_le h178
    rw [h179, h166]
  have h171_2 : (2, 2) ∈ points := by
    rw [hallpoints]
    norm_num [hn2]
  obtain ⟨l5, hl5_in_lines, h15_eq⟩ := h170 (2, 2) h171_2
  have h15_eq' : l5.1 * 2 + l5.2 = 2 := by
    norm_num at h15_eq
    <;> linarith
  have h171_3 : (2, 3) ∈ points := by
    rw [hallpoints]
    norm_num [hn2]
  obtain ⟨l6, hl6_in_lines, h16_eq⟩ := h170 (2, 3) h171_3
  have h16_eq' : l6.1 * 2 + l6.2 = 3 := by
    norm_num at h16_eq
    <;> linarith
  have h1801 : lines = ({l1, l2, l3, l4} : Finset (ℝ × ℝ)) := by tauto
  have h15_in_set : l5 ∈ ({l1, l2, l3, l4} : Finset (ℝ × ℝ)) := by
    rw [h1801] at hl5_in_lines
    tauto
  have h16_in_set : l6 ∈ ({l1, l2, l3, l4} : Finset (ℝ × ℝ)) := by
    rw [h1801] at hl6_in_lines
    tauto
  have h15_cases : l5 = l1 ∨ l5 = l2 ∨ l5 = l3 ∨ l5 = l4 := by
    simp only [Finset.mem_insert, Finset.mem_singleton] at h15_in_set
    tauto
  have h16_cases : l6 = l1 ∨ l6 = l2 ∨ l6 = l3 ∨ l6 = l4 := by
    simp only [Finset.mem_insert, Finset.mem_singleton] at h16_in_set
    tauto
  have h15_ne_2 : l5 ≠ l2 := by
    intro h15_eq_2
    have h177_l2 := h177 l2 hl2_in_lines
    have h151 : l2.1 * 2 + l2.2 = 2 := by
      have h1511 : l5 = l2 := h15_eq_2
      rw [h1511] at h15_eq'
      <;> linarith
    have h152 : l2.1 = 0 := by linarith
    have h177_l21 : l2.1 ≠ 0 := h177_l2.1
    contradiction
  have h15_ne_3 : l5 ≠ l3 := by
    intro h15_eq_3
    have h177_l3 := h177 l3 hl3_in_lines
    have h151 : l3.1 * 2 + l3.2 = 2 := by
      have h1511 : l5 = l3 := h15_eq_3
      rw [h1511] at h15_eq'
      <;> linarith
    have h152 : l3.1 = -1 := by linarith
    have h177_l32 : l3.1 ≠ -1 := h177_l3.2
    contradiction
  have h15_cases2 : l5 = l1 ∨ l5 = l4 := by tauto
  have h16_ne_3 : l6 ≠ l3 := by
    intro h16_eq_3
    have h177_l3 := h177 l3 hl3_in_lines
    have h161 : l3.1 * 2 + l3.2 = 3 := by
      have h1611 : l6 = l3 := h16_eq_3
      rw [h1611] at h16_eq'
      <;> linarith
    have h162 : l3.1 = 0 := by linarith
    have h177_l31 : l3.1 ≠ 0 := h177_l3.1
    contradiction
  have h16_ne_4 : l6 ≠ l4 := by
    intro h16_eq_4
    have h177_l4 := h177 l4 hl4_in_lines
    have h161 : l4.1 * 2 + l4.2 = 3 := by
      have h1611 : l6 = l4 := h16_eq_4
      rw [h1611] at h16_eq'
      <;> linarith
    have h162 : l4.1 = -1 := by linarith
    have h177_l42 : l4.1 ≠ -1 := h177_l4.2
    contradiction
  have h16_cases2 : l6 = l1 ∨ l6 = l2 := by tauto
  rcases h15_cases2 with (h15_eq_l1 | h15_eq_l4)
  · have h15_eq_l11 : l5 = l1 := h15_eq_l1
    have h15_eq_l12 : l1.1 * 2 + l1.2 = 2 := by
      rw [h15_eq_l11] at h15_eq'
      <;> linarith
    have h1111 : l1.1 = 1 := by linarith
    have h1112 : l1.2 = 0 := by linarith
    rcases h16_cases2 with (h16_eq_l1 | h16_eq_l2)
    · have h16_eq_l11 : l6 = l1 := h16_eq_l1
      have h16_eq_l12 : l1.1 * 2 + l1.2 = 3 := by
        rw [h16_eq_l11] at h16_eq'
        <;> linarith
      norm_num [h1111, h1112] at h16_eq_l12
    · have h16_eq_l21 : l6 = l2 := h16_eq_l2
      have h16_eq_l22 : l2.1 * 2 + l2.2 = 3 := by
        rw [h16_eq_l21] at h16_eq'
        <;> linarith
      have h1221 : l2.1 = 1 := by linarith
      have h1222 : l2.2 = 1 := by linarith
      have h171_4 : (3, 1) ∈ points := by
        rw [hallpoints]
        norm_num [hn2]
      obtain ⟨l9, hl9_in_lines, h19_eq⟩ := h170 (3, 1) h171_4
      have h19_eq' : l9.1 * 3 + l9.2 = 1 := by
        norm_num at h19_eq
        <;> linarith
      have h19_in_set : l9 ∈ ({l1, l2, l3, l4} : Finset (ℝ × ℝ)) := by
        rw [h1801] at hl9_in_lines
        tauto
      have h19_cases : l9 = l1 ∨ l9 = l2 ∨ l9 = l3 ∨ l9 = l4 := by
        simp only [Finset.mem_insert, Finset.mem_singleton] at h19_in_set
        tauto
      rcases h19_cases with (h19_eq_l1 | h19_eq_l2 | h19_eq_l3 | h19_eq_l4)
      · have h19_eq_l11 : l9 = l1 := h19_eq_l1
        have h19_eq1 : l1.1 * 3 + l1.2 = 1 := by
          rw [h19_eq_l11] at h19_eq'
          <;> linarith
        norm_num [h1111, h1112] at h19_eq1
      · have h19_eq_l21 : l9 = l2 := h19_eq_l2
        have h19_eq2 : l2.1 * 3 + l2.2 = 1 := by
          rw [h19_eq_l21] at h19_eq'
          <;> linarith
        norm_num [h1221, h1222] at h19_eq2
      · have h19_eq_l31 : l9 = l3 := h19_eq_l3
        have h19_eq3 : l3.1 * 3 + l3.2 = 1 := by
          rw [h19_eq_l31] at h19_eq'
          <;> linarith
        have h31 : l3.1 = -1 := by linarith
        have h177_l3 := h177 l3 hl3_in_lines
        have h177_l32 : l3.1 ≠ -1 := h177_l3.2
        contradiction
      · have h19_eq_l41 : l9 = l4 := h19_eq_l4
        have h19_eq4 : l4.1 * 3 + l4.2 = 1 := by
          rw [h19_eq_l41] at h19_eq'
          <;> linarith
        have h41 : l4.1 = -3 / 2 := by linarith
        have h42 : l4.2 = 11 / 2 := by linarith
        have h171_5 : (2, 1) ∈ points := by
          rw [hallpoints]
          norm_num [hn2]
        obtain ⟨l10, hl10_in_lines, h20_eq⟩ := h170 (2, 1) h171_5
        have h20_eq' : l10.1 * 2 + l10.2 = 1 := by
          norm_num at h20_eq
          <;> linarith
        have h20_in_set : l10 ∈ ({l1, l2, l3, l4} : Finset (ℝ × ℝ)) := by
          rw [h1801] at hl10_in_lines
          tauto
        have h20_cases : l10 = l1 ∨ l10 = l2 ∨ l10 = l3 ∨ l10 = l4 := by
          simp only [Finset.mem_insert, Finset.mem_singleton] at h20_in_set
          tauto
        rcases h20_cases with (h20_eq_l1 | h20_eq_l2 | h20_eq_l3 | h20_eq_l4)
        · have h20_eq_l11 : l10 = l1 := h20_eq_l1
          have h20_eq1 : l1.1 * 2 + l1.2 = 1 := by
            rw [h20_eq_l11] at h20_eq'
            <;> linarith
          norm_num [h1111, h1112] at h20_eq1
        · have h20_eq_l21 : l10 = l2 := h20_eq_l2
          have h20_eq2 : l2.1 * 2 + l2.2 = 1 := by
            rw [h20_eq_l21] at h20_eq'
            <;> linarith
          norm_num [h1221, h1222] at h20_eq2
        · have h20_eq_l31 : l10 = l3 := h20_eq_l3
          have h20_eq3 : l3.1 * 2 + l3.2 = 1 := by
            rw [h20_eq_l31] at h20_eq'
            <;> linarith
          have h31 : l3.1 = -2 := by linarith
          have h32 : l3.2 = 5 := by linarith
          have h171_6 : (4, 1) ∈ points := by
            rw [hallpoints]
            norm_num [hn2]
          obtain ⟨l11, hl11_in_lines, h21_eq⟩ := h170 (4, 1) h171_6
          have h21_eq' : l11.1 * 4 + l11.2 = 1 := by
            norm_num at h21_eq
            <;> linarith
          have h21_in_set : l11 ∈ ({l1, l2, l3, l4} : Finset (ℝ × ℝ)) := by
            rw [h1801] at hl11_in_lines
            tauto
          have h21_cases : l11 = l1 ∨ l11 = l2 ∨ l11 = l3 ∨ l11 = l4 := by
            simp only [Finset.mem_insert, Finset.mem_singleton] at h21_in_set
            tauto
          rcases h21_cases with (h21_eq_l1 | h21_eq_l2 | h21_eq_l3 | h21_eq_l4)
          · have h21_eq_l11 : l11 = l1 := h21_eq_l1
            have h21_eq1 : l1.1 * 4 + l1.2 = 1 := by
              rw [h21_eq_l11] at h21_eq'
              <;> linarith
            norm_num [h1111, h1112] at h21_eq1
          · have h21_eq_l21 : l11 = l2 := h21_eq_l2
            have h21_eq2 : l2.1 * 4 + l2.2 = 1 := by
              rw [h21_eq_l21] at h21_eq'
              <;> linarith
            norm_num [h1221, h1222] at h21_eq2
          · have h21_eq_l31 : l11 = l3 := h21_eq_l3
            have h21_eq3 : l3.1 * 4 + l3.2 = 1 := by
              rw [h21_eq_l31] at h21_eq'
              <;> linarith
            norm_num [h31, h32] at h21_eq3
          · have h21_eq_l41 : l11 = l4 := h21_eq_l4
            have h21_eq4 : l4.1 * 4 + l4.2 = 1 := by
              rw [h21_eq_l41] at h21_eq'
              <;> linarith
            norm_num [h41, h42] at h21_eq4
        · have h20_eq_l41 : l10 = l4 := h20_eq_l4
          have h20_eq4 : l4.1 * 2 + l4.2 = 1 := by
            rw [h20_eq_l41] at h20_eq'
            <;> linarith
          norm_num [h41, h42] at h20_eq4
  · have h15_eq_l41 : l5 = l4 := h15_eq_l4
    have h15_eq_l42 : l4.1 * 2 + l4.2 = 2 := by
      rw [h15_eq_l41] at h15_eq'
      <;> linarith
    have h41 : l4.1 = -2 := by linarith
    have h42 : l4.2 = 6 := by linarith
    rcases h16_cases2 with (h16_eq_l1 | h16_eq_l2)
    · have h16_eq_l11 : l6 = l1 := h16_eq_l1
      have h16_eq_l12 : l1.1 * 2 + l1.2 = 3 := by
        rw [h16_eq_l11] at h16_eq'
        <;> linarith
      have h1111 : l1.1 = 2 := by linarith
      have h1112 : l1.2 = -1 := by linarith
      have h171_4 : (3, 1) ∈ points := by
        rw [hallpoints]
        norm_num [hn2]
      obtain ⟨l9, hl9_in_lines, h19_eq⟩ := h170 (3, 1) h171_4
      have h19_eq' : l9.1 * 3 + l9.2 = 1 := by
        norm_num at h19_eq <;> linarith
      have h19_in_set : l9 ∈ ({l1, l2, l3, l4} : Finset (ℝ × ℝ)) := by
        rw [h1801] at hl9_in_lines
        tauto
      have h19_cases : l9 = l1 ∨ l9 = l2 ∨ l9 = l3 ∨ l9 = l4 := by
        simp only [Finset.mem_insert, Finset.mem_singleton] at h19_in_set
        tauto
      rcases h19_cases with (h19_eq_l1 | h19_eq_l2 | h19_eq_l3 | h19_eq_l4)
      · have h19_eq_l11 : l9 = l1 := h19_eq_l1
        have h19_eq1 : l1.1 * 3 + l1.2 = 1 := by
          rw [h19_eq_l11] at h19_eq'
          <;> linarith
        norm_num [h1111, h1112] at h19_eq1
      · have h19_eq_l21 : l9 = l2 := h19_eq_l2
        have h19_eq2 : l2.1 * 3 + l2.2 = 1 := by
          rw [h19_eq_l21] at h19_eq'
          <;> linarith
        have h21 : l2.1 = -1 / 2 := by linarith
        have h22 : l2.2 = 5 / 2 := by linarith
        have h171_5 : (2, 1) ∈ points := by
          rw [hallpoints]
          norm_num [hn2]
        obtain ⟨l10, hl10_in_lines, h20_eq⟩ := h170 (2, 1) h171_5
        have h20_eq' : l10.1 * 2 + l10.2 = 1 := by
          norm_num at h20_eq
          <;> linarith
        have h20_in_set : l10 ∈ ({l1, l2, l3, l4} : Finset (ℝ × ℝ)) := by
          rw [h1801] at hl10_in_lines
          tauto
        have h20_cases : l10 = l1 ∨ l10 = l2 ∨ l10 = l3 ∨ l10 = l4 := by
          simp only [Finset.mem_insert, Finset.mem_singleton] at h20_in_set
          tauto
        rcases h20_cases with (h20_eq_l1 | h20_eq_l2 | h20_eq_l3 | h20_eq_l4)
        · have h20_eq_l11 : l10 = l1 := h20_eq_l1
          have h20_eq1 : l1.1 * 2 + l1.2 = 1 := by
            rw [h20_eq_l11] at h20_eq'
            <;> linarith
          norm_num [h1111, h1112] at h20_eq1
        · have h20_eq_l21 : l10 = l2 := h20_eq_l2
          have h20_eq2 : l2.1 * 2 + l2.2 = 1 := by
            rw [h20_eq_l21] at h20_eq'
            <;> linarith
          norm_num [h21, h22] at h20_eq2
        · have h20_eq_l31 : l10 = l3 := h20_eq_l3
          have h20_eq3 : l3.1 * 2 + l3.2 = 1 := by
            rw [h20_eq_l31] at h20_eq'
            <;> linarith
          have h31 : l3.1 = -2 := by linarith
          have h32 : l3.2 = 5 := by linarith
          have h171_6 : (4, 1) ∈ points := by
            rw [hallpoints]
            norm_num [hn2]
          obtain ⟨l11, hl11_in_lines, h21_eq⟩ := h170 (4, 1) h171_6
          have h21_eq' : l11.1 * 4 + l11.2 = 1 := by
            norm_num at h21_eq <;> linarith
          have h21_in_set : l11 ∈ ({l1, l2, l3, l4} : Finset (ℝ × ℝ)) := by
            rw [h1801] at hl11_in_lines
            tauto
          have h21_cases : l11 = l1 ∨ l11 = l2 ∨ l11 = l3 ∨ l11 = l4 := by
            simp only [Finset.mem_insert, Finset.mem_singleton] at h21_in_set
            tauto
          rcases h21_cases with (h21_eq_l1 | h21_eq_l2 | h21_eq_l3 | h21_eq_l4)
          · have h21_eq_l11 : l11 = l1 := h21_eq_l1
            have h21_eq1 : l1.1 * 4 + l1.2 = 1 := by
              rw [h21_eq_l11] at h21_eq'
              <;> linarith
            norm_num [h1111, h1112] at h21_eq1
          · have h21_eq_l21 : l11 = l2 := h21_eq_l2
            have h21_eq2 : l2.1 * 4 + l2.2 = 1 := by
              rw [h21_eq_l21] at h21_eq'
              <;> linarith
            norm_num [h21, h22] at h21_eq2
          · have h21_eq_l31 : l11 = l3 := h21_eq_l3
            have h21_eq3 : l3.1 * 4 + l3.2 = 1 := by
              rw [h21_eq_l31] at h21_eq'
              <;> linarith
            norm_num [h31, h32] at h21_eq3
          · have h21_eq_l41 : l11 = l4 := h21_eq_l4
            have h21_eq4 : l4.1 * 4 + l4.2 = 1 := by
              rw [h21_eq_l41] at h21_eq'
              <;> linarith
            norm_num [h41, h42] at h21_eq4
        · have h20_eq_l41 : l10 = l4 := h20_eq_l4
          have h20_eq4 : l4.1 * 2 + l4.2 = 1 := by
            rw [h20_eq_l41] at h20_eq'
            <;> linarith
          norm_num [h41, h42] at h20_eq4
      · have h19_eq_l31 : l9 = l3 := h19_eq_l3
        have h19_eq3 : l3.1 * 3 + l3.2 = 1 := by
          rw [h19_eq_l31] at h19_eq'
          <;> linarith
        have h31 : l3.1 = -1 := by linarith
        have h177_l3 := h177 l3 hl3_in_lines
        have h177_l32 : l3.1 ≠ -1 := h177_l3.2
        contradiction
      · have h19_eq_l41 : l9 = l4 := h19_eq_l4
        have h19_eq4 : l4.1 * 3 + l4.2 = 1 := by
          rw [h19_eq_l41] at h19_eq'
          <;> linarith
        norm_num [h41, h42] at h19_eq4
    · have h16_eq_l21 : l6 = l2 := h16_eq_l2
      have h16_eq_l22 : l2.1 * 2 + l2.2 = 3 := by
        rw [h16_eq_l21] at h16_eq'
        <;> linarith
      have h1221 : l2.1 = 1 := by linarith
      have h1222 : l2.2 = 1 := by linarith
      have h171_4 : (3, 1) ∈ points := by
        rw [hallpoints]
        norm_num [hn2]
      obtain ⟨l9, hl9_in_lines, h19_eq⟩ := h170 (3, 1) h171_4
      have h19_eq' : l9.1 * 3 + l9.2 = 1 := by
        norm_num at h19_eq <;> linarith
      have h19_in_set : l9 ∈ ({l1, l2, l3, l4} : Finset (ℝ × ℝ)) := by
        rw [h1801] at hl9_in_lines
        tauto
      have h19_cases : l9 = l1 ∨ l9 = l2 ∨ l9 = l3 ∨ l9 = l4 := by
        simp only [Finset.mem_insert, Finset.mem_singleton] at h19_in_set
        tauto
      rcases h19_cases with (h19_eq_l1 | h19_eq_l2 | h19_eq_l3 | h19_eq_l4)
      · have h19_eq_l11 : l9 = l1 := h19_eq_l1
        have h19_eq1 : l1.1 * 3 + l1.2 = 1 := by
          rw [h19_eq_l11] at h19_eq'
          <;> linarith
        have h1111 : l1.1 = 0 := by linarith
        have h177_l1 := h177 l1 hl1_in_lines
        have h177_l11 : l1.1 ≠ 0 := h177_l1.1
        contradiction
      · have h19_eq_l21 : l9 = l2 := h19_eq_l2
        have h19_eq2 : l2.1 * 3 + l2.2 = 1 := by
          rw [h19_eq_l21] at h19_eq'
          <;> linarith
        norm_num [h1221, h1222] at h19_eq2
      · have h19_eq_l31 : l9 = l3 := h19_eq_l3
        have h19_eq3 : l3.1 * 3 + l3.2 = 1 := by
          rw [h19_eq_l31] at h19_eq'
          <;> linarith
        have h31 : l3.1 = -1 := by linarith
        have h177_l3 := h177 l3 hl3_in_lines
        have h177_l32 : l3.1 ≠ -1 := h177_l3.2
        contradiction
      · have h19_eq_l41 : l9 = l4 := h19_eq_l4
        have h19_eq4 : l4.1 * 3 + l4.2 = 1 := by
          rw [h19_eq_l41] at h19_eq'
          <;> linarith
        norm_num [h41, h42] at h19_eq4

theorem round1_case_n_eq_3 (n k : ℕ) (verts : Finset ℝ) (lines : Finset (ℝ × ℝ)) (points : Finset (ℕ × ℕ)) (hn : 3 ≤ n) (hcard : lines.card + verts.card = n) (hallpoints : ∀ p, p ∈ points ↔ p.1 ≥ 1 ∧ p.2 ≥ 1 ∧ p.1 + p.2 ≤ n + 1) (hmain : ∀ p ∈ points, (∃ l ∈ lines, l.1 * p.1 + l.2 = p.2) ∨ (∃ x ∈ verts, p.1 = x)) (hk : (lines.filter (fun l ↦ l.1 ≠ 0 ∧ l.1 ≠ -1)).card = k) (hn2 : n = 3):
  k ≤ 3 := by
  linarith [Finset.card_filter_le lines fun l ↦ l.1 ≠ 0 ∧ l.1 ≠ -1]

theorem k_le_3_for_n_le_4 (n k : ℕ) (verts : Finset ℝ) (lines : Finset (ℝ × ℝ)) (points : Finset (ℕ × ℕ)) (hn : 3 ≤ n) (hcard : lines.card + verts.card = n) (hallpoints : ∀ p, p ∈ points ↔ p.1 ≥ 1 ∧ p.2 ≥ 1 ∧ p.1 + p.2 ≤ n + 1) (hmain : ∀ p ∈ points, (∃ l ∈ lines, l.1 * p.1 + l.2 = p.2) ∨ (∃ x ∈ verts, p.1 = x)) (hk : (lines.filter (fun l ↦ l.1 ≠ 0 ∧ l.1 ≠ -1)).card = k) (hn : n = 3 ∨ n = 4):
  k ≤ 3  := by
  cases hn
  apply round1_case_n_eq_3 <;> assumption
  apply k_le_3_for_n_le_4_round1_main <;> assumption

theorem round1_case1 (n : ℕ)
  (k : ℕ)
  (verts : Finset ℝ)
  (lines : Finset (ℝ × ℝ))
  (points : Finset (ℕ × ℕ))
  (hn : n = 3)
  (hcard : lines.card + verts.card = n)
  (hallpoints : ∀ p, p ∈ points ↔ p.1 ≥ 1 ∧ p.2 ≥ 1 ∧ p.1 + p.2 ≤ n + 1)
  (hmain : ∀ p ∈ points, (∃ l ∈ lines, l.1 * (p.1 : ℝ) + l.2 = (p.2 : ℝ)) ∨ (∃ x ∈ verts, (p.1 : ℝ) = x))
  (h411 : ∀ l ∈ lines, l.1 ≠ 0 ∧ l.1 ≠ -1)
  (h412 : verts.card = 1):
  False := by
  simp only [hn] at hcard hallpoints hmain h411 h412
  have h4122 : ∃ x, verts = {x} := by
    exact Finset.card_eq_one.mp h412
  rcases h4122 with ⟨x, hx⟩
  by_cases h1inverts : (1 : ℝ) ∈ verts
  · have h21inpoints : (⟨2, 1⟩ : ℕ × ℕ) ∈ points := by
      rw [hallpoints (⟨2, 1⟩ : ℕ × ℕ)]
      <;> simp
    have h31inpoints : (⟨3, 1⟩ : ℕ × ℕ) ∈ points := by
      rw [hallpoints (⟨3, 1⟩ : ℕ × ℕ)]
      <;> simp
    have h22inpoints : (⟨2, 2⟩ : ℕ × ℕ) ∈ points := by
      rw [hallpoints (⟨2, 2⟩ : ℕ × ℕ)]
      <;> simp
    have h5 : ∃ l ∈ lines, l.1 * 2 + l.2 = 1 := by
      have h211 := hmain (⟨2, 1⟩ : ℕ × ℕ) h21inpoints
      rcases h211 with h211 | h211
      · obtain ⟨l, hl, h_eq⟩ := h211
        refine ⟨l, hl,?_⟩
        norm_num at h_eq ⊢
        <;> linarith
      · rcases h211 with h211
        rw [hx] at h211
        aesop
    have h6 : ∃ l ∈ lines, l.1 * 3 + l.2 = 1 := by
      have h311 := hmain (⟨3, 1⟩ : ℕ × ℕ) h31inpoints
      rcases h311 with h311 | h311
      · obtain ⟨l, hl, h_eq⟩ := h311
        refine ⟨l, hl,?_⟩
        norm_num at h_eq ⊢
        <;> linarith
      · rcases h311 with h311
        rw [hx] at h311
        aesop
    rcases h5 with ⟨l1, hl1_in_lines, h1_eq1⟩
    rcases h6 with ⟨l2, hl2_in_lines, h1_eq2⟩
    have h_l1_ne_l2 : l1 ≠ l2 := by
      intro h_l1_eq_l2
      have h111 : l1.1 * 2 + l1.2 = 1 := h1_eq1
      have h112 : l2.1 * 3 + l2.2 = 1 := h1_eq2
      have h113 : l1.1 * 3 + l1.2 = 1 := by
        have h1131 : l2.1 * 3 + l2.2 = 1 := h112
        have h1132 : l1 = l2 := by tauto
        simp [h1132] at *
        <;> linarith
      have h114 : l1.1 = 0 := by linarith
      have h115 := h411 l1 hl1_in_lines
      have h116 : l1.1 ≠ 0 := h115.1
      contradiction
    have h7 : ∃ l ∈ lines, l.1 * 2 + l.2 = 2 := by
      have h222 := hmain (⟨2, 2⟩ : ℕ × ℕ) h22inpoints
      rcases h222 with h222 | h222
      · obtain ⟨l, hl, h_eq⟩ := h222
        refine ⟨l, hl,?_⟩
        norm_num at h_eq ⊢
        <;> linarith
      · rcases h222 with h222
        rw [hx] at h222
        aesop
    rcases h7 with ⟨l3, hl3_in_lines, h1_eq3⟩
    have h_lines_card : lines.card = 2 := by linarith
    have h121 : ({l1, l2} : Finset (ℝ × ℝ)) ⊆ lines := by
      intro x hx
      simp at hx
      rcases hx with (rfl | rfl)
      · exact hl1_in_lines
      · exact hl2_in_lines
    have h122 : ({l1, l2} : Finset (ℝ × ℝ)).card = 2 := by
      simp [Finset.card_pair, h_l1_ne_l2]
    have h123 : ({l1, l2} : Finset (ℝ × ℝ)) = lines := by
      apply Finset.eq_of_subset_of_card_le h121
      <;> simp [h122, h_lines_card]
    have h124 : l3 ∈ ({l1, l2} : Finset (ℝ × ℝ)) := by
      rw [h123]
      exact hl3_in_lines
    have h1241 : l3 = l1 ∨ l3 = l2 := by
      simp at h124
      tauto
    rcases h1241 with (h1241 | h1241)
    · have h12411 : l3 = l1 := h1241
      have h1_eq3' : l3.1 * 2 + l3.2 = 2 := h1_eq3
      rw [h12411] at h1_eq3'
      have h1_eq11 : l1.1 * 2 + l1.2 = 1 := h1_eq1
      linarith
    · have h12412 : l3 = l2 := h1241
      have h1_eq3' : l3.1 * 2 + l3.2 = 2 := h1_eq3
      have h1_eq22 : l2.1 * 2 + l2.2 = 2 := by
        rw [h12412] at h1_eq3'
        tauto
      have h12421 : l2.1 = -1 := by linarith
      have h4112 := h411 l2 hl2_in_lines
      have h4113 : l2.1 ≠ -1 := h4112.2
      contradiction
  · have h11inpoints : (⟨1, 1⟩ : ℕ × ℕ) ∈ points := by
      rw [hallpoints (⟨1, 1⟩ : ℕ × ℕ)]
      <;> simp
    have h12inpoints : (⟨1, 2⟩ : ℕ × ℕ) ∈ points := by
      rw [hallpoints (⟨1, 2⟩ : ℕ × ℕ)]
      <;> simp
    have h13inpoints : (⟨1, 3⟩ : ℕ × ℕ) ∈ points := by
      rw [hallpoints (⟨1, 3⟩ : ℕ × ℕ)]
      <;> simp
    have h51 : ∃ l ∈ lines, l.1 + l.2 = 1 := by
      have h111 := hmain (⟨1, 1⟩ : ℕ × ℕ) h11inpoints
      rcases h111 with h111 | h111
      · obtain ⟨l, hl, h_eq⟩ := h111
        refine ⟨l, hl,?_⟩
        norm_num at h_eq ⊢
        <;> linarith
      · rcases h111 with h111
        simp_all
    have h52 : ∃ l ∈ lines, l.1 + l.2 = 2 := by
      have h121 := hmain (⟨1, 2⟩ : ℕ × ℕ) h12inpoints
      rcases h121 with h121 | h121
      · obtain ⟨l, hl, h_eq⟩ := h121
        refine ⟨l, hl,?_⟩
        norm_num at h_eq ⊢
        <;> linarith
      · rcases h121 with h121
        simp_all
    have h53 : ∃ l ∈ lines, l.1 + l.2 = 3 := by
      have h131 := hmain (⟨1, 3⟩ : ℕ × ℕ) h13inpoints
      rcases h131 with h131 | h131
      · obtain ⟨l, hl, h_eq⟩ := h131
        refine ⟨l, hl,?_⟩
        norm_num at h_eq ⊢
        <;> linarith
      · rcases h131 with h131
        simp_all
    rcases h51 with ⟨l1, hl1_in_lines, h1_eq1⟩
    rcases h52 with ⟨l2, hl2_in_lines, h1_eq2⟩
    rcases h53 with ⟨l3, hl3_in_lines, h1_eq3⟩
    have h125 : ({l1, l2, l3} : Finset (ℝ × ℝ)) ⊆ lines := by
      intro x hx
      simp at hx
      rcases hx with (rfl | rfl | rfl)
      · exact hl1_in_lines
      · exact hl2_in_lines
      · exact hl3_in_lines
    have h126 : ({l1, l2, l3} : Finset (ℝ × ℝ)).card = 3 := by
      have h1 : l1 ≠ l2 := by intro h; simp [h] at *; linarith
      have h2 : l1 ≠ l3 := by intro h; simp [h] at *; linarith
      have h3 : l2 ≠ l3 := by intro h; simp [h] at *; linarith
      simp [Finset.card_insert_of_not_mem, Finset.mem_singleton, h1, h2, h3]
    have h127 : ({l1, l2, l3} : Finset (ℝ × ℝ)).card ≤ lines.card := Finset.card_le_card h125
    linarith

theorem round1_case2 (n : ℕ)
  (k : ℕ)
  (verts : Finset ℝ)
  (lines : Finset (ℝ × ℝ))
  (points : Finset (ℕ × ℕ))
  (hn : n = 3)
  (hcard : lines.card + verts.card = n)
  (hallpoints : ∀ p, p ∈ points ↔ p.1 ≥ 1 ∧ p.2 ≥ 1 ∧ p.1 + p.2 ≤ n + 1)
  (hmain : ∀ p ∈ points, (∃ l ∈ lines, l.1 * (p.1 : ℝ) + l.2 = (p.2 : ℝ)) ∨ (∃ x ∈ verts, (p.1 : ℝ) = x))
  (h421 : (lines.filter (fun l : ℝ × ℝ => l.1 = 0 ∨ l.1 = -1)).card = 1)
  (h422 : verts.card = 0):
  False := by
  simp only [hn] at hcard hallpoints hmain h421 h422
  have h_lines_card : lines.card = 3 := by linarith
  have h_verts_empty : verts = ∅ := by exact Finset.card_eq_zero.mp h422
  have h11inpoints : (⟨1, 1⟩ : ℕ × ℕ) ∈ points := by rw [hallpoints (⟨1, 1⟩ : ℕ × ℕ)]; simp
  have h12inpoints : (⟨1, 2⟩ : ℕ × ℕ) ∈ points := by rw [hallpoints (⟨1, 2⟩ : ℕ × ℕ)]; simp
  have h13inpoints : (⟨1, 3⟩ : ℕ × ℕ) ∈ points := by rw [hallpoints (⟨1, 3⟩ : ℕ × ℕ)]; simp
  have h21inpoints : (⟨2, 1⟩ : ℕ × ℕ) ∈ points := by rw [hallpoints (⟨2, 1⟩ : ℕ × ℕ)]; simp
  have h22inpoints : (⟨2, 2⟩ : ℕ × ℕ) ∈ points := by rw [hallpoints (⟨2, 2⟩ : ℕ × ℕ)]; simp
  have h31inpoints : (⟨3, 1⟩ : ℕ × ℕ) ∈ points := by rw [hallpoints (⟨3, 1⟩ : ℕ × ℕ)]; simp
  have h51 : ∃ l ∈ lines, l.1 + l.2 = 1 := by
    have h111 := hmain (⟨1, 1⟩ : ℕ × ℕ) h11inpoints
    cases h111 with
    | inl h1111 =>
      rcases h1111 with ⟨l, hl, h_eq⟩
      refine ⟨l, hl,?_⟩
      norm_num at h_eq ⊢
      <;> linarith
    | inr h1112 =>
      rcases h1112 with ⟨x, hx, hx2⟩
      rw [h_verts_empty] at hx
      simp at hx
  have h52 : ∃ l ∈ lines, l.1 + l.2 = 2 := by
    have h121 := hmain (⟨1, 2⟩ : ℕ × ℕ) h12inpoints
    cases h121 with
    | inl h1211 =>
      rcases h1211 with ⟨l, hl, h_eq⟩
      refine ⟨l, hl,?_⟩
      norm_num at h_eq ⊢
      <;> linarith
    | inr h1212 =>
      rcases h1212 with ⟨x, hx, hx2⟩
      rw [h_verts_empty] at hx
      simp at hx
  have h53 : ∃ l ∈ lines, l.1 + l.2 = 3 := by
    have h131 := hmain (⟨1, 3⟩ : ℕ × ℕ) h13inpoints
    cases h131 with
    | inl h1311 =>
      rcases h1311 with ⟨l, hl, h_eq⟩
      refine ⟨l, hl,?_⟩
      norm_num at h_eq ⊢
      <;> linarith
    | inr h1312 =>
      rcases h1312 with ⟨x, hx, hx2⟩
      rw [h_verts_empty] at hx
      simp at hx
  rcases h51 with ⟨l1, hl1_in_lines, h1_eq1⟩
  rcases h52 with ⟨l2, hl2_in_lines, h1_eq2⟩
  rcases h53 with ⟨l3, hl3_in_lines, h1_eq3⟩
  have h_l1_ne_l2 : l1 ≠ l2 := by
    intro h
    have h1 : l1.1 + l1.2 = 1 := h1_eq1
    have h2 : l2.1 + l2.2 = 2 := h1_eq2
    have h3 : l1 = l2 := by tauto
    simp [h3] at *
    <;> linarith
  have h_l1_ne_l3 : l1 ≠ l3 := by
    intro h
    have h1 : l1.1 + l1.2 = 1 := h1_eq1
    have h2 : l3.1 + l3.2 = 3 := h1_eq3
    have h3 : l1 = l3 := by tauto
    simp [h3] at *
    <;> linarith
  have h_l2_ne_l3 : l2 ≠ l3 := by
    intro h
    have h1 : l2.1 + l2.2 = 2 := h1_eq2
    have h2 : l3.1 + l3.2 = 3 := h1_eq3
    have h3 : l2 = l3 := by tauto
    simp [h3] at *
    <;> linarith
  have h125 : ({l1, l2, l3} : Finset (ℝ × ℝ)) ⊆ lines := by
    intro x hx
    simp at hx
    rcases hx with (rfl | rfl | rfl)
    · exact hl1_in_lines
    · exact hl2_in_lines
    · exact hl3_in_lines
  have h126 : ({l1, l2, l3} : Finset (ℝ × ℝ)).card = 3 := by
    have h1 : l1 ≠ l2 := h_l1_ne_l2
    have h2 : l1 ≠ l3 := h_l1_ne_l3
    have h3 : l2 ≠ l3 := h_l2_ne_l3
    simp [Finset.card_insert_of_not_mem, Finset.mem_singleton, h1, h2, h3]
  have h123 : ({l1, l2, l3} : Finset (ℝ × ℝ)) = lines := by
    apply Finset.eq_of_subset_of_card_le h125
    <;> simp [h126, h_lines_card]
  have h54 : ∃ l4 ∈ lines, l4.1 * 2 + l4.2 = 1 := by
    have h211 := hmain (⟨2, 1⟩ : ℕ × ℕ) h21inpoints
    cases h211 with
    | inl h2111 =>
      rcases h2111 with ⟨l, hl, h_eq⟩
      refine ⟨l, hl,?_⟩
      norm_num at h_eq ⊢
      <;> linarith
    | inr h2112 =>
      rcases h2112 with ⟨x, hx, hx2⟩
      rw [h_verts_empty] at hx
      simp at hx
  have h55 : ∃ l5 ∈ lines, l5.1 * 2 + l5.2 = 2 := by
    have h221 := hmain (⟨2, 2⟩ : ℕ × ℕ) h22inpoints
    cases h221 with
    | inl h2211 =>
      rcases h2211 with ⟨l, hl, h_eq⟩
      refine ⟨l, hl,?_⟩
      norm_num at h_eq ⊢
      <;> linarith
    | inr h2212 =>
      rcases h2212 with ⟨x, hx, hx2⟩
      rw [h_verts_empty] at hx
      simp at hx
  have h56 : ∃ l6 ∈ lines, l6.1 * 3 + l6.2 = 1 := by
    have h311 := hmain (⟨3, 1⟩ : ℕ × ℕ) h31inpoints
    cases h311 with
    | inl h3111 =>
      rcases h3111 with ⟨l, hl, h_eq⟩
      refine ⟨l, hl,?_⟩
      norm_num at h_eq ⊢
      <;> linarith
    | inr h3112 =>
      rcases h3112 with ⟨x, hx, hx2⟩
      rw [h_verts_empty] at hx
      simp at hx
  rcases h54 with ⟨l4, hl4_in_lines, h4_eq⟩
  rcases h55 with ⟨l5, hl5_in_lines, h5_eq⟩
  rcases h56 with ⟨l6, hl6_in_lines, h6_eq⟩
  have h_l4_in_set : l4 ∈ ({l1, l2, l3} : Finset (ℝ × ℝ)) := by
    rw [h123]
    exact hl4_in_lines
  have h_l5_in_set : l5 ∈ ({l1, l2, l3} : Finset (ℝ × ℝ)) := by
    rw [h123]
    exact hl5_in_lines
  have h_l6_in_set : l6 ∈ ({l1, l2, l3} : Finset (ℝ × ℝ)) := by
    rw [h123]
    exact hl6_in_lines
  have h_l4_eq : l4 = l1 ∨ l4 = l2 ∨ l4 = l3 := by
    simp at h_l4_in_set
    tauto
  have h_l5_eq : l5 = l1 ∨ l5 = l2 ∨ l5 = l3 := by
    simp at h_l5_in_set
    tauto
  have h_l6_eq : l6 = l1 ∨ l6 = l2 ∨ l6 = l3 := by
    simp at h_l6_in_set
    tauto
  have h4211 : (lines.filter (fun l : ℝ × ℝ => l.1 = 0 ∨ l.1 = -1)).card = 1 := h421
  rcases h_l4_eq with (h_l4_eq1 | h_l4_eq2 | h_l4_eq3)
  ·
    have h_l4_eq11 : l4 = l1 := h_l4_eq1
    have h4_eq11 : l1.1 * 2 + l1.2 = 1 := by
      rw [h_l4_eq11] at h4_eq
      exact h4_eq
    have h1_eq111 : l1.1 + l1.2 = 1 := h1_eq1
    have h_l1_1_eq_0 : l1.1 = 0 := by linarith
    rcases h_l5_eq with (h_l5_eq1 | h_l5_eq2 | h_l5_eq3)
    ·
      have h_l5_eq11 : l5 = l1 := h_l5_eq1
      have h5_eq11 : l1.1 * 2 + l1.2 = 2 := by
        rw [h_l5_eq11] at h5_eq
        exact h5_eq
      have h1_eq1111 : l1.1 + l1.2 = 1 := h1_eq1
      have h_l1_1_eq_01 : l1.1 = 0 := h_l1_1_eq_0
      have h12 : l1.2 = 1 := by linarith
      linarith
    ·
      have h_l5_eq22 : l5 = l2 := h_l5_eq2
      have h5_eq22 : l2.1 * 2 + l2.2 = 2 := by
        rw [h_l5_eq22] at h5_eq
        exact h5_eq
      have h1_eq222 : l2.1 + l2.2 = 2 := h1_eq2
      have h_l2_1_eq_0 : l2.1 = 0 := by linarith
      have h13 : (lines.filter (fun l : ℝ × ℝ => l.1 = 0 ∨ l.1 = -1)).card ≥ 2 := by
        have h131 : l1 ∈ lines.filter (fun l : ℝ × ℝ => l.1 = 0 ∨ l.1 = -1) := by
          simp [Finset.mem_filter]
          <;> aesop
        have h132 : l2 ∈ lines.filter (fun l : ℝ × ℝ => l.1 = 0 ∨ l.1 = -1) := by
          simp [Finset.mem_filter]
          <;> aesop
        have h133 : l1 ≠ l2 := h_l1_ne_l2
        have h : ({l1, l2} : Finset (ℝ × ℝ)) ⊆ lines.filter (fun l : ℝ × ℝ => l.1 = 0 ∨ l.1 = -1) := by
          intro x hx
          simp at hx
          rcases hx with (rfl | rfl)
          · exact h131
          · exact h132
        have h134 : ({l1, l2} : Finset (ℝ × ℝ)).card = 2 := by
          simp [Finset.card_pair, h133]
        have h135 : ({l1, l2} : Finset (ℝ × ℝ)).card ≤ (lines.filter (fun l : ℝ × ℝ => l.1 = 0 ∨ l.1 = -1)).card := by
          apply Finset.card_le_card h
        linarith
      linarith
    ·
      have h_l5_eq33 : l5 = l3 := h_l5_eq3
      have h5_eq33 : l3.1 * 2 + l3.2 = 2 := by
        rw [h_l5_eq33] at h5_eq
        exact h5_eq
      have h1_eq333 : l3.1 + l3.2 = 3 := h1_eq3
      have h_l3_1_eq_neg1 : l3.1 = -1 := by linarith
      have h13 : (lines.filter (fun l : ℝ × ℝ => l.1 = 0 ∨ l.1 = -1)).card ≥ 2 := by
        have h131 : l1 ∈ lines.filter (fun l : ℝ × ℝ => l.1 = 0 ∨ l.1 = -1) := by
          simp [Finset.mem_filter]
          <;> aesop
        have h132 : l3 ∈ lines.filter (fun l : ℝ × ℝ => l.1 = 0 ∨ l.1 = -1) := by
          simp [Finset.mem_filter]
          <;> aesop
        have h133 : l1 ≠ l3 := h_l1_ne_l3
        have h : ({l1, l3} : Finset (ℝ × ℝ)) ⊆ lines.filter (fun l : ℝ × ℝ => l.1 = 0 ∨ l.1 = -1) := by
          intro x hx
          simp at hx
          rcases hx with (rfl | rfl)
          · exact h131
          · exact h132
        have h134 : ({l1, l3} : Finset (ℝ × ℝ)).card = 2 := by
          simp [Finset.card_pair, h133]
        have h135 : ({l1, l3} : Finset (ℝ × ℝ)).card ≤ (lines.filter (fun l : ℝ × ℝ => l.1 = 0 ∨ l.1 = -1)).card := by
          apply Finset.card_le_card h
        linarith
      linarith
  ·
    have h_l4_eq22 : l4 = l2 := h_l4_eq2
    have h4_eq22 : l2.1 * 2 + l2.2 = 1 := by
      rw [h_l4_eq22] at h4_eq
      exact h4_eq
    have h1_eq222 : l2.1 + l2.2 = 2 := h1_eq2
    have h_l2_1_eq_neg1 : l2.1 = -1 := by linarith
    rcases h_l5_eq with (h_l5_eq1 | h_l5_eq2 | h_l5_eq3)
    ·
      have h_l5_eq11 : l5 = l1 := h_l5_eq1
      have h5_eq11 : l1.1 * 2 + l1.2 = 2 := by
        rw [h_l5_eq11] at h5_eq
        exact h5_eq
      have h1_eq1111 : l1.1 + l1.2 = 1 := h1_eq1
      have h_l1_1_eq_1 : l1.1 = 1 := by linarith
      rcases h_l6_eq with (h_l6_eq1 | h_l6_eq2 | h_l6_eq3)
      ·
        have h_l6_eq11 : l6 = l1 := h_l6_eq1
        have h6_eq11 : l1.1 * 3 + l1.2 = 1 := by
          rw [h_l6_eq11] at h6_eq
          exact h6_eq
        have h1_eq11111 : l1.1 + l1.2 = 1 := h1_eq1
        have h_l1_1_eq_11 : l1.1 = 1 := h_l1_1_eq_1
        linarith
      ·
        have h_l6_eq22 : l6 = l2 := h_l6_eq2
        have h6_eq22 : l2.1 * 3 + l2.2 = 1 := by
          rw [h_l6_eq22] at h6_eq
          exact h6_eq
        have h1_eq2222 : l2.1 + l2.2 = 2 := h1_eq2
        have h_l2_1_eq_neg11 : l2.1 = -1 := h_l2_1_eq_neg1
        linarith
      ·
        have h_l6_eq33 : l6 = l3 := h_l6_eq3
        have h6_eq33 : l3.1 * 3 + l3.2 = 1 := by
          rw [h_l6_eq33] at h6_eq
          exact h6_eq
        have h_l3_1_eq_neg1 : l3.1 = -1 := by linarith
        have h14 : (lines.filter (fun l : ℝ × ℝ => l.1 = 0 ∨ l.1 = -1)).card ≥ 2 := by
          have h141 : l2 ∈ lines.filter (fun l : ℝ × ℝ => l.1 = 0 ∨ l.1 = -1) := by
            simp [Finset.mem_filter]
            <;> aesop
          have h142 : l3 ∈ lines.filter (fun l : ℝ × ℝ => l.1 = 0 ∨ l.1 = -1) := by
            simp [Finset.mem_filter]
            <;> aesop
          have h143 : l2 ≠ l3 := h_l2_ne_l3
          have h : ({l2, l3} : Finset (ℝ × ℝ)) ⊆ lines.filter (fun l : ℝ × ℝ => l.1 = 0 ∨ l.1 = -1) := by
            intro x hx
            simp at hx
            rcases hx with (rfl | rfl)
            · exact h141
            · exact h142
          have h144 : ({l2, l3} : Finset (ℝ × ℝ)).card = 2 := by
            simp [Finset.card_pair, h143]
          have h145 : ({l2, l3} : Finset (ℝ × ℝ)).card ≤ (lines.filter (fun l : ℝ × ℝ => l.1 = 0 ∨ l.1 = -1)).card := by
            apply Finset.card_le_card h
          linarith
        linarith
    ·
      have h_l5_eq22 : l5 = l2 := h_l5_eq2
      have h5_eq22 : l2.1 * 2 + l2.2 = 2 := by
        rw [h_l5_eq22] at h5_eq
        exact h5_eq
      have h1_eq2222 : l2.1 + l2.2 = 2 := h1_eq2
      have h_l2_1_eq_neg11 : l2.1 = -1 := h_l2_1_eq_neg1
      have h13 : l2.2 = 3 := by linarith
      have h13_continue2 : False := by linarith
      linarith
    ·
      have h_l5_eq33 : l5 = l3 := h_l5_eq3
      have h5_eq33 : l3.1 * 2 + l3.2 = 2 := by
        rw [h_l5_eq33] at h5_eq
        exact h5_eq
      have h1_eq333 : l3.1 + l3.2 = 3 := h1_eq3
      have h_l3_1_eq_neg1 : l3.1 = -1 := by linarith
      have h14 : (lines.filter (fun l : ℝ × ℝ => l.1 = 0 ∨ l.1 = -1)).card ≥ 2 := by
        have h141 : l2 ∈ lines.filter (fun l : ℝ × ℝ => l.1 = 0 ∨ l.1 = -1) := by
          simp [Finset.mem_filter]
          <;> aesop
        have h142 : l3 ∈ lines.filter (fun l : ℝ × ℝ => l.1 = 0 ∨ l.1 = -1) := by
          simp [Finset.mem_filter]
          <;> aesop
        have h143 : l2 ≠ l3 := h_l2_ne_l3
        have h : ({l2, l3} : Finset (ℝ × ℝ)) ⊆ lines.filter (fun l : ℝ × ℝ => l.1 = 0 ∨ l.1 = -1) := by
          intro x hx
          simp at hx
          rcases hx with (rfl | rfl)
          · exact h141
          · exact h142
        have h144 : ({l2, l3} : Finset (ℝ × ℝ)).card = 2 := by
          simp [Finset.card_pair, h143]
        have h145 : ({l2, l3} : Finset (ℝ × ℝ)).card ≤ (lines.filter (fun l : ℝ × ℝ => l.1 = 0 ∨ l.1 = -1)).card := by
          apply Finset.card_le_card h
        linarith
      linarith
  ·
    have h_l4_eq33 : l4 = l3 := h_l4_eq3
    have h4_eq33 : l3.1 * 2 + l3.2 = 1 := by
      rw [h_l4_eq33] at h4_eq
      exact h4_eq
    have h1_eq33 : l3.1 + l3.2 = 3 := h1_eq3
    have h_l3_1_eq_neg2 : l3.1 = -2 := by linarith
    have h_l3_2_eq_5 : l3.2 = 5 := by linarith
    have h_l5_ne_l3 : l5 ≠ l3 := by
      by_contra h_l5_eq_l3
      have h5_eq2 : l5.1 * 2 + l5.2 = 2 := h5_eq
      rw [h_l5_eq_l3] at h5_eq2
      norm_num [h_l3_1_eq_neg2, h_l3_2_eq_5] at h5_eq2
    have h_l5_eq_l1_or_l5_eq_l2 : l5 = l1 ∨ l5 = l2 := by
      rcases h_l5_eq with (h51 | h52 | h53)
      · exact Or.inl h51
      · exact Or.inr h52
      · contradiction
    rcases h_l5_eq_l1_or_l5_eq_l2 with (h_l5_eq_l1 | h_l5_eq_l2)
    ·
      have h5_eq2 : l5.1 * 2 + l5.2 = 2 := h5_eq
      rw [h_l5_eq_l1] at h5_eq2
      have h_l6_ne_l3 : l6 ≠ l3 := by
        by_contra h_l6_eq_l3
        have h6_eq2 : l6.1 * 3 + l6.2 = 1 := h6_eq
        rw [h_l6_eq_l3] at h6_eq2
        norm_num [h_l3_1_eq_neg2, h_l3_2_eq_5] at h6_eq2
      have h_l6_eq_l1_or_l6_eq_l2 : l6 = l1 ∨ l6 = l2 := by
        rcases h_l6_eq with (h61 | h62 | h63)
        · exact Or.inl h61
        · exact Or.inr h62
        · contradiction
      rcases h_l6_eq_l1_or_l6_eq_l2 with (h_l6_eq_l1 | h_l6_eq_l2)
      ·
        have h6_eq1 : l1.1 * 3 + l1.2 = 1 := by
          rw [h_l6_eq_l1] at h6_eq
          exact h6_eq
        have h_l1_1_eq_neg1 : l1.1 = -1 := by linarith
        have h_l1_2_eq_4 : l1.2 = 4 := by linarith
        have h_l1_in_filter : l1 ∈ lines.filter (fun l : ℝ × ℝ => l.1 = 0 ∨ l.1 = -1) := by
          simp [Finset.mem_filter]
          <;> aesop
        have h1 : l1.1 = 1 := by linarith
        linarith
      ·
        have h6_eq2 : l2.1 * 3 + l2.2 = 1 := by
          rw [h_l6_eq_l2] at h6_eq
          exact h6_eq
        have h_l2_1_eq_neg1_2 : l2.1 = -1 / 2 := by linarith
        have h_l1_1_eq_1 : l1.1 = 1 := by linarith
        have h_l1_2_eq_0 : l1.2 = 0 := by linarith
        have h42111 : ∃ l7, l7 ∈ lines.filter (fun l ↦ l.1 = 0 ∨ l.1 = -1) := by
          have h1 : (lines.filter (fun l : ℝ × ℝ => l.1 = 0 ∨ l.1 = -1)).card = 1 := h4211
          have h2 : (lines.filter (fun l : ℝ × ℝ => l.1 = 0 ∨ l.1 = -1)).Nonempty := by
            rw [Finset.nonempty_iff_ne_empty]
            by_contra h
            have h3 : (lines.filter (fun l : ℝ × ℝ => l.1 = 0 ∨ l.1 = -1)) = ∅ := by simpa using h
            have h4 : (lines.filter (fun l : ℝ × ℝ => l.1 = 0 ∨ l.1 = -1)).card = 0 := by
              rw [h3]
              simp
            linarith
          exact h2
        rcases h42111 with ⟨l7, hl7_in_filter⟩
        have hl7_in_lines : l7 ∈ lines := (Finset.mem_filter.mp hl7_in_filter).1
        have hl7_prop : l7.1 = 0 ∨ l7.1 = -1 := (Finset.mem_filter.mp hl7_in_filter).2
        have h_l7_eq : l7 = l1 ∨ l7 = l2 ∨ l7 = l3 := by
          have h1231 : l7 ∈ ({l1, l2, l3} : Finset (ℝ × ℝ)) := by
            rw [h123]
            exact hl7_in_lines
          simp at h1231
          tauto
        rcases h_l7_eq with (h_l7_eq1 | h_l7_eq2 | h_l7_eq3)
        ·
          have h_l7_eq11 : l7 = l1 := h_l7_eq1
          have h1 : l7.1 = 0 ∨ l7.1 = -1 := hl7_prop
          have h2 : l7.1 = l1.1 := by rw [h_l7_eq11]
          have h3 : l1.1 = 1 := h_l1_1_eq_1
          have h4 : l7.1 = 1 := by linarith
          rcases h1 with (h11 | h12)
          ·
            linarith
          ·
            linarith
        ·
          have h_l7_eq22 : l7 = l2 := h_l7_eq2
          have h1 : l7.1 = 0 ∨ l7.1 = -1 := hl7_prop
          have h2 : l7.1 = l2.1 := by rw [h_l7_eq22]
          have h3 : l2.1 = -1 / 2 := h_l2_1_eq_neg1_2
          have h4 : l7.1 = -1 / 2 := by linarith
          rcases h1 with (h11 | h12)
          ·
            linarith
          ·
            linarith
        ·
          have h_l7_eq33 : l7 = l3 := h_l7_eq3
          have h1 : l7.1 = 0 ∨ l7.1 = -1 := hl7_prop
          have h2 : l7.1 = l3.1 := by rw [h_l7_eq33]
          have h3 : l3.1 = -2 := h_l3_1_eq_neg2
          have h4 : l7.1 = -2 := by linarith
          rcases h1 with (h11 | h12)
          ·
            linarith
          ·
            linarith
    ·
      have h5_eq22 : l2.1 * 2 + l2.2 = 2 := by
        rw [h_l5_eq_l2] at h5_eq
        exact h5_eq
      have h_l2_1_eq_0 : l2.1 = 0 := by linarith
      have h_l2_in_filter : l2 ∈ lines.filter (fun l : ℝ × ℝ => l.1 = 0 ∨ l.1 = -1) := by
        simp [Finset.mem_filter]
        <;> aesop
      have h_l6_ne_l3 : l6 ≠ l3 := by
        by_contra h_l6_eq_l3
        have h6_eq2 : l6.1 * 3 + l6.2 = 1 := h6_eq
        rw [h_l6_eq_l3] at h6_eq2
        norm_num [h_l3_1_eq_neg2, h_l3_2_eq_5] at h6_eq2
      have h_l6_eq_l1_or_l6_eq_l2 : l6 = l1 ∨ l6 = l2 := by
        rcases h_l6_eq with (h61 | h62 | h63)
        · exact Or.inl h61
        · exact Or.inr h62
        · contradiction
      rcases h_l6_eq_l1_or_l6_eq_l2 with (h_l6_eq_l1 | h_l6_eq_l2)
      ·
        have h6_eq1 : l1.1 * 3 + l1.2 = 1 := by
          rw [h_l6_eq_l1] at h6_eq
          exact h6_eq
        have h_l1_1_eq_0 : l1.1 = 0 := by linarith
        have h_l1_in_filter : l1 ∈ lines.filter (fun l : ℝ × ℝ => l.1 = 0 ∨ l.1 = -1) := by
          simp [Finset.mem_filter]
          <;> aesop
        have h14 : (lines.filter (fun l : ℝ × ℝ => l.1 = 0 ∨ l.1 = -1)).card ≥ 2 := by
          have h141 : l1 ∈ lines.filter (fun l : ℝ × ℝ => l.1 = 0 ∨ l.1 = -1) := h_l1_in_filter
          have h142 : l2 ∈ lines.filter (fun l : ℝ × ℝ => l.1 = 0 ∨ l.1 = -1) := h_l2_in_filter
          have h143 : l1 ≠ l2 := h_l1_ne_l2
          have h : ({l1, l2} : Finset (ℝ × ℝ)) ⊆ lines.filter (fun l : ℝ × ℝ => l.1 = 0 ∨ l.1 = -1) := by
            intro x hx
            simp at hx
            rcases hx with (rfl | rfl)
            · exact h141
            · exact h142
          have h144 : ({l1, l2} : Finset (ℝ × ℝ)).card = 2 := by
            simp [Finset.card_pair, h143]
          have h145 : ({l1, l2} : Finset (ℝ × ℝ)).card ≤ (lines.filter (fun l : ℝ × ℝ => l.1 = 0 ∨ l.1 = -1)).card := by
            apply Finset.card_le_card h
          linarith
        linarith
      ·
        have h6_eq2 : l2.1 * 3 + l2.2 = 1 := by
          rw [h_l6_eq_l2] at h6_eq
          exact h6_eq
        have h_l2_2_eq_1 : l2.2 = 1 := by linarith
        have h1 : l2.1 + l2.2 = 2 := h1_eq2
        norm_num [h_l2_1_eq_0, h_l2_2_eq_1] at h1

theorem k2_impossible_for_n3 (n : ℕ) (k : ℕ) (verts : Finset ℝ) (lines : Finset (ℝ × ℝ)) (points : Finset (ℕ × ℕ))
  (hn : n = 3) (hk : k = 2)
  (hcard : lines.card + verts.card = n) (hallpoints : ∀ p, p ∈ points ↔ p.1 ≥ 1 ∧ p.2 ≥ 1 ∧ p.1 + p.2 ≤ n + 1)
  (hmain : ∀ p ∈ points, (∃ l ∈ lines, l.1 * (p.1 : ℝ) + l.2 = (p.2 : ℝ)) ∨ (∃ x ∈ verts, (p.1 : ℝ) = x))
  (hk_sunny : (lines.filter (fun l ↦ l.1 ≠ 0 ∧ l.1 ≠ -1)).card = k) :
  False := by
  have h₁₇ : (lines.filter (fun l ↦ l.1 = 0 ∨ l.1 = -1)) ∪ (lines.filter (fun l ↦ l.1 ≠ 0 ∧ l.1 ≠ -1)) = lines := by
    ext x
    simp [or_iff_not_imp_left]
    tauto
  have h₁₅ : ((lines.filter (fun l ↦ l.1 = 0 ∨ l.1 = -1)) ∪ (lines.filter (fun l ↦ l.1 ≠ 0 ∧ l.1 ≠ -1))).card =
    (lines.filter (fun l ↦ l.1 = 0 ∨ l.1 = -1)).card + (lines.filter (fun l ↦ l.1 ≠ 0 ∧ l.1 ≠ -1)).card := by
    rw [Finset.card_union_of_disjoint]
    simp [Finset.disjoint_left]
    aesop
  have h₁₆ : lines.card = ((lines.filter (fun l ↦ l.1 = 0 ∨ l.1 = -1)) ∪ (lines.filter (fun l ↦ l.1 ≠ 0 ∧ l.1 ≠ -1))).card := by
    rw [h₁₇]
  rw [hk] at hk_sunny
  rcases (by omega : ((lines.filter (fun l ↦ l.1 = 0 ∨ l.1 = -1)).card = 0 ∧ verts.card = 1) ∨ ((lines.filter (fun l ↦ l.1 = 0 ∨ l.1 = -1)).card = 1 ∧ verts.card = 0)) with (h₃₁ | h₃₂)
  exact round1_case1 n k verts lines points hn hcard hallpoints hmain (by
    intro l hl
    by_contra h22
    have h23 : l.1 = 0 ∨ l.1 = -1 := by tauto
    have h24 : l ∈ lines.filter (fun l ↦ l.1 = 0 ∨ l.1 = -1) := by
      simp only [Finset.mem_filter]
      exact ⟨hl, h23⟩
    have h25 : 0 < (lines.filter (fun l ↦ l.1 = 0 ∨ l.1 = -1)).card := by
      apply Finset.card_pos.mpr
      exact ⟨l, h24⟩
    linarith) h₃₁.2
  exact round1_case2 n k verts lines points hn hcard hallpoints hmain h₃₂.1 h₃₂.2

theorem round1_h1 (k : ℕ)
  (lines : Finset (ℝ × ℝ))
  (verts : Finset ℝ)
  (points : Finset (ℕ × ℕ))
  (hcard : lines.card + verts.card = 3)
  (hallpoints : ∀ p, p ∈ points ↔ p.1 ≥ 1 ∧ p.2 ≥ 1 ∧ p.1 + p.2 ≤ 3 + 1)
  (hmain : ∀ p ∈ points, (∃ l ∈ lines, l.1 * p.1 + l.2 = p.2) ∨ (∃ x ∈ verts, p.1 = x))
  (hk : (lines.filter (fun l ↦ l.1 ≠ 0 ∧ l.1 ≠ -1)).card = k):
  k ≤ 3 := by
  apply k_le_3_for_n_le_4
  <;> tauto

theorem round1_h2 (k : ℕ)
  (lines : Finset (ℝ × ℝ))
  (verts : Finset ℝ)
  (points : Finset (ℕ × ℕ))
  (hcard : lines.card + verts.card = 3)
  (hallpoints : ∀ p, p ∈ points ↔ p.1 ≥ 1 ∧ p.2 ≥ 1 ∧ p.1 + p.2 ≤ 3 + 1)
  (hmain : ∀ p ∈ points, (∃ l ∈ lines, l.1 * p.1 + l.2 = p.2) ∨ (∃ x ∈ verts, p.1 = x))
  (hk : (lines.filter (fun l ↦ l.1 ≠ 0 ∧ l.1 ≠ -1)).card = k):
  k ≠ 2 := by
  have := k2_impossible_for_n3 3 2 verts lines points
  simp_all

theorem imo2025_p1_prop_n_eq_3_k_eq_0_1_3 (k : ℕ) (lines : Finset (ℝ × ℝ)) (verts : Finset ℝ) (points : Finset (ℕ × ℕ)) (hcard : lines.card + verts.card = 3) (hallpoints : ∀ p, p ∈ points ↔ p.1 ≥ 1 ∧ p.2 ≥ 1 ∧ p.1 + p.2 ≤ 3 + 1) (hmain : ∀ p ∈ points, (∃ l ∈ lines, l.1 * p.1 + l.2 = p.2) ∨ (∃ x ∈ verts, p.1 = x)) (hk : (lines.filter (fun l ↦ l.1 ≠ 0 ∧ l.1 ≠ -1)).card = k) :
  k = 0 ∨ k = 1 ∨ k = 3 := by
  have := round1_h1 k lines verts points hcard hallpoints hmain hk
  have := round1_h2 k lines verts points hcard hallpoints hmain hk
  omega

theorem inductive_step_if_contains_horizontal_line_h_sum_card_h1 (n k : ℕ)
  (verts : Finset ℝ)
  (lines : Finset (ℝ × ℝ))
  (points : Finset (ℕ × ℕ))
  (l : ℝ × ℝ)
  (hl_in_lines : l ∈ lines):
  1 ≤ lines.card := by
  by_contra
  aesop

theorem inductive_step_if_contains_horizontal_line_h_sum_card_h2 (n k : ℕ)
  (verts : Finset ℝ)
  (lines : Finset (ℝ × ℝ))
  (points : Finset (ℕ × ℕ))
  (l : ℝ × ℝ)
  (hl_in_lines : l ∈ lines):
  (lines.erase l).card = lines.card - 1 := by
  simp_all

theorem inductive_step_if_contains_horizontal_line_h_sum_card_h3 (n k : ℕ)
  (verts : Finset ℝ)
  (lines : Finset (ℝ × ℝ))
  (points : Finset (ℕ × ℕ))
  (hcard : lines.card + verts.card = n)
  (l : ℝ × ℝ)
  (h1 : 1 ≤ lines.card):
  verts.card + (lines.card - 1) = n - 1 := by
  omega

theorem inductive_step_if_contains_horizontal_line_h_sum_card_h4 (n k : ℕ)
  (verts : Finset ℝ)
  (lines : Finset (ℝ × ℝ))
  (points : Finset (ℕ × ℕ))
  (l : ℝ × ℝ)
  (h2 : (lines.erase l).card = lines.card - 1)
  (h3 : verts.card + (lines.card - 1) = n - 1):
  verts.card + (lines.erase l).card = n - 1 := by
  simp_all

theorem inductive_step_if_contains_horizontal_line_h_sum_card (n k : ℕ)
  (verts : Finset ℝ)
  (lines : Finset (ℝ × ℝ))
  (points : Finset (ℕ × ℕ))
  (hcard : lines.card + verts.card = n)
  (l : ℝ × ℝ)
  (hl_in_lines : l ∈ lines)
  (hn : n ≥ 4):
  verts.card + (lines.erase l).card = n - 1 := by
  have h1 := inductive_step_if_contains_horizontal_line_h_sum_card_h1 n k verts lines points l hl_in_lines
  simp [hl_in_lines]
  omega

theorem translation_equivalence_y_axis_h_main (n k_local : ℕ)
  (hn : n > 3)
  (H : ∀ (k' : ℕ) (verts' : Finset ℝ) (lines' : Finset (ℝ × ℝ)),
    (verts'.card + lines'.card = n - 1) →
    (∀ p : ℕ × ℕ, p.1 ≥ 1 ∧ p.2 ≥ 1 ∧ p.1 + p.2 ≤ n →
      (∃ l ∈ lines', l.1 * (p.1 : ℝ) + l.2 = (p.2 : ℝ)) ∨ (∃ x ∈ verts', (p.1 : ℝ) = x)) →
    ((lines'.filter (fun l ↦ l.1 ≠ 0 ∧ l.1 ≠ -1)).card = k') →
    k' = 0 ∨ k' = 1 ∨ k' = 3)
  (verts : Finset ℝ)
  (lines : Finset (ℝ × ℝ))
  (points : Finset (ℕ × ℕ))
  (h1 : verts.card + lines.card = n - 1)
  (h2 : ∀ p, p ∈ points ↔ p.1 ≥ 1 ∧ p.2 ≥ 2 ∧ p.1 + p.2 ≤ n + 1)
  (h3 : ∀ p ∈ points, (∃ l ∈ lines, l.1 * p.1 + l.2 = p.2) ∨ (∃ x ∈ verts, p.1 = x))
  (h4 : (lines.filter (fun l ↦ l.1 ≠ 0 ∧ l.1 ≠ -1)).card = k_local):
  k_local = 0 ∨ k_local = 1 ∨ k_local = 3 := by
  let f (p : ℝ × ℝ) := (p.1, p.2 - 1)
  have h_inj_f : Function.Injective f := by
    intro p q h
    simp_all [Prod.ext_iff]
  set lines' := Finset.image f lines
  have h_card_lines' : lines'.card = lines.card := by
    apply Finset.card_image_of_injective
    exact h_inj_f
  set verts' := verts
  have h_card_sum : verts'.card + lines'.card = n - 1 := by
    rw [h_card_lines']
    exact h1
  have h_cond_points : ∀ (p : ℕ × ℕ), p.1 ≥ 1 ∧ p.2 ≥ 1 ∧ p.1 + p.2 ≤ n →
    (∃ l ∈ lines', l.1 * (p.1 : ℝ) + l.2 = (p.2 : ℝ)) ∨ (∃ x ∈ verts', (p.1 : ℝ) = x) := by
    intro p hp
    let p' := (p.1, p.2 + 1)
    have h_p'_1 : p'.1 ≥ 1 := by simp [hp]
    have h_p'_2 : p'.2 ≥ 2 := by simp [hp]
    have h_p'_3 : p'.1 + p'.2 ≤ n + 1 := by
      simp [hp]
      <;> omega
    have h_p'_in_points : p' ∈ points := by
      rw [h2]
      <;> aesop
    have h_h3_p' : (∃ l ∈ lines, l.1 * p'.1 + l.2 = p'.2) ∨ (∃ x ∈ verts, p'.1 = x) := h3 p' h_p'_in_points
    cases h_h3_p' with
    | inl h_h3_p'_1 =>
      rcases h_h3_p'_1 with ⟨l, hl_in_lines, h_eq⟩
      have h_eq_p1 : (p'.1 : ℝ) = (p.1 : ℝ) := by
        simp [hp]
      have h_eq_p2 : (p'.2 : ℝ) = (p.2 : ℝ) + 1 := by
        simp [hp]
      have h_eq_l : l.1 * (p.1 : ℝ) + l.2 = (p.2 : ℝ) + 1 := by
        rw [h_eq_p1, h_eq_p2] at h_eq
        linarith
      set l' := f l
      have h_l'_in_lines' : l' ∈ lines' := by
        simp_all [f, Finset.mem_image]
        <;> aesop
      have h_l'_1 : l'.1 = l.1 := by
        simp [f]
      have h_l'_2 : l'.2 = l.2 - 1 := by
        simp [f]
      have h_main_eq : l'.1 * (p.1 : ℝ) + l'.2 = (p.2 : ℝ) := by
        rw [h_l'_1, h_l'_2]
        linarith
      exact Or.inl ⟨l', h_l'_in_lines', h_main_eq⟩
    | inr h_h3_p'_2 =>
      rcases h_h3_p'_2 with ⟨x, hx_in_vert, h_eq⟩
      have h_eq_p1 : p'.1 = p.1 := by
        simp [hp]
      have h_eq' : ∃ x ∈ verts, (p.1 : ℝ) = x := by
        refine' ⟨x, hx_in_vert, _⟩
        linarith
      have h_main_eq : ∃ x ∈ verts', (p.1 : ℝ) = x := by
        simpa [verts'] using h_eq'
      exact Or.inr h_main_eq
  have h_card_filter : ((lines'.filter (fun l ↦ l.1 ≠ 0 ∧ l.1 ≠ -1)).card = k_local) := by
    rw [h_card_lines'] at *
    have h14 : (Finset.image f (lines.filter (fun l ↦ l.1 ≠ 0 ∧ l.1 ≠ -1))).card = (lines.filter (fun l ↦ l.1 ≠ 0 ∧ l.1 ≠ -1)).card := by
      apply Finset.card_image_of_injective
      exact h_inj_f
    have h15 : (Finset.image f (lines.filter (fun l ↦ l.1 ≠ 0 ∧ l.1 ≠ -1))) = ((Finset.image f lines).filter (fun l ↦ l.1 ≠ 0 ∧ l.1 ≠ -1)) := by
      apply Finset.ext
      intro x
      simp only [Finset.mem_image, Finset.mem_filter]
      constructor
      · rintro ⟨y, hy, rfl⟩
        refine' ⟨_, _⟩
        · aesop
        · aesop
      · rintro ⟨hx, hx'⟩
        have h16 : ∃ y, y ∈ lines ∧ f y = x := by
          aesop
        rcases h16 with ⟨y, hy, h17⟩
        refine' ⟨y, _⟩
        aesop
    rw [← h15, h14]
    exact h4
  exact H k_local verts' lines' h_card_sum h_cond_points h_card_filter

theorem translation_equivalence_y_axis (n k : ℕ) (hn :  n > 3) :
  (∀ (k' : ℕ) (verts' : Finset ℝ) (lines' : Finset (ℝ × ℝ)),
    (verts'.card + lines'.card = n - 1) →
    (∀ p : ℕ × ℕ, p.1 ≥ 1 ∧ p.2 ≥ 1 ∧ p.1 + p.2 ≤ n →
      (∃ l ∈ lines', l.1 * (p.1 : ℝ) + l.2 = (p.2 : ℝ)) ∨ (∃ x ∈ verts', (p.1 : ℝ) = x)) →
    ((lines'.filter (fun l ↦ l.1 ≠ 0 ∧ l.1 ≠ -1)).card = k') →
    k' = 0 ∨ k' = 1 ∨ k' = 3) →
  (∀ (k : ℕ) (verts : Finset ℝ) (lines : Finset (ℝ × ℝ)) (points : Finset (ℕ × ℕ)),
    (verts.card + lines.card = n - 1) →
    (∀ p, p ∈ points ↔ p.1 ≥ 1 ∧ p.2 ≥ 2 ∧ p.1 + p.2 ≤ n + 1) →
    (∀ p ∈ points, (∃ l ∈ lines, l.1 * p.1 + l.2 = p.2) ∨ (∃ x ∈ verts, p.1 = x)) →
    ((lines.filter (fun l ↦ l.1 ≠ 0 ∧ l.1 ≠ -1)).card = k) →
    k = 0 ∨ k = 1 ∨ k = 3)    := by
  intros
  apply translation_equivalence_y_axis_h_main
  <;> assumption

theorem inductive_step_if_contains_horizontal_line_h_filter_card_eq_k (n k : ℕ)
  (verts : Finset ℝ)
  (lines : Finset (ℝ × ℝ))
  (points : Finset (ℕ × ℕ))
  (hk : (lines.filter (fun l ↦ l.1 ≠ 0 ∧ l.1 ≠ -1)).card = k)
  (l₀ : ℝ × ℝ)
  (hl₀_in_lines : l₀ ∈ lines)
  (hl₀_1 : l₀.1 = 0)
  (h_filter_card : ((lines.erase l₀).filter (fun l ↦ l.1 ≠ 0 ∧ l.1 ≠ -1)).card = (lines.filter (fun l ↦ l.1 ≠ 0 ∧ l.1 ≠ -1)).card):
  ((lines.erase l₀).filter (fun l ↦ l.1 ≠ 0 ∧ l.1 ≠ -1)).card = k := by
  simp_all

theorem inductive_step_if_contains_horizontal_line_h_card_erase (n k : ℕ)
  (verts : Finset ℝ)
  (lines : Finset (ℝ × ℝ))
  (points : Finset (ℕ × ℕ))
  (l₀ : ℝ × ℝ)
  (hl₀_in_lines : l₀ ∈ lines):
  (lines.erase l₀).card = lines.card - 1 := by
  simp_all

theorem inductive_step_if_contains_horizontal_line_h_n_gt_3 (n k : ℕ)
  (verts : Finset ℝ)
  (lines : Finset (ℝ × ℝ))
  (points : Finset (ℕ × ℕ))
  (hn : n ≥ 4):
  n > 3 := by
  omega

theorem inductive_step_if_contains_horizontal_line_h_main (n k : ℕ)
  (verts : Finset ℝ)
  (lines : Finset (ℝ × ℝ))
  (points : Finset (ℕ × ℕ))
  (h_has_horizontal : ∃ l ∈ lines, l.1 = 0 ∧ l.2 = 1):
  ∃ (l₀ : ℝ × ℝ), l₀ ∈ lines ∧ l₀.1 = 0 ∧ l₀.2 = 1 := by
  aesop

theorem inductive_step_if_contains_horizontal_line_h_translation_equivalence (n k : ℕ)
  (verts : Finset ℝ)
  (lines : Finset (ℝ × ℝ))
  (points : Finset (ℕ × ℕ))
  (h_ih : ∀ (k' : ℕ) (verts' : Finset ℝ) (lines' : Finset (ℝ × ℝ)),
    (verts'.card + lines'.card = n - 1) →
    (∀ p : ℕ × ℕ, p.1 ≥ 1 ∧ p.2 ≥ 1 ∧ p.1 + p.2 ≤ n →
      (∃ l ∈ lines', l.1 * (p.1 : ℝ) + l.2 = (p.2 : ℝ)) ∨ (∃ x ∈ verts', (p.1 : ℝ) = x)) →
    ((lines'.filter (fun l ↦ l.1 ≠ 0 ∧ l.1 ≠ -1)).card = k') →
    k' = 0 ∨ k' = 1 ∨ k' = 3)
  (hn : n ≥ 4)
  (h_n_gt_3 : n > 3):
  ∀ (k'' : ℕ) (verts'' : Finset ℝ) (lines'' : Finset (ℝ × ℝ)) (points'' : Finset (ℕ × ℕ)), (verts''.card + lines''.card = n - 1) → (∀ p, p ∈ points'' ↔ p.1 ≥ 1 ∧ p.2 ≥ 2 ∧ p.1 + p.2 ≤ n + 1) → (∀ p ∈ points'', (∃ l ∈ lines'', l.1 * p.1 + l.2 = p.2) ∨ (∃ x ∈ verts'', p.1 = x)) → ((lines''.filter (fun l ↦ l.1 ≠ 0 ∧ l.1 ≠ -1)).card = k'') → k'' = 0 ∨ k'' = 1 ∨ k'' = 3 := by
  apply translation_equivalence_y_axis
  <;> assumption

theorem inductive_step_if_contains_horizontal_line_h_filter_eq_h_main (n k : ℕ)
  (verts : Finset ℝ)
  (lines : Finset (ℝ × ℝ))
  (points : Finset (ℕ × ℕ))
  (l : ℝ × ℝ)
  (hl1 : l.1 = 0)
  (hl_in_lines : l ∈ lines)
  (lines' : Finset (ℝ × ℝ))
  (h_lines'_def : lines' = lines.erase l):
  ∀ (x : ℝ × ℝ), x ∈ (lines'.filter (fun l ↦ l.1 ≠ 0 ∧ l.1 ≠ -1)) ↔ x ∈ (lines.filter (fun l ↦ l.1 ≠ 0 ∧ l.1 ≠ -1)) := by
  aesop

theorem inductive_step_if_contains_horizontal_line_h_filter_eq_h_final (n k : ℕ)
  (verts : Finset ℝ)
  (lines : Finset (ℝ × ℝ))
  (points : Finset (ℕ × ℕ))
  (l : ℝ × ℝ)
  (lines' : Finset (ℝ × ℝ))
  (h_main : ∀ (x : ℝ × ℝ), x ∈ (lines'.filter (fun l ↦ l.1 ≠ 0 ∧ l.1 ≠ -1)) ↔ x ∈ (lines.filter (fun l ↦ l.1 ≠ 0 ∧ l.1 ≠ -1))):
  (lines'.filter (fun l ↦ l.1 ≠ 0 ∧ l.1 ≠ -1)) = (lines.filter (fun l ↦ l.1 ≠ 0 ∧ l.1 ≠ -1)) := by
  aesop

theorem inductive_step_if_contains_horizontal_line_h_filter_eq (n k : ℕ)
  (verts : Finset ℝ)
  (lines : Finset (ℝ × ℝ))
  (points : Finset (ℕ × ℕ))
  (l : ℝ × ℝ)
  (hl1 : l.1 = 0)
  (hl_in_lines : l ∈ lines)
  (lines' : Finset (ℝ × ℝ))
  (h_lines'_def : lines' = lines.erase l):
  (lines'.filter (fun l ↦ l.1 ≠ 0 ∧ l.1 ≠ -1)) = (lines.filter (fun l ↦ l.1 ≠ 0 ∧ l.1 ≠ -1)) := by
  aesop

theorem inductive_step_if_contains_horizontal_line_h_main' (n k : ℕ)
  (verts : Finset ℝ)
  (lines : Finset (ℝ × ℝ))
  (points : Finset (ℕ × ℕ))
  (h_has_horizontal : ∃ l ∈ lines, l.1 = 0 ∧ l.2 = 1):
  ∃ (l₀ : ℝ × ℝ), l₀ ∈ lines ∧ l₀.1 = 0 ∧ l₀.2 = 1 := by
  aesop

theorem inductive_step_if_contains_horizontal_line_h_card_erase' (n k : ℕ)
  (verts : Finset ℝ)
  (lines : Finset (ℝ × ℝ))
  (points : Finset (ℕ × ℕ))
  (l₀ : ℝ × ℝ)
  (hl₀_in_lines : l₀ ∈ lines):
  (lines.erase l₀).card = lines.card - 1 := by
  simp_all

theorem inductive_step_if_contains_horizontal_line_h_sum_card' (n k : ℕ)
  (verts : Finset ℝ)
  (lines : Finset (ℝ × ℝ))
  (points : Finset (ℕ × ℕ))
  (hcard : lines.card + verts.card = n)
  (l : ℝ × ℝ)
  (hl_in_lines : l ∈ lines)
  (hn : n ≥ 4):
  verts.card + (lines.erase l).card = n - 1 := by
  apply inductive_step_if_contains_horizontal_line_h_sum_card
  <;> assumption

theorem inductive_step_if_contains_horizontal_line_h_filter_card_eq_k' (n k : ℕ)
  (verts : Finset ℝ)
  (lines : Finset (ℝ × ℝ))
  (points : Finset (ℕ × ℕ))
  (hk : (lines.filter (fun l ↦ l.1 ≠ 0 ∧ l.1 ≠ -1)).card = k)
  (l₀ : ℝ × ℝ)
  (hl₀_in_lines : l₀ ∈ lines)
  (hl₀_1 : l₀.1 = 0)
  (h_filter_card : ((lines.erase l₀).filter (fun l ↦ l.1 ≠ 0 ∧ l.1 ≠ -1)).card = (lines.filter (fun l ↦ l.1 ≠ 0 ∧ l.1 ≠ -1)).card):
  ((lines.erase l₀).filter (fun l ↦ l.1 ≠ 0 ∧ l.1 ≠ -1)).card = k := by
  simp_all

theorem inductive_step_if_contains_horizontal_line_h_n_gt_3' (n k : ℕ)
  (verts : Finset ℝ)
  (lines : Finset (ℝ × ℝ))
  (points : Finset (ℕ × ℕ))
  (hn : n ≥ 4):
  n > 3 := by
 linarith

theorem inductive_step_if_contains_horizontal_line_h_translation_equivalence' (n k : ℕ)
  (verts : Finset ℝ)
  (lines : Finset (ℝ × ℝ))
  (points : Finset (ℕ × ℕ))
  (h_ih : ∀ (k' : ℕ) (verts' : Finset ℝ) (lines' : Finset (ℝ × ℝ)),
    (verts'.card + lines'.card = n - 1) →
    (∀ p : ℕ × ℕ, p.1 ≥ 1 ∧ p.2 ≥ 1 ∧ p.1 + p.2 ≤ n →
      (∃ l ∈ lines', l.1 * (p.1 : ℝ) + l.2 = (p.2 : ℝ)) ∨ (∃ x ∈ verts', (p.1 : ℝ) = x)) →
    ((lines'.filter (fun l ↦ l.1 ≠ 0 ∧ l.1 ≠ -1)).card = k') →
    k' = 0 ∨ k' = 1 ∨ k' = 3)
  (hn : n ≥ 4)
  (h_n_gt_3 : n > 3):
  ∀ (k'' : ℕ) (verts'' : Finset ℝ) (lines'' : Finset (ℝ × ℝ)) (points'' : Finset (ℕ × ℕ)), (verts''.card + lines''.card = n - 1) → (∀ p, p ∈ points'' ↔ p.1 ≥ 1 ∧ p.2 ≥ 2 ∧ p.1 + p.2 ≤ n + 1) → (∀ p ∈ points'', (∃ l ∈ lines'', l.1 * p.1 + l.2 = p.2) ∨ (∃ x ∈ verts'', p.1 = x)) → ((lines''.filter (fun l ↦ l.1 ≠ 0 ∧ l.1 ≠ -1)).card = k'') → k'' = 0 ∨ k'' = 1 ∨ k'' = 3 := by
  exact inductive_step_if_contains_horizontal_line_h_translation_equivalence n k verts lines points h_ih hn h_n_gt_3

theorem inductive_step_if_contains_horizontal_line_h_filter_eq' (n k : ℕ)
  (verts : Finset ℝ)
  (lines : Finset (ℝ × ℝ))
  (points : Finset (ℕ × ℕ))
  (l : ℝ × ℝ)
  (hl1 : l.1 = 0)
  (hl_in_lines : l ∈ lines)
  (lines' : Finset (ℝ × ℝ))
  (h_lines'_def : lines' = lines.erase l):
  (lines'.filter (fun l ↦ l.1 ≠ 0 ∧ l.1 ≠ -1)) = (lines.filter (fun l ↦ l.1 ≠ 0 ∧ l.1 ≠ -1)) := by
  aesop

theorem inductive_step_if_contains_horizontal_line_h_main_1 (n k : ℕ)
  (verts : Finset ℝ)
  (lines : Finset (ℝ × ℝ))
  (points : Finset (ℕ × ℕ))
  (h_has_horizontal : ∃ l ∈ lines, l.1 = 0 ∧ l.2 = 1):
  ∃ (l₀ : ℝ × ℝ), l₀ ∈ lines ∧ l₀.1 = 0 ∧ l₀.2 = 1 := by
  aesop

theorem inductive_step_if_contains_horizontal_line_h_card_erase_1 (n k : ℕ)
  (verts : Finset ℝ)
  (lines : Finset (ℝ × ℝ))
  (points : Finset (ℕ × ℕ))
  (l₀ : ℝ × ℝ)
  (hl₀_in_lines : l₀ ∈ lines):
  (lines.erase l₀).card = lines.card - 1 := by
  simp_all

theorem inductive_step_if_contains_horizontal_line_h_sum_card_1 (n k : ℕ)
  (verts : Finset ℝ)
  (lines : Finset (ℝ × ℝ))
  (points : Finset (ℕ × ℕ))
  (hcard : lines.card + verts.card = n)
  (l : ℝ × ℝ)
  (hl_in_lines : l ∈ lines)
  (hn : n ≥ 4):
  verts.card + (lines.erase l).card = n - 1 := by
  apply inductive_step_if_contains_horizontal_line_h_sum_card'
  assumption'

theorem inductive_step_if_contains_horizontal_line_h_filter_card_eq_k_1 (n k : ℕ)
  (verts : Finset ℝ)
  (lines : Finset (ℝ × ℝ))
  (points : Finset (ℕ × ℕ))
  (hk : (lines.filter (fun l ↦ l.1 ≠ 0 ∧ l.1 ≠ -1)).card = k)
  (l₀ : ℝ × ℝ)
  (hl₀_in_lines : l₀ ∈ lines)
  (hl₀_1 : l₀.1 = 0)
  (h_filter_card : ((lines.erase l₀).filter (fun l ↦ l.1 ≠ 0 ∧ l.1 ≠ -1)).card = (lines.filter (fun l ↦ l.1 ≠ 0 ∧ l.1 ≠ -1)).card):
  ((lines.erase l₀).filter (fun l ↦ l.1 ≠ 0 ∧ l.1 ≠ -1)).card = k := by
  simp_all

theorem inductive_step_if_contains_horizontal_line_h_n_gt_3_1 (n k : ℕ)
  (verts : Finset ℝ)
  (lines : Finset (ℝ × ℝ))
  (points : Finset (ℕ × ℕ))
  (hn : n ≥ 4):
  n > 3 := by
 linarith

theorem inductive_step_if_contains_horizontal_line_h_translation_equivalence_1 (n k : ℕ)
  (verts : Finset ℝ)
  (lines : Finset (ℝ × ℝ))
  (points : Finset (ℕ × ℕ))
  (h_ih : ∀ (k' : ℕ) (verts' : Finset ℝ) (lines' : Finset (ℝ × ℝ)),
    (verts'.card + lines'.card = n - 1) →
    (∀ p : ℕ × ℕ, p.1 ≥ 1 ∧ p.2 ≥ 1 ∧ p.1 + p.2 ≤ n →
      (∃ l ∈ lines', l.1 * (p.1 : ℝ) + l.2 = (p.2 : ℝ)) ∨ (∃ x ∈ verts', (p.1 : ℝ) = x)) →
    ((lines'.filter (fun l ↦ l.1 ≠ 0 ∧ l.1 ≠ -1)).card = k') →
    k' = 0 ∨ k' = 1 ∨ k' = 3)
  (hn : n ≥ 4)
  (h_n_gt_3 : n > 3):
  ∀ (k'' : ℕ) (verts'' : Finset ℝ) (lines'' : Finset (ℝ × ℝ)) (points'' : Finset (ℕ × ℕ)), (verts''.card + lines''.card = n - 1) → (∀ p, p ∈ points'' ↔ p.1 ≥ 1 ∧ p.2 ≥ 2 ∧ p.1 + p.2 ≤ n + 1) → (∀ p ∈ points'', (∃ l ∈ lines'', l.1 * p.1 + l.2 = p.2) ∨ (∃ x ∈ verts'', p.1 = x)) → ((lines''.filter (fun l ↦ l.1 ≠ 0 ∧ l.1 ≠ -1)).card = k'') → k'' = 0 ∨ k'' = 1 ∨ k'' = 3 := by
  apply inductive_step_if_contains_horizontal_line_h_translation_equivalence'
  <;> assumption

theorem inductive_step_if_contains_horizontal_line_h_filter_eq_1 (n k : ℕ)
  (verts : Finset ℝ)
  (lines : Finset (ℝ × ℝ))
  (points : Finset (ℕ × ℕ))
  (l : ℝ × ℝ)
  (hl1 : l.1 = 0)
  (hl_in_lines : l ∈ lines)
  (lines' : Finset (ℝ × ℝ))
  (h_lines'_def : lines' = lines.erase l):
  (lines'.filter (fun l ↦ l.1 ≠ 0 ∧ l.1 ≠ -1)) = (lines.filter (fun l ↦ l.1 ≠ 0 ∧ l.1 ≠ -1)) := by
  aesop

theorem inductive_step_if_contains_horizontal_line (n k : ℕ) (verts : Finset ℝ) (lines : Finset (ℝ × ℝ)) (points : Finset (ℕ × ℕ)) (hcard : lines.card + verts.card = n) (hallpoints : ∀ p, p ∈ points ↔ p.1 ≥ 1 ∧ p.2 ≥ 1 ∧ p.1 + p.2 ≤ n + 1) (hmain : ∀ p ∈ points, (∃ l ∈ lines, l.1 * p.1 + l.2 = p.2) ∨ (∃ x ∈ verts, p.1 = x)) (hk : (lines.filter (fun l ↦ l.1 ≠ 0 ∧ l.1 ≠ -1)).card = k) (hn : n ≥ 4) (hcover : ∀ p : ℕ × ℕ, p.1 ≥ 1 ∧ p.2 ≥ 1 ∧ p.1 + p.2 ≤ n + 1 →
    (∃ l ∈ lines, l.1 * (p.1 : ℝ) + l.2 = (p.2 : ℝ)) ∨ (∃ x ∈ verts, (p.1 : ℝ) = x)) (h_has_horizontal : ∃ l ∈ lines, l.1 = 0 ∧ l.2 = 1) (h_ih : ∀ (k' : ℕ) (verts' : Finset ℝ) (lines' : Finset (ℝ × ℝ)),
    (verts'.card + lines'.card = n - 1) →
    (∀ p : ℕ × ℕ, p.1 ≥ 1 ∧ p.2 ≥ 1 ∧ p.1 + p.2 ≤ n →
      (∃ l ∈ lines', l.1 * (p.1 : ℝ) + l.2 = (p.2 : ℝ)) ∨ (∃ x ∈ verts', (p.1 : ℝ) = x)) →
    ((lines'.filter (fun l ↦ l.1 ≠ 0 ∧ l.1 ≠ -1)).card = k') →
    k' = 0 ∨ k' = 1 ∨ k' = 3): k = 0 ∨ k = 1 ∨ k = 3  := by

  have h_main : ∃ (l₀ : ℝ × ℝ), l₀ ∈ lines ∧ l₀.1 = 0 ∧ l₀.2 = 1 := by
    exact inductive_step_if_contains_horizontal_line_h_main_1 n k verts lines points h_has_horizontal

  obtain ⟨l₀, hl₀_in_lines, hl₀_1, hl₀_2⟩ := h_main

  have h_card_erase : (lines.erase l₀).card = lines.card - 1 := by
    exact inductive_step_if_contains_horizontal_line_h_card_erase_1 n k verts lines points l₀ hl₀_in_lines

  have h_sum_card : verts.card + (lines.erase l₀).card = n - 1 := by
    exact inductive_step_if_contains_horizontal_line_h_sum_card_1 n k verts lines points hcard l₀ hl₀_in_lines hn

  have h_n_gt_3 : n > 3 := by
    exact inductive_step_if_contains_horizontal_line_h_n_gt_3_1 n k verts lines points hn

  have h_translation_equivalence : ∀ (k'' : ℕ) (verts'' : Finset ℝ) (lines'' : Finset (ℝ × ℝ)) (points'' : Finset (ℕ × ℕ)), (verts''.card + lines''.card = n - 1) → (∀ p, p ∈ points'' ↔ p.1 ≥ 1 ∧ p.2 ≥ 2 ∧ p.1 + p.2 ≤ n + 1) → (∀ p ∈ points'', (∃ l ∈ lines'', l.1 * p.1 + l.2 = p.2) ∨ (∃ x ∈ verts'', p.1 = x)) → ((lines''.filter (fun l ↦ l.1 ≠ 0 ∧ l.1 ≠ -1)).card = k'') → k'' = 0 ∨ k'' = 1 ∨ k'' = 3 := by
    exact inductive_step_if_contains_horizontal_line_h_translation_equivalence_1 n k verts lines points h_ih hn h_n_gt_3

  set lines' := lines.erase l₀ with h_lines'_def
  set verts' := verts with h_verts'_def

  have h_filter_eq : (lines'.filter (fun l ↦ l.1 ≠ 0 ∧ l.1 ≠ -1)) = (lines.filter (fun l ↦ l.1 ≠ 0 ∧ l.1 ≠ -1)) := by
    exact inductive_step_if_contains_horizontal_line_h_filter_eq_1 n k verts lines points l₀ hl₀_1 hl₀_in_lines lines' h_lines'_def

  have h_filter_card : ((lines.erase l₀).filter (fun l ↦ l.1 ≠ 0 ∧ l.1 ≠ -1)).card = (lines.filter (fun l ↦ l.1 ≠ 0 ∧ l.1 ≠ -1)).card := by
    have h1 : (lines'.filter (fun l ↦ l.1 ≠ 0 ∧ l.1 ≠ -1)) = (lines.filter (fun l ↦ l.1 ≠ 0 ∧ l.1 ≠ -1)) := h_filter_eq
    have h2 : lines' = lines.erase l₀ := by simpa using h_lines'_def
    rw [h2] at h1
    exact congr_arg Finset.card h1

  have h_filter_card_eq_k : ((lines.erase l₀).filter (fun l ↦ l.1 ≠ 0 ∧ l.1 ≠ -1)).card = k := by
    exact inductive_step_if_contains_horizontal_line_h_filter_card_eq_k_1 n k verts lines points hk l₀ hl₀_in_lines hl₀_1 h_filter_card

  have h1 : verts'.card + lines'.card = n - 1 := by
    simpa [h_lines'_def, h_verts'_def] using h_sum_card

  set points' : Finset (ℕ × ℕ) := (Finset.Icc 1 n ×ˢ Finset.Icc 2 (n + 1)).filter (fun p : ℕ × ℕ => p.1 ≥ 1 ∧ p.2 ≥ 2 ∧ p.1 + p.2 ≤ n + 1) with h_points'_def

  have h2 : ∀ p : ℕ × ℕ, p ∈ points' ↔ p.1 ≥ 1 ∧ p.2 ≥ 2 ∧ p.1 + p.2 ≤ n + 1 := by
    intro p
    constructor
    · -- Prove the forward direction: if p ∈ points', then p.1 ≥ 1 ∧ p.2 ≥ 2 ∧ p.1 + p.2 ≤ n + 1
      intro hp
      simp only [h_points'_def, Finset.mem_filter, Finset.mem_product, Finset.mem_Icc] at hp
      tauto
    · -- Prove the reverse direction: if p.1 ≥ 1 ∧ p.2 ≥ 2 ∧ p.1 + p.2 ≤ n + 1, then p ∈ points'
      rintro ⟨h1, h2, h3⟩
      simp only [h_points'_def, Finset.mem_filter, Finset.mem_product, Finset.mem_Icc]
      constructor
      · constructor <;> omega
      · exact ⟨h1, h2, h3⟩

  have h3 : ∀ p ∈ points', (∃ l ∈ lines', l.1 * p.1 + l.2 = p.2) ∨ (∃ x ∈ verts', p.1 = x) := by
    intro p hp
    have h3₁ : p.1 ≥ 1 ∧ p.2 ≥ 2 ∧ p.1 + p.2 ≤ n + 1 := (h2 p).mp hp
    have h3₂ : p.1 ≥ 1 := h3₁.1
    have h3₃ : p.2 ≥ 2 := h3₁.2.1
    have h3₄ : p.1 + p.2 ≤ n + 1 := h3₁.2.2
    have h3₅ : p.2 ≥ 1 := by linarith
    have h3₆ : p.1 ≥ 1 ∧ p.2 ≥ 1 ∧ p.1 + p.2 ≤ n + 1 := ⟨h3₂, h3₅, h3₄⟩
    have h3₇ : (∃ l ∈ lines, l.1 * (p.1 : ℝ) + l.2 = (p.2 : ℝ)) ∨ (∃ x ∈ verts, (p.1 : ℝ) = x) := hcover p h3₆
    cases h3₇ with
    | inl h3₇ =>
      rcases h3₇ with ⟨l, hl_in_lines, hl_eq⟩
      by_cases h3₈ : l = l₀
      · -- Case l = l₀
        have h3₈₁ : l = l₀ := h3₈
        have h3₈₂ : l.1 = l₀.1 := by rw [h3₈₁]
        have h3₈₃ : l.2 = l₀.2 := by rw [h3₈₁]
        have h3₈₄ : l.1 = 0 := by
          rw [h3₈₂, hl₀_1]
        have h3₈₅ : l.2 = 1 := by
          rw [h3₈₃, hl₀_2]
        have h3₈₆ : (l.1 : ℝ) * (p.1 : ℝ) + l.2 = (p.2 : ℝ) := by simpa using hl_eq
        rw [h3₈₄, h3₈₅] at h3₈₆
        have h3₈₇ : (0 : ℝ) * (p.1 : ℝ) + (1 : ℝ) = (p.2 : ℝ) := h3₈₆
        have h3₈₈ : (1 : ℝ) = (p.2 : ℝ) := by linarith
        have h3₈₉ : (p.2 : ℝ) = 1 := by linarith
        have h3₉₀ : p.2 = 1 := by exact_mod_cast h3₈₉
        linarith
      · -- Case l ≠ l₀
        have h3₈ : l ≠ l₀ := h3₈
        have h3₈₁ : l ∈ lines' := by
          have h3₈₂ : l ∈ lines := hl_in_lines
          have h3₈₃ : l ≠ l₀ := h3₈
          have h3₈₄ : l ∈ lines.erase l₀ := Finset.mem_erase.mpr ⟨h3₈₃, h3₈₂⟩
          simpa [h_lines'_def] using h3₈₄
        have h3₈₄ : ∃ l ∈ lines', l.1 * p.1 + l.2 = p.2 := by
          refine' ⟨l, h3₈₁, _⟩
          simpa using hl_eq
        exact Or.inl h3₈₄
    | inr h3₇ =>
      have h3₇₁ : ∃ x ∈ verts, (p.1 : ℝ) = x := h3₇
      have h3₇₂ : ∃ x ∈ verts', p.1 = x := by
        rcases h3₇₁ with ⟨x, hx_in_verts, hx_eq⟩
        refine' ⟨x, _⟩
        constructor
        · simpa [h_verts'_def] using hx_in_verts
        · linarith
      exact Or.inr h3₇₂

  have h4 : ((lines'.filter (fun l ↦ l.1 ≠ 0 ∧ l.1 ≠ -1)).card) = k := by simpa [h_lines'_def] using h_filter_card_eq_k

  have h5 : k = 0 ∨ k = 1 ∨ k = 3 := by
    specialize h_translation_equivalence k verts' lines' points' h1 h2 h3 h4
    simpa using h_translation_equivalence

  exact h5

theorem translation_equivalence_x_axis_h6 (n k : ℕ)
  (verts : Finset ℝ)
  (lines : Finset (ℝ × ℝ))
  (points : Finset (ℕ × ℕ))
  (hn : n > 3)
  (h₁ : verts.card + lines.card = n - 1)
  (h₂ : ∀ p, p ∈ points ↔ p.1 ≥ 2 ∧ p.2 ≥ 1 ∧ p.1 + p.2 ≤ n + 1)
  (h₃ : ∀ p ∈ points, (∃ l ∈ lines, l.1 * p.1 + l.2 = p.2) ∨ (∃ x ∈ verts, p.1 = x))
  (h₄ : (lines.filter (fun l ↦ l.1 ≠ 0 ∧ l.1 ≠ -1)).card = k):
  ∀ (p : ℕ × ℕ), p.1 ≥ 1 ∧ p.2 ≥ 1 ∧ p.1 + p.2 ≤ n → (∃ l ∈ (lines.image (fun l => (l.1, l.1 + l.2))), l.1 * (p.1 : ℝ) + l.2 = (p.2 : ℝ)) ∨ (∃ x ∈ (verts.image (fun x => x - 1)), (p.1 : ℝ) = x) := by
  intro p hp
  obtain ⟨l, hl, hl'⟩ | ⟨x, hx, hx'⟩ := h₃ (p.1 + 1, p.2) (by
    simp_all
    omega)
  exact Or.inl ⟨_
    , Finset.mem_image.mpr ⟨l, hl, rfl⟩
    , by
      simp_all
      linarith
    ⟩
  exact Or.inr ⟨_
    , Finset.mem_image.mpr ⟨x, hx, rfl⟩
    , by
      simp_all
      linarith
    ⟩

theorem translation_equivalence_x_axis_h8 (n k : ℕ)
  (verts : Finset ℝ)
  (lines : Finset (ℝ × ℝ))
  (hn : n > 3)
  (h₁ : verts.card + lines.card = n - 1)
  (h₄ : (lines.filter (fun l ↦ l.1 ≠ 0 ∧ l.1 ≠ -1)).card = k)
  (h7 : (( (lines.image (fun l => (l.1, l.1 + l.2)))).filter (fun l ↦ l.1 ≠ 0 ∧ l.1 ≠ -1)).card = (lines.filter (fun l ↦ l.1 ≠ 0 ∧ l.1 ≠ -1)).card):
  (( (lines.image (fun l => (l.1, l.1 + l.2)))).filter (fun l ↦ l.1 ≠ 0 ∧ l.1 ≠ -1)).card = k := by
  linarith

theorem translation_equivalence_x_axis_h5 (n k : ℕ)
  (verts : Finset ℝ)
  (lines : Finset (ℝ × ℝ))
  (hn : n > 3)
  (h₁ : verts.card + lines.card = n - 1):
  ( (verts.image (fun x => x - 1)) ).card + ( (lines.image (fun l => (l.1, l.1 + l.2))) ).card = n - 1 := by
  simp_all [Finset.card_image_of_injective, Function.Injective]

theorem translation_equivalence_x_axis_main_proof (n k : ℕ) (hn : n > 3)
  (h : ∀ (k' : ℕ) (verts' : Finset ℝ) (lines' : Finset (ℝ × ℝ)),
    (verts'.card + lines'.card = n - 1) →
    (∀ p : ℕ × ℕ, p.1 ≥ 1 ∧ p.2 ≥ 1 ∧ p.1 + p.2 ≤ n →
      (∃ l ∈ lines', l.1 * (p.1 : ℝ) + l.2 = (p.2 : ℝ)) ∨ (∃ x ∈ verts', (p.1 : ℝ) = x)) →
    ((lines'.filter (fun l ↦ l.1 ≠ 0 ∧ l.1 ≠ -1)).card = k') →
    k' = 0 ∨ k' = 1 ∨ k' = 3)
  (k' : ℕ) (verts' : Finset ℝ) (lines' : Finset (ℝ × ℝ))
  (h₁ : verts'.card + lines'.card = n - 1)
  (h₂ : ∀ p : ℕ × ℕ, p.1 ≥ 1 ∧ p.2 ≥ 1 ∧ p.1 + p.2 ≤ n →
    (∃ l ∈ lines', l.1 * (p.1 : ℝ) + l.2 = (p.2 : ℝ)) ∨ (∃ x ∈ verts', (p.1 : ℝ) = x))
  (h₃ : (lines'.filter (fun l ↦ l.1 ≠ 0 ∧ l.1 ≠ -1)).card = k')
  (h₄ : k' = k):
  k = 0 ∨ k = 1 ∨ k = 3 := by
  simp_all
  apply h
  all_goals assumption

theorem translation_equivalence_x_axis_h7 (n k : ℕ)
  (verts : Finset ℝ)
  (lines : Finset (ℝ × ℝ))
  (hn : n > 3)
  (h₁ : verts.card + lines.card = n - 1)
  (h₄ : (lines.filter (fun l ↦ l.1 ≠ 0 ∧ l.1 ≠ -1)).card = k):
  (( (lines.image (fun l => (l.1, l.1 + l.2)))).filter (fun l ↦ l.1 ≠ 0 ∧ l.1 ≠ -1)).card = (lines.filter (fun l ↦ l.1 ≠ 0 ∧ l.1 ≠ -1)).card := by
  simp_all [Finset.filter_image, Finset.card_image_of_injective, Function.Injective]

theorem translation_equivalence_x_axis (n k : ℕ) (hn :  n > 3) :
  (∀ (k' : ℕ) (verts' : Finset ℝ) (lines' : Finset (ℝ × ℝ)),
    (verts'.card + lines'.card = n - 1) →
    (∀ p : ℕ × ℕ, p.1 ≥ 1 ∧ p.2 ≥ 1 ∧ p.1 + p.2 ≤ n →
      (∃ l ∈ lines', l.1 * (p.1 : ℝ) + l.2 = (p.2 : ℝ)) ∨ (∃ x ∈ verts', (p.1 : ℝ) = x)) →
    ((lines'.filter (fun l ↦ l.1 ≠ 0 ∧ l.1 ≠ -1)).card = k') →
    k' = 0 ∨ k' = 1 ∨ k' = 3) →
  (∀ (k : ℕ) (verts : Finset ℝ) (lines : Finset (ℝ × ℝ)) (points : Finset (ℕ × ℕ)),
    (verts.card + lines.card = n - 1) →
    (∀ p, p ∈ points ↔ p.1 ≥ 2 ∧ p.2 ≥ 1 ∧ p.1 + p.2 ≤ n + 1) →
    (∀ p ∈ points, (∃ l ∈ lines, l.1 * p.1 + l.2 = p.2) ∨ (∃ x ∈ verts, p.1 = x)) →
    ((lines.filter (fun l ↦ l.1 ≠ 0 ∧ l.1 ≠ -1)).card = k) →
    k = 0 ∨ k = 1 ∨ k = 3)  := by
  intro h k verts lines points h₁ h₂ h₃ h₄
  have h₅ := translation_equivalence_x_axis_h5 n k verts lines hn h₁
  have h₆ := translation_equivalence_x_axis_h6 n k verts lines points hn h₁ h₂ h₃ h₄
  have h₇ := translation_equivalence_x_axis_h7 n k verts lines hn h₁ h₄
  have h₈ := translation_equivalence_x_axis_h8 n k verts lines hn h₁ h₄ h₇
  apply h
  <;> assumption

theorem inductive_step_if_contains_vertical_line_round1_h1 (n k : ℕ)
  (verts : Finset ℝ)
  (lines : Finset (ℝ × ℝ))
  (points : Finset (ℕ × ℕ))
  (h_has_vert : ∃ x ∈ verts, x = 1):
  (1 : ℝ) ∈ verts := by
  aesop

theorem round1_h_verts_card_ge_one (n k : ℕ)
  (verts : Finset ℝ)
  (lines : Finset (ℝ × ℝ))
  (points : Finset (ℕ × ℕ))
  (h1_in_verts : (1 : ℝ) ∈ verts):
  verts.card ≥ 1 := by
 by_contra
 simp_all

theorem round1_h_erase_card (n k : ℕ)
  (verts : Finset ℝ)
  (lines : Finset (ℝ × ℝ))
  (points : Finset (ℕ × ℕ))
  (h1_in_verts : (1 : ℝ) ∈ verts):
  (verts.erase (1 : ℝ)).card = verts.card - 1 := by
  simp_all

theorem round1_h_main_card (n k : ℕ)
  (verts : Finset ℝ)
  (lines : Finset (ℝ × ℝ))
  (points : Finset (ℕ × ℕ))
  (hcard : lines.card + verts.card = n)
  (h1_in_verts : (1 : ℝ) ∈ verts)
  (h_verts_card_ge_one : verts.card ≥ 1)
  (h_erase_card : (verts.erase (1 : ℝ)).card = verts.card - 1):
  (verts.erase (1 : ℝ)).card + lines.card + 1 = n := by
  omega

theorem round1_h14 (n k : ℕ)
  (verts : Finset ℝ)
  (lines : Finset (ℝ × ℝ))
  (points : Finset (ℕ × ℕ))
  (hn : n ≥ 4)
  (hcard : lines.card + verts.card = n)
  (h1_in_verts : (1 : ℝ) ∈ verts)
  (h_verts_card_ge_one : verts.card ≥ 1)
  (h_erase_card : (verts.erase (1 : ℝ)).card = verts.card - 1)
  (h_main_card : (verts.erase (1 : ℝ)).card + lines.card + 1 = n):
  (verts.erase (1 : ℝ)).card + lines.card = n - 1 := by
  omega

theorem inductive_step_if_contains_vertical_line (n k : ℕ) (verts : Finset ℝ) (lines : Finset (ℝ × ℝ)) (points : Finset (ℕ × ℕ)) (hcard : lines.card + verts.card = n) (hallpoints : ∀ p, p ∈ points ↔ p.1 ≥ 1 ∧ p.2 ≥ 1 ∧ p.1 + p.2 ≤ n + 1) (hmain : ∀ p ∈ points, (∃ l ∈ lines, l.1 * p.1 + l.2 = p.2) ∨ (∃ x ∈ verts, p.1 = x)) (hk : (lines.filter (fun l ↦ l.1 ≠ 0 ∧ l.1 ≠ -1)).card = k) (hn : n ≥ 4) (hcover : ∀ p : ℕ × ℕ, p.1 ≥ 1 ∧ p.2 ≥ 1 ∧ p.1 + p.2 ≤ n + 1 →
    (∃ l ∈ lines, l.1 * (p.1 : ℝ) + l.2 = (p.2 : ℝ)) ∨ (∃ x ∈ verts, (p.1 : ℝ) = x)) (h_has_vert : ∃ x ∈ verts, x = 1) (h_ih : ∀ (k' : ℕ) (verts' : Finset ℝ) (lines' : Finset (ℝ × ℝ)),
    (verts'.card + lines'.card = n - 1) →
    (∀ p : ℕ × ℕ, p.1 ≥ 1 ∧ p.2 ≥ 1 ∧ p.1 + p.2 ≤ n →
      (∃ l ∈ lines', l.1 * (p.1 : ℝ) + l.2 = (p.2 : ℝ)) ∨ (∃ x ∈ verts', (p.1 : ℝ) = x)) →
    ((lines'.filter (fun l ↦ l.1 ≠ 0 ∧ l.1 ≠ -1)).card = k') →
    k' = 0 ∨ k' = 1 ∨ k' = 3): k = 0 ∨ k = 1 ∨ k = 3 := by
  have h5 := inductive_step_if_contains_vertical_line_round1_h1 n k verts lines points h_has_vert
  have h6 := round1_h_verts_card_ge_one n k verts lines points h5
  have h7 := round1_h_erase_card n k verts lines points h5
  have h8 := round1_h_main_card n k verts lines points hcard h5 h6 h7
  have h9 := round1_h14 n k verts lines points hn hcard h5 h6 h7 h8
  set points' : Finset (ℕ × ℕ) := ((Finset.Icc 2 (n + 1)) ×ˢ (Finset.Icc 1 (n + 1))).filter (fun p : ℕ × ℕ => p.1 + p.2 ≤ n + 1) with hpoints'_def
  have h11 : ∀ (p : ℕ × ℕ), p ∈ points' ↔ p.1 ≥ 2 ∧ p.2 ≥ 1 ∧ p.1 + p.2 ≤ n + 1 := by
    simp [hpoints'_def, Finset.mem_filter, Finset.mem_product, Finset.mem_Icc]
    <;> omega
  have h12 : ∀ p ∈ points', (∃ l ∈ lines, l.1 * p.1 + l.2 = p.2) ∨ (∃ x ∈ (verts.erase (1 : ℝ)), p.1 = x) := by
    intro p hp
    have h13 := (h11 p).mp hp
    have h14 := hcover p ⟨by omega, by omega, by omega⟩
    cases h14 with
    | inl h14_left =>
      left
      exact h14_left
    | inr h14_right =>
      rcases h14_right with ⟨x, hx_in_verts, h_eq⟩
      have h15 : x ≠ (1 : ℝ) := by
        by_contra h151
        have h152 : (p.1 : ℝ) = 1 := by linarith
        have h153 : p.1 ≥ 2 := h13.1
        have h154 : (p.1 : ℝ) ≥ 2 := by exact_mod_cast h153
        linarith
      have hx_in_verts_erase : x ∈ verts.erase (1 : ℝ) := by
        exact Finset.mem_erase.mpr ⟨h15, hx_in_verts⟩
      right
      refine ⟨x, hx_in_verts_erase,?_⟩
      norm_cast at h_eq ⊢
  exact translation_equivalence_x_axis n k (by linarith) h_ih k (verts.erase (1 : ℝ)) lines points' h9 h11 h12 hk

theorem inductive_step_if_contains_rainy_diagonal_line_refined_main_proof (n k : ℕ) (verts : Finset ℝ) (lines : Finset (ℝ × ℝ)) (points : Finset (ℕ × ℕ)) (hn1 : 3 ≤ n) (hcard : lines.card + verts.card = n) (hallpoints : ∀ p, p ∈ points ↔ p.1 ≥ 1 ∧ p.2 ≥ 1 ∧ p.1 + p.2 ≤ n + 1) (hmain : ∀ p ∈ points, (∃ l ∈ lines, l.1 * p.1 + l.2 = p.2) ∨ (∃ x ∈ verts, p.1 = x)) (hk : (lines.filter (fun l ↦ l.1 ≠ 0 ∧ l.1 ≠ -1)).card = k) (hcover : ∀ p : ℕ × ℕ, p.1 ≥ 1 ∧ p.2 ≥ 1 ∧ p.1 + p.2 ≤ n + 1 →
    (∃ l ∈ lines, l.1 * (p.1 : ℝ) + l.2 = (p.2 : ℝ)) ∨ (∃ x ∈ verts, (p.1 : ℝ) = x)) (h_has_rainy_diagonal : ∃ l ∈ lines, l.1 = -1 ∧ l.2 = (n : ℝ) + 1) (h_ih : ∀ (k' : ℕ) (verts' : Finset ℝ) (lines' : Finset (ℝ × ℝ)),
    (verts'.card + lines'.card = n - 1) →
    (∀ p : ℕ × ℕ, p.1 ≥ 1 ∧ p.2 ≥ 1 ∧ p.1 + p.2 ≤ n →
      (∃ l ∈ lines', l.1 * (p.1 : ℝ) + l.2 = (p.2 : ℝ)) ∨ (∃ x ∈ verts', (p.1 : ℝ) = x)) →
    ((lines'.filter (fun l ↦ l.1 ≠ 0 ∧ l.1 ≠ -1)).card = k') →
    k' = 0 ∨ k' = 1 ∨ k' = 3): k = 0 ∨ k = 1 ∨ k = 3 := by
  obtain ⟨l0, hl0_in_lines, hl01, hl02⟩ := h_has_rainy_diagonal
  have h13 : ((lines.erase l0).filter (fun l ↦ l.1 ≠ 0 ∧ l.1 ≠ -1)).card = k := by
    rw [← hk]
    congr 1
    ext x
    simp [Finset.mem_filter, Finset.mem_erase]
    aesop
  have h11 : verts.card + (lines.erase l0).card = n - 1 := by
    rw [Finset.card_erase_of_mem hl0_in_lines]
    have h111 : lines.card ≥ 1 := by
      apply Finset.card_pos.mpr
      exact ⟨l0, hl0_in_lines⟩
    omega
  have h12 : ∀ p : ℕ × ℕ, p.1 ≥ 1 ∧ p.2 ≥ 1 ∧ p.1 + p.2 ≤ n → (∃ l ∈ lines.erase l0, l.1 * (p.1 : ℝ) + l.2 = (p.2 : ℝ)) ∨ (∃ x ∈ verts, (p.1 : ℝ) = x) := by
    intro p hp
    rcases hcover p ⟨hp.1, hp.2.1, by linarith⟩ with (h126 | h126)
    · rcases h126 with ⟨l, hl_in_lines, h_eq⟩
      have h1261 : l ≠ l0 := by
        by_contra h12611
        have h12612 : l = l0 := by tauto
        have h1263 : l.1 = -1 := by
          rw [h12612]
          linarith
        have h1264 : l.2 = (n : ℝ) + 1 := by
          rw [h12612]
          linarith
        have h1265 : (n : ℝ) + 1 = (p.1 : ℝ) + (p.2 : ℝ) := by
          rw [h1263, h1264] at h_eq
          ring_nf at h_eq ⊢
          linarith
        have h1266 : (p.1 : ℝ) + (p.2 : ℝ) ≤ (n : ℝ) := by exact_mod_cast hp.2.2
        linarith
      have h1267 : l ∈ lines.erase l0 := by
        exact Finset.mem_erase_of_ne_of_mem h1261 hl_in_lines
      apply Or.inl
      exact ⟨l, h1267, h_eq⟩
    · rcases h126 with ⟨x, hx_in_verts, h126_eq⟩
      apply Or.inr
      exact ⟨x, hx_in_verts, h126_eq⟩
  apply h_ih <;> assumption

theorem inductive_step_if_contains_rainy_diagonal_line_refined (n k : ℕ) (verts : Finset ℝ) (lines : Finset (ℝ × ℝ)) (points : Finset (ℕ × ℕ)) (hn : 3 ≤ n) (hcard : lines.card + verts.card = n) (hallpoints : ∀ p, p ∈ points ↔ p.1 ≥ 1 ∧ p.2 ≥ 1 ∧ p.1 + p.2 ≤ n + 1) (hmain : ∀ p ∈ points, (∃ l ∈ lines, l.1 * p.1 + l.2 = p.2) ∨ (∃ x ∈ verts, p.1 = x)) (hk : (lines.filter (fun l ↦ l.1 ≠ 0 ∧ l.1 ≠ -1)).card = k) (hn : n ≥ 4) (hcover : ∀ p : ℕ × ℕ, p.1 ≥ 1 ∧ p.2 ≥ 1 ∧ p.1 + p.2 ≤ n + 1 →
    (∃ l ∈ lines, l.1 * (p.1 : ℝ) + l.2 = (p.2 : ℝ)) ∨ (∃ x ∈ verts, (p.1 : ℝ) = x)) (h_has_rainy_diagonal : ∃ l ∈ lines, l.1 = -1 ∧ l.2 = (n : ℝ) + 1) (h_ih : ∀ (k' : ℕ) (verts' : Finset ℝ) (lines' : Finset (ℝ × ℝ)),
    (verts'.card + lines'.card = n - 1) →
    (∀ p : ℕ × ℕ, p.1 ≥ 1 ∧ p.2 ≥ 1 ∧ p.1 + p.2 ≤ n →
      (∃ l ∈ lines', l.1 * (p.1 : ℝ) + l.2 = (p.2 : ℝ)) ∨ (∃ x ∈ verts', (p.1 : ℝ) = x)) →
    ((lines'.filter (fun l ↦ l.1 ≠ 0 ∧ l.1 ≠ -1)).card = k') →
    k' = 0 ∨ k' = 1 ∨ k' = 3): k = 0 ∨ k = 1 ∨ k = 3  := by
  apply inductive_step_if_contains_rainy_diagonal_line_refined_main_proof
  all_goals assumption

theorem num_points_on_boundary_main (n : ℕ) (hpoints : Finset (ℕ × ℕ)) (hpoints_def : ∀ p, p ∈ hpoints ↔ p.1 ≥ 1 ∧ p.2 ≥ 1 ∧ p.1 + p.2 ≤ n + 1) : (Finset.filter (fun p => p.1 = 1 ∨ p.2 = 1 ∨ p.1 + p.2 = n + 1) hpoints).card = 3 * n - (if n = 1 then 2 else if n = 2 then 3 else 3) := by
  by_cases h0 : n = 0
  ·
    have h2 : hpoints = ∅ := by
      apply Finset.eq_empty_of_forall_not_mem
      intro p
      intro h4
      have h5 := (hpoints_def p).mp h4
      simp [h0] at h5
      <;> omega
    simp [h2, h0]
  ·
    by_cases h1 : n = 1
    ·
      have h4 : hpoints = {(1, 1)} := by
        ext ⟨x, y⟩
        simp [hpoints_def, h1]
        <;> omega
      rw [h4, h1]
      <;> aesop
    ·
      by_cases h2 : n = 2
      ·
        have h4 : hpoints = {(1, 1), (1, 2), (2, 1)} := by
          ext ⟨x, y⟩
          simp [hpoints_def, h2]
          <;> omega
        rw [h4, h2]
        <;> aesop
      ·
        set A : Finset (ℕ × ℕ) := Finset.image (fun y => (1, y)) (Finset.Icc 1 n) with hA
        set B : Finset (ℕ × ℕ) := Finset.image (fun x => (x, 1)) (Finset.Icc 2 n) with hB
        set C : Finset (ℕ × ℕ) := Finset.image (fun x => (x, n + 1 - x)) (Finset.Icc 2 (n - 1)) with hC
        have h51 : Finset.filter (fun p => p.1 = 1 ∨ p.2 = 1 ∨ p.1 + p.2 = n + 1) hpoints ⊆ A ∪ B ∪ C := by
          intro p hp
          simp only [Finset.mem_filter] at hp
          have h5312 : p ∈ hpoints := hp.1
          have h5318 : p.1 = 1 ∨ p.2 = 1 ∨ p.1 + p.2 = n + 1 := hp.2
          have h5319 : p.1 ≥ 1 ∧ p.2 ≥ 1 ∧ p.1 + p.2 ≤ n + 1 := hpoints_def p |>.mp h5312
          by_cases h5324 : p.1 = 1
          ·
            have h1_eq : p.1 = 1 := h5324
            have h5315 : 1 ≤ p.2 := by linarith
            have h5316 : p.2 ≤ n := by linarith
            have h5317 : p.2 ∈ Finset.Icc 1 n := by
              simp [Finset.mem_Icc]
              <;> omega
            have h5318 : p ∈ A := by
              rw [hA]
              refine' Finset.mem_image.mpr ⟨p.2, h5317, _⟩
              simp [h1_eq, Prod.ext_iff]
            simp [h5318]
          ·
            have h1_ne : p.1 ≠ 1 := h5324
            have h53110 : p.1 ≥ 2 := by omega
            by_cases h53111 : p.2 = 1
            ·
              have h2_eq : p.2 = 1 := h53111
              have h53112 : 2 ≤ p.1 := by linarith
              have h53113 : p.1 ≤ n := by linarith
              have h53114 : p.1 ∈ Finset.Icc 2 n := by
                simp [Finset.mem_Icc]
                <;> omega
              have h53115 : p ∈ B := by
                rw [hB]
                refine' Finset.mem_image.mpr ⟨p.1, h53114, _⟩
                simp [h2_eq, Prod.ext_iff]
              simp [h53115]
            ·
              have h2_ne : p.2 ≠ 1 := h53111
              have h53117 : p.2 ≥ 2 := by omega
              have h53118 : p.1 + p.2 = n + 1 := by omega
              have h53119 : p.1 ≤ n - 1 := by omega
              have h53122 : 2 ≤ p.1 := by linarith
              have h53124 : p.1 ∈ Finset.Icc 2 (n - 1) := by
                simp [Finset.mem_Icc]
                <;> omega
              have h53125 : p ∈ C := by
                rw [hC]
                refine' Finset.mem_image.mpr ⟨p.1, h53124, _⟩
                simp [Prod.ext_iff]
                <;> omega
              simp [h53125]
        have h52 : A ∪ B ∪ C ⊆ Finset.filter (fun p => p.1 = 1 ∨ p.2 = 1 ∨ p.1 + p.2 = n + 1) hpoints := by
          intro p hp
          simp only [Finset.mem_union, Finset.mem_filter] at hp ⊢
          have h53214 : p ∈ A ∨ p ∈ B ∨ p ∈ C := by tauto
          rcases h53214 with (h53214 | h53214 | h53214)
          ·
            have h532141 : p ∈ A := h53214
            rw [hA] at h532141
            simp only [Finset.mem_image] at h532141
            rcases h532141 with ⟨y, hy, h532142⟩
            have hy1 : 1 ≤ y := by
              simp [Finset.mem_Icc] at hy
              <;> linarith
            have hy2 : y ≤ n := by
              simp [Finset.mem_Icc] at hy
              <;> linarith
            have h5321421 : p.1 = 1 := by
              simp [Prod.ext_iff] at h532142
              <;> aesop
            have h532143 : p.2 = y := by
              have h532142' : p = (1, y) := by simp [Prod.ext_iff] at h532142 ⊢ <;> tauto
              rw [h532142']
            have h532144 : p.1 ≥ 1 ∧ p.2 ≥ 1 ∧ p.1 + p.2 ≤ n + 1 := by
              constructor
              · linarith
              constructor
              · linarith
              · linarith
            have h532145 : p ∈ hpoints := hpoints_def p |>.mpr h532144
            exact ⟨h532145, by tauto⟩
          ·
            have h532141 : p ∈ B := h53214
            rw [hB] at h532141
            simp only [Finset.mem_image] at h532141
            rcases h532141 with ⟨x, hx, h532142⟩
            have hx1 : 2 ≤ x := by
              simp [Finset.mem_Icc] at hx
              <;> linarith
            have hx2 : x ≤ n := by
              simp [Finset.mem_Icc] at hx
              <;> linarith
            have h5321421 : p.1 = x := by
              simp [Prod.ext_iff] at h532142
              <;> aesop
            have h5321422 : p.2 = 1 := by
              simp [Prod.ext_iff] at h532142
              <;> aesop
            have h532144 : p.1 ≥ 1 ∧ p.2 ≥ 1 ∧ p.1 + p.2 ≤ n + 1 := by
              constructor
              · linarith
              constructor
              · linarith
              · linarith
            have h532145 : p ∈ hpoints := hpoints_def p |>.mpr h532144
            exact ⟨h532145, by tauto⟩
          ·
            have h532141 : p ∈ C := h53214
            rw [hC] at h532141
            simp only [Finset.mem_image] at h532141
            rcases h532141 with ⟨x, hx, h532142⟩
            have hx1 : 2 ≤ x := by
              simp [Finset.mem_Icc] at hx
              <;> omega
            have hx2 : x ≤ n - 1 := by
              simp [Finset.mem_Icc] at hx
              <;> omega
            have h5321421 : p.1 = x := by
              simp [Prod.ext_iff] at h532142
              <;> aesop
            have h5321422 : p.2 = n + 1 - x := by
              simp [Prod.ext_iff] at h532142
              <;> aesop
            have h532144 : p.1 ≥ 1 ∧ p.2 ≥ 1 ∧ p.1 + p.2 ≤ n + 1 := by
              constructor
              · linarith
              constructor
              · omega
              · omega
            have h532145 : p ∈ hpoints := hpoints_def p |>.mpr h532144
            have h532146 : p.1 + p.2 = n + 1 := by omega
            exact ⟨h532145, by tauto⟩
        have h53 : Finset.filter (fun p => p.1 = 1 ∨ p.2 = 1 ∨ p.1 + p.2 = n + 1) hpoints = A ∪ B ∪ C := by
          apply Finset.Subset.antisymm h51 h52
        rw [h53]
        have h_disj1 : Disjoint A B := by
          rw [Finset.disjoint_left]
          intro p hpA hpB
          rw [hA] at hpA
          rw [hB] at hpB
          simp only [Finset.mem_image] at hpA hpB
          rcases hpA with ⟨y, hy, hpy⟩
          rcases hpB with ⟨x, hx, hpx⟩
          have h11 : p.1 = 1 := by
            simp [Prod.ext_iff] at hpy
            <;> aesop
          have h12 : p.1 ≥ 2 := by
            simp [Finset.mem_Icc] at hx
            simp [Prod.ext_iff] at hpx
            <;> omega
          omega
        have h_disj2 : Disjoint A C := by
          rw [Finset.disjoint_left]
          intro p hpA hpC
          rw [hA] at hpA
          rw [hC] at hpC
          simp only [Finset.mem_image] at hpA hpC
          rcases hpA with ⟨y, hy, hpy⟩
          rcases hpC with ⟨x, hx, hpx⟩
          have h11 : p.1 = 1 := by
            simp [Prod.ext_iff] at hpy
            <;> aesop
          have h12 : p.1 ≥ 2 := by
            simp [Finset.mem_Icc] at hx
            simp [Prod.ext_iff] at hpx
            <;> omega
          omega
        have h_disj3 : Disjoint B C := by
          rw [Finset.disjoint_left]
          intro p hpB hpC
          rw [hB] at hpB
          rw [hC] at hpC
          simp only [Finset.mem_image] at hpB hpC
          rcases hpB with ⟨x, hx, hpx⟩
          rcases hpC with ⟨x1, hx1, hpx1⟩
          have h1 : x1 < n := by
            have h11 : x1 ∈ Finset.Icc 2 (n - 1) := hx1
            have h12 : x1 ≤ n - 1 := by
              simp [Finset.mem_Icc] at h11
              <;> omega
            omega
          have h13 : (x, 1) = p := by tauto
          have h14 : (x1, n + 1 - x1) = p := by tauto
          have h15 : (x, 1) = (x1, n + 1 - x1) := by rw [h13, h14]
          have h2 : (x, 1).2 = (x1, n + 1 - x1).2 := by rw [h15]
          have h21 : (x, 1).2 = 1 := rfl
          have h22 : (x1, n + 1 - x1).2 = n + 1 - x1 := rfl
          rw [h21, h22] at h2
          omega
        have hA_card : A.card = n := by
          rw [hA]
          have h_inj : Function.Injective (fun y : ℕ => (1, y)) := by
            intro y1 y2 h
            simp [Prod.ext_iff] at h
            <;> aesop
          rw [Finset.card_image_of_injective _ h_inj]
          simp [Finset.Icc_eq_empty_of_lt]
        have hB_card : B.card = n - 1 := by
          rw [hB]
          have h_inj : Function.Injective (fun x : ℕ => (x, 1)) := by
            intro x1 x2 h
            simp [Prod.ext_iff] at h
            <;> aesop
          rw [Finset.card_image_of_injective _ h_inj]
          simp [Finset.Icc_eq_empty_of_lt]
        have hC_card : C.card = n - 2 := by
          rw [hC]
          have h_inj : Function.Injective (fun x : ℕ => (x, n + 1 - x)) := by
            intro x1 x2 h
            simp [Prod.ext_iff] at h
            <;> aesop
          rw [Finset.card_image_of_injective _ h_inj]
          simp [Finset.Icc_eq_empty_of_lt]
          <;> omega
        simp_all
        <;> omega

theorem num_points_on_boundary (n : ℕ) (hpoints : Finset (ℕ × ℕ)) (hpoints_def : ∀ p, p ∈ hpoints ↔ p.1 ≥ 1 ∧ p.2 ≥ 1 ∧ p.1 + p.2 ≤ n + 1) : (Finset.filter (fun p => p.1 = 1 ∨ p.2 = 1 ∨ p.1 + p.2 = n+1) hpoints).card = 3*n - (if n=1 then 2 else if n=2 then 3 else 3) := by
  apply num_points_on_boundary_main
  assumption

theorem non_sunny_lines_cover_at_most_2_points_on_boundary_same_boundary_condition_implies_eq (n : ℕ) (l : ℝ × ℝ) (points : Finset (ℕ × ℕ))
  (hn : 3 ≤ n) (h_non_sunny : l.1 ≠ 0 ∧ l.1 ≠ -1)
  (p q : ℕ × ℕ)
  (hp : (p.1 = 1 ∨ p.2 = 1 ∨ p.1 + p.2 = n + 1) ∧ (l.1 * (p.1 : ℝ) + l.2 = (p.2 : ℝ)))
  (hq : (q.1 = 1 ∨ q.2 = 1 ∨ q.1 + q.2 = n + 1) ∧ (l.1 * (q.1 : ℝ) + l.2 = (q.2 : ℝ)))
  (h_same_boundary : (p.1 = 1 ∧ q.1 = 1) ∨ (p.2 = 1 ∧ q.2 = 1) ∨ (p.1 + p.2 = n + 1 ∧ q.1 + q.2 = n + 1)) :
  p = q := by
  rcases h_same_boundary with (h1 | h2 | h3)
  · aesop
  · simp_all
    have : (p.1 : ℝ) = q.1 := by
      apply mul_left_cancel₀ h_non_sunny.1
      linarith
    aesop
  have : (p.1 : ℝ) + (p.2 : ℝ) = (n : ℝ) + 1 := by exact_mod_cast h3.1
  have : (q.1 : ℝ) + (q.2 : ℝ) = (n : ℝ) + 1 := by exact_mod_cast h3.2
  have : (p.1 : ℝ) = q.1 := by
    apply mul_left_cancel₀ (sub_ne_zero.mpr h_non_sunny.2)
    linarith
  aesop

theorem non_sunny_lines_cover_at_most_2_points_on_boundary_main (n k : ℕ)
  (verts : Finset ℝ)
  (lines : Finset (ℝ × ℝ))
  (points : Finset (ℕ × ℕ))
  (l : ℝ × ℝ)
  (h_non_sunny : l.1 ≠ 0 ∧ l.1 ≠ -1)
  (p q r : ℕ × ℕ)
  (hp : p ∈ (Finset.filter (fun p ↦ (p.1 = 1 ∨ p.2 = 1 ∨ p.1 + p.2 = n + 1) ∧ (l.1 * (p.1 : ℝ) + l.2 = (p.2 : ℝ))) points))
  (hq : q ∈ (Finset.filter (fun p ↦ (p.1 = 1 ∨ p.2 = 1 ∨ p.1 + p.2 = n + 1) ∧ (l.1 * (p.1 : ℝ) + l.2 = (p.2 : ℝ))) points))
  (hr : r ∈ (Finset.filter (fun p ↦ (p.1 = 1 ∨ p.2 = 1 ∨ p.1 + p.2 = n + 1) ∧ (l.1 * (p.1 : ℝ) + l.2 = (p.2 : ℝ))) points))
  (hp1 : p.1 = 1)
  (hq2 : q.2 = 1)
  (hr3 : r.1 + r.2 = n + 1)
  (hpq : p ≠ q)
  (hpr : p ≠ r)
  (hqr : q ≠ r)
  (hn : 3 ≤ n)
  (hallpoints : ∀ p, p ∈ points ↔ p.1 ≥ 1 ∧ p.2 ≥ 1 ∧ p.1 + p.2 ≤ n + 1) :
  False := by
  have h1 := (hallpoints p).mp (by simp_all)
  have h2 := (hallpoints q).mp (by simp_all)
  have h3 := (hallpoints r).mp (by simp_all)
  have h13 : l.1 + l.2 = (p.2 : ℝ) := by simp_all
  have h23 : l.1 * (q.1 : ℝ) + l.2 = 1 := by simp_all
  have h33 : l.1 * (r.1 : ℝ) + l.2 = (r.2 : ℝ) := by simp_all
  norm_num [hp1, hq2] at h13 h23
  have h13' : l.1 + l.2 = (p.2 : ℝ) := by linarith
  have h23' : l.1 * (q.1 : ℝ) + l.2 = 1 := by linarith
  have h4 : l.1 * ((q.1 : ℝ) - 1) = 1 - (p.2 : ℝ) := by linarith
  by_cases h10 : q.1 = 1
  · have h10' : (q.1 : ℝ) = 1 := by exact_mod_cast h10
    have h11 : l.1 * ((q.1 : ℝ) - 1) = 0 := by
      rw [h10']
      ring
    have h12 : 1 - (p.2 : ℝ) = 0 := by linarith
    have h13 : (p.2 : ℝ) = 1 := by linarith
    have h14 : p.2 = 1 := by exact_mod_cast h13
    have h15 : p.1 = 1 := hp1
    have h16 : p = (1, 1) := by
      ext <;> simp [h15, h14]
    have h17 : q = (1, 1) := by
      ext <;> simp [h10, hq2]
    have h18 : p = q := by rw [h16, h17]
    contradiction
  · have h10' : q.1 > 1 := by omega
    have h10'' : (q.1 : ℝ) - 1 > 0 := by
      have h10''' : (q.1 : ℝ) > 1 := by exact_mod_cast h10'
      linarith
    have h13_ne_0 : l.1 ≠ 0 := h_non_sunny.1
    have h13_ne_neg1 : l.1 ≠ -1 := h_non_sunny.2
    have h19 : p.2 ≥ 1 := h1.2.1
    have h20 : p.2 = 1 ∨ p.2 > 1 := by omega
    cases h20 with
    | inl h20 =>
      have h21 : (p.2 : ℝ) = 1 := by exact_mod_cast h20
      have h22_l1_mul : l.1 * ((q.1 : ℝ) - 1) = 0 := by
        rw [h21] at h4
        linarith
      have h25 : l.1 = 0 := by
        apply mul_left_cancel₀ (by linarith : (q.1 : ℝ) - 1 ≠ 0)
        linarith
      contradiction
    | inr h20 =>
      have h21 : p.2 > 1 := h20
      have h22_p2_gt_1 : (p.2 : ℝ) > 1 := by exact_mod_cast h21
      have h23 : 1 - (p.2 : ℝ) < 0 := by linarith
      have h24 : l.1 * ((q.1 : ℝ) - 1) < 0 := by linarith [h4, h23]
      have h25 : l.1 < 0 := by nlinarith
      have h33' : l.1 * (r.1 : ℝ) + l.2 = (r.2 : ℝ) := h33
      have h14 : (r.1 : ℝ) + (r.2 : ℝ) = (n : ℝ) + 1 := by
        have h141 : (r.1 : ℝ) + (r.2 : ℝ) = ((r.1 + r.2 : ℕ) : ℝ) := by norm_cast
        have h142 : r.1 + r.2 = n + 1 := hr3
        have h143 : ((r.1 + r.2 : ℕ) : ℝ) = ((n + 1 : ℕ) : ℝ) := by rw [h142]
        have h144 : ((n + 1 : ℕ) : ℝ) = (n : ℝ) + 1 := by norm_cast
        linarith
      have h15 : l.1 * (r.1 : ℝ) - l.1 + (p.2 : ℝ) = (r.2 : ℝ) := by linarith
      have h16 : l.1 * ((r.1 : ℝ) - 1) + (p.2 : ℝ) = (r.2 : ℝ) := by linarith
      by_cases h17 : p.2 = r.2
      · have h17' : (p.2 : ℝ) = (r.2 : ℝ) := by exact_mod_cast h17
        have h18 : l.1 * ((r.1 : ℝ) - 1) = 0 := by linarith [h16, h17']
        have h19 : (r.1 : ℝ) - 1 = 0 := by
          apply mul_left_cancel₀ h13_ne_0
          linarith
        have h20 : (r.1 : ℝ) = 1 := by linarith
        have h21 : r.1 = 1 := by exact_mod_cast h20
        have h22 : r.2 = n := by omega
        have h23 : p.2 = n := by linarith [h17, h22]
        have h24 : p.1 = 1 := hp1
        have h25 : p = (1, n) := by ext <;> simp [h24, h23]
        have h26 : r.1 = 1 := h21
        have h27 : r.2 = n := h22
        have h28 : r = (1, n) := by ext <;> simp [h26, h27]
        have h29 : p = r := by rw [h25, h28]
        contradiction
      · by_cases h17' : q.2 = r.2
        · have h17'' : q.2 = r.2 := h17'
          have h17''' : q.2 = 1 := hq2
          have h17'''' : r.2 = 1 := by linarith
          have h20 : r.1 = n := by omega
          have h21 : l.1 * (r.1 : ℝ) + l.2 = (r.2 : ℝ) := h33
          have h22 : (r.1 : ℝ) = (n : ℝ) := by exact_mod_cast h20
          have h23 : (r.2 : ℝ) = 1 := by exact_mod_cast h17''''
          have h24 : l.1 * (n : ℝ) + l.2 = 1 := by
            rw [h22, h23] at h21
            linarith
          have h25 : l.1 + l.2 = (p.2 : ℝ) := h13'
          have h26 : l.1 * (n : ℝ) + l.2 - (l.1 + l.2) = 1 - (p.2 : ℝ) := by linarith
          have h27 : l.1 * ((n : ℝ) - 1) = 1 - (p.2 : ℝ) := by linarith
          have h28 : l.1 * ((q.1 : ℝ) - 1) = 1 - (p.2 : ℝ) := by linarith
          have h29 : l.1 * ((q.1 : ℝ) - 1) = l.1 * ((n : ℝ) - 1) := by linarith
          have h30 : (q.1 : ℝ) - 1 = (n : ℝ) - 1 := by
            apply mul_left_cancel₀ h13_ne_0
            linarith
          have h31 : (q.1 : ℝ) = (n : ℝ) := by linarith
          have h32 : q.1 = n := by exact_mod_cast h31
          have h33 : q.2 = 1 := hq2
          have h34 : q = (n, 1) := by ext <;> simp [h32, h33]
          have h35 : r.1 = n := h20
          have h36 : r.2 = 1 := h17''''
          have h37 : r = (n, 1) := by ext <;> simp [h35, h36]
          have h38 : q = r := by rw [h34, h37]
          contradiction
        · by_cases h17' : q.2 ≠ r.2
          · have h26 : r.2 ≥ 2 := by
              have h261 : r.2 ≥ 1 := h3.2.1
              omega
            by_cases h50 : r.1 = 1
            · have h51 : (r.1 : ℝ) = 1 := by exact_mod_cast h50
              have h52 : (r.1 : ℝ) - 1 = 0 := by linarith
              have h53 : l.1 * ((r.1 : ℝ) - 1) = 0 := by
                rw [h52]
                <;> ring
              have h54 : (r.2 : ℝ) - (p.2 : ℝ) = 0 := by linarith [h16, h53]
              have h54' : (r.2 : ℝ) = (p.2 : ℝ) := by linarith
              have h55 : r.2 = p.2 := by exact_mod_cast h54'
              have h56 : p.2 = r.2 := by linarith
              contradiction
            · have h50' : r.1 ≥ 2 := by omega
              have h50'' : (r.1 : ℝ) ≥ 2 := by exact_mod_cast h50'
              have h51 : (r.1 : ℝ) - 1 > 0 := by linarith
              by_cases h52 : l.1 < -1
              · have h53 : l.1 * ((r.1 : ℝ) - 1) < -1 * ((r.1 : ℝ) - 1) := by nlinarith
                have h54 : (n : ℝ) + 1 - (p.2 : ℝ) - 1 < 0 := by linarith
                have h55 : (n : ℝ) < (p.2 : ℝ) := by linarith
                have h55' : p.2 ≤ n := by linarith [h1.2.2]
                have h55'' : (p.2 : ℝ) ≤ (n : ℝ) := by exact_mod_cast h55'
                linarith
              · have h52' : l.1 > -1 := by
                  by_contra h521
                  have h522 : l.1 ≤ -1 := by linarith
                  have h523 : l.1 = -1 := by linarith
                  contradiction
                have h53 : l.1 * ((q.1 : ℝ) - (r.1 : ℝ)) = 1 - (r.2 : ℝ) := by
                  have h531 : l.1 * (q.1 : ℝ) + l.2 = 1 := by simpa using h23'
                  have h532 : l.1 * (r.1 : ℝ) + l.2 = (r.2 : ℝ) := by simpa using h33
                  have h : l.1 * (q.1 : ℝ) + l.2 - (l.1 * (r.1 : ℝ) + l.2) = 1 - (r.2 : ℝ) := by linarith
                  have h' : l.1 * (q.1 : ℝ) - l.1 * (r.1 : ℝ) = 1 - (r.2 : ℝ) := by linarith
                  have h'' : l.1 * ((q.1 : ℝ) - (r.1 : ℝ)) = 1 - (r.2 : ℝ) := by
                    linarith
                  linarith
                have h54 : (q.1 : ℝ) > (r.1 : ℝ) := by
                  have h541 : l.1 * ((q.1 : ℝ) - (r.1 : ℝ)) = 1 - (r.2 : ℝ) := h53
                  have h542 : (r.2 : ℝ) ≥ 2 := by exact_mod_cast h26
                  have h543 : 1 - (r.2 : ℝ) ≤ -1 := by linarith
                  have h544 : l.1 * ((q.1 : ℝ) - (r.1 : ℝ)) ≤ -1 := by linarith
                  nlinarith
                have h54' : (q.1 : ℝ) - (r.1 : ℝ) > 0 := by linarith
                have h55 : l.1 * ((q.1 : ℝ) - (r.1 : ℝ)) > -1 * ((q.1 : ℝ) - (r.1 : ℝ)) := by nlinarith
                have h56 : (q.1 : ℝ) + 1 > (r.1 : ℝ) + (r.2 : ℝ) := by linarith [h53, h55]
                have h56' : (q.1 : ℝ) > (n : ℝ) := by linarith [h14, h56]
                have h56'' : q.1 > n := by exact_mod_cast h56'
                have h57 : q.1 + q.2 ≤ n + 1 := h2.2.2
                linarith
          · simp_all

theorem non_sunny_lines_cover_at_most_2_points_on_boundary_final (n k : ℕ)
  (verts : Finset ℝ)
  (lines : Finset (ℝ × ℝ))
  (points : Finset (ℕ × ℕ))
  (l : ℝ × ℝ)
  (h_non_sunny : l.1 ≠ 0 ∧ l.1 ≠ -1)
  (p q r : ℕ × ℕ)
  (hp : p ∈ (Finset.filter (fun p ↦ (p.1 = 1 ∨ p.2 = 1 ∨ p.1 + p.2 = n + 1) ∧ (l.1 * (p.1 : ℝ) + l.2 = (p.2 : ℝ))) points))
  (hq : q ∈ (Finset.filter (fun p ↦ (p.1 = 1 ∨ p.2 = 1 ∨ p.1 + p.2 = n + 1) ∧ (l.1 * (p.1 : ℝ) + l.2 = (p.2 : ℝ))) points))
  (hr : r ∈ (Finset.filter (fun p ↦ (p.1 = 1 ∨ p.2 = 1 ∨ p.1 + p.2 = n + 1) ∧ (l.1 * (p.1 : ℝ) + l.2 = (p.2 : ℝ))) points))
  (hp1 : p.1 = 1)
  (hq2 : q.2 = 1)
  (hr3 : r.1 + r.2 = n + 1)
  (hpq : p ≠ q)
  (hpr : p ≠ r)
  (hqr : q ≠ r)
  (hn : 3 ≤ n)
  (hallpoints : ∀ p, p ∈ points ↔ p.1 ≥ 1 ∧ p.2 ≥ 1 ∧ p.1 + p.2 ≤ n + 1) :
  False := by
  exact non_sunny_lines_cover_at_most_2_points_on_boundary_main n k verts lines points l h_non_sunny p q r hp hq hr hp1 hq2 hr3 hpq hpr hqr hn hallpoints

theorem non_sunny_lines_cover_at_most_2_points_on_boundary_contradiction_from_conditions (n k : ℕ)
  (verts : Finset ℝ)
  (lines : Finset (ℝ × ℝ))
  (points : Finset (ℕ × ℕ))
  (l : ℝ × ℝ)
  (h_non_sunny : l.1 ≠ 0 ∧ l.1 ≠ -1)
  (p q r : ℕ × ℕ)
  (hp : p ∈ (Finset.filter (fun p ↦ (p.1 = 1 ∨ p.2 = 1 ∨ p.1 + p.2 = n + 1) ∧ (l.1 * p.1 + l.2 = p.2)) points))
  (hq : q ∈ (Finset.filter (fun p ↦ (p.1 = 1 ∨ p.2 = 1 ∨ p.1 + p.2 = n + 1) ∧ (l.1 * p.1 + l.2 = p.2)) points))
  (hr : r ∈ (Finset.filter (fun p ↦ (p.1 = 1 ∨ p.2 = 1 ∨ p.1 + p.2 = n + 1) ∧ (l.1 * p.1 + l.2 = p.2)) points))
  (hp1 : p.1 = 1)
  (hq2 : q.2 = 1)
  (hr3 : r.1 + r.2 = n + 1)
  (hpq : p ≠ q)
  (hpr : p ≠ r)
  (hqr : q ≠ r)
  (hn : 3 ≤ n)
  (hallpoints : ∀ p, p ∈ points ↔ p.1 ≥ 1 ∧ p.2 ≥ 1 ∧ p.1 + p.2 ≤ n + 1) :
  False := by
  apply non_sunny_lines_cover_at_most_2_points_on_boundary_final n k verts lines points l h_non_sunny p q r
  <;> aesop

theorem non_sunny_lines_cover_at_most_2_points_on_boundary_h_final (n k : ℕ)
  (verts : Finset ℝ)
  (lines : Finset (ℝ × ℝ))
  (points : Finset (ℕ × ℕ))
  (hn : 3 ≤ n)
  (hcard : lines.card + verts.card = n)
  (hallpoints : ∀ p, p ∈ points ↔ p.1 ≥ 1 ∧ p.2 ≥ 1 ∧ p.1 + p.2 ≤ n + 1)
  (hmain : ∀ p ∈ points, (∃ l ∈ lines, l.1 * p.1 + l.2 = p.2) ∨ (∃ x ∈ verts, p.1 = x))
  (hk : (lines.filter (fun l ↦ l.1 ≠ 0 ∧ l.1 ≠ -1)).card = k)
  (l : ℝ × ℝ)
  (h_non_sunny : l.1 ≠ 0 ∧ l.1 ≠ -1)
  (h_main : ∀ (x y z : ℕ × ℕ), x ∈ (Finset.filter (fun p ↦ (p.1 = 1 ∨ p.2 = 1 ∨ p.1 + p.2 = n + 1) ∧ (l.1 * p.1 + l.2 = p.2)) points) → y ∈ (Finset.filter (fun p ↦ (p.1 = 1 ∨ p.2 = 1 ∨ p.1 + p.2 = n + 1) ∧ (l.1 * p.1 + l.2 = p.2)) points) → z ∈ (Finset.filter (fun p ↦ (p.1 = 1 ∨ p.2 = 1 ∨ p.1 + p.2 = n + 1) ∧ (l.1 * p.1 + l.2 = p.2)) points) → x = y ∨ x = z ∨ y = z):
  (Finset.filter (fun p ↦ (p.1 = 1 ∨ p.2 = 1 ∨ p.1 + p.2 = n + 1) ∧ (l.1 * p.1 + l.2 = p.2)) points).card ≤ 2 := by
  contrapose! h_main
  exact Finset.two_lt_card_iff.mp h_main

theorem non_sunny_lines_cover_at_most_2_points_on_boundary_h_main (n k : ℕ)
  (verts : Finset ℝ)
  (lines : Finset (ℝ × ℝ))
  (points : Finset (ℕ × ℕ))
  (hn : 3 ≤ n)
  (hcard : lines.card + verts.card = n)
  (hallpoints : ∀ p, p ∈ points ↔ p.1 ≥ 1 ∧ p.2 ≥ 1 ∧ p.1 + p.2 ≤ n + 1)
  (hmain : ∀ p ∈ points, (∃ l ∈ lines, l.1 * p.1 + l.2 = p.2) ∨ (∃ x ∈ verts, p.1 = x))
  (hk : (lines.filter (fun l ↦ l.1 ≠ 0 ∧ l.1 ≠ -1)).card = k)
  (l : ℝ × ℝ)
  (h_non_sunny : l.1 ≠ 0 ∧ l.1 ≠ -1):
  ∀ (x y z : ℕ × ℕ), x ∈ (Finset.filter (fun p ↦ (p.1 = 1 ∨ p.2 = 1 ∨ p.1 + p.2 = n + 1) ∧ (l.1 * p.1 + l.2 = p.2)) points) → y ∈ (Finset.filter (fun p ↦ (p.1 = 1 ∨ p.2 = 1 ∨ p.1 + p.2 = n + 1) ∧ (l.1 * p.1 + l.2 = p.2)) points) → z ∈ (Finset.filter (fun p ↦ (p.1 = 1 ∨ p.2 = 1 ∨ p.1 + p.2 = n + 1) ∧ (l.1 * p.1 + l.2 = p.2)) points) → x = y ∨ x = z ∨ y = z := by
  intro x y z hx hy hz
  by_contra! h
  have hx_prop := Finset.mem_filter.mp hx |>.2
  have hy_prop := Finset.mem_filter.mp hy |>.2
  have hz_prop := Finset.mem_filter.mp hz |>.2
  rcases hx_prop.1 with (hx1 | hx2 | hx3)
  · -- Case x.1 = 1
    rcases hy_prop.1 with (hy1 | hy2 | hy3)
    · -- Subcase y.1 = 1
      have h_x_eq_y : x = y := by
        apply non_sunny_lines_cover_at_most_2_points_on_boundary_same_boundary_condition_implies_eq n l points hn h_non_sunny x y hx_prop hy_prop
        tauto
      tauto
    · -- Subcase y.2 = 1
      rcases hz_prop.1 with (hz1 | hz2 | hz3)
      · -- Sub-subcase z.1 = 1
        have h_z_eq_x : z = x := by
          apply non_sunny_lines_cover_at_most_2_points_on_boundary_same_boundary_condition_implies_eq n l points hn h_non_sunny z x hz_prop hx_prop
          tauto
        tauto
      · -- Sub-subcase z.2 = 1
        have h_y_eq_z : y = z := by
          apply non_sunny_lines_cover_at_most_2_points_on_boundary_same_boundary_condition_implies_eq n l points hn h_non_sunny y z hy_prop hz_prop
          tauto
        tauto
      · -- Sub-subcase z.1 + z.2 = n + 1
        exfalso
        exact non_sunny_lines_cover_at_most_2_points_on_boundary_contradiction_from_conditions n k verts lines points l h_non_sunny x y z hx hy hz hx1 hy2 hz3 (by tauto) (by tauto) (by tauto) hn hallpoints
    · -- Subcase y.1 + y.2 = n + 1
      rcases hz_prop.1 with (hz1 | hz2 | hz3)
      · -- Sub-subcase z.1 = 1
        have h_z_eq_x : z = x := by
          apply non_sunny_lines_cover_at_most_2_points_on_boundary_same_boundary_condition_implies_eq n l points hn h_non_sunny z x hz_prop hx_prop
          tauto
        tauto
      · -- Sub-subcase z.2 = 1
        exfalso
        exact non_sunny_lines_cover_at_most_2_points_on_boundary_contradiction_from_conditions n k verts lines points l h_non_sunny x z y hx hz hy hx1 hz2 hy3 (by tauto) (by tauto) (by tauto) hn hallpoints
      · -- Sub-subcase z.1 + z.2 = n + 1
        have h_y_eq_z : y = z := by
          apply non_sunny_lines_cover_at_most_2_points_on_boundary_same_boundary_condition_implies_eq n l points hn h_non_sunny y z hy_prop hz_prop
          tauto
        tauto
  · -- Case x.2 = 1
    rcases hy_prop.1 with (hy1 | hy2 | hy3)
    · -- Subcase y.1 = 1
      rcases hz_prop.1 with (hz1 | hz2 | hz3)
      · -- Sub-subcase z.1 = 1
        have h_y_eq_z : y = z := by
          apply non_sunny_lines_cover_at_most_2_points_on_boundary_same_boundary_condition_implies_eq n l points hn h_non_sunny y z hy_prop hz_prop
          tauto
        tauto
      · -- Sub-subcase z.2 = 1
        have h_x_eq_z : x = z := by
          apply non_sunny_lines_cover_at_most_2_points_on_boundary_same_boundary_condition_implies_eq n l points hn h_non_sunny x z hx_prop hz_prop
          tauto
        tauto
      · -- Sub-subcase z.1 + z.2 = n + 1
        exfalso
        exact non_sunny_lines_cover_at_most_2_points_on_boundary_contradiction_from_conditions n k verts lines points l h_non_sunny y x z hy hx hz hy1 hx2 hz3 (by tauto) (by tauto) (by tauto) hn hallpoints
    · -- Case y.2 = 1
      have h_x_eq_y : x = y := by
        apply non_sunny_lines_cover_at_most_2_points_on_boundary_same_boundary_condition_implies_eq n l points hn h_non_sunny x y hx_prop hy_prop
        tauto
      tauto
    · -- Case y.1 + y.2 = n + 1
      rcases hz_prop.1 with (hz1 | hz2 | hz3)
      · -- Sub-subcase z.1 = 1
        exfalso
        exact non_sunny_lines_cover_at_most_2_points_on_boundary_contradiction_from_conditions n k verts lines points l h_non_sunny z x y hz hx hy hz1 hx2 hy3 (by tauto) (by tauto) (by tauto) hn hallpoints
      · -- Sub-subcase z.2 = 1
        have h_x_eq_z : x = z := by
          apply non_sunny_lines_cover_at_most_2_points_on_boundary_same_boundary_condition_implies_eq n l points hn h_non_sunny x z hx_prop hz_prop
          tauto
        tauto
      · -- Sub-subcase z.1 + z.2 = n + 1
        have h_y_eq_z : y = z := by
          apply non_sunny_lines_cover_at_most_2_points_on_boundary_same_boundary_condition_implies_eq n l points hn h_non_sunny y z hy_prop hz_prop
          tauto
        tauto
  · -- Case x.1 + x.2 = n + 1
    rcases hy_prop.1 with (hy1 | hy2 | hy3)
    · -- Subcase y.1 = 1
      rcases hz_prop.1 with (hz1 | hz2 | hz3)
      · -- Sub-subcase z.1 = 1
        have h_y_eq_z : y = z := by
          apply non_sunny_lines_cover_at_most_2_points_on_boundary_same_boundary_condition_implies_eq n l points hn h_non_sunny y z hy_prop hz_prop
          tauto
        tauto
      · -- Sub-subcase z.2 = 1
        exfalso
        exact non_sunny_lines_cover_at_most_2_points_on_boundary_contradiction_from_conditions n k verts lines points l h_non_sunny y z x hy hz hx hy1 hz2 hx3 (by tauto) (by tauto) (by tauto) hn hallpoints
      · -- Sub-subcase z.1 + z.2 = n + 1
        have h_x_eq_z : x = z := by
          apply non_sunny_lines_cover_at_most_2_points_on_boundary_same_boundary_condition_implies_eq n l points hn h_non_sunny x z hx_prop hz_prop
          tauto
        tauto
    · -- Subcase y.2 = 1
      rcases hz_prop.1 with (hz1 | hz2 | hz3)
      · -- Sub-subcase z.1 = 1
        exfalso
        exact non_sunny_lines_cover_at_most_2_points_on_boundary_contradiction_from_conditions n k verts lines points l h_non_sunny z y x hz hy hx hz1 hy2 hx3 (by tauto) (by tauto) (by tauto) hn hallpoints
      · -- Sub-subcase z.2 = 1
        have h_y_eq_z : y = z := by
          apply non_sunny_lines_cover_at_most_2_points_on_boundary_same_boundary_condition_implies_eq n l points hn h_non_sunny y z hy_prop hz_prop
          tauto
        tauto
      · -- Sub-subcase z.1 + z.2 = n + 1
        have h_x_eq_z : x = z := by
          apply non_sunny_lines_cover_at_most_2_points_on_boundary_same_boundary_condition_implies_eq n l points hn h_non_sunny x z hx_prop hz_prop
          tauto
        tauto
    · -- Subcase y.1 + y.2 = n + 1
      have h_x_eq_y : x = y := by
        apply non_sunny_lines_cover_at_most_2_points_on_boundary_same_boundary_condition_implies_eq n l points hn h_non_sunny x y hx_prop hy_prop
        tauto
      tauto

theorem non_sunny_lines_cover_at_most_2_points_on_boundary (n k : ℕ) (verts : Finset ℝ) (lines : Finset (ℝ × ℝ)) (points : Finset (ℕ × ℕ)) (hn : 3 ≤ n) (hcard : lines.card + verts.card = n) (hallpoints : ∀ p, p ∈ points ↔ p.1 ≥ 1 ∧ p.2 ≥ 1 ∧ p.1 + p.2 ≤ n + 1) (hmain : ∀ p ∈ points, (∃ l ∈ lines, l.1 * p.1 + l.2 = p.2) ∨ (∃ x ∈ verts, p.1 = x)) (hk : (lines.filter (fun l ↦ l.1 ≠ 0 ∧ l.1 ≠ -1)).card = k) (l : ℝ × ℝ) (h_non_sunny : l.1 ≠ 0 ∧ l.1 ≠ -1) :
  (Finset.filter (fun p ↦ (p.1 = 1 ∨ p.2 = 1 ∨ p.1 + p.2 = n + 1) ∧
    (l.1 * p.1 + l.2 = p.2)) points).card ≤ 2   := by
  apply non_sunny_lines_cover_at_most_2_points_on_boundary_h_final <;> try assumption
  apply non_sunny_lines_cover_at_most_2_points_on_boundary_h_main <;> try assumption

theorem round1_case_l1_eq_0 (n k : ℕ) (verts : Finset ℝ) (lines : Finset (ℝ × ℝ)) (points : Finset (ℕ × ℕ))
  (hn : 3 ≤ n) (hcard : lines.card + verts.card = n)
  (hallpoints : ∀ p, p ∈ points ↔ p.1 ≥ 1 ∧ p.2 ≥ 1 ∧ p.1 + p.2 ≤ n + 1)
  (hmain : ∀ p ∈ points, (∃ l ∈ lines, l.1 * p.1 + l.2 = p.2) ∨ (∃ x ∈ verts, p.1 = x))
  (hk : (lines.filter (fun l ↦ l.1 ≠ 0 ∧ l.1 ≠ -1)).card = k)
  (l : ℝ × ℝ) (h_non_boundary : ¬ (l.1 = 0 ∧ l.2 = 1) ∧ ¬ (l.1 = -1 ∧ l.2 = n + 1))
  (h10 : l.1 = 0) :
  (Finset.filter (fun p ↦ (p.1 = 1 ∨ p.2 = 1 ∨ p.1 + p.2 = n + 1) ∧ (l.1 * p.1 + l.2 = p.2)) points).card ≤ 2 := by
  set S := Finset.filter (fun p ↦ (p.1 = 1 ∨ p.2 = 1 ∨ p.1 + p.2 = n + 1) ∧ (l.1 * p.1 + l.2 = p.2)) points
  set A := S.filter (fun p ↦ p.1 = 1)
  set B := S.filter (fun p ↦ p.1 + p.2 = n + 1)
  have : S ≤ A ∪ B := by
    intro p hp
    aesop
  have h1 : (A ∪ B).card ≤ A.card + B.card := Finset.card_union_le A B
  have h2 : S.card ≤ (A ∪ B).card := Finset.card_le_card this
  have h3 : A.card ≤ 1 := by
    apply Finset.card_le_one.mpr
    intro p hp q hq
    obtain ⟨h1, h2⟩ := Finset.mem_filter.mp hp
    obtain ⟨h3, h4⟩ := Finset.mem_filter.mp hq
    aesop
  have h4 : B.card ≤ 1 := by
    apply Finset.card_le_one.mpr
    intro p hp q hq
    obtain ⟨h1, h2⟩ := Finset.mem_filter.mp hp
    obtain ⟨h3, h4⟩ := Finset.mem_filter.mp hq
    have h4 : p.2 = q.2 := by aesop
    have h6 : p.1 = q.1 := by linarith
    aesop
  linarith

theorem round1_case_l1_eq_neg1 (n k : ℕ) (verts : Finset ℝ) (lines : Finset (ℝ × ℝ)) (points : Finset (ℕ × ℕ))
  (hn : 3 ≤ n) (hcard : lines.card + verts.card = n)
  (hallpoints : ∀ p, p ∈ points ↔ p.1 ≥ 1 ∧ p.2 ≥ 1 ∧ p.1 + p.2 ≤ n + 1)
  (hmain : ∀ p ∈ points, (∃ l ∈ lines, l.1 * p.1 + l.2 = p.2) ∨ (∃ x ∈ verts, p.1 = x))
  (hk : (lines.filter (fun l ↦ l.1 ≠ 0 ∧ l.1 ≠ -1)).card = k)
  (l : ℝ × ℝ) (h_non_boundary : ¬ (l.1 = 0 ∧ l.2 = 1) ∧ ¬ (l.1 = -1 ∧ l.2 = n + 1))
  (h12 : l.1 = -1) :
  (Finset.filter (fun p ↦ (p.1 = 1 ∨ p.2 = 1 ∨ p.1 + p.2 = n + 1) ∧ (l.1 * p.1 + l.2 = p.2)) points).card ≤ 2 := by
  have h13 : l.2 ≠ (n : ℝ) + 1 := by simp_all
  set S := Finset.filter (fun p ↦ (p.1 = 1 ∨ p.2 = 1 ∨ p.1 + p.2 = n + 1) ∧ (l.1 * p.1 + l.2 = p.2)) points
  have h14 : ∀ p ∈ S, p.1 = 1 ∨ p.2 = 1 := by
    intro p hp
    rcases Finset.mem_filter.mp hp with ⟨_, h141⟩
    rw [h12] at h141
    by_contra
    have h142 : p.1 + p.2 = n + 1 := by tauto
    have h143 : (p.1 : ℝ) + (p.2 : ℝ) = (n : ℝ) + 1 := by exact_mod_cast h142
    have h144 : l.2 = (n : ℝ) + 1 := by linarith
    contradiction
  have h15 : ∀ p ∈ S, l.2 = (p.1 : ℝ) + (p.2 : ℝ) := by
    intro p hp
    rcases Finset.mem_filter.mp hp with ⟨_, h151⟩
    rw [h12] at h151
    linarith
  set A := S.filter (fun p ↦ p.1 = 1)
  set B := S.filter (fun p ↦ p.2 = 1)
  have h16 : S ⊆ A ∪ B := by
    intro p hp
    rcases h14 p hp with (h161 | h161) <;> simp [A, B, Finset.mem_filter] <;> tauto
  have h17 : A.card ≤ 1 := by
    apply Finset.card_le_one.mpr
    intro p hp q hq
    simp [A, Finset.mem_filter] at hp hq
    have h171 := h15 p hp.1
    have h172 := h15 q hq.1
    have h173 : (p.1 : ℝ) = 1 := by exact_mod_cast hp.2
    have h174 : (q.1 : ℝ) = 1 := by exact_mod_cast hq.2
    rw [h173] at h171
    rw [h174] at h172
    have h175 : (p.2 : ℝ) = (q.2 : ℝ) := by linarith
    have h176 : p.2 = q.2 := by exact_mod_cast h175
    have h177 : p.1 = q.1 := by simp [hp.2, hq.2]
    have h178 : p = q := by
      ext <;> tauto
    exact h178
  have h18 : B.card ≤ 1 := by
    apply Finset.card_le_one.mpr
    intro p hp q hq
    simp [B, Finset.mem_filter] at hp hq
    have h181 := h15 p hp.1
    have h182 := h15 q hq.1
    have h183 : (p.2 : ℝ) = 1 := by exact_mod_cast hp.2
    have h184 : (q.2 : ℝ) = 1 := by exact_mod_cast hq.2
    rw [h183] at h181
    rw [h184] at h182
    have h185 : (p.1 : ℝ) = (q.1 : ℝ) := by linarith
    have h186 : p.1 = q.1 := by exact_mod_cast h185
    have h187 : p.2 = q.2 := by simp [hp.2, hq.2]
    have h188 : p = q := by
      ext <;> tauto
    exact h188
  exact Finset.card_le_card h16 |>.trans (Finset.card_union_le A B) |>.trans (by linarith)

theorem line_not_boundary_covers_at_most_2_boundary_points (n k : ℕ) (verts : Finset ℝ) (lines : Finset (ℝ × ℝ)) (points : Finset (ℕ × ℕ)) (hn : 3 ≤ n) (hcard : lines.card + verts.card = n) (hallpoints : ∀ p, p ∈ points ↔ p.1 ≥ 1 ∧ p.2 ≥ 1 ∧ p.1 + p.2 ≤ n + 1) (hmain : ∀ p ∈ points, (∃ l ∈ lines, l.1 * p.1 + l.2 = p.2) ∨ (∃ x ∈ verts, p.1 = x)) (hk : (lines.filter (fun l ↦ l.1 ≠ 0 ∧ l.1 ≠ -1)).card = k) (l : ℝ × ℝ) (h_non_boundary : ¬ (l.1 = 0 ∧ l.2 = 1) ∧ ¬ (l.1 = -1 ∧ l.2 = n + 1)) :
  (Finset.filter (fun p ↦ (p.1 = 1 ∨ p.2 = 1 ∨ p.1 + p.2 = n + 1) ∧
    (l.1 * p.1 + l.2 = p.2)) points).card ≤ 2   := by
  by_cases h0 : l.1 = 0
  · apply round1_case_l1_eq_0 n k verts lines points hn hcard hallpoints hmain hk l h_non_boundary h0
  by_cases h1 : l.1 = -1
  · apply round1_case_l1_eq_neg1 n k verts lines points hn hcard hallpoints hmain hk l h_non_boundary h1
  apply non_sunny_lines_cover_at_most_2_points_on_boundary n k verts lines points hn hcard hallpoints hmain hk
  aesop

theorem vert_line_covers_at_most_two_boundary_points (n : ℕ)
  (points : Finset (ℕ × ℕ))
  (x : ℝ)
  (hx_neq1 : x ≠ 1):
  (Finset.filter (fun p : ℕ × ℕ => p.1 ≥ 1 ∧ p.2 ≥ 1 ∧ p.1 + p.2 ≤ n + 1 ∧ ((p.1 = 1 ∨ p.2 = 1 ∨ p.1 + p.2 = n + 1)) ∧ (p.1 = x)) points).card ≤ 2 := by
  rcases (Finset.filter (fun p => p.1 ≥ 1 ∧ p.2 ≥ 1 ∧ p.1 + p.2 ≤ n + 1 ∧ (p.1 = 1 ∨ p.2 = 1 ∨ p.1 + p.2 = n + 1) ∧ p.1 = x) points).eq_empty_or_nonempty with h | ⟨p₀, hp₀⟩
  · aesop
  have : Finset.filter (fun p => p.1 ≥ 1 ∧ p.2 ≥ 1 ∧ p.1 + p.2 ≤ n + 1 ∧ (p.1 = 1 ∨ p.2 = 1 ∨ p.1 + p.2 = n + 1) ∧ p.1 = x) points ⊆ { (p₀.1, 1), (p₀.1, n + 1 - p₀.1) } := by
    intro p hp
    simp only [Finset.mem_filter] at hp
    have : p.1 = p₀.1 := by aesop
    have : p.2 = 1 ∨ p.1 + p.2 = n + 1 := by aesop
    rcases this with (h | h)
    · aesop
    · have : p.2 = n + 1 - p.1 := by omega
      aesop
  exact (Finset.card_le_card this).trans (by simp [Finset.card_le_two])

theorem total_boundary_points_covered_by_at_most_2n_h1 (n k : ℕ)
  (verts : Finset ℝ)
  (lines : Finset (ℝ × ℝ))
  (points : Finset (ℕ × ℕ))
  (h_not_y1 : ∀ l ∈ lines, ¬(l.1 = 0 ∧ l.2 = 1))
  (h_not_xn1 : ∀ l ∈ lines, ¬(l.1 = -1 ∧ l.2 = n + 1)):
  ∀ l ∈ lines, ¬ (l.1 = 0 ∧ l.2 = 1) ∧ ¬ (l.1 = -1 ∧ l.2 = n + 1) := by
  tauto

theorem total_boundary_points_covered_by_at_most_2n_h2 (n k : ℕ)
  (verts : Finset ℝ)
  (lines : Finset (ℝ × ℝ))
  (points : Finset (ℕ × ℕ))
  (hn : 3 ≤ n)
  (hcard : lines.card + verts.card = n)
  (hallpoints : ∀ p, p ∈ points ↔ p.1 ≥ 1 ∧ p.2 ≥ 1 ∧ p.1 + p.2 ≤ n + 1)
  (hmain : ∀ p ∈ points, (∃ l ∈ lines, l.1 * p.1 + l.2 = p.2) ∨ (∃ x ∈ verts, p.1 = x))
  (hk : (lines.filter (fun l ↦ l.1 ≠ 0 ∧ l.1 ≠ -1)).card = k)
  (h_not_v1 : 1 ∉ verts)
  (h_not_y1 : ∀ l ∈ lines, ¬(l.1 = 0 ∧ l.2 = 1))
  (h_not_xn1 : ∀ l ∈ lines, ¬(l.1 = -1 ∧ l.2 = n + 1))
  (h1 : ∀ l ∈ lines, ¬ (l.1 = 0 ∧ l.2 = 1) ∧ ¬ (l.1 = -1 ∧ l.2 = n + 1)):
  ∀ l ∈ lines, (Finset.filter (fun p => (p.1 = 1 ∨ p.2 = 1 ∨ p.1 + p.2 = n + 1) ∧ (l.1 * p.1 + l.2 = p.2)) points).card ≤ 2 := by
  intros
  apply line_not_boundary_covers_at_most_2_boundary_points
  all_goals
    tauto

theorem total_boundary_points_covered_by_at_most_2n_h3 (n k : ℕ)
  (verts : Finset ℝ)
  (lines : Finset (ℝ × ℝ))
  (points : Finset (ℕ × ℕ))
  (h_not_v1 : 1 ∉ verts):
  ∀ x ∈ verts, x ≠ 1 := by
  aesop

theorem total_boundary_points_covered_by_at_most_2n_h4 (n k : ℕ)
  (verts : Finset ℝ)
  (lines : Finset (ℝ × ℝ))
  (points : Finset (ℕ × ℕ))
  (hn : 3 ≤ n)
  (hcard : lines.card + verts.card = n)
  (hallpoints : ∀ p, p ∈ points ↔ p.1 ≥ 1 ∧ p.2 ≥ 1 ∧ p.1 + p.2 ≤ n + 1)
  (hmain : ∀ p ∈ points, (∃ l ∈ lines, l.1 * p.1 + l.2 = p.2) ∨ (∃ x ∈ verts, p.1 = x))
  (hk : (lines.filter (fun l ↦ l.1 ≠ 0 ∧ l.1 ≠ -1)).card = k)
  (h_not_v1 : 1 ∉ verts)
  (h3 : ∀ x ∈ verts, x ≠ 1):
  ∀ x ∈ verts, (Finset.filter (fun p : ℕ × ℕ => p.1 ≥ 1 ∧ p.2 ≥ 1 ∧ p.1 + p.2 ≤ n + 1 ∧ ((p.1 = 1 ∨ p.2 = 1 ∨ p.1 + p.2 = n + 1)) ∧ (p.1 = x)) points).card ≤ 2 := by
  intros
  apply vert_line_covers_at_most_two_boundary_points
  aesop

theorem total_boundary_points_covered_by_at_most_2n_h_main (n k : ℕ)
  (verts : Finset ℝ)
  (lines : Finset (ℝ × ℝ))
  (points : Finset (ℕ × ℕ))
  (hn : 3 ≤ n)
  (hcard : lines.card + verts.card = n)
  (hallpoints : ∀ p, p ∈ points ↔ p.1 ≥ 1 ∧ p.2 ≥ 1 ∧ p.1 + p.2 ≤ n + 1)
  (hmain : ∀ p ∈ points, (∃ l ∈ lines, l.1 * p.1 + l.2 = p.2) ∨ (∃ x ∈ verts, p.1 = x))
  (hk : (lines.filter (fun l ↦ l.1 ≠ 0 ∧ l.1 ≠ -1)).card = k)
  (h_not_v1 : 1 ∉ verts)
  (h_not_y1 : ∀ l ∈ lines, ¬(l.1 = 0 ∧ l.2 = 1))
  (h_not_xn1 : ∀ l ∈ lines, ¬(l.1 = -1 ∧ l.2 = n + 1))
  (h2 : ∀ l ∈ lines, (Finset.filter (fun p => (p.1 = 1 ∨ p.2 = 1 ∨ p.1 + p.2 = n + 1) ∧ (l.1 * p.1 + l.2 = p.2)) points).card ≤ 2)
  (h4 : ∀ x ∈ verts, (Finset.filter (fun p : ℕ × ℕ => p.1 ≥ 1 ∧ p.2 ≥ 1 ∧ p.1 + p.2 ≤ n + 1 ∧ ((p.1 = 1 ∨ p.2 = 1 ∨ p.1 + p.2 = n + 1)) ∧ (p.1 = x)) points).card ≤ 2):
  (Finset.filter (fun p => p.1 = 1 ∨ p.2 = 1 ∨ p.1 + p.2 = n + 1) points).card ≤ 2 * n := by
  let a := Finset.biUnion lines (fun l => Finset.filter (fun p => (p.1 = 1 ∨ p.2 = 1 ∨ p.1 + p.2 = n + 1) ∧ (l.1 * p.1 + l.2 = p.2)) points)
  let b := Finset.biUnion verts (fun x => Finset.filter (fun p => p.1 ≥ 1 ∧ p.2 ≥ 1 ∧ p.1 + p.2 ≤ n + 1 ∧ (p.1 = 1 ∨ p.2 = 1 ∨ p.1 + p.2 = n + 1) ∧ p.1 = x) points)
  calc
    (Finset.filter (fun p => p.1 = 1 ∨ p.2 = 1 ∨ p.1 + p.2 = n + 1) points).card
      ≤ (a ∪ b).card := Finset.card_le_card fun p hp => by aesop
    _ ≤ a.card + b.card := Finset.card_union_le _ _
    _ ≤ 2 * lines.card + 2 * verts.card := by
      simpa [mul_comm] using
        Nat.add_le_add
          (Finset.card_biUnion_le.trans (Finset.sum_le_sum h2))
          (Finset.card_biUnion_le.trans (Finset.sum_le_sum h4))
    _ = 2 * (lines.card + verts.card) := by ring
    _ = 2 * n := by linarith

theorem total_boundary_points_covered_by_at_most_2n (n k : ℕ) (verts : Finset ℝ) (lines : Finset (ℝ × ℝ)) (points : Finset (ℕ × ℕ)) (hn : 3 ≤ n) (hcard : lines.card + verts.card = n) (hallpoints : ∀ p, p ∈ points ↔ p.1 ≥ 1 ∧ p.2 ≥ 1 ∧ p.1 + p.2 ≤ n + 1) (hmain : ∀ p ∈ points, (∃ l ∈ lines, l.1 * p.1 + l.2 = p.2) ∨ (∃ x ∈ verts, p.1 = x)) (hk : (lines.filter (fun l ↦ l.1 ≠ 0 ∧ l.1 ≠ -1)).card = k) (h_not_v1 : 1 ∉ verts) (h_not_y1 : ∀ l ∈ lines, ¬(l.1 = 0 ∧ l.2 = 1)) (h_not_xn1 : ∀ l ∈ lines, ¬(l.1 = -1 ∧ l.2 = n + 1)) : (Finset.filter (fun p => p.1 = 1 ∨ p.2 = 1 ∨ p.1 + p.2 = n+1) points).card ≤ 2 * n  := by
  apply total_boundary_points_covered_by_at_most_2n_h_main n k verts lines points hn hcard hallpoints hmain hk h_not_v1 h_not_y1 h_not_xn1
  apply total_boundary_points_covered_by_at_most_2n_h2 n k verts lines points hn hcard hallpoints hmain hk h_not_v1 h_not_y1 h_not_xn1
  aesop
  apply total_boundary_points_covered_by_at_most_2n_h4 n k verts lines points hn hcard hallpoints hmain hk h_not_v1
  aesop

theorem boundary_line_exists_at_any_cover_simplified_h_main (n : ℕ)
  (verts : Finset ℝ)
  (lines : Finset (ℝ × ℝ))
  (points : Finset (ℕ × ℕ))
  (hn : 4 ≤ n)
  (hcard : lines.card + verts.card = n)
  (hallpoints : ∀ p, p ∈ points ↔ p.1 ≥ 1 ∧ p.2 ≥ 1 ∧ p.1 + p.2 ≤ n + 1)
  (hmain : ∀ p ∈ points, (∃ l ∈ lines, l.1 * p.1 + l.2 = p.2) ∨ (∃ x ∈ verts, p.1 = x)):
  (∃ x ∈ verts, x = 1) ∨ (∃ l ∈ lines, (l.1 = 0 ∧ l.2 = 1) ∨ (l.1 = -1 ∧ l.2 = n + 1)) := by
  by_contra h_neg
  have h1 := num_points_on_boundary n points hallpoints
  have h2 := total_boundary_points_covered_by_at_most_2n n (lines.filter (fun l ↦ l.1 ≠ 0 ∧ l.1 ≠ -1)).card verts lines points (by omega) hcard hallpoints hmain rfl (by simp_all) (fun l hl h_not_y1 => h_neg (Or.inr ⟨l, hl, Or.inl h_not_y1⟩)) (fun l hl h_not_xn1 => h_neg (Or.inr ⟨l, hl, Or.inr h_not_xn1⟩))
  have h3 : n ≠ 1 := by omega
  simp_all
  <;> omega

theorem boundary_line_exists_at_any_cover_simplified (n : ℕ) (verts : Finset ℝ) (lines : Finset (ℝ × ℝ)) (points : Finset (ℕ × ℕ))
    (hn : 4 ≤ n)
    (hcard : lines.card + verts.card = n)
    (hallpoints : ∀ p, p ∈ points ↔ p.1 ≥ 1 ∧ p.2 ≥ 1 ∧ p.1 + p.2 ≤ n + 1)
    (hmain : ∀ p ∈ points, (∃ l ∈ lines, l.1 * p.1 + l.2 = p.2) ∨ (∃ x ∈ verts, p.1 = x)):
  (∃ x ∈ verts, x = 1) ∨ (∃ l ∈ lines, (l.1 = 0 ∧ l.2 = 1) ∨ (l.1 = -1 ∧ l.2 = n + 1))  := by
  apply boundary_line_exists_at_any_cover_simplified_h_main
  <;> assumption

theorem round1_main (n k : ℕ) (verts : Finset ℝ) (lines : Finset (ℝ × ℝ)) (points : Finset (ℕ × ℕ)) (hn : 3 ≤ n) (hcard : lines.card + verts.card = n) (hallpoints : ∀ p, p ∈ points ↔ p.1 ≥ 1 ∧ p.2 ≥ 1 ∧ p.1 + p.2 ≤ n + 1) (hmain : ∀ p ∈ points, (∃ l ∈ lines, l.1 * p.1 + l.2 = p.2) ∨ (∃ x ∈ verts, p.1 = x)) (hk : (lines.filter (fun l ↦ l.1 ≠ 0 ∧ l.1 ≠ -1)).card = k) : k = 0 ∨ k = 1 ∨ k = 3 := by
  have h : ∀ n : ℕ, 3 ≤ n → ∀ k : ℕ, ∀ (verts : Finset ℝ) (lines : Finset (ℝ × ℝ)) (points : Finset (ℕ × ℕ)),
    (hcard : lines.card + verts.card = n) →
    (hallpoints : ∀ p, p ∈ points ↔ p.1 ≥ 1 ∧ p.2 ≥ 1 ∧ p.1 + p.2 ≤ n + 1) →
    (hmain : ∀ p ∈ points, (∃ l ∈ lines, l.1 * p.1 + l.2 = p.2) ∨ (∃ x ∈ verts, p.1 = x)) →
    (hk : (lines.filter (fun l ↦ l.1 ≠ 0 ∧ l.1 ≠ -1)).card = k) →
    k = 0 ∨ k = 1 ∨ k = 3 := by
    intro n
    induction n using Nat.strong_induction_on with
    | h n ih =>
      intro hn3 k verts lines points hcard hallpoints hmain hk
      by_cases h1 : n = 3
      · subst h1
        exact imo2025_p1_prop_n_eq_3_k_eq_0_1_3 k lines verts points hcard hallpoints hmain hk
      have h2 : n ≥ 4 := by omega
      have h4 := boundary_line_exists_at_any_cover_simplified n verts lines points h2 hcard hallpoints hmain
      have hcover : ∀ p : ℕ × ℕ, p.1 ≥ 1 ∧ p.2 ≥ 1 ∧ p.1 + p.2 ≤ n + 1 →
        (∃ l ∈ lines, l.1 * (p.1 : ℝ) + l.2 = (p.2 : ℝ)) ∨ (∃ x ∈ verts, (p.1 : ℝ) = x) := by
        intro p hp
        exact hmain p (by aesop)
      have h_ih : ∀ (k' : ℕ) (verts' : Finset ℝ) (lines' : Finset (ℝ × ℝ)),
        (verts'.card + lines'.card = n - 1) →
        (∀ p : ℕ × ℕ, p.1 ≥ 1 ∧ p.2 ≥ 1 ∧ p.1 + p.2 ≤ n →
          (∃ l ∈ lines', l.1 * (p.1 : ℝ) + l.2 = (p.2 : ℝ)) ∨ (∃ x ∈ verts', (p.1 : ℝ) = x)) →
        ((lines'.filter (fun l ↦ l.1 ≠ 0 ∧ l.1 ≠ -1)).card = k') →
        k' = 0 ∨ k' = 1 ∨ k' = 3 := by
        intro k' verts' lines' h13 h14 h15
        set points' : Finset (ℕ × ℕ) := (Finset.Ico 1 (n + 1) ×ˢ Finset.Ico 1 (n + 1)).filter (fun p => p.1 + p.2 ≤ n) with h18
        have h19 : ∀ p : ℕ × ℕ, p ∈ points' ↔ p.1 ≥ 1 ∧ p.2 ≥ 1 ∧ p.1 + p.2 ≤ n := by
          intro p
          simp [h18, Finset.mem_filter, Finset.mem_Ico]
          <;> omega
        have h20 : ∀ p ∈ points', (∃ l ∈ lines', l.1 * p.1 + l.2 = p.2) ∨ (∃ x ∈ verts', p.1 = x) := by
          intro p hp
          have h21 : p.1 ≥ 1 ∧ p.2 ≥ 1 ∧ p.1 + p.2 ≤ n := by
            rw [h19 p] at hp
            tauto
          have h22 := h14 p h21
          simpa using h22
        have h23 : lines'.card + verts'.card = n - 1 := by
          linarith
        have h24 : ∀ p, p ∈ points' ↔ p.1 ≥ 1 ∧ p.2 ≥ 1 ∧ p.1 + p.2 ≤ (n - 1) + 1 := by
          intro p
          have h25 : (n - 1) + 1 = n := by omega
          rw [h25]
          exact h19 p
        have h26 := ih (n - 1) (by omega) (by omega) k' verts' lines' points' h23 h24 h20 h15
        tauto
      rcases h4 with h41 | h42
      · exact inductive_step_if_contains_vertical_line n k verts lines points hcard hallpoints hmain hk (by linarith) hcover h41 h_ih
      rcases h42 with ⟨l, hl_in_lines, h421 | h4212 ⟩
      · have h42111 : ∃ l' ∈ lines, l'.1 = 0 ∧ l'.2 = 1 := ⟨l, hl_in_lines, by tauto⟩
        exact inductive_step_if_contains_horizontal_line n k verts lines points hcard hallpoints hmain hk (by linarith) hcover h42111 h_ih
      · have h42121 : ∃ l' ∈ lines, l'.1 = -1 ∧ l'.2 = (n : ℝ) + 1 := ⟨l, hl_in_lines, by tauto⟩
        exact inductive_step_if_contains_rainy_diagonal_line_refined n k verts lines points (by linarith) hcard hallpoints hmain hk (by linarith) hcover h42121 h_ih
  exact h n hn k verts lines points hcard hallpoints hmain hk

theorem imo2025_p1_left (n k : ℕ) (verts : Finset ℝ) (lines : Finset (ℝ × ℝ)) (points : Finset (ℕ × ℕ)) (hn : 3 ≤ n) (hcard : lines.card + verts.card = n) (hallpoints : ∀ p, p ∈ points ↔ p.1 ≥ 1 ∧ p.2 ≥ 1 ∧ p.1 + p.2 ≤ n + 1) (hmain : ∀ p ∈ points, (∃ l ∈ lines, l.1 * p.1 + l.2 = p.2) ∨ (∃ x ∈ verts, p.1 = x)) (hk : (lines.filter (fun l ↦ l.1 ≠ 0 ∧ l.1 ≠ -1)).card = k) : k = 0 ∨ k = 1 ∨ k = 3 := by
  apply round1_main
  <;> assumption

theorem round3_k3_card (n : ℕ) (hn : 3 ≤ n) :
  (({(-1 / 2, 1 + (n : ℝ) / 2), (1, 3 - (n : ℝ)), (-2, 2 * (n : ℝ) - 1)} : Finset (ℝ × ℝ)).card) = 3 := by
  norm_num

theorem round3_k1_third_cond (n : ℕ) (hn : 3 ≤ n) :
  (Finset.filter (fun l => l.1 ≠ 0 ∧ l.1 ≠ -1) ({(1, 1 - (n : ℝ))} : Finset (ℝ × ℝ))).card = 1 := by
  norm_num [Finset.filter_singleton]

theorem round3_k3_third_cond (n : ℕ) (hn : 3 ≤ n) :
  (Finset.filter (fun l => l.1 ≠ 0 ∧ l.1 ≠ -1) ({(-1 / 2, 1 + (n : ℝ) / 2), (1, 3 - (n : ℝ)), (-2, 2 * (n : ℝ) - 1)} : Finset (ℝ × ℝ))).card = 3 := by
  norm_num [Finset.filter_true_of_mem]

theorem imo2025_p1_right (n k : ℕ) (hn : 3 ≤ n) (hk : k = 0 ∨ k = 1 ∨ k = 3) : ∃ lines : Finset (ℝ × ℝ), ∃ xs : Finset ℝ, lines.card + xs.card = n ∧ (∀ a b : ℕ, a > 0 → b > 0 → a + b ≤ n + 1 → (∃ l ∈ lines, l.1 * a + l.2 = b) ∨ (∃ x ∈ xs, a = x)) ∧ (lines.filter (fun l ↦ l.1 ≠ 0 ∧ l.1 ≠ -1)).card = k := by
  rcases hk with (rfl | rfl | rfl)
  use ∅
  use (Finset.range n).image (fun (i : ℕ) => (i + 1 : ℝ))
  constructor
  simp [Finset.card_image_of_injective, Function.Injective]
  constructor
  intro a b ha_pos hb_pos hab
  exact Or.inr ⟨a, Finset.mem_image.mpr ⟨a - 1, Finset.mem_range.mpr (by omega), by simp [ha_pos]⟩, by simp⟩
  simp
  use {(1, 1 - (n : ℝ))}
  use (Finset.range (n - 1)).image (fun (i : ℕ) => (i + 1 : ℝ))
  constructor
  have h21 : ((Finset.range (n - 1)).image (fun (i : ℕ) => (i + 1 : ℝ))).card = n - 1 := by
    simp [Finset.card_image_of_injective, Function.Injective]
  have h22 : (({(1, 1 - (n : ℝ))} : Finset (ℝ × ℝ)).card) = 1 := by simp
  omega
  constructor
  intro a b ha_pos hb_pos hab
  by_cases h17 : a ≤ n - 1
  · have h171 : a ≤ n - 1 := h17
    have h172 : a ≥ 1 := by linarith
    have h173 : a - 1 < n - 1 := by omega
    have h174 : (a - 1) ∈ Finset.range (n - 1) := Finset.mem_range.mpr h173
    have h175 : ((a - 1 : ℕ) : ℝ) + 1 ∈ (Finset.range (n - 1)).image (fun (i : ℕ) => (i + 1 : ℝ)) := by
      refine Finset.mem_image.mpr ⟨(a - 1), h174, by simp⟩
    have h176 : ((a - 1 : ℕ) : ℝ) + 1 = (a : ℝ) := by simp [Nat.cast_sub (by omega : 0 < a)]
    have h177 : (a : ℝ) ∈ (Finset.range (n - 1)).image (fun (i : ℕ) => (i + 1 : ℝ)) := by
      rw [h176] at h175
      exact h175
    refine Or.inr ⟨(a : ℝ), h177, by simp⟩
  · have h17' : a > n - 1 := by omega
    have h180 : a = n := by omega
    have h181 : b = 1 := by omega
    refine Or.inl ⟨(1, 1 - (n : ℝ)), by simp, ?_⟩
    simp [h180, h181]
  exact round3_k1_third_cond n hn
  use ({(-1 / 2, 1 + (n : ℝ) / 2), (1, 3 - (n : ℝ)), (-2, 2 * (n : ℝ) - 1)} : Finset (ℝ × ℝ))
  use (Finset.range (n - 3)).image (fun (i : ℕ) => (i + 1 : ℝ))
  constructor
  have h21 : ((Finset.range (n - 3)).image (fun (i : ℕ) => (i + 1 : ℝ))).card = n - 3 := by
    simp [Finset.card_image_of_injective, Function.Injective]
  have h22 : (({(-1 / 2, 1 + (n : ℝ) / 2), (1, 3 - (n : ℝ)), (-2, 2 * (n : ℝ) - 1)} : Finset (ℝ × ℝ)).card) = 3 := by
    norm_num
  omega
  constructor
  intro a b ha_pos hb_pos hab
  by_cases h17 : a ≤ n - 3
  · have h171 : a ≤ n - 3 := h17
    have h172 : a ≥ 1 := by linarith
    have h173 : a - 1 < n - 3 := by omega
    have h174 : (a - 1) ∈ Finset.range (n - 3) := Finset.mem_range.mpr h173
    have h175 : ((a - 1 : ℕ) : ℝ) + 1 ∈ (Finset.range (n - 3)).image (fun (i : ℕ) => (i + 1 : ℝ)) := by
      refine Finset.mem_image.mpr ⟨(a - 1), h174, by simp⟩
    have h176 : ((a - 1 : ℕ) : ℝ) + 1 = (a : ℝ) := by simp [Nat.cast_sub (by omega : 0 < a)]
    have h177 : (a : ℝ) ∈ (Finset.range (n - 3)).image (fun (i : ℕ) => (i + 1 : ℝ)) := by
      rw [h176] at h175
      exact h175
    refine Or.inr ⟨(a : ℝ), h177, by simp⟩
  · have h17' : a > n - 3 := by omega
    have h178 : a ≥ n - 2 := by omega
    have h179 : a ≤ n := by omega
    have h180 : a = n - 2 ∨ a = n - 1 ∨ a = n := by omega
    rcases h180 with (h180 | h180 | h180)
    · have h1801 : a = n - 2 := h180
      have h181 : b ≤ 3 := by omega
      have h182 : b ≥ 1 := by linarith
      have h183 : b = 1 ∨ b = 2 ∨ b = 3 := by omega
      rcases h183 with (h183 | h183 | h183)
      · refine Or.inl ⟨(1, 3 - (n : ℝ)), by simp, ?_⟩
        simp [h1801, h183]
        <;> ring_nf <;> simp [Nat.cast_sub (show 2 ≤ n by omega)] <;> ring_nf
      · refine Or.inl ⟨(-1 / 2, 1 + (n : ℝ) / 2), by simp, ?_⟩
        simp [h1801, h183]
        <;> ring_nf <;> norm_num <;> simp [Nat.cast_sub (show 2 ≤ n by omega)] <;> ring_nf
      · refine Or.inl ⟨(-2, 2 * (n : ℝ) - 1), by simp, ?_⟩
        simp [h1801, h183]
        <;> ring_nf <;> simp [Nat.cast_sub (show 2 ≤ n by omega)] <;> ring_nf
    · have h1802 : a = n - 1 := h180
      have h181 : b ≤ 2 := by omega
      have h182 : b ≥ 1 := by linarith
      have h183 : b = 1 ∨ b = 2 := by omega
      rcases h183 with (h183 | h183)
      · refine Or.inl ⟨(-2, 2 * (n : ℝ) - 1), by simp, ?_⟩
        simp [h1802, h183]
        <;> ring_nf <;> simp [Nat.cast_sub (show 1 ≤ n by omega)] <;> ring_nf
      · refine Or.inl ⟨(1, 3 - (n : ℝ)), by simp, ?_⟩
        simp [h1802, h183]
        <;> ring_nf <;> simp [Nat.cast_sub (show 1 ≤ n by omega)] <;> ring_nf
    · have h1803 : a = n := h180
      have h181 : b ≤ 1 := by omega
      have h182 : b ≥ 1 := by linarith
      have h183 : b = 1 := by omega
      refine Or.inl ⟨(-1 / 2, 1 + (n : ℝ) / 2), by simp, ?_⟩
      simp [h1803, h183]
      <;> ring_nf
  simp
  exact round3_k3_third_cond n hn