import Mathlib
import Aesop
set_option pp.numericTypes true
set_option pp.funBinderTypes true
set_option maxHeartbeats 0
set_option maxRecDepth 1000
set_option tactic.hygienic false
open BigOperators Real Nat Topology Rat Classical Polynomial

theorem round1_h1 (n : ℤ)
  (k : ℕ)
  (hn : n > 0)
  (h_k_le_2_plus_padic : k ≤ 2 + padicValNat 2 n.toNat):
  (2 : ℤ) ^ k ≤ (2 : ℤ) ^ (2 + padicValNat 2 n.toNat) := by
  gcongr
  linarith

theorem round1_h2 (n : ℤ)
  (k : ℕ)
  (hn : n > 0):
  (2 : ℤ) ^ (2 + padicValNat 2 n.toNat) = 4 * (2 : ℤ) ^ (padicValNat 2 n.toNat) := by
  ring_nf

theorem round1_h3 (n : ℤ)
  (k : ℕ)
  (hn : n > 0)
  (h1 : (2 : ℤ) ^ k ≤ (2 : ℤ) ^ (2 + padicValNat 2 n.toNat))
  (h2 : (2 : ℤ) ^ (2 + padicValNat 2 n.toNat) = 4 * (2 : ℤ) ^ (padicValNat 2 n.toNat)):
  (2 : ℤ) ^ k ≤ 4 * (2 : ℤ) ^ (padicValNat 2 n.toNat) := by
  linarith

theorem round1_h4 (n : ℤ)
  (k : ℕ)
  (hn : n > 0):
  (2 : ℤ) ^ (padicValNat 2 n.toNat) ∣ n := by
  have h4₁ : (2 : ℕ) ^ (padicValNat 2 n.toNat) ∣ n.toNat := by
    apply pow_padicValNat_dvd
  have h4₂ : (2 : ℤ) ^ (padicValNat 2 n.toNat) ∣ (n.toNat : ℤ) := by
    exact_mod_cast h4₁
  have h4₃ : (n.toNat : ℤ) = n := by
    simp [hn]
    <;> omega
  rw [h4₃] at h4₂
  exact h4₂

theorem round1_h5 (n : ℤ)
  (k : ℕ)
  (hn : n > 0)
  (h4 : (2 : ℤ) ^ (padicValNat 2 n.toNat) ∣ n):
  (2 : ℤ) ^ (padicValNat 2 n.toNat) ≤ n := by
  apply Int.le_of_dvd hn h4

theorem round1_h6 (n : ℤ)
  (k : ℕ)
  (hn : n > 0)
  (h5 : (2 : ℤ) ^ (padicValNat 2 n.toNat) ≤ n):
  4 * (2 : ℤ) ^ (padicValNat 2 n.toNat) ≤ 4 * n := by
  linarith

theorem round1_h7 (n : ℤ)
  (k : ℕ)
  (hn : n > 0)
  (h3 : (2 : ℤ) ^ k ≤ 4 * (2 : ℤ) ^ (padicValNat 2 n.toNat))
  (h6 : 4 * (2 : ℤ) ^ (padicValNat 2 n.toNat) ≤ 4 * n):
  (2 : ℤ) ^ k ≤ 4 * n := by
  linarith

theorem round1_h_main (n : ℤ)
  (f : ℤ → ℤ)
  (k : ℕ)
  (hn : n > 0)
  (hk : f n = (2 : ℤ) ^ k)
  (h7 : (2 : ℤ) ^ k ≤ 4 * n):
  f n ≤ 4 * n := by
  simp_all

theorem round1_h6' (n : ℤ) (f : ℤ → ℤ) (hn : n > 0) (hpos : ∀ k : ℤ, k > 0 → f k > 0) (hf : ∀ a b : ℤ, a > 0 → b > 0 → f a ∣ b ^ a.toNat - (f b) ^ (f a).toNat) (k : ℕ) (hk : f n = (2 : ℤ) ^ k) (h_k_le_2_plus_padic : k ≤ 2 + padicValNat 2 n.toNat) : f n ≤ 4 * n := by
  rw [hk]
  apply round1_h7 n k hn
  apply round1_h3 n k hn
  apply round1_h1 n k hn h_k_le_2_plus_padic
  apply round1_h2 n k hn
  apply round1_h6 n k hn
  apply round1_h5 n k hn
  apply round1_h4 n k hn

theorem lte_2_3n_minus_1_h1 :
  ∀ k : ℕ, k > 0 → k % 2 = 1 → 3 ^ k % 4 = 3 := by
  intros
  rw [← Nat.mod_add_div k 2]
  simp_all [pow_add, pow_mul, Nat.mul_mod, Nat.pow_mod]

theorem lte_2_3n_minus_1_h4 :
  ∀ k : ℕ, k > 0 → k % 2 = 0 → 3 ^ k % 4 = 1 := by
  intros
  rw [← Nat.mod_add_div k 2]
  simp_all [Nat.pow_mod, Nat.pow_mul]

theorem lte_2_3n_minus_1_h3_pow_mod_8 :
  ∀ m : ℕ, m > 0 → m % 2 = 1 → 3 ^ m % 8 = 3 := by
  intros
  rw [← Nat.mod_add_div m 2]
  simp_all [pow_add, pow_mul, Nat.mul_mod, Nat.pow_mod]

theorem lte_2_3n_minus_1_h_padicValNat_mul (p : ℕ) [Fact p.Prime] (a b : ℕ) (ha : a ≠ 0) (hb : b ≠ 0) :
  padicValNat p (a * b) = padicValNat p a + padicValNat p b := by
  apply padicValNat.mul
  assumption'

theorem lte_2_3n_minus_1_general_lemma_A (x : ℕ) (h1 : 2 ∣ x) (h2 : ¬ 4 ∣ x) : padicValNat 2 x = 1 := by
  cases' h1 with y
  cases y
  all_goals simp_all [padicValNat.mul]
  all_goals omega

theorem lte_2_3n_minus_1_general_lemma_B (x : ℕ) (h1 : 4 ∣ x) (h2 : ¬ 8 ∣ x) : padicValNat 2 x = 2 := by
  rw [show x = 2 * 2 * (x / 4) by omega]
  repeat' rw [padicValNat.mul]
  all_goals norm_num
  all_goals omega

theorem lte_2_3n_minus_1_lemma1 (k : ℕ) (hk_pos : k > 0) (hk_odd : k % 2 = 1) : padicValNat 2 (3 ^ k - 1) = 1 := by
  apply lte_2_3n_minus_1_general_lemma_A
  all_goals
    rw [← Nat.mod_add_div (3 ^ k) 4]
    simp_all [lte_2_3n_minus_1_h1]
    omega

theorem lte_2_3n_minus_1_lemma2 (k : ℕ) (hk_pos : k > 0) (hk_even : k % 2 = 0) : padicValNat 2 (3 ^ k - 1) = 2 + padicValNat 2 k := by
  obtain ⟨m, rfl⟩ := Nat.dvd_iff_mod_eq_zero.mpr hk_even
  have hm_pos : m > 0 := by omega
  by_cases h3 : m % 2 = 1
  · have h4 : 3 ^ m % 8 = 3 := by
      apply lte_2_3n_minus_1_h3_pow_mod_8
      omega
      exact h3
    have h5 : 2 ∣ (3 ^ m - 1) := by omega
    have h6 : ¬ 4 ∣ (3 ^ m - 1) := by
      intro h71
      have h72 : (3 ^ m - 1) % 4 = 0 := by omega
      have h31 : m > 0 := hm_pos
      have h32 : 3 ^ m ≥ 3 ^ 1 := by
        exact Nat.pow_le_pow_of_le_right (by norm_num) (by omega)
      omega
    have h7 : padicValNat 2 (3 ^ m - 1) = 1 := by
      apply lte_2_3n_minus_1_general_lemma_A
      exact h5
      exact h6
    have h8 : 4 ∣ (3 ^ m + 1) := by omega
    have h9 : ¬ 8 ∣ (3 ^ m + 1) := by omega
    have h10 : padicValNat 2 (3 ^ m + 1) = 2 := by
      apply lte_2_3n_minus_1_general_lemma_B
      exact h8
      exact h9
    have h11 : 3 ^ (2 * m) - 1 = (3 ^ m - 1) * (3 ^ m + 1) := by
      have h111 : 3 ^ m ≥ 1 := by omega
      have h112 : 3 ^ (2 * m) = (3 ^ m) ^ 2 := by ring
      rw [h112]
      have h113 : (3 ^ m) ^ 2 = (3 ^ m) * (3 ^ m) := by ring
      rw [h113]
      cases' le_iff_exists_add.mp (by omega : 1 ≤ 3 ^ m) with x hx
      simp [hx, Nat.mul_add, Nat.add_mul, Nat.add_assoc] <;> ring_nf at * 
    have h12 : padicValNat 2 ((3 ^ m - 1) * (3 ^ m + 1)) = padicValNat 2 (3 ^ m - 1) + padicValNat 2 (3 ^ m + 1) := by
      apply lte_2_3n_minus_1_h_padicValNat_mul
      omega
      omega
    have h13 : padicValNat 2 (3 ^ (2 * m) - 1) = padicValNat 2 (3 ^ m - 1) + padicValNat 2 (3 ^ m + 1) := by
      rw [h11] at *
      exact h12
    have h14 : padicValNat 2 (3 ^ (2 * m) - 1) = 1 + 2 := by linarith
    have h15 : padicValNat 2 (3 ^ (2 * m) - 1) = 3 := by linarith
    have h16 : 2 ∣ (2 * m) := by omega
    have h17 : ¬ 4 ∣ (2 * m) := by omega
    have h18 : padicValNat 2 (2 * m) = 1 := by
      apply lte_2_3n_minus_1_general_lemma_A
      exact h16
      exact h17
    linarith
  · have h4 : ∃ t, m = 2 * t := by
      refine ⟨m / 2, ?_⟩
      omega
    rcases h4 with ⟨t, h4t⟩
    have ht_pos : t > 0 := by omega
    have hm_even : m % 2 = 0 := by omega
    have h5 : m < 2 * m := by nlinarith
    have ih_m : padicValNat 2 (3 ^ m - 1) = 2 + padicValNat 2 m := by
      exact lte_2_3n_minus_1_lemma2 m (by omega) (by omega)
    have h6 : 3 ^ m % 4 = 1 := by
      apply lte_2_3n_minus_1_h4
      exact hm_pos
      exact hm_even
    have h7 : 2 ∣ (3 ^ m + 1) := by omega
    have h8 : ¬ 4 ∣ (3 ^ m + 1) := by omega
    have h9 : padicValNat 2 (3 ^ m + 1) = 1 := by
      apply lte_2_3n_minus_1_general_lemma_A
      exact h7
      exact h8
    have h10 : 3 ^ m - 1 > 0 := by
      have h101 : m > 0 := by omega
      have h102 : 3 ^ m ≥ 3 ^ 1 := by
        exact Nat.pow_le_pow_of_le_right (by norm_num) (by omega)
      omega
    have h11 : 3 ^ m + 1 > 0 := by positivity
    have h12 : 3 ^ (2 * m) - 1 = (3 ^ m - 1) * (3 ^ m + 1) := by
      have h121 : 3 ^ m ≥ 1 := by omega
      have h122 : 3 ^ (2 * m) = (3 ^ m) ^ 2 := by ring
      rw [h122]
      have h123 : (3 ^ m) ^ 2 = (3 ^ m) * (3 ^ m) := by ring
      rw [h123]
      cases' le_iff_exists_add.mp (by omega : 1 ≤ 3 ^ m) with x hx
      simp [hx, Nat.mul_add, Nat.add_mul, Nat.add_assoc] <;> ring_nf at * 
    have h13 : padicValNat 2 ((3 ^ m - 1) * (3 ^ m + 1)) = padicValNat 2 (3 ^ m - 1) + padicValNat 2 (3 ^ m + 1) := by
      apply lte_2_3n_minus_1_h_padicValNat_mul
      omega
      omega
    have h14 : padicValNat 2 (3 ^ (2 * m) - 1) = padicValNat 2 (3 ^ m - 1) + padicValNat 2 (3 ^ m + 1) := by
      rw [h12] at *
      exact h13
    have h15 : padicValNat 2 (3 ^ (2 * m) - 1) = (2 + padicValNat 2 m) + 1 := by linarith
    have h16 : padicValNat 2 (3 ^ (2 * m) - 1) = 3 + padicValNat 2 m := by linarith
    have h17 : m = 2 * t := by
      rw [h4t]
    have ht_pos' : t > 0 := by omega
    have h18 : padicValNat 2 m = padicValNat 2 (2 * t) := by
      rw [h17]
    have h19 : padicValNat 2 (2 * t) = 1 + padicValNat 2 t := by
      have h191 : padicValNat 2 2 = 1 := by norm_num
      have h192 : t > 0 := by linarith
      have h193 : padicValNat 2 (2 * t) = padicValNat 2 2 + padicValNat 2 t := by
        have h194 : (2 : ℕ) ≠ 0 := by norm_num
        have h195 : t ≠ 0 := by linarith
        exact lte_2_3n_minus_1_h_padicValNat_mul 2 2 t h194 h195
      rw [h193, h191]
    have h20 : padicValNat 2 m = 1 + padicValNat 2 t := by
      linarith
    have h21 : padicValNat 2 (3 ^ (2 * m) - 1) = 4 + padicValNat 2 t := by
      linarith
    have h22 : padicValNat 2 (2 * m) = 2 + padicValNat 2 t := by
      have h221 : padicValNat 2 (2 * m) = padicValNat 2 (2 * (2 * t)) := by
        rw [h17]
      have h222 : padicValNat 2 (2 * (2 * t)) = padicValNat 2 2 + padicValNat 2 (2 * t) := by
        have h223 : (2 : ℕ) ≠ 0 := by norm_num
        have h224 : 2 * t ≠ 0 := by linarith
        exact lte_2_3n_minus_1_h_padicValNat_mul 2 2 (2 * t) h223 h224
      have h223 : padicValNat 2 2 = 1 := by norm_num
      linarith
    linarith

theorem lte_2_3n_minus_1 (n : ℤ) (hn : n > 0) : padicValNat 2 (3 ^ n.toNat - 1) = if n % 2 = 1 then 1 else 2 + padicValNat 2 n.toNat := by
  split_ifs
  apply lte_2_3n_minus_1_lemma1
  <;> omega
  apply lte_2_3n_minus_1_lemma2
  <;> omega

theorem round1_h_n_toNat_ge_one (n : ℤ)
  (hn : n > 0):
  n.toNat ≥ 1 := by
  omega

theorem round1_h_pow_div (n : ℤ)
  (k : ℕ)
  (hn : n > 0)
  (h_2_pow_k_divides : (2 : ℤ) ^ k ∣ 3 ^ n.toNat - 1)
  (h_n_toNat_ge_one : n.toNat ≥ 1):
  2 ^ k ∣ 3 ^ n.toNat - 1 := by
  apply Int.coe_nat_dvd.mp
  simp_all

theorem round1_h_main'' (n : ℤ)
  (k : ℕ)
  (hn : n > 0)
  (h_n_toNat_ge_one : n.toNat ≥ 1)
  (h_pow_div : 2 ^ k ∣ 3 ^ n.toNat - 1):
  k ≤ padicValNat 2 (3 ^ n.toNat - 1) := by
  simp_all [Nat.sub_eq_zero_iff_le, padicValNat_dvd_iff_le]

theorem round1_h_k_le_padic (n : ℤ)
  (f : ℤ → ℤ)
  (k : ℕ)
  (hn : n > 0)
  (hpos : ∀ k : ℤ, k > 0 → f k > 0)
  (hf : ∀ a b : ℤ, a > 0 → b > 0 → f a ∣ b ^ a.toNat - (f b) ^ (f a).toNat)
  (h_2_pow_k_divides : (2 : ℤ) ^ k ∣ 3 ^ n.toNat - 1):
  k ≤ padicValNat 2 (3 ^ n.toNat - 1) := by
  apply round1_h_main''
  assumption
  omega
  apply round1_h_pow_div
  all_goals
    omega

theorem round1_main (f : ℤ → ℤ) (hpos : ∀ k : ℤ, k > 0 → f k > 0) (hf : ∀ a b : ℤ, a > 0 → b > 0 → f a ∣ b ^ a.toNat - (f b) ^ (f a).toNat) : f 1 = 1 := by
  have h1 := hpos 1 (by norm_num)
  have h3 : f 1 ∣ 1 := by
    have : f 1 ∣ 1 ^ 1 - (f 1) ^ (f 1).toNat + (f 1) ^ (f 1).toNat := by
      apply Int.dvd_add
      · apply hf 1 1
        all_goals norm_num
      · apply dvd_pow
        · exact dvd_refl (f 1)
        · omega
    simp_all
  exact Int.eq_one_of_dvd_one (by linarith) h3

theorem imo2025_p3_subproblem_f1_is_1_or_f_is_const_1 (f : ℤ → ℤ) (hpos : ∀ k : ℤ, k > 0 → f k > 0) (hf : ∀ a b : ℤ, a > 0 → b > 0 → f a ∣ b ^ a.toNat - (f b) ^ (f a).toNat) : (∀ k : ℤ, k > 0 → f k = 1) ∨ f 1 = 1:= by
  simp_all [round1_main]

theorem round1_h_subcase1 (n : ℤ)
  (f : ℤ → ℤ)
  (hn : n > 0)
  (hpos : ∀ k : ℤ, k > 0 → f k > 0)
  (hf : ∀ a b : ℤ, a > 0 → b > 0 → f a ∣ b ^ a.toNat - (f b) ^ (f a).toNat)
  (h_subcase1 : ∀ k : ℤ, k > 0 → f k = k):
  f n ≤ 4 * n := by
  simp_all

theorem f_is_not_identity_implies_f_p_eq_1_for_p_gt_2_int_toNat_mul (a b : ℤ) (ha : 0 ≤ a) (hb : 0 ≤ b) : (a * b).toNat = a.toNat * b.toNat := by
  apply Int.ofNat.inj
  simp_all [Int.toNat_of_nonneg, mul_nonneg]

theorem f_is_not_identity_implies_f_p_eq_1_for_p_gt_2_h64 (p : ℤ) (hp_nonneg : 0 ≤ p) (k : ℕ) : (p : ℤ) ^ k = ↑((p.toNat) ^ k) := by
  simp_all

theorem f_is_not_identity_implies_f_p_eq_1_for_p_gt_2_p_divides_f_p_stronger (n : ℤ) (f : ℤ → ℤ) (hn : n > 0) (hpos : ∀ k : ℤ, k > 0 → f k > 0) (hf : ∀ a b : ℤ, a > 0 → b > 0 → f a ∣ b ^ a.toNat - (f b) ^ (f a).toNat) (p : ℤ) (hp : Nat.Prime p.toNat) (hfp_ne_1 : f p ≠ 1) (hp_pos : p > 0):
  ∃ j : ℕ, j ≥ 1 ∧ f p = p ^ j := by
  specialize hpos p hp_pos
  specialize hf p p hp_pos hp_pos
  have h323 : f p ∣ (p ^ p.toNat - (f p) ^ (f p).toNat) + (f p) ^ (f p).toNat := by
    apply Int.dvd_add
    exact hf
    exact dvd_pow_self (f p) (by aesop)
  simp at h323
  obtain ⟨c, hc⟩ := h323
  have h322 : p ^ p.toNat > 0 := by positivity
  have hc_pos : c > 0 := by nlinarith
  have h3251 : (p ^ p.toNat : ℤ).toNat = (f p : ℤ).toNat * (c : ℤ).toNat := by
    rw [hc]
    exact f_is_not_identity_implies_f_p_eq_1_for_p_gt_2_int_toNat_mul (f p) c (by linarith) (by linarith)
  have h326 : (f p : ℤ).toNat ∣ (p ^ p.toNat : ℤ).toNat := by
    use (c : ℤ).toNat
  have h324 : ∀ (k : ℕ), (p ^ k : ℤ).toNat = (p.toNat) ^ k := by
    intro k
    induction' k with k ih
    simp
    have h2 : p ^ k ≥ 0 := by positivity
    have h3 : (p ^ (k + 1) : ℤ) = p * (p ^ k) := by ring
    have h4 : (p ^ (k + 1) : ℤ) ≥ 0 := by positivity
    have h5 : ((p ^ (k + 1) : ℤ).toNat) = (p : ℤ).toNat * ((p ^ k : ℤ).toNat) := by
      rw [h3]
      exact f_is_not_identity_implies_f_p_eq_1_for_p_gt_2_int_toNat_mul p (p ^ k) (by linarith) (by linarith)
    rw [h5]
    rw [ih]
    simp [pow_succ]
    <;> ring_nf
  have h3241 : (p ^ p.toNat : ℤ).toNat = (p.toNat) ^ p.toNat := by
    specialize h324 (p.toNat)
    simp_all
  have h323 : (f p : ℤ).toNat ∣ (p.toNat) ^ p.toNat := by
    rw [h3241] at h326
    exact h326
  have h325 : ∃ j : ℕ, j ≤ p.toNat ∧ (f p : ℤ).toNat = (p.toNat) ^ j := by
    exact (Nat.dvd_prime_pow hp).mp h323
  rcases h325 with ⟨j, hj1, hj2⟩
  have h326 : j ≥ 1 := by
    by_contra h3261
    have h3262 : j = 0 := by omega
    rw [h3262] at hj2
    have h3263 : (f p : ℤ).toNat = 1 := by simpa using hj2
    have h3264 : f p = 1 := by
      have h1 : 0 ≤ f p := by linarith
      omega
    contradiction
  refine ⟨j, h326, ?_⟩
  have h3271 : (f p : ℤ).toNat = (p.toNat) ^ j := hj2
  have h2 : 0 ≤ f p := by linarith
  have h64 : ∀ (k : ℕ), (p : ℤ) ^ k = ↑((p.toNat) ^ k) := by
    intro k
    exact f_is_not_identity_implies_f_p_eq_1_for_p_gt_2_h64 p (by linarith) k
  have h3272 : f p = (p : ℤ) ^ j := by
    have h1 : (f p : ℤ).toNat = (p.toNat) ^ j := h3271
    have h22 : (f p) = ↑((f p : ℤ).toNat) := by simp [h2]
    have h23 : ((p : ℤ) ^ j) = ↑((p.toNat) ^ j) := by simpa using h64 j
    have h24 : ↑((f p : ℤ).toNat) = ↑((p.toNat) ^ j) := by rw [h1]
    rw [h22, h24, h23]
  simp_all

theorem fermat_little_theorem_int_version (q : ℕ) (hq : Nat.Prime q) (x : ℤ) : (q : ℤ) ∣ x ^ q - x := by
  haveI := Fact.mk hq
  simp [← ZMod.intCast_zmod_eq_zero_iff_dvd]

theorem f_is_not_identity_implies_f_p_eq_1_for_p_gt_2_main_proof (n : ℤ) (f : ℤ → ℤ) (hn : n > 0) (hpos : ∀ k : ℤ, k > 0 → f k > 0) (hf : ∀ a b : ℤ, a > 0 → b > 0 → f a ∣ b ^ a.toNat - (f b) ^ (f a).toNat) (p : ℤ) (hp : Nat.Prime p.toNat) (hfp_ne_1 : f p ≠ 1) (hp_pos : p > 0) (h_f1_eq_1 : f 1 = 1) (h_p_divides_f_p_stronger : ∃ j : ℕ, j ≥ 1 ∧ f p = p ^ j):
  ∀ b : ℤ, b > 0 → b ≡ f b [ZMOD p] := by
  have h13 : f p > 0 := hpos p (by linarith)
  have h_prime_p : Prime p := by
    have h1 : Nat.Prime p.toNat := hp
    have h2 : Prime (p.toNat : ℤ) := by exact prime_iff_prime_int.mp hp
    have h3 : (p.toNat : ℤ) = p := by
      simp [show 0 ≤ p by linarith]
    have h4 : Prime p := by
      rw [h3] at h2
      exact h2
    exact h4
  rcases h_p_divides_f_p_stronger with ⟨j, hj_ge1, hj_eq⟩
  intro b hb
  have h19 : f p ∣ b ^ p.toNat - (f b) ^ (f p).toNat := by
    specialize hf p b (by linarith) (by linarith)
    simpa using hf
  have h21 : p ∣ f p := by
    have h1 : f p = p ^ j := hj_eq
    have h_j_ge_1 : j ≥ 1 := hj_ge1
    have h_j_pos : 0 < j := by linarith
    have h : ∃ k : ℕ, j = k + 1 := by
      refine ⟨j - 1,?_⟩
      omega
    rcases h with ⟨k, hk⟩
    have h2 : f p = p ^ (k + 1) := by
      rw [h1, hk]
    have h3 : p ∣ p ^ (k + 1) := by
      use p ^ k
      <;> ring
    rw [h2] at *
    exact h3
  have hX : p ∣ b ^ p.toNat - (f b) ^ (f p).toNat := dvd_trans h21 h19
  have h20 : p ∣ b ^ p.toNat - b := by
    have h201 : (p.toNat : ℤ) ∣ b ^ p.toNat - b := by
      exact fermat_little_theorem_int_version p.toNat hp b
    have h202 : (p.toNat : ℤ) = p := by
      simp [show 0 ≤ p by linarith]
    rw [h202] at h201
    exact h201
  have h222 : p ∣ (f b) ^ p.toNat - f b := by
    have h2221 : (p.toNat : ℤ) ∣ (f b) ^ p.toNat - f b := by
      exact fermat_little_theorem_int_version p.toNat hp (f b)
    have h2222 : (p.toNat : ℤ) = p := by
      simp [show 0 ≤ p by linarith]
    rw [h2222] at h2221
    exact h2221
  have hY : p ∣ b - b ^ p.toNat := by
    have h20' : p ∣ b ^ p.toNat - b := h20
    have h201 : p ∣ -(b ^ p.toNat - b) := dvd_neg.mpr h20'
    have h202 : -(b ^ p.toNat - b) = b - b ^ p.toNat := by ring
    rw [h202] at h201
    exact h201
  have h231 : p ∣ (b - b ^ p.toNat) + (b ^ p.toNat - (f b) ^ (f p).toNat) := by
    apply Int.dvd_add
    · exact hY
    · exact hX
  have h232 : (b - b ^ p.toNat) + (b ^ p.toNat - (f b) ^ (f p).toNat) = b - (f b) ^ (f p).toNat := by ring
  have h23 : p ∣ b - (f b) ^ (f p).toNat := by
    rw [h232] at h231
    exact h231
  have h23' : b ≡ (f b) ^ (f p).toNat [ZMOD p] := by
    simpa [Int.ModEq, Int.emod_eq_emod_iff_emod_sub_eq_zero] using h23
  have h_induction : ∀ (k : ℕ), k ≥ 1 → (f b) ^ ((p.toNat) ^ k) ≡ f b [ZMOD p] := by
    intro k hk
    induction k with
    | zero =>
      exfalso
      <;> omega
    | succ k ih =>
      by_cases h : k = 0
      ·
        subst h
        have h22_flt : (f b) ^ p.toNat ≡ f b [ZMOD p] := by
          have h2221 : p ∣ (f b) ^ p.toNat - f b := h222
          simpa [Int.ModEq, Int.emod_eq_emod_iff_emod_sub_eq_zero] using h2221
        simpa using h22_flt
      ·
        have h_k_ge1 : k ≥ 1 := by omega
        have ih' : (f b) ^ ((p.toNat) ^ k) ≡ f b [ZMOD p] := ih (by omega)
        have h22_flt : (f b) ^ p.toNat ≡ f b [ZMOD p] := by
          have h2221 : p ∣ (f b) ^ p.toNat - f b := h222
          simpa [Int.ModEq, Int.emod_eq_emod_iff_emod_sub_eq_zero] using h2221
        have h1 : ((f b) ^ ((p.toNat) ^ k)) ^ p.toNat ≡ (f b) ^ p.toNat [ZMOD p] := by
          exact Int.ModEq.pow p.toNat ih'
        have h2 : ((f b) ^ ((p.toNat) ^ k)) ^ p.toNat ≡ f b [ZMOD p] := by
          exact Int.ModEq.trans h1 h22_flt
        have h3 : (f b) ^ ((p.toNat) ^ (k + 1)) = ((f b) ^ ((p.toNat) ^ k)) ^ p.toNat := by
          have h31 : (p.toNat) ^ (k + 1) = (p.toNat) * (p.toNat) ^ k := by ring
          rw [h31]
          rw [show (f b) ^ ((p.toNat) * (p.toNat) ^ k) = ((f b) ^ ((p.toNat) ^ k)) ^ (p.toNat) by
            rw [← pow_mul]
            <;> ring]
        have h4 : (f b) ^ ((p.toNat) ^ (k + 1)) ≡ f b [ZMOD p] := by
          rw [h3]
          exact h2
        simpa using h4
  have h5 : (f p).toNat = (p.toNat) ^ j := by
    have h324 : ∀ (k : ℕ), (p ^ k : ℤ).toNat = (p.toNat) ^ k := by
      intro k
      have h1 : p ≥ 0 := by linarith
      induction k with
      | zero =>
        simp
      | succ k ih =>
        have h2 : p ^ k ≥ 0 := by positivity
        have h3 : (p ^ (k + 1) : ℤ) = p * (p ^ k) := by ring
        have h4 : (p ^ (k + 1) : ℤ) ≥ 0 := by positivity
        have h5 : ((p ^ (k + 1) : ℤ).toNat) = (p : ℤ).toNat * ((p ^ k : ℤ).toNat) := by
          rw [h3]
          exact f_is_not_identity_implies_f_p_eq_1_for_p_gt_2_int_toNat_mul p (p ^ k) (by linarith) (by linarith)
        rw [h5]
        rw [ih]
        simp [pow_succ]
        <;> ring_nf 
    have h51 : f p = p ^ j := hj_eq
    have h512 : 0 ≤ f p := by linarith
    have h513 : (f p).toNat = ((p ^ j : ℤ)).toNat := by rw [h51]
    rw [h513]
    have h514 := h324 j
    simpa using h514
  have h24 : (f b) ^ ((p.toNat) ^ j) ≡ f b [ZMOD p] := h_induction j (by linarith)
  have h24' : (f b) ^ (f p).toNat ≡ f b [ZMOD p] := by
    have h6 : (f b) ^ ((p.toNat) ^ j) ≡ f b [ZMOD p] := h24
    have h7 : (f p).toNat = (p.toNat) ^ j := h5
    have h8 : (f b) ^ ((p.toNat) ^ j) = (f b) ^ (f p).toNat := by
      rw [h7]
    rw [h8] at h6
    exact h6
  have h_final : b ≡ f b [ZMOD p] := Int.ModEq.trans h23' h24'
  simpa using h_final

theorem f_b_equiv_b_mod_p_of_f_p_ne_1 (n : ℤ) (f : ℤ → ℤ) (hn : n > 0) (hpos : ∀ k : ℤ, k > 0 → f k > 0) (hf : ∀ a b : ℤ, a > 0 → b > 0 → f a ∣ b ^ a.toNat - (f b) ^ (f a).toNat) (p : ℤ) (hp : Nat.Prime p.toNat) (hfp_ne_1 : f p ≠ 1):
  ∀ b : ℤ, b > 0 → b ≡ f b [ZMOD p] := by
  have hp_pos : p > 0 := by
    by_contra h
    have h1 : p ≤ 0 := by linarith
    have h2 : p.toNat = 0 := by omega
    rw [h2] at hp
    norm_num at hp
  have h_f1_eq_1 : f 1 = 1 := by
    have h1 := hpos 1
    have h2 := hf 1 1
    simp at h2
    have h3 : f 1 ∣ 1 := by
      have h32 := hf 1 1
      have h31 := h32
      have h33 : f 1 ∣ (f 1) ^ (f 1).toNat + (1 ^ (1 : ℤ).toNat - (f 1) ^ (f 1).toNat) := by
        apply Int.dvd_add
        · apply dvd_pow_self
          omega
        · simp_all
      have h34 : (f 1) ^ (f 1).toNat + (1 ^ (1 : ℤ).toNat - (f 1) ^ (f 1).toNat) = 1 := by ring
      rw [h34] at h33
      exact h33
    have h35 : f 1 ≤ 1 := Int.le_of_dvd (by norm_num) h3
    omega
  exact f_is_not_identity_implies_f_p_eq_1_for_p_gt_2_main_proof n f hn hpos hf p hp hfp_ne_1 hp_pos h_f1_eq_1 (f_is_not_identity_implies_f_p_eq_1_for_p_gt_2_p_divides_f_p_stronger n f hn hpos hf p hp hfp_ne_1 hp_pos)

theorem f_is_not_identity_implies_f_p_eq_1_for_p_gt_2_case2 (f : ℤ → ℤ) (hpos : ∀ k : ℤ, k > 0 → f k > 0) (hf : ∀ a b : ℤ, a > 0 → b > 0 → f a ∣ b ^ a.toNat - (f b) ^ (f a).toNat) (k : ℤ) (hk_pos : k > 0) (hf_not_id : ∃ i > 0, f i ≠ i) : ∃ p, Nat.Prime p.toNat ∧ p > k ∧ f p = 1 := by
  rcases hf_not_id with ⟨i₀, hi₀_pos, hfi₀_ne_i₀⟩
  by_contra! h
  have h_fi₀_pos : f i₀ > 0 := hpos i₀ hi₀_pos
  have h3 : ∃ q : ℕ, Nat.Prime q ∧ q > k.toNat ∧ q > i₀.toNat ∧ q > (f i₀).toNat := by
    set M : ℕ := max (k.toNat) (max (i₀.toNat) ((f i₀).toNat)) with hM
    have h1 := Nat.exists_infinite_primes (M + 1)
    rcases h1 with ⟨q, hq_ge, hq_prime⟩
    have hq_gt_M : M < q := by linarith
    have h11 : (k : ℤ).toNat ≤ M := by simp [hM]
    have h12 : (i₀ : ℤ).toNat ≤ M := by
      simp [hM]
    have h13 : ((f i₀ : ℤ).toNat) ≤ M := by
      simp [hM]
    exact ⟨q, hq_prime, by linarith, by linarith, by linarith⟩
  rcases h3 with ⟨q, hq_prime, hq_gt_k, hq_gt_i₀, hq_gt_fi₀⟩
  have hq_gt_k2 : (q : ℤ) > k := by
    have hq_gt_k21 : (q : ℤ) > (k : ℤ).toNat := by exact_mod_cast hq_gt_k
    have h4 : 0 ≤ k := by linarith
    have h5 : ((k : ℤ).toNat : ℤ) = k := by
      simp [Int.toNat_of_nonneg h4]
    linarith
  have hq_gt_i₀2 : (q : ℤ) > i₀ := by
    have hq_gt_i₀21 : (q : ℤ) > (i₀ : ℤ).toNat := by exact_mod_cast hq_gt_i₀
    have h4 : 0 ≤ i₀ := by linarith
    have h5 : ((i₀ : ℤ).toNat : ℤ) = i₀ := by
      simp [Int.toNat_of_nonneg h4]
    linarith
  have hq_gt_fi₀2 : (q : ℤ) > f i₀ := by
    have hq_gt_fi₀21 : (q : ℤ) > ((f i₀ : ℤ).toNat) := by exact_mod_cast hq_gt_fi₀
    have h4 : 0 ≤ f i₀ := by linarith
    have h5 : (((f i₀ : ℤ).toNat : ℤ)) = f i₀ := by
      simp [Int.toNat_of_nonneg h4]
    linarith
  have h5 : f (q : ℤ) ≠ 1 := h q hq_prime hq_gt_k2
  have h6 : i₀ ≡ f i₀ [ZMOD (q : ℤ)] := by
    apply f_b_equiv_b_mod_p_of_f_p_ne_1
    all_goals
      assumption
  simp [Int.ModEq, Int.emod_eq_emod_iff_emod_sub_eq_zero] at h6
  have h62 : (q : ℤ) ∣ i₀ - f i₀ := by omega
  by_cases h7 : f i₀ ≤ i₀
  ·
    have h73 : i₀ - f i₀ > 0 := by omega
    have h74 : i₀ - f i₀ < (q : ℤ) := by linarith [h_fi₀_pos]
    have h75 : (q : ℤ) ≤ i₀ - f i₀ := by exact Int.le_of_dvd (by linarith) h62
    linarith
  ·
    have h8 : f i₀ > i₀ := by linarith
    have h9 : (q : ℤ) ∣ f i₀ - i₀ := by
      have h91 : (q : ℤ) ∣ i₀ - f i₀ := h62
      have h92 : (q : ℤ) ∣ -(i₀ - f i₀) := by exact dvd_neg.mpr h91
      have h93 : -(i₀ - f i₀) = f i₀ - i₀ := by ring
      rw [h93] at h92
      exact h92
    have h94 : f i₀ - i₀ > 0 := by linarith
    have h95 : (q : ℤ) ≤ f i₀ - i₀ := by exact Int.le_of_dvd (by linarith) h9
    linarith

theorem f_is_not_identity_implies_f_p_eq_1_for_p_gt_2_case1 (f : ℤ → ℤ) (hpos : ∀ k : ℤ, k > 0 → f k > 0) (hf : ∀ a b : ℤ, a > 0 → b > 0 → f a ∣ b ^ a.toNat - (f b) ^ (f a).toNat) (k : ℤ) (hk_pos : k > 0) (h11 : ∀ k : ℤ, k > 0 → f k = 1) : ∃ p, Nat.Prime p.toNat ∧ p > k ∧ f p = 1 := by
  obtain ⟨p, hp_prop⟩ := Nat.exists_infinite_primes k.toNat.succ
  use p
  constructor
  exact hp_prop.2
  constructor
  omega
  apply h11
  omega

theorem f_is_not_identity_implies_f_p_eq_1_for_some_p_gt_k (f : ℤ → ℤ) (hpos : ∀ k : ℤ, k > 0 → f k > 0) (hf : ∀ a b : ℤ, a > 0 → b > 0 → f a ∣ b ^ a.toNat - (f b) ^ (f a).toNat) (k : ℤ) (hk_pos : k > 0) (hf_not_id : ∃ i > 0, f i ≠ i):
  ∃ p, Nat.Prime p.toNat ∧ p > k ∧ f p = 1  := by
  apply f_is_not_identity_implies_f_p_eq_1_for_p_gt_2_case2
  <;> simp_all

theorem f_is_not_identity_implies_f_p_eq_1_for_p_gt_2_h_main (n : ℤ)
  (f : ℤ → ℤ)
  (hn : n > 0)
  (hpos : ∀ k : ℤ, k > 0 → f k > 0)
  (hf : ∀ a b : ℤ, a > 0 → b > 0 → f a ∣ b ^ a.toNat - (f b) ^ (f a).toNat)
  (h_exists_k : ∃ k : ℤ, k > 1 ∧ f k ≠ k)
  (p0 : ℤ)
  (hp0_prime : Nat.Prime p0.toNat)
  (hfp0_eq_1 : f p0 = 1)
  (h_f_not_const_1 : ∃ n, n > 0 ∧ f n ≠ 1):
  ∀ (p : ℤ), Nat.Prime p.toNat → p ≥ p0 → f p = 1 := by
  intro p hp_prime hp_ge_p0
  by_contra h
  have h_p0_ge_2 : p0 ≥ 2 := by
    have h1 : Nat.Prime p0.toNat := hp0_prime
    have h2 : p0.toNat ≥ 2 := Nat.Prime.two_le h1
    omega
  have := f_b_equiv_b_mod_p_of_f_p_ne_1 n f hn hpos hf p hp_prime h
  simp_all [Int.ModEq, Int.emod_eq_emod_iff_emod_sub_eq_zero]
  obtain ⟨k, hk⟩ := this p0 (by linarith)
  have h5 : k > 0 := by
    by_contra h6
    have h6' : k ≤ 0 := by linarith
    nlinarith
  nlinarith

theorem f_is_1_on_all_primes_ge_p0_if_f_p0_eq_1_and_f_is_not_const_1 (n : ℤ) (f : ℤ → ℤ) (hn : n > 0) (hpos : ∀ k : ℤ, k > 0 → f k > 0) (hf : ∀ a b : ℤ, a > 0 → b > 0 → f a ∣ b ^ a.toNat - (f b) ^ (f a).toNat) (h_exists_k : ∃ k : ℤ, k > 1 ∧ f k ≠ k) {p0 : ℤ} (hp0_prime : Nat.Prime p0.toNat) (hfp0_eq_1 : f p0 = 1) (h_f_not_const_1 : ∃ n, n > 0 ∧ f n ≠ 1): ∀ p, Nat.Prime p.toNat → p ≥ p0 → f p = 1   := by
  apply f_is_not_identity_implies_f_p_eq_1_for_p_gt_2_h_main
  all_goals assumption

theorem f_is_not_identity_implies_f_p_eq_1_for_p_gt_2_main (n : ℤ) (f : ℤ → ℤ) (hn : n > 0) (hpos : ∀ k : ℤ, k > 0 → f k > 0) (hf : ∀ a b : ℤ, a > 0 → b > 0 → f a ∣ b ^ a.toNat - (f b) ^ (f a).toNat):
  (∃ n : ℤ, n > 0 ∧ f n ≠ n) → ∀ p : ℤ, Nat.Prime p.toNat → p > 2 → f p = 1 := by
  intro h_f_not_id p hp_prime hp_gt_2
  by_contra h_f_neq_1
  cases' imo2025_p3_subproblem_f1_is_1_or_f_is_const_1 f hpos hf with h_f_const_1 h_f1_eq_1
  · have h2 := h_f_const_1 p (by linarith)
    contradiction
  · have h_f1_eq_1 : f 1 = 1 := h_f1_eq_1
    have h_exists_k : ∃ k : ℤ, k > 1 ∧ f k ≠ k := by
      rcases h_f_not_id with ⟨n, hn_pos, hfn_ne_n⟩
      by_cases h_n_gt_1 : n > 1
      · refine ⟨n, h_n_gt_1, hfn_ne_n⟩
      · have h_n_le_1 : n ≤ 1 := by linarith
        have h_n_eq_1 : n = 1 := by linarith
        rw [h_n_eq_1] at hfn_ne_n
        contradiction
    have h_exists_p0 := f_is_not_identity_implies_f_p_eq_1_for_some_p_gt_k f hpos hf p (by linarith) h_f_not_id
    rcases h_exists_p0 with ⟨p0, hp0_prime, hp0_gt_p, hfp0_eq_1⟩
    have h_f_not_const_1 : ∃ n, n > 0 ∧ f n ≠ 1 := by
      refine ⟨p, by linarith, h_f_neq_1⟩
    have h_forall_primes_ge_p0_f_eq_1 := f_is_1_on_all_primes_ge_p0_if_f_p0_eq_1_and_f_is_not_const_1 n f hn hpos hf h_exists_k hp0_prime hfp0_eq_1 h_f_not_const_1
    have h_p_toNat_gt_2 : p.toNat > 2 := by
      have h2 := hp_prime
      norm_cast
      omega
    have h_p_toNat_pos : 0 < p.toNat := by linarith
    haveI : Fact (Nat.Prime p.toNat) := ⟨by exact_mod_cast hp_prime⟩
    have h_exists_q : ∃ q : ℕ, q > p0.toNat ∧ Nat.Prime q ∧ (q : ZMod p.toNat) = (2 : ZMod p.toNat) := by
      have h9 := Nat.forall_exists_prime_gt_and_eq_mod
        (isUnit_iff_ne_zero.mpr (by
          have h2_unit' : (2 : ZMod p.toNat) ≠ 0 := by
            intro h
            have h_dvd : (p.toNat : ℕ) ∣ 2 := by
              exact (ZMod.natCast_zmod_eq_zero_iff_dvd 2 p.toNat).mp h
            have h4 : p.toNat ≤ 2 := Nat.le_of_dvd (by norm_num) h_dvd
            linarith
          exact h2_unit'))
        (p0.toNat)
      rcases h9 with ⟨q, hq1, hq2, hq3⟩
      refine ⟨q, hq1, hq2, hq3⟩
    rcases h_exists_q with ⟨q, hq_gt_p0, hq_prime, hq_mod⟩
    have hq_gt_p0' : (q : ℤ) > p0 := by
      have h10 : q > p0.toNat := hq_gt_p0
      have h11 : (q : ℤ) > (p0.toNat : ℤ) := by exact_mod_cast h10
      have h12 : (p0.toNat : ℤ) = p0 := by
        have h13 : 0 ≤ p0 := by linarith
        simp [Int.toNat_of_nonneg h13]
      rw [h12] at h11
      linarith
    have hq_pos : (q : ℤ) > 0 := by linarith
    have hq_ge_p0 : (q : ℤ) ≥ p0 := by linarith
    have h14 : Nat.Prime q := hq_prime
    have h15 : f (q : ℤ) = 1 := by
      exact h_forall_primes_ge_p0_f_eq_1 (q : ℤ) hq_prime (by linarith)
    have h13 : (q : ℤ) ≡ f (q : ℤ) [ZMOD p] := f_b_equiv_b_mod_p_of_f_p_ne_1 n f hn hpos hf p hp_prime h_f_neq_1 q (by linarith)
    have h14' : (q : ℤ) ≡ 1 [ZMOD p] := by
      rw [h15] at h13
      simp_all
    have h151 : p ∣ (q : ℤ) - 1 := by
      simp_all [Int.ModEq, Int.emod_eq_emod_iff_emod_sub_eq_zero]
    have hq_ge_2 : q ≥ 2 := by linarith
    have h4 : (q : ℕ) % p.toNat = 2 := by
      have h11 : (q : ZMod p.toNat) = (2 : ZMod p.toNat) := hq_mod
      have h12 : (q : ℕ) % p.toNat = (2 : ℕ) % p.toNat := by
        exact (ZMod.nat_cast_eq_nat_cast_iff' q (2 : ℕ) p.toNat).mp hq_mod
      have h13 : (2 : ℕ) % p.toNat = 2 := by
        apply Nat.mod_eq_of_lt
        have h14 : p.toNat > 2 := by exact_mod_cast h_p_toNat_gt_2
        omega
      rw [h13] at h12
      exact h12
    have h2 : ∃ k : ℕ, q = p.toNat * k + 2 := by
      use (q / p.toNat)
      have h8 : q = (q / p.toNat) * p.toNat + q % p.toNat := by
        exact Eq.symm (div_add_mod' q p.toNat)
      rw [h4] at h8
      linarith
    rcases h2 with ⟨k, hk⟩
    have h6 : (p.toNat : ℕ) ∣ (q : ℕ) - 2 := by
      use k
      have h8 : q = p.toNat * k + 2 := hk
      omega
    have h7 : (p.toNat : ℤ) ∣ (q : ℤ) - 2 := by
      exact_mod_cast h6
    have h8 : (p : ℤ) = (p.toNat : ℤ) := by
      have h71 : 0 ≤ p := by linarith
      simp [Int.toNat_of_nonneg h71]
    have h9 : (p : ℤ) ∣ (q : ℤ) - 2 := by
      rw [h8]
      exact h7
    have h10 : p ∣ ((q : ℤ) - 1) - ((q : ℤ) - 2) := by
      exact Int.dvd_sub h151 h9
    have h11 : ((q : ℤ) - 1) - ((q : ℤ) - 2) = 1 := by ring
    rw [h11] at h10
    have h12 : p ∣ 1 := h10
    have h13 : p ≤ 1 := by
      exact Int.le_of_dvd (by norm_num) h12
    linarith

theorem f_is_not_identity_implies_f_p_eq_1_for_p_gt_2_f_is_not_identity_implies_f_p_eq_1_for_p_gt_2 (n : ℤ) (f : ℤ → ℤ) (hn : n > 0) (hpos : ∀ k : ℤ, k > 0 → f k > 0) (hf : ∀ a b : ℤ, a > 0 → b > 0 → f a ∣ b ^ a.toNat - (f b) ^ (f a).toNat):
  (∃ n : ℤ, n > 0 ∧ f n ≠ n) → ∀ p : ℤ, Nat.Prime p.toNat → p > 2 → f p = 1 := by
  apply f_is_not_identity_implies_f_p_eq_1_for_p_gt_2_main
  <;> assumption

theorem f_is_not_identity_implies_f_p_eq_1_for_p_gt_2 (n : ℤ) (f : ℤ → ℤ) (hn : n > 0) (hpos : ∀ k : ℤ, k > 0 → f k > 0) (hf : ∀ a b : ℤ, a > 0 → b > 0 → f a ∣ b ^ a.toNat - (f b) ^ (f a).toNat):
  (∃ n : ℤ, n > 0 ∧ f n ≠ n) → ∀ p : ℤ, Nat.Prime p.toNat → p > 2 → f p = 1  := by
  apply f_is_not_identity_implies_f_p_eq_1_for_p_gt_2_f_is_not_identity_implies_f_p_eq_1_for_p_gt_2
  <;> assumption

theorem prime_divisor_of_fa_divides_fx_minus_x_h1 (n : ℤ)
  (f : ℤ → ℤ)
  (hn : n > 0)
  (hpos : ∀ k : ℤ, k > 0 → f k > 0)
  (hf : ∀ a b : ℤ, a > 0 → b > 0 → f a ∣ b ^ a.toNat - (f b) ^ (f a).toNat)
  (a x p : ℤ)
  (ha : a > 0)
  (hx : x > 0)
  (hp : Nat.Prime p.toNat)
  (hdiv : p ∣ f a):
  p ≥ 2 := by
  have := hp.two_le
  omega

theorem prime_divisor_of_fa_divides_fx_minus_x_h2 (n : ℤ)
  (f : ℤ → ℤ)
  (hn : n > 0)
  (hpos : ∀ k : ℤ, k > 0 → f k > 0)
  (hf : ∀ a b : ℤ, a > 0 → b > 0 → f a ∣ b ^ a.toNat - (f b) ^ (f a).toNat)
  (a x p : ℤ)
  (ha : a > 0)
  (hx : x > 0)
  (hp : Nat.Prime p.toNat)
  (hdiv : p ∣ f a)
  (h1 : p ≥ 2):
  f p ≠ 1 := by
  intro hfp1
  have : p ∣ p ^ a.toNat - (p ^ a.toNat - (f p) ^ (f a).toNat) := by
    apply Int.dvd_sub
    · exact dvd_pow_self p (by omega)
    · exact dvd_trans hdiv (hf a p ha (by linarith))
  simp_all
  rw [← Int.natAbs_dvd_natAbs] at this
  norm_num at this
  omega

theorem prime_divisor_of_fa_divides_fx_minus_x_h10 (n : ℤ)
  (f : ℤ → ℤ)
  (hn : n > 0)
  (hpos : ∀ k : ℤ, k > 0 → f k > 0)
  (hf : ∀ a b : ℤ, a > 0 → b > 0 → f a ∣ b ^ a.toNat - (f b) ^ (f a).toNat)
  (a x p : ℤ)
  (ha : a > 0)
  (hx : x > 0)
  (hp : Nat.Prime p.toNat)
  (hdiv : p ∣ f a)
  (h2 : f p ≠ 1):
  ∀ (b : ℤ), b > 0 → b ≡ f b [ZMOD p] := by
  apply f_b_equiv_b_mod_p_of_f_p_ne_1
  <;> aesop

theorem prime_divisor_of_fa_divides_fx_minus_x_h11 (n : ℤ)
  (f : ℤ → ℤ)
  (hn : n > 0)
  (hpos : ∀ k : ℤ, k > 0 → f k > 0)
  (hf : ∀ a b : ℤ, a > 0 → b > 0 → f a ∣ b ^ a.toNat - (f b) ^ (f a).toNat)
  (a x p : ℤ)
  (ha : a > 0)
  (hx : x > 0)
  (hp : Nat.Prime p.toNat)
  (hdiv : p ∣ f a)
  (h10 : ∀ (b : ℤ), b > 0 → b ≡ f b [ZMOD p]):
  x ≡ f x [ZMOD p] := by
  apply h10
  assumption

theorem prime_divisor_of_fa_divides_fx_minus_x_h13 (n : ℤ)
  (f : ℤ → ℤ)
  (hn : n > 0)
  (hpos : ∀ k : ℤ, k > 0 → f k > 0)
  (hf : ∀ a b : ℤ, a > 0 → b > 0 → f a ∣ b ^ a.toNat - (f b) ^ (f a).toNat)
  (a x p : ℤ)
  (ha : a > 0)
  (hx : x > 0)
  (hp : Nat.Prime p.toNat)
  (hdiv : p ∣ f a)
  (h11 : x ≡ f x [ZMOD p]):
  p ∣ f x - x := by
  exact h11.dvd

theorem prime_divisor_of_fa_divides_fx_minus_x (n : ℤ) (f : ℤ → ℤ) (hn : n > 0) (hpos : ∀ k : ℤ, k > 0 → f k > 0) (hf : ∀ a b : ℤ, a > 0 → b > 0 → f a ∣ b ^ a.toNat - (f b) ^ (f a).toNat) (a x p : ℤ) (ha : a > 0) (hx : x > 0) (hp : Nat.Prime p.toNat) (hdiv : p ∣ f a): p ∣ f x - x  := by
  apply prime_divisor_of_fa_divides_fx_minus_x_h13 n f hn hpos hf a x p ha hx hp hdiv
  apply prime_divisor_of_fa_divides_fx_minus_x_h11 n f hn hpos hf a x p ha hx hp hdiv
  apply prime_divisor_of_fa_divides_fx_minus_x_h10 n f hn hpos hf a x p ha hx hp hdiv
  apply prime_divisor_of_fa_divides_fx_minus_x_h2 n f hn hpos hf a x p ha hx hp hdiv
  apply prime_divisor_of_fa_divides_fx_minus_x_h1 n f hn hpos hf a x p ha hx hp hdiv

theorem f_n_is_power_of_two_for_even_n_h10 :
  ∀ (m : ℕ), m > 0 → (∀ p : ℕ, Nat.Prime p → p ∣ m → p = 2) → (∃ k : ℕ, m = 2 ^ k) := by
  intro m hm h_prime
  induction' m using Nat.strong_induction_on with m ih
  by_cases h : m = 1
  · exact ⟨0, h⟩
  rcases Nat.exists_prime_and_dvd (by omega : m ≠ 1) with ⟨p, hp, hp'⟩
  have := h_prime p hp hp'
  simp_all
  cases' hp' with t ht
  cases' ih t (by omega) (by omega) (fun p hp' hp'' => h_prime p hp' (by rw [ht]; exact dvd_mul_of_dvd_right hp'' 2)) with k hk
  exact ⟨k + 1, by simp_all; ring⟩

theorem f_n_is_power_of_two_for_even_n_h1 (n : ℤ)
  (f : ℤ → ℤ)
  (hn : n > 0)
  (hpos : ∀ k : ℤ, k > 0 → f k > 0)
  (hf : ∀ a b : ℤ, a > 0 → b > 0 → f a ∣ b ^ a.toNat - (f b) ^ (f a).toNat)
  (h_exists_k : ∃ k : ℤ, k > 1 ∧ f k ≠ k):
  ∀ (q : ℤ), Nat.Prime q.toNat → q ∣ f n → q = 2 := by
  intro q hq_prime hq_divides_fn
  by_contra hq
  obtain ⟨k, hk⟩ := h_exists_k
  have hq_gt_2 : q > 2 := by
    by_contra hq_le_2
    have hq1 : q ≤ 2 := by linarith
    have hq11 : q.toNat = 0 ∨ q.toNat = 1 := by
      omega
    rcases hq11 with (hq11 | hq11) <;> simp_all [Nat.Prime]
  have := f_is_not_identity_implies_f_p_eq_1_for_p_gt_2 n f hn hpos hf ⟨k, by linarith, hk.2⟩
  have := prime_divisor_of_fa_divides_fx_minus_x n f hn hpos hf n q q hn (by omega) hq_prime hq_divides_fn
  have : q = 1 := by
    have : q ∣ 1 := by simp_all
    exact Int.eq_one_of_dvd_one (by linarith) this
  simp_all

theorem f_n_is_power_of_two_for_even_n_main (n : ℤ)
  (f : ℤ → ℤ)
  (hn : n > 0)
  (hpos : ∀ k : ℤ, k > 0 → f k > 0)
  (hf : ∀ a b : ℤ, a > 0 → b > 0 → f a ∣ b ^ a.toNat - (f b) ^ (f a).toNat)
  (h_exists_k : ∃ k : ℤ, k > 1 ∧ f k ≠ k):
  ∃ k : ℕ, f n = 2 ^ k := by
  have h6 := hpos n hn
  have h61 : ∃ (m : ℕ), (m : ℤ) = f n ∧ m > 0 := by
    use (f n).toNat
    constructor
    · simp [Int.toNat_of_nonneg (by linarith : 0 ≤ f n)]
    · omega
  rcases h61 with ⟨m, hm1, hm2⟩
  obtain ⟨k, hk⟩ := f_n_is_power_of_two_for_even_n_h10 m hm2 fun p hp hpdvd => by
    have hpdvd' : (p : ℤ) ∣ (m : ℤ) := by exact_mod_cast hpdvd
    exact_mod_cast f_n_is_power_of_two_for_even_n_h1 n f hn hpos hf h_exists_k p hp (by simp_all [dvd_gcd_iff])
  exact ⟨k, by linarith⟩

theorem f_n_is_power_of_two_for_even_n (n : ℤ) (f : ℤ → ℤ) (hn : n > 0) (hpos : ∀ k : ℤ, k > 0 → f k > 0) (hf : ∀ a b : ℤ, a > 0 → b > 0 → f a ∣ b ^ a.toNat - (f b) ^ (f a).toNat) (h_exists_k : ∃ k : ℤ, k > 1 ∧ f k ≠ k) :
  ∃ k : ℕ, f n = 2 ^ k   := by
  apply f_n_is_power_of_two_for_even_n_main
  <;> assumption

theorem round1_h_main' (n : ℤ) (f : ℤ → ℤ) (hn : n > 0) (hpos : ∀ k : ℤ, k > 0 → f k > 0) (hf : ∀ a b : ℤ, a > 0 → b > 0 → f a ∣ b ^ a.toNat - (f b) ^ (f a).toNat) : f n ≤ 4 * n := by
  cases' imo2025_p3_subproblem_f1_is_1_or_f_is_const_1 f hpos hf with h19 h20
  · have h21 : f n = 1 := h19 n hn
    linarith
  · by_cases h21 : ∀ k : ℤ, k > 0 → f k = k
    · exact round1_h_subcase1 n f hn hpos hf h21
    · push_neg at h21
      obtain ⟨k, hk_pos, hk_ne⟩ := h21
      have h22 : k > 1 := by
        by_contra h23
        have h24 : k ≤ 1 := by linarith
        have h25 : k = 1 := by omega
        rw [h25] at hk_ne
        contradiction
      have h23 : ∃ k' : ℤ, k' > 1 ∧ f k' ≠ k' := ⟨k, h22, hk_ne⟩
      have h24 : ∃ n : ℤ, n > 0 ∧ f n ≠ n := by
        obtain ⟨k, hk1, hk2⟩ := h23
        refine' ⟨k, by linarith, hk2⟩
      have h25 := f_is_not_identity_implies_f_p_eq_1_for_p_gt_2 n f hn hpos hf h24
      have h26 : f 3 = 1 := h25 3 (by decide) (by norm_num)
      have h27 : f n ∣ 3 ^ n.toNat - 1 := by
        have h28 := hf n 3 hn (by norm_num)
        rw [h26] at h28
        aesop
      have h28 : ∃ k : ℕ, f n = 2 ^ k := f_n_is_power_of_two_for_even_n n f hn hpos hf h23
      obtain ⟨k, hk⟩ := h28
      have h29 : f n = (2 : ℤ) ^ k := hk
      have h30 : (2 : ℤ) ^ k ∣ 3 ^ n.toNat - 1 := by
        rw [h29] at h27
        exact h27
      have h31 := round1_h_k_le_padic n f k hn hpos hf h30
      have h32 := lte_2_3n_minus_1 n hn
      have h33 : k ≤ 2 + padicValNat 2 n.toNat := by
        split_ifs at h32 <;> omega
      exact round1_h6' n f hn hpos hf k (by aesop) (by aesop)

theorem imo2025_p3_left (n : ℤ) (f : ℤ → ℤ) (hn : n > 0) (hpos : ∀ k : ℤ, k > 0 → f k > 0) (hf : ∀ a b : ℤ, a > 0 → b > 0 → f a ∣ b ^ a.toNat - (f b) ^ (f a).toNat) : f n ≤ 4 * n  := by
  apply round1_h_main'
  assumption'

theorem imo2025_p3_right : ∃ (n : ℤ) (f : ℤ → ℤ), (n > 0) ∧ (∀ k : ℤ, k > 0 → f k > 0) ∧ (∀ a b : ℤ, a > 0 → b > 0 → f a ∣ b ^ a.toNat - (f b) ^ (f a).toNat) ∧ (f n ≥ 4 * n) := by
  use 4
  use fun k => if k > 0 then if k = 4 then 16 else if k % 2 = 1 then 1 else 2 else 0
  constructor
  norm_num
  constructor
  intro k hk
  split_ifs
  <;> omega
  constructor
  intro a b ha hb
  by_cases ha4 : a = 4
  · have h1 : a = 4 := ha4
    by_cases hb4 : b = 4
    · have h2 : b = 4 := hb4
      simp [h1, h2]
      <;> norm_num
    · have h2 : b ≠ 4 := hb4
      by_cases hb10 : b % 2 = 1
      · have h21 : b % 2 = 1 := hb10
        have h22 : (b ^ 4 - 1) % 16 = 0 := by
          have h221 : b % 2 = 1 := h21
          have h222 : b ^ 4 % 16 = 1 := by
            have h223 : b % 16 = 1 ∨ b % 16 = 3 ∨ b % 16 = 5 ∨ b % 16 = 7 ∨ b % 16 = 9 ∨ b % 16 = 11 ∨ b % 16 = 13 ∨ b % 16 = 15 := by omega
            rcases h223 with (h223 | h223 | h223 | h223 | h223 | h223 | h223 | h223) <;> simp [h223, pow_succ, Int.mul_emod]
          omega
        simp [h1, h2, h21] at *
        <;> omega
      · have h22 : b % 2 ≠ 1 := hb10
        have h23 : b % 2 = 0 := by omega
        have h24 : (b ^ 4 - 2 ^ 16) % 16 = 0 := by
          have h241 : b % 2 = 0 := h23
          have h242 : b ^ 4 % 16 = 0 := by
            have h244 : b % 16 = 0 ∨ b % 16 = 2 ∨ b % 16 = 4 ∨ b % 16 = 6 ∨ b % 16 = 8 ∨ b % 16 = 10 ∨ b % 16 = 12 ∨ b % 16 = 14 := by omega
            rcases h244 with (h244 | h244 | h244 | h244 | h244 | h244 | h244 | h244) <;> simp [h244, pow_succ, Int.mul_emod]
          omega
        simp [h1, h2, h22, h23] at *
        <;> omega
  · have ha11 : a ≠ 4 := ha4
    by_cases ha12 : a % 2 = 1
    · have ha121 : a % 2 = 1 := ha12
      have h3 : (if a > 0 then (if a = 4 then 16 else (if a % 2 = 1 then 1 else 2)) else 0 : ℤ) = 1 := by
        simp [ha, ha11, ha121]
      rw [h3]
      norm_num
    · have ha122 : a % 2 ≠ 1 := ha12
      have ha13 : a % 2 = 0 := by omega
      have h3 : (if a > 0 then (if a = 4 then 16 else (if a % 2 = 1 then 1 else 2)) else 0 : ℤ) = 2 := by
        simp [ha, ha11, ha122, ha13]
      have h4 : (if a > 0 then (if a = 4 then 16 else (if a % 2 = 1 then 1 else 2)) else 0 : ℤ).toNat = 2 := by
        simp [h3]
      have h6 : (2 : ℤ) ∣ b ^ a.toNat - (if b > 0 then (if b = 4 then 16 else (if b % 2 = 1 then 1 else 2)) else 0 : ℤ) ^ 2 := by
        have h61 : (b ^ a.toNat) % 2 = b % 2 := by
          by_cases h604 : b % 2 = 0
          · have h605 : (b ^ a.toNat) % 2 = 0 := by
              have h6061 : a.toNat > 0 := by
                have h6062 : 0 < a := by linarith
                have h6063 : a ≥ 1 := by linarith
                have h6064 : a.toNat ≥ 1 := by omega
                omega
              have h607 : (b ^ a.toNat) % 2 = 0 := by
                have h608 : b % 2 = 0 := h604
                have h609 : ∀ n : ℕ, n > 0 → (b ^ n) % 2 = 0 := by
                  intro n hn
                  induction n with
                  | zero => contradiction
                  | succ n ih =>
                    by_cases h610 : n = 0
                    · simp [h610, h608]
                    · have h611 : n > 0 := by omega
                      have ih' := ih h611
                      simp [pow_succ, Int.mul_emod, h608, ih']
                exact h609 a.toNat h6061
              exact h607
            have h6041 : b % 2 = 0 := h604
            omega
          · have h6041 : b % 2 = 1 := by omega
            have h605 : (b ^ a.toNat) % 2 = 1 := by
              have h606 : a.toNat > 0 := by
                have h6061 : 0 < a := by linarith
                have h6062 : a ≥ 1 := by linarith
                have h6063 : a.toNat ≥ 1 := by omega
                omega
              have h607 : (b ^ a.toNat) % 2 = 1 := by
                have h608 : b % 2 = 1 := h6041
                have h609 : ∀ n : ℕ, (b ^ n) % 2 = 1 := by
                  intro n
                  induction n with
                  | zero => simp [h608]
                  | succ n ih =>
                    simp [pow_succ, Int.mul_emod, h608, ih]
                exact h609 a.toNat
              exact h607
            have h610 : b % 2 = 1 := h6041
            omega
        have h61 : ( (if b > 0 then (if b = 4 then 16 else (if b % 2 = 1 then 1 else 2)) else 0 : ℤ) ) % 2 = b % 2 := by
          have h610 : b > 0 := by linarith
          have h611 : (if b > 0 then (if b = 4 then 16 else (if b % 2 = 1 then 1 else 2)) else 0 : ℤ) = (if b = 4 then 16 else (if b % 2 = 1 then 1 else 2)) := by
            simp [h610]
          rw [h611]
          by_cases h612 : b = 4
          · rw [if_pos h612]
            <;> omega
          · rw [if_neg h612]
            by_cases h613 : b % 2 = 1
            · rw [if_pos h613]
              <;> omega
            · rw [if_neg h613]
              have h614 : b % 2 = 0 := by omega
              have h615 : (2 : ℤ) % 2 = 0 := by norm_num
              omega
        have h62 : ( (if b > 0 then (if b = 4 then 16 else (if b % 2 = 1 then 1 else 2)) else 0 : ℤ) ^ 2) % 2 = ( (if b > 0 then (if b = 4 then 16 else (if b % 2 = 1 then 1 else 2)) else 0 : ℤ) ) % 2 := by
          have h616 : ∀ x : ℤ, (x ^ 2) % 2 = x % 2 := by
            intro x
            have h617 : x % 2 = 0 ∨ x % 2 = 1 := by omega
            rcases h617 with (h617 | h617) <;> simp [h617, pow_two, Int.mul_emod] 
          exact h616 ((if b > 0 then (if b = 4 then 16 else (if b % 2 = 1 then 1 else 2)) else 0 : ℤ))
        have h63 : ( (if b > 0 then (if b = 4 then 16 else (if b % 2 = 1 then 1 else 2)) else 0 : ℤ) ^ 2) % 2 = b % 2 := by omega
        have h64 : (b ^ a.toNat - (if b > 0 then (if b = 4 then 16 else (if b % 2 = 1 then 1 else 2)) else 0 : ℤ) ^ 2) % 2 = 0 := by omega
        omega
      simpa [h3, h4] using h6
  norm_num

#print axioms imo2025_p3_left
#print axioms imo2025_p3_right
