import Mathlib
import Aesop
set_option maxHeartbeats 0
set_option maxRecDepth 1000
set_option tactic.hygienic false
open BigOperators Real Nat Topology Rat

theorem round8_LoseA_iff (l : ℝ) (WinA : ℕ → ℝ → ℝ → Prop)
    (winA_iff : ∀ (n : ℕ) (sum1 sum2 : ℝ), WinA n sum1 sum2 ↔
      ∃ a : ℝ, a ≥ 0 ∧ sum1 + a ≤ (2 * n + 1) * l ∧
        ∀ b : ℝ, b ≥ 0 → sum2 + a ^ 2 + b ^ 2 ≤ 2 * n + 2 →
          WinA (n + 1) (sum1 + a + b) (sum2 + a ^ 2 + b ^ 2))
    (n : ℕ) (sum1 sum2 : ℝ) :
    ¬ WinA n sum1 sum2 ↔ ∀ (a : ℝ), a ≥ 0 → sum1 + a > (2 * n + 1) * l ∨ (∃ (b : ℝ), b ≥ 0 ∧ sum2 + a ^ 2 + b ^ 2 ≤ 2 * n + 2 ∧ ¬ WinA (n + 1) (sum1 + a + b) (sum2 + a ^ 2 + b ^ 2)) := by
  rw [winA_iff]
  simp [imp_iff_not_or]

theorem round1_main (l : ℝ)
  (hl : l > Real.sqrt 2 / 2):
  ∃ (N : ℕ), ((2 * (N : ℝ) + 1) * l - Real.sqrt 2 * (N : ℝ)) ^ 2 > 2 * (N : ℝ) + 2 := by
  obtain ⟨N, hN⟩ := exists_nat_gt (4 / ((2 * l - Real.sqrt 2) ^ 2) + 2)
  use N
  have h1 : 0 < Real.sqrt 2 := Real.sqrt_pos.mpr (by norm_num)
  have h2 : 0 < l := by linarith [Real.sqrt_nonneg 2]
  have h3 : 0 < 2 * l - Real.sqrt 2 := by linarith
  have h4 : 0 < (2 * l - Real.sqrt 2) ^ 2 := by positivity
  have h5 : 0 < 4 / ((2 * l - Real.sqrt 2) ^ 2) := by positivity
  have h6 : (N : ℝ) > 4 / ((2 * l - Real.sqrt 2) ^ 2) + 2 := by exact_mod_cast hN
  have h7 : (2 * l - Real.sqrt 2) ^ 2 * (N : ℝ) > 4 := by
    calc
      (2 * l - Real.sqrt 2) ^ 2 * (N : ℝ) > (2 * l - Real.sqrt 2) ^ 2 * (4 / ((2 * l - Real.sqrt 2) ^ 2)) := by nlinarith
      _ = 4 := by field_simp [h4.ne']
  have h8 : 4 * (N : ℝ) > 2 * (N : ℝ) + 2 := by linarith
  have h9 : (2 * l - Real.sqrt 2) ^ 2 * (N : ℝ) ^ 2 > 2 * (N : ℝ) + 2 := by nlinarith
  ring_nf
  nlinarith

theorem round1_final (l : ℝ)
  (hl : l > Real.sqrt 2 / 2)
  (N : ℕ)
  (h20 : ((2 * (N : ℝ) + 1) * l - Real.sqrt 2 * (N : ℝ)) ^ 2 > 2 * (N : ℝ) + 2):
  ∀ (s1 s2 : ℝ), 0 ≤ s1 → s1 ≤ Real.sqrt 2 * (N : ℝ) → 0 ≤ s2 → s2 ≤ 2 * (N : ℝ) → s2 + ((2 * (N : ℝ) + 1) * l - s1) ^ 2 > 2 * (N : ℝ) + 2 := by
  intros
  nlinarith [show (2 * (N : ℝ) + 1) * l - Real.sqrt 2 * (N : ℝ) > 0 by
    nlinarith [Real.sqrt_nonneg 2, Real.sq_sqrt (show 0 ≤ 2 by norm_num)]]

theorem round8_quadratic_growth_contradiction (l : ℝ) (hl : l > Real.sqrt 2 / 2) :
    ∃ (N : ℕ), ∀ (s1 s2 : ℝ), 0 ≤ s1 → s1 ≤ Real.sqrt 2 * (N : ℝ) → 0 ≤ s2 → s2 ≤ 2 * (N : ℝ) → s2 + ((2 * (N : ℝ) + 1) * l - s1) ^ 2 > 2 * (N : ℝ) + 2 := by
  apply(round1_main l hl).imp
  exact round1_final l hl

theorem round15_lemma1 (l : ℝ) (hl0 : l > 0) (WinA : ℕ → ℝ → ℝ → Prop)
  (winA_iff : ∀ (n : ℕ) (sum1 sum2 : ℝ), WinA n sum1 sum2 ↔
    ∃ a : ℝ, a ≥ 0 ∧ sum1 + a ≤ (2 * n + 1) * l ∧
      ∀ b : ℝ, b ≥ 0 → sum2 + a ^ 2 + b ^ 2 ≤ 2 * n + 2 →
        WinA (n + 1) (sum1 + a + b) (sum2 + a ^ 2 + b ^ 2))
  (hl : l > √2 / 2):
  ∀ (k : ℕ) (s1 s2 : ℝ),
    (¬ WinA k s1 s2) →
    (0 ≤ s1) →
    (0 ≤ s2) →
    (s1 ^ 2 ≤ (k : ℝ) * s2) →
    (s2 ≤ 2 * (k : ℝ)) →
    ∃ (b_next : ℝ),
      b_next ≥ 0 ∧
      (¬ WinA (k + 1) (s1 + b_next) (s2 + b_next ^ 2)) ∧
      (s2 + b_next ^ 2 ≤ 2 * ((k : ℝ) + 1)) ∧
      ((s1 + b_next) ^ 2 ≤ ((k : ℝ) + 1) * (s2 + b_next ^ 2)) := by
  intro k s1 s2 h1 h2 h3 h4 h5
  simp [round8_LoseA_iff l WinA winA_iff k s1 s2] at h1
  have h6 : s1 ≤ Real.sqrt 2 * k := by
    nlinarith [Real.sqrt_nonneg 2, Real.sq_sqrt (show 0 ≤ 2 by norm_num), sq_nonneg (k : ℝ), mul_nonneg (Real.sqrt_nonneg 2) (Nat.cast_nonneg k)]
  have h7 : (2 * k + 1) * l ≥ Real.sqrt 2 * k := by
    nlinarith [Real.sqrt_nonneg 2, Real.sq_sqrt (show 0 ≤ 2 by norm_num), sq_nonneg (k : ℝ)]
  have h8 : ∃ b, b ≥ 0 ∧ s2 + b ^ 2 ≤ 2 * k + 2 ∧ ¬ WinA (k + 1) (s1 + b) (s2 + b ^ 2) := by
    have h61 : s1 > (2 * k + 1) * l ∨ ∃ b, b ≥ 0 ∧ s2 + 0 ^ 2 + b ^ 2 ≤ 2 * k + 2 ∧ ¬ WinA (k + 1) (s1 + 0 + b) (s2 + 0 ^ 2 + b ^ 2) := by
      simpa using h1 0 (by linarith)
    have h62 : ¬ (s1 > (2 * k + 1) * l) := by linarith
    have h63 : ∃ b, b ≥ 0 ∧ s2 + 0 ^ 2 + b ^ 2 ≤ 2 * k + 2 ∧ ¬ WinA (k + 1) (s1 + 0 + b) (s2 + 0 ^ 2 + b ^ 2) := by
      tauto
    rcases h63 with ⟨b, hb1, hb2, hb3⟩
    refine ⟨b, hb1, ?_, ?_⟩
    linarith
    simpa using hb3
  rcases h8 with ⟨b, hb1, hb2, hb3⟩
  have h10 : (k : ℝ) * b ^ 2 - 2 * s1 * b + s2 ≥ 0 := by
    by_cases h121 : (k : ℝ) = 0
    · have h1211 : s1 = 0 := by
        have h1212 : s1 ^ 2 ≤ (k : ℝ) * s2 := h4
        rw [h121] at h1212
        nlinarith
      rw [h121, h1211]
      nlinarith
    · have h122 : (k : ℝ) > 0 := by positivity
      nlinarith [sq_nonneg (b * (k : ℝ) - s1), Real.sq_sqrt (show 0 ≤ 2 by norm_num),
        Real.sqrt_nonneg 2, sq_nonneg s1, sq_nonneg ((k : ℝ))]
  have h11 : (s1 + b) ^ 2 ≤ ((k : ℝ) + 1) * (s2 + b ^ 2) := by
    nlinarith
  exact ⟨b, hb1, hb3, by linarith, h11⟩

theorem round15_h_main (l : ℝ) (hl0 : l > 0) (WinA : ℕ → ℝ → ℝ → Prop)
  (winA_iff : ∀ (n : ℕ) (sum1 sum2 : ℝ), WinA n sum1 sum2 ↔
    ∃ a : ℝ, a ≥ 0 ∧ sum1 + a ≤ (2 * n + 1) * l ∧
      ∀ b : ℝ, b ≥ 0 → sum2 + a ^ 2 + b ^ 2 ≤ 2 * n + 2 →
        WinA (n + 1) (sum1 + a + b) (sum2 + a ^ 2 + b ^ 2))
  (hl : l > √2 / 2)
  (h : ¬ WinA 0 0 0)
  (lemma1 : ∀ (k : ℕ) (s1 s2 : ℝ),
    (¬ WinA k s1 s2) →
    (0 ≤ s1) →
    (0 ≤ s2) →
    (s1 ^ 2 ≤ (k : ℝ) * s2) →
    (s2 ≤ 2 * (k : ℝ)) →
    ∃ (b_next : ℝ),
      b_next ≥ 0 ∧
      (¬ WinA (k + 1) (s1 + b_next) (s2 + b_next ^ 2)) ∧
      (s2 + b_next ^ 2 ≤ 2 * ((k : ℝ) + 1)) ∧
      ((s1 + b_next) ^ 2 ≤ ((k : ℝ) + 1) * (s2 + b_next ^ 2))):
  ∀ k : ℕ, ∃ s1 s2 : ℝ, (0 ≤ s1) ∧ (0 ≤ s2) ∧ (s1 ^ 2 ≤ (k : ℝ) * s2) ∧ (s2 ≤ 2 * (k : ℝ)) ∧ (¬ WinA k s1 s2) := by
  intro k
  induction' k with k ih
  use 0, 0
  simp [h]
  rcases ih with ⟨s1, s2, h1, h2, h3, h4, h5⟩
  rcases lemma1 k s1 s2 h5 h1 h2 h3 h4 with ⟨b_next, h_b_next1, h_b_next2, h_b_next3, h_b_next4⟩
  use s1 + b_next, s2 + b_next ^ 2
  norm_num
  repeat' constructor
  nlinarith
  nlinarith
  nlinarith
  nlinarith
  exact h_b_next2

theorem imo2025_p5_algebra_A (l : ℝ) (hl0 : l > 0) (WinA : ℕ → ℝ → ℝ → Prop)
    (winA_iff : ∀ (n : ℕ) (sum1 sum2 : ℝ), WinA n sum1 sum2 ↔
      ∃ a : ℝ, a ≥ 0 ∧ sum1 + a ≤ (2 * n + 1) * l ∧
        ∀ b : ℝ, b ≥ 0 → sum2 + a ^ 2 + b ^ 2 ≤ 2 * n + 2 →
          WinA (n + 1) (sum1 + a + b) (sum2 + a ^ 2 + b ^ 2))
    (hl : l > √2 / 2) : WinA 0 0 0 := by
  by_contra h₁
  obtain ⟨N, h₂⟩ := round8_quadratic_growth_contradiction l hl
  obtain ⟨s1, s2, h3, h4, h5, h6, h7⟩ := round15_h_main l hl0 WinA winA_iff hl h₁
      (round15_lemma1 l hl0 WinA winA_iff hl) N
  have h8 : s1 ≤ Real.sqrt 2 * (N : ℝ) := by
    nlinarith [Real.sqrt_nonneg 2, Real.sq_sqrt (show 0 ≤ 2 by norm_num), sq_nonneg s1,
      sq_nonneg (N : ℝ), mul_nonneg (Real.sqrt_nonneg 2) (Nat.cast_nonneg N)]
  have h9 := h₂ s1 s2 h3 h8 h4 h6
  obtain h11 | ⟨b, hb1, hb2⟩ := (round8_LoseA_iff l WinA winA_iff N s1 s2).mp h7 ((2 * (N : ℝ) + 1) * l - s1) (by nlinarith)
  <;> nlinarith

theorem round3_P_holds_for_large_n (l : ℝ) (hl0 : l > 0) (hl : l < √2 / 2)
  (WinB : ℕ → ℝ → ℝ → Prop)
  (winB_iff : ∀ (n : ℕ) (sum1 sum2 : ℝ), WinB n sum1 sum2 ↔
    ∀ a : ℝ, a ≥ 0 → sum1 + a ≤ (2 * n + 1) * l →
      ∃ b : ℝ, b ≥ 0 ∧ sum2 + a ^ 2 + b ^ 2 ≤ 2 * n + 2 ∧
        WinB (n + 1) (sum1 + a + b) (sum2 + a ^ 2 + b ^ 2)):
  ∃ N : ℕ, ∀ n : ℕ, n ≥ N → ∀ (s₁ : ℝ) (s₂ : ℝ), s₁ ≥ (n : ℝ) * Real.sqrt 2 → s₂ = 2 * (n : ℝ) → WinB n s₁ s₂ := by
  rcases exists_nat_gt (l / (Real.sqrt 2 - 2 * l)) with ⟨N, hN⟩
  use N + 1
  intro n hn s₁ s₂ hs₁ hs₂
  have hN' : (N + 1 : ℝ) > l / (Real.sqrt 2 - 2 * l) := by linarith
  have hn' : (n : ℝ) ≥ (N + 1 : ℝ) := by exact_mod_cast hn
  have h_ineq1 : (n : ℝ) * (Real.sqrt 2 - 2 * l) > l := by
    have h : (n : ℝ) > l / (Real.sqrt 2 - 2 * l) := by linarith
    have h3 : 0 < Real.sqrt 2 - 2 * l := by
      nlinarith [Real.sqrt_pos_of_pos (show 0 < 2 by norm_num)]
    have h4 : (n : ℝ) * (Real.sqrt 2 - 2 * l) > (l / (Real.sqrt 2 - 2 * l)) * (Real.sqrt 2 - 2 * l) := by nlinarith
    have h5 : (l / (Real.sqrt 2 - 2 * l)) * (Real.sqrt 2 - 2 * l) = l := by
      field_simp [h3.ne']
    linarith
  apply (winB_iff n s₁ s₂).mpr
  intro a ha₁ ha₂
  nlinarith

theorem round3_P_inductive_step_backward (l : ℝ) (hl0 : l > 0) (hl : l < √2 / 2)
  (WinB : ℕ → ℝ → ℝ → Prop)
  (winB_iff : ∀ (n : ℕ) (sum1 sum2 : ℝ), WinB n sum1 sum2 ↔
    ∀ a : ℝ, a ≥ 0 → sum1 + a ≤ (2 * n + 1) * l →
      ∃ b : ℝ, b ≥ 0 ∧ sum2 + a ^ 2 + b ^ 2 ≤ 2 * n + 2 ∧
        WinB (n + 1) (sum1 + a + b) (sum2 + a ^ 2 + b ^ 2))
  (k : ℕ)
  (P_holds_for_k_plus_1 : ∀ (s₁ : ℝ) (s₂ : ℝ), s₁ ≥ ((k + 1 : ℕ) : ℝ) * Real.sqrt 2 → s₂ = 2 * ((k + 1 : ℕ) : ℝ) → WinB (k + 1) s₁ s₂):
  ∀ (s₁ : ℝ) (s₂ : ℝ), s₁ ≥ (k : ℝ) * Real.sqrt 2 → s₂ = 2 * (k : ℝ) → WinB k s₁ s₂ := by
  intro s₁ s₂ hs₁ hs₂
  rw [winB_iff]
  intro a ha_nonneg ha_le
  have h_a_lt_sqrt2_div_2 : a < Real.sqrt 2 / 2 := by nlinarith [ha_le, hl]
  have h2_minus_a_sq_pos : 0 < 2 - a ^ 2 := by nlinarith [h_a_lt_sqrt2_div_2, Real.sq_sqrt (show 0 ≤ 2 by norm_num), Real.sqrt_nonneg 2]
  set b := Real.sqrt (2 - a ^ 2) with hb_def
  have hb_nonneg : b ≥ 0 := Real.sqrt_nonneg _
  have h_sum2_cond : s₂ + a ^ 2 + b ^ 2 ≤ 2 * k + 2 := by
    have h_b_sq : b ^ 2 = 2 - a ^ 2 := by
      rw [hb_def]
      exact Real.sq_sqrt (by nlinarith)
    nlinarith [hs₂, h_b_sq]
  have h_a_plus_b_ge_sqrt2 : a + b ≥ Real.sqrt 2 := by
    have h : (a + b) ^ 2 ≥ (Real.sqrt 2) ^ 2 := by
      have h_sqrt2_sq : (Real.sqrt 2) ^ 2 = 2 := by
        rw [Real.sq_sqrt] <;> norm_num
      have h_b_sq : (Real.sqrt (2 - a ^ 2)) ^ 2 = 2 - a ^ 2 := by
        rw [Real.sq_sqrt] <;> nlinarith [ha_nonneg]
      nlinarith
    have h_a_nonneg : 0 ≤ a := by linarith [ha_nonneg]
    have h_sqrt2_nonneg : 0 ≤ Real.sqrt 2 := Real.sqrt_nonneg 2
    nlinarith
  have h_S1_next_ge : s₁ + a + b ≥ (k + 1 : ℕ) * Real.sqrt 2 := by
    have h_s1_ge_k_sqrt2 : s₁ ≥ k * Real.sqrt 2 := by nlinarith
    have h : s₁ + a + b ≥ k * Real.sqrt 2 + (a + b) := by linarith
    have h' : k * Real.sqrt 2 + (a + b) ≥ k * Real.sqrt 2 + Real.sqrt 2 := by linarith
    have h'' : k * Real.sqrt 2 + Real.sqrt 2 = (k + 1 : ℕ) * Real.sqrt 2 := by
      simp
      <;> ring
    linarith
  have h_S2_next : s₂ + a ^ 2 + b ^ 2 = 2 * ((k + 1 : ℕ) : ℝ) := by
    have h_b_sq : b ^ 2 = 2 - a ^ 2 := by
      rw [hb_def]
      exact Real.sq_sqrt (by nlinarith)
    have h1 : s₂ + a ^ 2 + b ^ 2 = 2 * k + 2 := by nlinarith [hs₂, h_b_sq]
    have h2 : 2 * ((k + 1 : ℕ) : ℝ) = 2 * k + 2 := by
      simp
      <;> ring
    linarith
  exact ⟨b, hb_nonneg, h_sum2_cond, P_holds_for_k_plus_1 (s₁ + a + b) (s₂ + a ^ 2 + b ^ 2) h_S1_next_ge h_S2_next⟩

theorem imo2025_p5_algebra_B (l : ℝ) (hl0 : l > 0) (WinB : ℕ → ℝ → ℝ → Prop)
    (winB_iff : ∀ (n : ℕ) (sum1 sum2 : ℝ), WinB n sum1 sum2 ↔
      ∀ a : ℝ, a ≥ 0 → sum1 + a ≤ (2 * n + 1) * l →
        ∃ b : ℝ, b ≥ 0 ∧ sum2 + a ^ 2 + b ^ 2 ≤ 2 * n + 2 ∧
          WinB (n + 1) (sum1 + a + b) (sum2 + a ^ 2 + b ^ 2))
    (hl : l < √2 / 2) : WinB 0 0 0 := by
  choose N hN using round3_P_holds_for_large_n l hl0 hl WinB winB_iff
  have h_P_N : ∀ j : ℕ, j ≤ N → ∀ (s₁ : ℝ) (s₂ : ℝ), s₁ ≥ (N - j : ℕ) * Real.sqrt 2 → s₂ = 2 * (N - j : ℕ) → WinB (N - j) s₁ s₂ := by
    intro j hj
    induction' j with j' ih
    · intro s₁ s₂ hs₁ hs₂
      exact hN N (by linarith) s₁ s₂ hs₁ hs₂
    intro s₁ s₂ hs₁ hs₂
    have h_k_plus_1_eq_N_minus_j' : ((N - (j' + 1)) + 1) = N - j' := by omega
    have ih' := ih (by linarith)
    have h_P_k_plus_1 : ∀ (s₁ : ℝ) (s₂ : ℝ), s₁ ≥ (((N - (j' + 1)) + 1) : ℕ) * Real.sqrt 2 → s₂ = 2 * (((N - (j' + 1)) + 1) : ℕ) → WinB ((N - (j' + 1)) + 1) s₁ s₂ := by
      intro s₁' s₂' hs₁' hs₂'
      rw [h_k_plus_1_eq_N_minus_j'] at *
      exact ih' s₁' s₂' hs₁' hs₂'
    exact round3_P_inductive_step_backward l hl0 hl WinB winB_iff (N - (j' + 1)) h_P_k_plus_1 s₁ s₂ hs₁ hs₂
  have h_P_0' : WinB (N - N) 0 0 := h_P_N N (by linarith) 0 0 (by norm_num) (by norm_num)
  rw [Nat.sub_self] at h_P_0'
  exact h_P_0'

theorem imo2025_p5_draw1_main (l : ℝ) (hl0 : l > 0) (hl : l = √2 / 2) :
  ∃ sa : (n : ℕ) → (Fin n → ℝ) → ℝ, (∀ i x, sa i x ≥ 0) ∧
    ∀ b : ℕ → ℝ, (∀ i : ℕ, b i ≥ 0) →
    ∀ a : ℕ → ℝ, (∀ i : ℕ, a i = sa i (fun j ↦ b (j : ℕ))) →
      ∀ n : ℕ,
        (∀ k, k < n →
          (∑ i ∈ Finset.range k, (a i + b i)) + a k ≤ (2 * k + 1) * l ∧
          (∑ i ∈ Finset.range k, (a i ^ 2 + b i ^ 2)) + a k ^ 2 + b k ^ 2 ≤ 2 * k + 2) →
        (∑ i ∈ Finset.range n, (a i + b i)) + a n ≤ (2 * n + 1) * l := by
  use fun _ _ => 0
  constructor
  simp
  intros b hb a ha n h₁
  have h₂ : ∀ m : ℕ, m ≤ n → (∑ i in Finset.range m, b i ^ 2) ≤ 2 * (m : ℝ) := by
    intro m hm
    induction' m with m ih
    · simp
    · have h11 : m < n := by linarith
      have h12 := h₁ m h11
      have h122 := h12.2
      have ha_m : a m = 0 := ha m
      have h1222 : (∑ i in Finset.range m, (a i ^ 2 + b i ^ 2)) + a m ^ 2 + b m ^ 2 ≤ 2 * (m : ℝ) + 2 := by simpa using h122
      have h1223 : (∑ i in Finset.range m, (a i ^ 2 + b i ^ 2)) + a m ^ 2 + b m ^ 2 = (∑ i in Finset.range m, (0 ^ 2 + b i ^ 2)) + 0 ^ 2 + b m ^ 2 := by
        have h12241 : ∀ i ∈ Finset.range m, a i = 0 := by
          intro i hi
          exact ha i
        have h1 : (∑ i in Finset.range m, (a i ^ 2 + b i ^ 2)) = ∑ i in Finset.range m, (0 ^ 2 + b i ^ 2) := by
          apply Finset.sum_congr rfl
          intro i hi
          rw [h12241 i hi]
        rw [h1]
        rw [ha_m]
      have h1224 : (∑ i in Finset.range m, (0 ^ 2 + b i ^ 2)) + 0 ^ 2 + b m ^ 2 = (∑ i in Finset.range m, b i ^ 2) + b m ^ 2 := by
        simp
      have h1225 : (∑ i in Finset.range m, b i ^ 2) + b m ^ 2 ≤ 2 * ((m : ℝ) + 1) := by linarith
      have h1226 : (∑ i in Finset.range (m + 1), b i ^ 2) = (∑ i in Finset.range m, b i ^ 2) + b m ^ 2 := by
        rw [Finset.sum_range_succ]
      have h1227 : (∑ i in Finset.range (m + 1), b i ^ 2) ≤ 2 * ((m : ℝ) + 1) := by linarith
      norm_num at *
      <;> linarith
  have h₂₁ : (∑ i in Finset.range n, b i ^ 2) ≤ 2 * (n : ℝ) := h₂ n (by linarith)
  have h₃ : (∑ i in Finset.range n, b i) ^ 2 ≤ (∑ i in Finset.range n, (1 : ℝ) ^ 2) * (∑ i in Finset.range n, b i ^ 2) := by
    have h31 : (∑ i in Finset.range n, b i * 1) ^ 2 ≤ (∑ i in Finset.range n, b i ^ 2) * (∑ i in Finset.range n, (1 : ℝ) ^ 2) := by
      exact Finset.sum_mul_sq_le_sq_mul_sq (Finset.range n) b fun i => 1
    have h32 : (∑ i in Finset.range n, b i * 1) = ∑ i in Finset.range n, b i := by
      simp
    rw [h32] at h31
    linarith
  have h₄ : (∑ i in Finset.range n, (1 : ℝ) ^ 2) = (n : ℝ) := by
    simp [Finset.sum_const, mul_one]
  rw [h₄] at h₃
  have h₅ : (∑ i in Finset.range n, b i) ^ 2 ≤ (n : ℝ) * (∑ i in Finset.range n, b i ^ 2) := by linarith
  have h₅₁ : (n : ℝ) * (∑ i in Finset.range n, b i ^ 2) ≤ (n : ℝ) * (2 * (n : ℝ)) := by
    have h₅1 : (∑ i in Finset.range n, b i ^ 2) ≤ 2 * (n : ℝ) := h₂₁
    have h₅2 : 0 ≤ (n : ℝ) := by exact_mod_cast Nat.zero_le n
    nlinarith
  have h₅₂ : (∑ i in Finset.range n, b i) ^ 2 ≤ 2 * (n : ℝ) ^ 2 := by linarith
  have h₆ : (2 * (n : ℝ) + 1) * (Real.sqrt 2 / 2) ≥ 0 := by positivity
  have h₇ : 2 * (n : ℝ) ^ 2 ≤ ((2 * (n : ℝ) + 1) * (Real.sqrt 2 / 2)) ^ 2 := by
    nlinarith [Real.sq_sqrt (show 0 ≤ 2 by norm_num), Real.sqrt_nonneg 2]
  have h₈ : (∑ i in Finset.range n, b i) ≥ 0 := by
    apply Finset.sum_nonneg
    intro i _
    exact hb i
  have h₉ : (∑ i in Finset.range n, b i) ≤ (2 * (n : ℝ) + 1) * (Real.sqrt 2 / 2) := by nlinarith [h₆, h₅₂, Real.sqrt_nonneg 2]
  simp_all

theorem imo2025_p5_draw_b (l : ℝ) (hl0 : l > 0) (hl : l = √2 / 2) :
  ∃ sa : (n : ℕ) → (Fin n → ℝ) → ℝ, (∀ i x, sa i x ≥ 0) ∧
    ∀ b : ℕ → ℝ, (∀ i : ℕ, b i ≥ 0) →
    ∀ a : ℕ → ℝ, (∀ i : ℕ, a i = sa i (fun j ↦ b (j : ℕ))) →
      ∀ n : ℕ,
        (∀ k, k < n →
          (∑ i ∈ Finset.range k, (a i + b i)) + a k ≤ (2 * k + 1) * l ∧
          (∑ i ∈ Finset.range k, (a i ^ 2 + b i ^ 2)) + a k ^ 2 + b k ^ 2 ≤ 2 * k + 2) →
        (∑ i ∈ Finset.range n, (a i + b i)) + a n ≤ (2 * n + 1) * l := by
  apply imo2025_p5_draw1_main
  all_goals assumption

theorem imo2025_p5_draw_a_v22_main (l : ℝ) (hl0 : l > 0) (hl : l = √2 / 2) :
  ∃ sb : (n : ℕ) → (Fin (n + 1) → ℝ) → ℝ, (∀ i x, sb i x ≥ 0) ∧
    ∀ a : ℕ → ℝ, (∀ i : ℕ, a i ≥ 0) →
    ∀ b : ℕ → ℝ, (∀ i : ℕ, b i = sb i (fun j ↦ a (j : ℕ))) →
      ∀ n : ℕ,
        (∀ k, k < n →
          (∑ i ∈ Finset.range k, (a i + b i)) + a k ≤ (2 * k + 1) * l ∧
          (∑ i ∈ Finset.range k, (a i ^ 2 + b i ^ 2)) + a k ^ 2 + b k ^ 2 ≤ 2 * k + 2) →
        (∑ i ∈ Finset.range n, (a i + b i)) + a n ≤ (2 * n + 1) * l →
        (∑ i ∈ Finset.range n, (a i ^ 2 + b i ^ 2)) + a n ^ 2 + b n ^ 2 ≤ 2 * n + 2 := by
  use fun (n : ℕ) (f : Fin (n + 1) → ℝ) => if f ⟨n, by linarith⟩ ≤ Real.sqrt 2 then Real.sqrt 2 - f ⟨n, by linarith⟩ else 0
  constructor
  ·
    intro i x
    by_cases h : x ⟨i, by linarith⟩ ≤ Real.sqrt 2
    ·
      simp [h]
    ·
      simp [h]
  · intro a ha b h1 n h2 h3
    have h100 : ∀ m : ℕ, m ≤ n → ∑ i in Finset.range m, (a i ^ 2 + b i ^ 2) ≤ 2 * (m : ℝ) := by
      intro m hm
      induction' m with m hm
      · norm_num
      · have h4 : m ≤ n := by linarith
        have h5 : m < n := by linarith
        have h6 := h2 m h5
        have h61 := h6.2
        have h7 : ∑ i in Finset.range (m + 1), (a i ^ 2 + b i ^ 2) = (∑ i in Finset.range m, (a i ^ 2 + b i ^ 2)) + (a m ^ 2 + b m ^ 2) := by
          rw [Finset.sum_range_succ]
        have h8 : (∑ i in Finset.range m, (a i ^ 2 + b i ^ 2)) + a m ^ 2 + b m ^ 2 ≤ 2 * (m : ℝ) + 2 := by linarith
        have h9 : (∑ i in Finset.range (m + 1), (a i ^ 2 + b i ^ 2)) ≤ 2 * (m : ℝ) + 2 := by linarith [h7, h8]
        have h10 : (2 * (m : ℝ) + 2 : ℝ) = 2 * ((m + 1 : ℕ) : ℝ) := by
          simp [Nat.cast_add, Nat.cast_one]
          <;> ring
        linarith
    have h4 : ∀ i : ℕ, b i = if a i ≤ Real.sqrt 2 then Real.sqrt 2 - a i else 0 := by
      intro i
      have h11 := h1 i
      simpa using h11
    have h5 : ∀ i : ℕ, b i ≥ 0 := by
      intro i
      have h51 := h4 i
      rw [h51]
      by_cases h52 : a i ≤ Real.sqrt 2
      ·
        rw [if_pos h52]
        linarith [Real.sqrt_nonneg 2]
      ·
        rw [if_neg h52]
    have h6 : ∀ i : ℕ, a i + b i ≥ Real.sqrt 2 := by
      intro i
      have h41 := h4 i
      rw [h41]
      by_cases h61 : a i ≤ Real.sqrt 2
      ·
        rw [if_pos h61]
        linarith
      ·
        rw [if_neg h61]
        have h62 : a i > Real.sqrt 2 := by linarith
        linarith
    have h7 : (∑ i in Finset.range n, (a i + b i)) ≥ (n : ℝ) * Real.sqrt 2 := by
      have h71 : ∀ i ∈ Finset.range n, a i + b i ≥ Real.sqrt 2 := fun i _ => h6 i
      have h72 : (∑ i in Finset.range n, (a i + b i)) ≥ ∑ i in Finset.range n, Real.sqrt 2 := by
        apply Finset.sum_le_sum
        intro i _
        exact h71 i ‹_›
      have h73 : (∑ i in Finset.range n, Real.sqrt 2) = (n : ℝ) * Real.sqrt 2 := by
        simp [mul_comm]
      linarith
    have h8 : (∑ i in Finset.range n, (a i + b i)) + a n ≤ (2 * n + 1) * l := by simpa using h3
    have h9 : (∑ i in Finset.range n, (a i + b i)) + a n ≤ (2 * (n : ℝ) + 1) * (Real.sqrt 2 / 2) := by
      have h91 : l = Real.sqrt 2 / 2 := by linarith [hl]
      rw [h91] at h8
      linarith
    have h10 : (n : ℝ) * Real.sqrt 2 + a n ≤ (2 * (n : ℝ) + 1) * (Real.sqrt 2 / 2) := by linarith [h7, h9]
    have h11 : a n ≤ Real.sqrt 2 / 2 := by
      nlinarith [Real.sqrt_nonneg 2, Real.sq_sqrt (show (0 : ℝ) ≤ 2 by norm_num)]
    have h12 : a n ≤ Real.sqrt 2 := by linarith [Real.sqrt_nonneg 2, h11]
    have h13 : b n = Real.sqrt 2 - a n := by
      have h131 := h4 n
      rw [h131]
      rw [if_pos h12]
    have h14 : a n ^ 2 + b n ^ 2 ≤ 2 := by
      rw [h13]
      have h141 : 0 ≤ a n := ha n
      have h142 : a n ≤ Real.sqrt 2 / 2 := h11
      nlinarith [Real.sqrt_nonneg 2, Real.sq_sqrt (show (0 : ℝ) ≤ 2 by norm_num)]
    have h15 : ∑ i in Finset.range n, (a i ^ 2 + b i ^ 2) ≤ 2 * (n : ℝ) := by
      specialize h100 n (by linarith)
      simpa using h100
    have h_final : (∑ i in Finset.range n, (a i ^ 2 + b i ^ 2)) + a n ^ 2 + b n ^ 2 ≤ 2 * (n : ℝ) + 2 := by linarith
    norm_cast at h_final ⊢

theorem imo2025_p5_draw_a (l : ℝ) (hl0 : l > 0) (hl : l = √2 / 2) :
  ∃ sb : (n : ℕ) → (Fin (n + 1) → ℝ) → ℝ, (∀ i x, sb i x ≥ 0) ∧
    ∀ a : ℕ → ℝ, (∀ i : ℕ, a i ≥ 0) →
    ∀ b : ℕ → ℝ, (∀ i : ℕ, b i = sb i (fun j ↦ a (j : ℕ))) →
      ∀ n : ℕ,
        (∀ k, k < n →
          (∑ i ∈ Finset.range k, (a i + b i)) + a k ≤ (2 * k + 1) * l ∧
          (∑ i ∈ Finset.range k, (a i ^ 2 + b i ^ 2)) + a k ^ 2 + b k ^ 2 ≤ 2 * k + 2) →
        (∑ i ∈ Finset.range n, (a i + b i)) + a n ≤ (2 * n + 1) * l →
        (∑ i ∈ Finset.range n, (a i ^ 2 + b i ^ 2)) + a n ^ 2 + b n ^ 2 ≤ 2 * n + 2 := by
  apply imo2025_p5_draw_a_v22_main
  <;> assumption

#print axioms imo2025_p5_algebra_A
#print axioms imo2025_p5_algebra_B
#print axioms imo2025_p5_draw1_main
#print axioms imo2025_p5_draw_b
#print axioms imo2025_p5_draw_a_v22_main
#print axioms imo2025_p5_draw_a

