import pandas as pd


# Path to the concatenated data (adjust if you save it elsewhere)
data_path = "/Users/home/Documents/naz/research_codes/uncert_prop/realworld_exp/hai_down1/concatenated_train.csv"

# Read the data
data = pd.read_csv(data_path)

# Remove boolean columns (columns with only two unique values)
non_bool_cols = [col for col in data.columns if data[col].nunique() > 2]
data_no_bool = data[non_bool_cols]

# Optionally, save the result
output_path = "/Users/home/Documents/naz/research_codes/uncert_prop/realworld_exp/hai_down1/train_no_bool.csv"
data_no_bool.to_csv(output_path, index=False)

print(f"Removed boolean columns. Saved cleaned data to {output_path}")