import numpy as np
import matplotlib.pyplot as plt
from mpl_toolkits.mplot3d import Axes3D

# Toy data: 4 iterations, 3x3 covariance matrices
iterations = [100, 2000, 2500, 10000]
cov_matrices = []
np.random.seed(0)
for _ in iterations:
    A = np.random.randn(3, 3)
    cov = np.cov(A)
    cov_matrices.append(cov)

cov_matrices = np.array(cov_matrices)  # shape: (4, 3, 3)

# Let's visualize the evolution of all entries (i, j) over iterations
fig = plt.figure(figsize=(10, 7))
ax = fig.add_subplot(111, projection='3d')

num_vars = cov_matrices.shape[1]
for i in range(num_vars):
    for j in range(num_vars):
        z = [cov_matrices[k, i, j] for k in range(len(iterations))]
        x = [i] * len(iterations)
        y = iterations
        ax.plot(y, x, z, marker='o', label=f'Cov({i},{j})' if i != j else None)

ax.set_xlabel('Iteration')
ax.set_ylabel('Matrix Row (i)')
ax.set_zlabel('Covariance Value')
ax.set_title('Covariance Evolution for Each Entry')
plt.show()